/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arreporting;

import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.Field;
import com.bmc.arsys.arreporting.Aggregation;
import com.bmc.arsys.arreporting.ChartType;
import com.bmc.arsys.arreporting.FieldInfo;
import com.bmc.arsys.arreporting.OutputFormat;
import com.bmc.arsys.arreporting.ReportConstants;
import com.bmc.arsys.arreporting.ReportStyle;
import com.bmc.arsys.arreporting.ReportType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportParameters {
    public static final String REPORT_DESIGNER = "reportDesigner";
    public static final String BIRT_DESIGNER = "BIRT_DESIGNER";
    public static final String AR_DESIGNER = "AR_DESIGNER";
    private String reportSet = null;
    private Properties properties = new Properties();
    private String midtierUrl = null;
    private String reportFile = null;
    private String qualification = null;
    private String resultList = null;
    private boolean forcePNG = true;
    private final List<FieldInfo> fields = new ArrayList<FieldInfo>();
    private final List<FieldInfo> groups = new ArrayList<FieldInfo>();
    private Map<Integer, String> fieldNameMap = null;
    private String footer;
    private ReportType type = null;
    private final ReportStyle style = null;
    private boolean overrideQualification = true;
    private int maxRecords = 0;
    private String entryId;

    public String getEncodedPrimaryQual() {
        return this.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_MAIN_QUERY_ID.toInt()));
    }

    public String getEncodedSecondaryQual() {
        return this.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_SECONDARY_QUERY_ID.toInt()));
    }

    public String getTitle() {
        return this.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_TITLE_ID.toInt()));
    }

    public String getFooter() {
        return this.footer;
    }

    public void setFooter(String footer) {
        this.footer = footer;
    }

    public List<FieldInfo> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public void addField(FieldInfo field) {
        if (field == null) {
            return;
        }
        if (this.fields.isEmpty()) {
            this.fields.add(field);
        } else {
            FieldInfo removeMe = null;
            for (FieldInfo listInfo : this.fields) {
                if (field.getFieldId() != listInfo.getFieldId()) continue;
                removeMe = listInfo;
                break;
            }
            if (removeMe != null) {
                this.fields.remove(removeMe);
            }
            this.fields.add(field);
        }
    }

    public void removeField(FieldInfo field) {
        this.fields.remove(field);
    }

    public FieldInfo getField(int fieldId) {
        for (FieldInfo listInfo : this.fields) {
            if (fieldId != listInfo.getFieldId()) continue;
            return listInfo;
        }
        return null;
    }

    public void removeField(int fieldId) {
        FieldInfo removeMe = null;
        for (FieldInfo listInfo : this.fields) {
            if (fieldId != listInfo.getFieldId()) continue;
            removeMe = listInfo;
            break;
        }
        if (removeMe != null) {
            this.fields.remove(removeMe);
        }
    }

    public void addGroup(FieldInfo group) {
        if (group == null) {
            return;
        }
        if (this.groups.isEmpty()) {
            this.groups.add(group);
        } else {
            FieldInfo removeMe = null;
            for (FieldInfo listInfo : this.groups) {
                if (group.getFieldId() != listInfo.getFieldId()) continue;
                removeMe = listInfo;
                break;
            }
            if (removeMe != null) {
                this.groups.remove(removeMe);
            }
            this.groups.add(group);
        }
    }

    public void removeGroup(FieldInfo group) {
        this.groups.remove(group);
    }

    public void removeGroup(int groupId) {
        FieldInfo removeMe = null;
        for (FieldInfo listInfo : this.groups) {
            if (groupId != listInfo.getFieldId()) continue;
            removeMe = listInfo;
            break;
        }
        if (removeMe != null) {
            this.groups.remove(removeMe);
        }
    }

    public List<FieldInfo> getGroups() {
        return Collections.unmodifiableList(this.groups);
    }

    public void setType(ReportType type) {
        this.type = type;
    }

    public ReportType getType() {
        return this.type;
    }

    public void setMaxRecords(int maxRecords) {
        this.maxRecords = maxRecords;
    }

    public int getMaxRecords() {
        return this.maxRecords;
    }

    public String getName() {
        return this.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_NAME_ID.toInt()));
    }

    public String getDescription() {
        return this.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_DESC_ID.toInt()));
    }

    public void setReportSet(String reportSet) {
        this.reportSet = reportSet;
    }

    public String getReportSet() {
        return this.reportSet;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void clearFields() {
        this.fields.clear();
    }

    public void clearGroups() {
        this.groups.clear();
    }

    public void setMidtierUrl(String midtierUrl) {
        this.midtierUrl = midtierUrl;
    }

    public String getMidtierUrl() {
        return this.midtierUrl;
    }

    public int getSeriesField() {
        String property = this.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_CHART_SERIES_ID.toInt()));
        if (property != null && property.length() > 0) {
            return Integer.parseInt(property);
        }
        return -1;
    }

    public int getCategoryField() {
        String property = this.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_CHART_CATEGORY_ID.toInt()));
        if (property != null && property.length() > 0) {
            return Integer.parseInt(property);
        }
        return -1;
    }

    public void setSeriesField(int fieldId) {
        this.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_CHART_SERIES_ID.toInt()), Integer.toString(fieldId));
    }

    public void setCategoryField(int fieldId) {
        this.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_CHART_CATEGORY_ID.toInt()), Integer.toString(fieldId));
    }

    public String getForm() {
        return this.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_FORM_NAME_ID.toInt()));
    }

    public void setForm(String form) {
        this.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_FORM_NAME_ID.toInt()), form);
    }

    public OutputFormat getOutputFormat() {
        String property = this.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_FORMAT_ID.toInt()));
        if (property != null && property.length() > 0) {
            return OutputFormat.fromPropValue(property);
        }
        return OutputFormat.HTML;
    }

    public void setOutputFormat(OutputFormat format) {
        if (format == null) {
            this.getProperties().remove(Integer.toString(ReportConstants.DESIGNER_REPORT_FORMAT_ID.toInt()));
        } else {
            this.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_FORMAT_ID.toInt()), format.getPropValue());
        }
    }

    public void setReportFile(String reportFile) {
        this.reportFile = reportFile;
    }

    public String getReportFile() {
        return this.reportFile;
    }

    public void setOverrideQualification(boolean overrideQualification) {
        this.overrideQualification = overrideQualification;
    }

    public boolean isOverrideQualification() {
        return this.overrideQualification;
    }

    public String getEntryId() {
        return this.entryId;
    }

    public void setEntryId(String entryId) {
        this.entryId = entryId;
    }

    public void setQualification(String qualification) {
        this.qualification = qualification;
    }

    public String getQualification() {
        return this.qualification;
    }

    public boolean isIncludeList() {
        ReportStyle style = this.getStyle();
        return ReportStyle.LIST.equals((Object)style) || ReportStyle.CHART_AND_LIST.equals((Object)style);
    }

    public boolean isIncludeChart() {
        return !ReportStyle.LIST.equals((Object)this.getStyle());
    }

    public int getVuiId() {
        String property = this.getProperties().getProperty(Integer.toString(ReportConstants.FIELD_INFO_VUI_ID.toInt()));
        if (property != null && property.length() > 0) {
            return Integer.parseInt(property);
        }
        return 0;
    }

    public void setResultList(String resultList) {
        this.resultList = resultList;
    }

    public String getResultList() {
        return this.resultList;
    }

    public void setForcePNG(boolean forcePNG) {
        this.forcePNG = forcePNG;
    }

    public boolean isForcePNG() {
        return this.forcePNG;
    }

    public void setChartType(ChartType chartType) {
        if (chartType == null) {
            this.getProperties().remove(Integer.toString(ReportConstants.DESIGNER_REPORT_CHART_ID.toInt()));
        } else {
            this.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_CHART_ID.toInt()), Integer.toString(chartType.getEnumValue()));
        }
    }

    public ChartType getChartType() {
        String property = this.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_CHART_ID.toInt()));
        if (property != null && property.length() > 0) {
            return ChartType.fromInt(Integer.parseInt(property));
        }
        return null;
    }

    public void setAggregation(Aggregation aggregation) {
        if (aggregation == null) {
            this.getProperties().remove(Integer.toString(ReportConstants.DESIGNER_CHART_AGGREGATE_BY.toInt()));
        } else {
            this.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_CHART_AGGREGATE_BY.toInt()), Integer.toString(aggregation.getEnumValue()));
        }
    }

    public Aggregation getAggregation() {
        String property = this.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_CHART_AGGREGATE_BY.toInt()));
        if (property != null && property.length() > 0) {
            return Aggregation.fromInt(Integer.parseInt(property));
        }
        return Aggregation.COUNT;
    }

    public void setStyle(ReportStyle reportStyle) {
        if (reportStyle == null) {
            this.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_TEMPLATE_ID.toInt()), Integer.toString(ReportStyle.LIST.getEnumValue()));
        } else {
            this.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_TEMPLATE_ID.toInt()), Integer.toString(reportStyle.getEnumValue()));
        }
    }

    public ReportStyle getStyle() {
        String property = this.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_TEMPLATE_ID.toInt()));
        if (property != null && property.length() > 0) {
            return ReportStyle.fromInt(Integer.parseInt(property));
        }
        return ReportStyle.LIST;
    }

    public String getSeriesLabel() {
        return this.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_CHART_SERIES_LABEL_ID.toInt()));
    }

    public String getCategoryLabel() {
        return this.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_CHART_CATEGORY_LABEL_ID.toInt()));
    }

    public String getFieldName(int fieldId) {
        String name;
        if (this.fieldNameMap == null || this.fieldNameMap != null && this.fieldNameMap.isEmpty()) {
            this.fieldNameMap = new HashMap<Integer, String>();
            Object propObj = this.getProperties().get("arFieldObjects");
            if (propObj != null && propObj instanceof List) {
                List fieldList = (List)propObj;
                for (Field field : fieldList) {
                    this.fieldNameMap.put(field.getFieldID(), field.getName());
                }
            }
        }
        if ((name = this.fieldNameMap.get(fieldId)) != null) {
            return name;
        }
        return Integer.toString(fieldId);
    }

    public int getFieldDataType(int fieldId) {
        Object propObj;
        DataType result = null;
        FieldInfo field = this.getField(fieldId);
        if (field != null && (result = field.getDataType()) != null) {
            return result.toInt();
        }
        if (result == null && (propObj = this.getProperties().get("arFieldObjects")) != null && propObj instanceof List) {
            List fieldList = (List)propObj;
            for (Field arField : fieldList) {
                if (arField.getFieldID() != fieldId) continue;
                return arField.getDataType();
            }
        }
        return 0;
    }
}

