/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.web.servlet.support;

import com.bmc.thirdparty.org.springframework.ui.context.Theme;
import com.bmc.thirdparty.org.springframework.ui.context.ThemeSource;
import com.bmc.thirdparty.org.springframework.web.context.WebApplicationContext;
import com.bmc.thirdparty.org.springframework.web.context.support.WebApplicationContextUtils;
import com.bmc.thirdparty.org.springframework.web.servlet.DispatcherServlet;
import com.bmc.thirdparty.org.springframework.web.servlet.LocaleResolver;
import com.bmc.thirdparty.org.springframework.web.servlet.ThemeResolver;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public abstract class RequestContextUtils {
    public static WebApplicationContext getWebApplicationContext(ServletRequest request) throws IllegalStateException {
        return RequestContextUtils.getWebApplicationContext(request, null);
    }

    public static WebApplicationContext getWebApplicationContext(ServletRequest request, ServletContext servletContext) throws IllegalStateException {
        WebApplicationContext webApplicationContext = (WebApplicationContext)request.getAttribute(DispatcherServlet.WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (webApplicationContext == null) {
            if (servletContext == null) {
                throw new IllegalStateException("No WebApplicationContext found: not in a DispatcherServlet request?");
            }
            webApplicationContext = WebApplicationContextUtils.getWebApplicationContext(servletContext);
            if (webApplicationContext == null) {
                throw new IllegalStateException("No WebApplicationContext found: no ContextLoaderListener registered?");
            }
        }
        return webApplicationContext;
    }

    public static LocaleResolver getLocaleResolver(HttpServletRequest request) {
        return (LocaleResolver)request.getAttribute(DispatcherServlet.LOCALE_RESOLVER_ATTRIBUTE);
    }

    public static Locale getLocale(HttpServletRequest request) {
        LocaleResolver localeResolver = RequestContextUtils.getLocaleResolver(request);
        if (localeResolver != null) {
            return localeResolver.resolveLocale(request);
        }
        return request.getLocale();
    }

    public static ThemeResolver getThemeResolver(HttpServletRequest request) {
        return (ThemeResolver)request.getAttribute(DispatcherServlet.THEME_RESOLVER_ATTRIBUTE);
    }

    public static ThemeSource getThemeSource(HttpServletRequest request) {
        return (ThemeSource)request.getAttribute(DispatcherServlet.THEME_SOURCE_ATTRIBUTE);
    }

    public static Theme getTheme(HttpServletRequest request) {
        ThemeResolver themeResolver = RequestContextUtils.getThemeResolver(request);
        ThemeSource themeSource = RequestContextUtils.getThemeSource(request);
        if (themeResolver != null && themeSource != null) {
            String themeName = themeResolver.resolveThemeName(request);
            return themeSource.getTheme(themeName);
        }
        return null;
    }
}

