/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.orm.hibernate3;

import com.bmc.thirdparty.org.springframework.dao.DataAccessException;
import com.bmc.thirdparty.org.springframework.dao.InvalidDataAccessApiUsageException;
import com.bmc.thirdparty.org.springframework.orm.hibernate3.HibernateAccessor;
import com.bmc.thirdparty.org.springframework.orm.hibernate3.HibernateCallback;
import com.bmc.thirdparty.org.springframework.orm.hibernate3.HibernateOperations;
import com.bmc.thirdparty.org.springframework.orm.hibernate3.SessionFactoryUtils;
import com.bmc.thirdparty.org.springframework.util.Assert;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Filter;
import org.hibernate.FlushMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.ReplicationMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Example;
import org.hibernate.engine.SessionImplementor;

public class HibernateTemplate
extends HibernateAccessor
implements HibernateOperations {
    private boolean allowCreate = true;
    private boolean alwaysUseNewSession = false;
    private boolean exposeNativeSession = false;
    private boolean checkWriteOperations = true;
    private boolean cacheQueries = false;
    private String queryCacheRegion;
    private int fetchSize = 0;
    private int maxResults = 0;
    static /* synthetic */ Class class$org$hibernate$Session;
    static /* synthetic */ Class class$org$hibernate$engine$SessionImplementor;

    public HibernateTemplate() {
    }

    public HibernateTemplate(SessionFactory sessionFactory) {
        this.setSessionFactory(sessionFactory);
        this.afterPropertiesSet();
    }

    public HibernateTemplate(SessionFactory sessionFactory, boolean allowCreate) {
        this.setSessionFactory(sessionFactory);
        this.setAllowCreate(allowCreate);
        this.afterPropertiesSet();
    }

    public void setAllowCreate(boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    public boolean isAllowCreate() {
        return this.allowCreate;
    }

    public void setAlwaysUseNewSession(boolean alwaysUseNewSession) {
        this.alwaysUseNewSession = alwaysUseNewSession;
    }

    public boolean isAlwaysUseNewSession() {
        return this.alwaysUseNewSession;
    }

    public void setExposeNativeSession(boolean exposeNativeSession) {
        this.exposeNativeSession = exposeNativeSession;
    }

    public boolean isExposeNativeSession() {
        return this.exposeNativeSession;
    }

    public void setCheckWriteOperations(boolean checkWriteOperations) {
        this.checkWriteOperations = checkWriteOperations;
    }

    public boolean isCheckWriteOperations() {
        return this.checkWriteOperations;
    }

    public void setCacheQueries(boolean cacheQueries) {
        this.cacheQueries = cacheQueries;
    }

    public boolean isCacheQueries() {
        return this.cacheQueries;
    }

    public void setQueryCacheRegion(String queryCacheRegion) {
        this.queryCacheRegion = queryCacheRegion;
    }

    public String getQueryCacheRegion() {
        return this.queryCacheRegion;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public Object execute(HibernateCallback action) throws DataAccessException {
        return this.execute(action, this.isExposeNativeSession());
    }

    public List executeFind(HibernateCallback action) throws DataAccessException {
        Object result = this.execute(action, this.isExposeNativeSession());
        if (result != null && !(result instanceof List)) {
            throw new InvalidDataAccessApiUsageException("Result object returned from HibernateCallback isn't a List: [" + result + "]");
        }
        return (List)result;
    }

    public Object execute(HibernateCallback action, boolean exposeNativeSession) throws DataAccessException {
        Assert.notNull(action, "Callback object must not be null");
        Session session = this.getSession();
        boolean existingTransaction = SessionFactoryUtils.isSessionTransactional(session, this.getSessionFactory());
        if (existingTransaction) {
            this.logger.debug("Found thread-bound Session for HibernateTemplate");
        }
        FlushMode previousFlushMode = null;
        try {
            previousFlushMode = this.applyFlushMode(session, existingTransaction);
            this.enableFilters(session);
            Session sessionToExpose = exposeNativeSession ? session : this.createSessionProxy(session);
            Object result = action.doInHibernate(sessionToExpose);
            this.flushIfNecessary(session, existingTransaction);
            Object object = result;
            return object;
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
        catch (SQLException ex) {
            throw this.convertJdbcAccessException(ex);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            if (existingTransaction) {
                this.logger.debug("Not closing pre-bound Hibernate Session after HibernateTemplate");
                this.disableFilters(session);
                if (previousFlushMode != null) {
                    session.setFlushMode(previousFlushMode);
                }
            } else if (this.isAlwaysUseNewSession()) {
                SessionFactoryUtils.closeSession(session);
            } else {
                SessionFactoryUtils.closeSessionOrRegisterDeferredClose(session, this.getSessionFactory());
            }
        }
    }

    protected Session getSession() {
        if (this.isAlwaysUseNewSession()) {
            return SessionFactoryUtils.getNewSession(this.getSessionFactory(), this.getEntityInterceptor());
        }
        if (!this.isAllowCreate()) {
            return SessionFactoryUtils.getSession(this.getSessionFactory(), false);
        }
        return SessionFactoryUtils.getSession(this.getSessionFactory(), this.getEntityInterceptor(), this.getJdbcExceptionTranslator());
    }

    protected Session createSessionProxy(Session session) {
        Class[] sessionIfcs = null;
        sessionIfcs = session instanceof SessionImplementor ? new Class[]{class$org$hibernate$Session == null ? (class$org$hibernate$Session = HibernateTemplate.class$("org.hibernate.Session")) : class$org$hibernate$Session, class$org$hibernate$engine$SessionImplementor == null ? (class$org$hibernate$engine$SessionImplementor = HibernateTemplate.class$("org.hibernate.engine.SessionImplementor")) : class$org$hibernate$engine$SessionImplementor} : new Class[]{class$org$hibernate$Session == null ? (class$org$hibernate$Session = HibernateTemplate.class$("org.hibernate.Session")) : class$org$hibernate$Session};
        return (Session)Proxy.newProxyInstance(this.getClass().getClassLoader(), sessionIfcs, (InvocationHandler)new CloseSuppressingInvocationHandler(session));
    }

    public Object get(Class entityClass, Serializable id) throws DataAccessException {
        return this.get(entityClass, id, null);
    }

    public Object get(final Class entityClass, final Serializable id, final LockMode lockMode) throws DataAccessException {
        return this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                if (lockMode != null) {
                    return session.get(entityClass, id, lockMode);
                }
                return session.get(entityClass, id);
            }
        }, true);
    }

    public Object get(String entityName, Serializable id) throws DataAccessException {
        return this.get(entityName, id, null);
    }

    public Object get(final String entityName, final Serializable id, final LockMode lockMode) throws DataAccessException {
        return this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                if (lockMode != null) {
                    return session.get(entityName, id, lockMode);
                }
                return session.get(entityName, id);
            }
        }, true);
    }

    public Object load(Class entityClass, Serializable id) throws DataAccessException {
        return this.load(entityClass, id, null);
    }

    public Object load(final Class entityClass, final Serializable id, final LockMode lockMode) throws DataAccessException {
        return this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                if (lockMode != null) {
                    return session.load(entityClass, id, lockMode);
                }
                return session.load(entityClass, id);
            }
        }, true);
    }

    public Object load(String entityName, Serializable id) throws DataAccessException {
        return this.load(entityName, id, null);
    }

    public Object load(final String entityName, final Serializable id, final LockMode lockMode) throws DataAccessException {
        return this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                if (lockMode != null) {
                    return session.load(entityName, id, lockMode);
                }
                return session.load(entityName, id);
            }
        }, true);
    }

    public List loadAll(final Class entityClass) throws DataAccessException {
        return (List)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria criteria = session.createCriteria(entityClass);
                HibernateTemplate.this.prepareCriteria(criteria);
                return criteria.list();
            }
        }, true);
    }

    public void load(final Object entity, final Serializable id) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                session.load(entity, id);
                return null;
            }
        }, true);
    }

    public void refresh(Object entity) throws DataAccessException {
        this.refresh(entity, null);
    }

    public void refresh(final Object entity, final LockMode lockMode) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                if (lockMode != null) {
                    session.refresh(entity, lockMode);
                } else {
                    session.refresh(entity);
                }
                return null;
            }
        }, true);
    }

    public boolean contains(final Object entity) throws DataAccessException {
        Boolean result = (Boolean)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                return session.contains(entity) ? Boolean.TRUE : Boolean.FALSE;
            }
        }, true);
        return result;
    }

    public void evict(final Object entity) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                session.evict(entity);
                return null;
            }
        }, true);
    }

    public void initialize(Object proxy) throws DataAccessException {
        try {
            Hibernate.initialize((Object)proxy);
        }
        catch (HibernateException ex) {
            throw SessionFactoryUtils.convertHibernateAccessException(ex);
        }
    }

    public Filter enableFilter(String filterName) throws IllegalStateException {
        Session session = SessionFactoryUtils.getSession(this.getSessionFactory(), false);
        Filter filter = session.getEnabledFilter(filterName);
        if (filter == null) {
            filter = session.enableFilter(filterName);
        }
        return filter;
    }

    public void lock(final Object entity, final LockMode lockMode) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                session.lock(entity, lockMode);
                return null;
            }
        }, true);
    }

    public void lock(final String entityName, final Object entity, final LockMode lockMode) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                session.lock(entityName, entity, lockMode);
                return null;
            }
        }, true);
    }

    public Serializable save(final Object entity) throws DataAccessException {
        return (Serializable)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                return session.save(entity);
            }
        }, true);
    }

    public Serializable save(final String entityName, final Object entity) throws DataAccessException {
        return (Serializable)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                return session.save(entityName, entity);
            }
        }, true);
    }

    public void update(Object entity) throws DataAccessException {
        this.update(entity, null);
    }

    public void update(final Object entity, final LockMode lockMode) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                session.update(entity);
                if (lockMode != null) {
                    session.lock(entity, lockMode);
                }
                return null;
            }
        }, true);
    }

    public void update(String entityName, Object entity) throws DataAccessException {
        this.update(entityName, entity, null);
    }

    public void update(final String entityName, final Object entity, final LockMode lockMode) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                session.update(entityName, entity);
                if (lockMode != null) {
                    session.lock(entity, lockMode);
                }
                return null;
            }
        }, true);
    }

    public void saveOrUpdate(final Object entity) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                session.saveOrUpdate(entity);
                return null;
            }
        }, true);
    }

    public void saveOrUpdate(final String entityName, final Object entity) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                session.saveOrUpdate(entityName, entity);
                return null;
            }
        }, true);
    }

    public void saveOrUpdateAll(final Collection entities) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                Iterator it = entities.iterator();
                while (it.hasNext()) {
                    session.saveOrUpdate(it.next());
                }
                return null;
            }
        }, true);
    }

    public void replicate(final Object entity, final ReplicationMode replicationMode) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                session.replicate(entity, replicationMode);
                return null;
            }
        }, true);
    }

    public void replicate(final String entityName, final Object entity, final ReplicationMode replicationMode) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                session.replicate(entityName, entity, replicationMode);
                return null;
            }
        }, true);
    }

    public void persist(final Object entity) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                session.persist(entity);
                return null;
            }
        }, true);
    }

    public void persist(final String entityName, final Object entity) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                session.persist(entityName, entity);
                return null;
            }
        }, true);
    }

    public Object merge(final Object entity) throws DataAccessException {
        return this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                return session.merge(entity);
            }
        }, true);
    }

    public Object merge(final String entityName, final Object entity) throws DataAccessException {
        return this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                return session.merge(entityName, entity);
            }
        }, true);
    }

    public void delete(Object entity) throws DataAccessException {
        this.delete(entity, null);
    }

    public void delete(final Object entity, final LockMode lockMode) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                if (lockMode != null) {
                    session.lock(entity, lockMode);
                }
                session.delete(entity);
                return null;
            }
        }, true);
    }

    public void deleteAll(final Collection entities) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateTemplate.this.checkWriteOperationAllowed(session);
                Iterator it = entities.iterator();
                while (it.hasNext()) {
                    session.delete(it.next());
                }
                return null;
            }
        }, true);
    }

    public void flush() throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                session.flush();
                return null;
            }
        }, true);
    }

    public void clear() throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                session.clear();
                return null;
            }
        }, true);
    }

    public List find(String queryString) throws DataAccessException {
        return this.find(queryString, null);
    }

    public List find(String queryString, Object value) throws DataAccessException {
        return this.find(queryString, new Object[]{value});
    }

    public List find(final String queryString, final Object[] values) throws DataAccessException {
        return (List)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery(queryString);
                HibernateTemplate.this.prepareQuery(queryObject);
                if (values != null) {
                    for (int i2 = 0; i2 < values.length; ++i2) {
                        queryObject.setParameter(i2, values[i2]);
                    }
                }
                return queryObject.list();
            }
        }, true);
    }

    public List findByNamedParam(String queryString, String paramName, Object value) throws DataAccessException {
        return this.findByNamedParam(queryString, new String[]{paramName}, new Object[]{value});
    }

    public List findByNamedParam(final String queryString, final String[] paramNames, final Object[] values) throws DataAccessException {
        if (paramNames.length != values.length) {
            throw new IllegalArgumentException("Length of paramNames array must match length of values array");
        }
        return (List)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery(queryString);
                HibernateTemplate.this.prepareQuery(queryObject);
                if (values != null) {
                    for (int i2 = 0; i2 < values.length; ++i2) {
                        HibernateTemplate.this.applyNamedParameterToQuery(queryObject, paramNames[i2], values[i2]);
                    }
                }
                return queryObject.list();
            }
        }, true);
    }

    public List findByValueBean(final String queryString, final Object valueBean) throws DataAccessException {
        return (List)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery(queryString);
                HibernateTemplate.this.prepareQuery(queryObject);
                queryObject.setProperties(valueBean);
                return queryObject.list();
            }
        }, true);
    }

    public List findByNamedQuery(String queryName) throws DataAccessException {
        return this.findByNamedQuery(queryName, null);
    }

    public List findByNamedQuery(String queryName, Object value) throws DataAccessException {
        return this.findByNamedQuery(queryName, new Object[]{value});
    }

    public List findByNamedQuery(final String queryName, final Object[] values) throws DataAccessException {
        return (List)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.getNamedQuery(queryName);
                HibernateTemplate.this.prepareQuery(queryObject);
                if (values != null) {
                    for (int i2 = 0; i2 < values.length; ++i2) {
                        queryObject.setParameter(i2, values[i2]);
                    }
                }
                return queryObject.list();
            }
        }, true);
    }

    public List findByNamedQueryAndNamedParam(String queryName, String paramName, Object value) throws DataAccessException {
        return this.findByNamedQueryAndNamedParam(queryName, new String[]{paramName}, new Object[]{value});
    }

    public List findByNamedQueryAndNamedParam(final String queryName, final String[] paramNames, final Object[] values) throws DataAccessException {
        if (paramNames != null && values != null && paramNames.length != values.length) {
            throw new IllegalArgumentException("Length of paramNames array must match length of values array");
        }
        return (List)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.getNamedQuery(queryName);
                HibernateTemplate.this.prepareQuery(queryObject);
                if (values != null) {
                    for (int i2 = 0; i2 < values.length; ++i2) {
                        HibernateTemplate.this.applyNamedParameterToQuery(queryObject, paramNames[i2], values[i2]);
                    }
                }
                return queryObject.list();
            }
        }, true);
    }

    public List findByNamedQueryAndValueBean(final String queryName, final Object valueBean) throws DataAccessException {
        return (List)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.getNamedQuery(queryName);
                HibernateTemplate.this.prepareQuery(queryObject);
                queryObject.setProperties(valueBean);
                return queryObject.list();
            }
        }, true);
    }

    public List findByCriteria(DetachedCriteria criteria) throws DataAccessException {
        return this.findByCriteria(criteria, -1, -1);
    }

    public List findByCriteria(final DetachedCriteria criteria, final int firstResult, final int maxResults) throws DataAccessException {
        Assert.notNull(criteria, "DetachedCriteria must not be null");
        return (List)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria executableCriteria = criteria.getExecutableCriteria(session);
                HibernateTemplate.this.prepareCriteria(executableCriteria);
                if (firstResult >= 0) {
                    executableCriteria.setFirstResult(firstResult);
                }
                if (maxResults > 0) {
                    executableCriteria.setMaxResults(maxResults);
                }
                return executableCriteria.list();
            }
        }, true);
    }

    public List findByExample(Object exampleEntity) throws DataAccessException {
        return this.findByExample(exampleEntity, -1, -1);
    }

    public List findByExample(final Object exampleEntity, final int firstResult, final int maxResults) throws DataAccessException {
        Assert.notNull(exampleEntity, "Example entity must not be null");
        return (List)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria executableCriteria = session.createCriteria(exampleEntity.getClass());
                executableCriteria.add((Criterion)Example.create((Object)exampleEntity));
                HibernateTemplate.this.prepareCriteria(executableCriteria);
                if (firstResult >= 0) {
                    executableCriteria.setFirstResult(firstResult);
                }
                if (maxResults > 0) {
                    executableCriteria.setMaxResults(maxResults);
                }
                return executableCriteria.list();
            }
        }, true);
    }

    public Iterator iterate(String queryString) throws DataAccessException {
        return this.iterate(queryString, null);
    }

    public Iterator iterate(String queryString, Object value) throws DataAccessException {
        return this.iterate(queryString, new Object[]{value});
    }

    public Iterator iterate(final String queryString, final Object[] values) throws DataAccessException {
        return (Iterator)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery(queryString);
                HibernateTemplate.this.prepareQuery(queryObject);
                if (values != null) {
                    for (int i2 = 0; i2 < values.length; ++i2) {
                        queryObject.setParameter(i2, values[i2]);
                    }
                }
                return queryObject.iterate();
            }
        }, true);
    }

    public void closeIterator(Iterator it) throws DataAccessException {
        try {
            Hibernate.close((Iterator)it);
        }
        catch (HibernateException ex) {
            throw SessionFactoryUtils.convertHibernateAccessException(ex);
        }
    }

    public int bulkUpdate(String queryString) throws DataAccessException {
        return this.bulkUpdate(queryString, null);
    }

    public int bulkUpdate(String queryString, Object value) throws DataAccessException {
        return this.bulkUpdate(queryString, new Object[]{value});
    }

    public int bulkUpdate(final String queryString, final Object[] values) throws DataAccessException {
        Integer updateCount = (Integer)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery(queryString);
                HibernateTemplate.this.prepareQuery(queryObject);
                if (values != null) {
                    for (int i2 = 0; i2 < values.length; ++i2) {
                        queryObject.setParameter(i2, values[i2]);
                    }
                }
                return new Integer(queryObject.executeUpdate());
            }
        }, true);
        return updateCount;
    }

    protected void checkWriteOperationAllowed(Session session) throws InvalidDataAccessApiUsageException {
        if (this.isCheckWriteOperations() && this.getFlushMode() != 2 && session.getFlushMode().lessThan(FlushMode.COMMIT)) {
            throw new InvalidDataAccessApiUsageException("Write operations are not allowed in read-only mode (FlushMode.NEVER/MANUAL): Turn your Session into FlushMode.COMMIT/AUTO or remove 'readOnly' marker from transaction definition.");
        }
    }

    protected void prepareQuery(Query queryObject) {
        if (this.isCacheQueries()) {
            queryObject.setCacheable(true);
            if (this.getQueryCacheRegion() != null) {
                queryObject.setCacheRegion(this.getQueryCacheRegion());
            }
        }
        if (this.getFetchSize() > 0) {
            queryObject.setFetchSize(this.getFetchSize());
        }
        if (this.getMaxResults() > 0) {
            queryObject.setMaxResults(this.getMaxResults());
        }
        SessionFactoryUtils.applyTransactionTimeout(queryObject, this.getSessionFactory());
    }

    protected void prepareCriteria(Criteria criteria) {
        if (this.isCacheQueries()) {
            criteria.setCacheable(true);
            if (this.getQueryCacheRegion() != null) {
                criteria.setCacheRegion(this.getQueryCacheRegion());
            }
        }
        if (this.getFetchSize() > 0) {
            criteria.setFetchSize(this.getFetchSize());
        }
        if (this.getMaxResults() > 0) {
            criteria.setMaxResults(this.getMaxResults());
        }
        SessionFactoryUtils.applyTransactionTimeout(criteria, this.getSessionFactory());
    }

    protected void applyNamedParameterToQuery(Query queryObject, String paramName, Object value) throws HibernateException {
        if (value instanceof Collection) {
            queryObject.setParameterList(paramName, (Collection)value);
        } else if (value instanceof Object[]) {
            queryObject.setParameterList(paramName, (Object[])value);
        } else {
            queryObject.setParameter(paramName, value);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CloseSuppressingInvocationHandler
    implements InvocationHandler {
        private final Session target;

        public CloseSuppressingInvocationHandler(Session target) {
            this.target = target;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(this.hashCode());
            }
            if (method.getName().equals("close")) {
                return null;
            }
            try {
                Object retVal = method.invoke((Object)this.target, args);
                if (retVal instanceof Query) {
                    HibernateTemplate.this.prepareQuery((Query)retVal);
                }
                if (retVal instanceof Criteria) {
                    HibernateTemplate.this.prepareCriteria((Criteria)retVal);
                }
                return retVal;
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

