/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apitransport.session;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.apitransport.session.AREncryptAPISessionNodeBase;
import com.bmc.arsys.apitransport.session.ARRpcKeyExchangeBase;
import com.bmc.arsys.apitransport.session.ARServerContext;
import com.bmc.arsys.apitransport.session.ApiRpcClientStubBase;
import com.bmc.arsys.apitransport.session.ArRpcCallContext;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.ARPublicKey;
import com.bmc.arsys.arrpc.ArControlStruct12;
import com.bmc.arsys.arrpc.ArGetServerInfo12In;
import com.bmc.arsys.arrpc.ArGetServerInfo12Out;
import com.bmc.arsys.arrpc.ArKeyExchangeBegin12In;
import com.bmc.arsys.arrpc.ArKeyExchangeBegin12Out;
import com.bmc.arsys.arrpc.ArKeyExchangeFinal12In;
import com.bmc.arsys.arrpc.ArKeyExchangeFinal12Out;
import com.bmc.arsys.arrpc.ArRandomBytes;
import com.bmc.arsys.utils.StringByteUtil;
import java.io.IOException;
import org.acplt.oncrpc.OncRpcException;
import org.apache.log4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class ARKeyExchanger
extends ARRpcKeyExchangeBase {
    private transient ApiRpcClientStubBase new;
    private transient int int;
    private transient ARPublicKey do;
    private static Logger for = Logger.getLogger(ARKeyExchanger.class);

    protected ARKeyExchanger(ApiRpcClientStubBase apiRpcClientStubBase) {
        this.new = apiRpcClientStubBase;
        this.int = 2;
        this.do = new ARPublicKey();
    }

    protected void keyExchangeHandler() throws OncRpcException, IOException, ARException, AREncryptionException {
        ArControlStruct12 arControlStruct12 = new ArControlStruct12();
        this.a(arControlStruct12);
        if (this.encryptionIsAllowed()) {
            this.new.getArRpcCallContext().setEncryptAPICalls(true);
            try {
                this.keyExchange(arControlStruct12);
            }
            catch (AREncryptionException aREncryptionException) {
                if (this.int == 0 && (aREncryptionException.getErrorNum() == 9010 || aREncryptionException.getErrorNum() == 9011)) {
                    this.new.getArRpcCallContext().setEncryptAPICalls(false);
                    String string = "";
                    ARServerContext aRServerContext = this.new.getArRpcCallContext().getServerContext();
                    if (aRServerContext != null) {
                        string = aRServerContext.getServer();
                    }
                    for.info("Error " + aREncryptionException.getErrorNum() + " turns off encrytion on the connection since Encrypt-Security-Policy is optional on server " + string);
                }
                throw aREncryptionException;
            }
        }
    }

    private void a(ArControlStruct12 arControlStruct12) throws OncRpcException, ARException, AREncryptionException {
        ArGetServerInfo12In arGetServerInfo12In = new ArGetServerInfo12In();
        arGetServerInfo12In.setControl(arControlStruct12);
        arGetServerInfo12In.requestList.value = new int[4];
        arGetServerInfo12In.requestList.value[0] = 133;
        arGetServerInfo12In.requestList.value[1] = 129;
        arGetServerInfo12In.requestList.value[2] = 132;
        arGetServerInfo12In.requestList.value[3] = 168;
        ArGetServerInfo12Out arGetServerInfo12Out = new ArGetServerInfo12Out();
        ArRpcCallContext arRpcCallContext = this.new.getArRpcCallContext();
        arRpcCallContext.setSkipXdrEncryption(true);
        this.new.arCall(97, arGetServerInfo12In, arGetServerInfo12Out);
        arRpcCallContext.setSkipXdrEncryption(false);
        ApiRpcClientStubBase.verifyStatus(arGetServerInfo12Out);
        String string = "";
        ARServerContext aRServerContext = arRpcCallContext.getServerContext();
        if (aRServerContext != null) {
            string = aRServerContext.getServer();
        }
        if (arGetServerInfo12Out.serverInfoList.value.length > 0 && arGetServerInfo12Out.serverInfoList.value[0].operation == 133) {
            this.int = arGetServerInfo12Out.serverInfoList.value[0].value.intVal;
        }
        if (arGetServerInfo12Out.serverInfoList.value.length > 1 && arGetServerInfo12Out.serverInfoList.value[1].operation == 129) {
            this.do.setKey(arGetServerInfo12Out.serverInfoList.value[1].value.byteListVal.bytes);
        }
        if (arGetServerInfo12Out.serverInfoList.value.length > 2 && arGetServerInfo12Out.serverInfoList.value[2].operation == 132) {
            arRpcCallContext.getEncCtx().setDataEncryptAlg(arGetServerInfo12Out.serverInfoList.value[2].value.intVal, this.int, string);
        }
        if (this.int != 2 && arGetServerInfo12Out.serverInfoList.value.length > 3 && arGetServerInfo12Out.serverInfoList.value[3].operation == 168) {
            this.do.setAlgorithmParam(arGetServerInfo12Out.serverInfoList.value[3].value.intVal);
        }
    }

    protected void keyExchange(ArControlStruct12 arControlStruct12) throws ARException, AREncryptionException, OncRpcException, IOException {
        ArRpcCallContext arRpcCallContext = this.new.getArRpcCallContext();
        arRpcCallContext.setSkipXdrEncryption(true);
        this.keyExchangePrepare();
        this.keyExchangeBegin(arControlStruct12);
        this.keyExchangeFinal(arControlStruct12);
        arRpcCallContext.setSkipXdrEncryption(false);
    }

    protected void keyExchangePrepare() throws AREncryptionException {
        AREncryptAPISessionNodeBase aREncryptAPISessionNodeBase = this.new.getArRpcCallContext().getEncCtx();
        aREncryptAPISessionNodeBase.setClientRandBytes(StringByteUtil.generateRandomBytes(20));
        aREncryptAPISessionNodeBase.setPreMasterKey(StringByteUtil.generateRandomBytes(40));
    }

    protected boolean encryptionIsAllowed() {
        boolean bl = true;
        bl = this.int != 2;
        ARServerContext aRServerContext = this.new.getArRpcCallContext().getServerContext();
        if (aRServerContext != null) {
            aRServerContext.setEncryptionEnabled(bl);
        }
        return bl;
    }

    protected void keyExchangeBegin(ArControlStruct12 arControlStruct12) throws ARException, OncRpcException {
        ArKeyExchangeBegin12In arKeyExchangeBegin12In = new ArKeyExchangeBegin12In();
        AREncryptAPISessionNodeBase aREncryptAPISessionNodeBase = this.new.getArRpcCallContext().getEncCtx();
        arKeyExchangeBegin12In.setControl(arControlStruct12);
        arKeyExchangeBegin12In.clientRandBytes = new ArRandomBytes(aREncryptAPISessionNodeBase.getClientRandBytes());
        ArKeyExchangeBegin12Out arKeyExchangeBegin12Out = new ArKeyExchangeBegin12Out();
        this.new.arCall(95, arKeyExchangeBegin12In, arKeyExchangeBegin12Out);
        ApiRpcClientStubBase.verifyStatus(arKeyExchangeBegin12Out);
        aREncryptAPISessionNodeBase.setServerRandBytes(arKeyExchangeBegin12Out.serverRandBytes.value);
        aREncryptAPISessionNodeBase.getClintKeyInfo().setSessionId(arKeyExchangeBegin12Out.sessionId);
    }

    protected void keyExchangeFinal(ArControlStruct12 arControlStruct12) throws AREncryptionException, ARException, OncRpcException, IOException {
        ArKeyExchangeFinal12In arKeyExchangeFinal12In = new ArKeyExchangeFinal12In();
        AREncryptAPISessionNodeBase aREncryptAPISessionNodeBase = this.new.getArRpcCallContext().getEncCtx();
        arKeyExchangeFinal12In.control = arControlStruct12;
        arKeyExchangeFinal12In.sessionId = aREncryptAPISessionNodeBase.getClintKeyInfo().getSessionId();
        for.debug("sessionID before encryption = " + arKeyExchangeFinal12In.sessionId);
        byte[] byArray = this.xdrAndEncrypPreMasterKey(this.do, aREncryptAPISessionNodeBase.getPreMasterKey());
        arKeyExchangeFinal12In.setEncPreMasterKey(byArray);
        ArKeyExchangeFinal12Out arKeyExchangeFinal12Out = new ArKeyExchangeFinal12Out();
        this.new.arCall(96, arKeyExchangeFinal12In, arKeyExchangeFinal12Out);
        ApiRpcClientStubBase.verifyStatus(arKeyExchangeFinal12Out);
        aREncryptAPISessionNodeBase.getClintKeyInfo().genDataEncKeys(aREncryptAPISessionNodeBase.getDataEncRandomBytesObj());
        aREncryptAPISessionNodeBase.resetDataEncRandomBytesObj();
        int n2 = this.unxdrAndDecryptSessionId(aREncryptAPISessionNodeBase.getClintKeyInfo().getSvrDataKey(), arKeyExchangeFinal12Out.getEncSessionId());
        for.debug("compare to org sessionId = " + aREncryptAPISessionNodeBase.getClintKeyInfo().getSessionId());
        if (aREncryptAPISessionNodeBase.getClintKeyInfo().getSessionId() != n2) {
            throw new ARException(2, 9002);
        }
        aREncryptAPISessionNodeBase.getClintKeyInfo().setSessionId(n2);
        aREncryptAPISessionNodeBase.setSessionId(n2);
    }
}

