/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.jdbc.core;

import com.bmc.thirdparty.org.springframework.dao.InvalidDataAccessApiUsageException;
import com.bmc.thirdparty.org.springframework.jdbc.core.ParameterDisposer;
import com.bmc.thirdparty.org.springframework.jdbc.core.PreparedStatementSetter;
import com.bmc.thirdparty.org.springframework.jdbc.core.StatementCreatorUtils;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;

class ArgTypePreparedStatementSetter
implements PreparedStatementSetter,
ParameterDisposer {
    private final Object[] args;
    private final int[] argTypes;

    public ArgTypePreparedStatementSetter(Object[] args, int[] argTypes) {
        if (args != null && argTypes == null || args == null && argTypes != null || args != null && args.length != argTypes.length) {
            throw new InvalidDataAccessApiUsageException("args and argTypes parameters must match");
        }
        this.args = args;
        this.argTypes = argTypes;
    }

    public void setValues(PreparedStatement ps) throws SQLException {
        int argIndx = 1;
        if (this.args != null) {
            for (int i2 = 0; i2 < this.args.length; ++i2) {
                Object arg = this.args[i2];
                if (arg instanceof Collection && this.argTypes[i2] != 2003) {
                    Collection entries = (Collection)arg;
                    Iterator it = entries.iterator();
                    while (it.hasNext()) {
                        Object entry = it.next();
                        StatementCreatorUtils.setParameterValue(ps, argIndx++, this.argTypes[i2], null, entry);
                    }
                    continue;
                }
                StatementCreatorUtils.setParameterValue(ps, argIndx++, this.argTypes[i2], null, arg);
            }
        }
    }

    public void cleanupParameters() {
        StatementCreatorUtils.cleanupParameters(this.args);
    }
}

