/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.beans.factory.support;

import com.bmc.thirdparty.org.springframework.beans.factory.support.MethodOverride;
import com.bmc.thirdparty.org.springframework.util.ObjectUtils;
import java.lang.reflect.Method;

public class LookupOverride
extends MethodOverride {
    private final String beanName;

    public LookupOverride(String methodName, String beanName) {
        super(methodName);
        this.beanName = beanName;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public boolean matches(Method method) {
        return method.getName().equals(this.getMethodName()) && method.getParameterTypes().length == 0;
    }

    public String toString() {
        return "LookupOverride for method '" + this.getMethodName() + "'; will return bean '" + this.beanName + "'";
    }

    public boolean equals(Object o2) {
        if (!super.equals(o2)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals(this.beanName, ((LookupOverride)o2).beanName);
    }

    public int hashCode() {
        return 29 * super.hashCode() + ObjectUtils.nullSafeHashCode(this.beanName);
    }
}

