/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.beans.factory.support;

import com.bmc.thirdparty.org.springframework.beans.MutablePropertyValues;
import com.bmc.thirdparty.org.springframework.beans.factory.config.ConstructorArgumentValues;
import com.bmc.thirdparty.org.springframework.beans.factory.support.AbstractBeanDefinition;
import com.bmc.thirdparty.org.springframework.beans.factory.support.BeanDefinitionValidationException;
import com.bmc.thirdparty.org.springframework.util.ObjectUtils;

public class ChildBeanDefinition
extends AbstractBeanDefinition {
    private final String parentName;

    public ChildBeanDefinition(String parentName) {
        this.parentName = parentName;
    }

    public ChildBeanDefinition(String parentName, MutablePropertyValues pvs) {
        super(null, pvs);
        this.parentName = parentName;
    }

    public ChildBeanDefinition(String parentName, ConstructorArgumentValues cargs, MutablePropertyValues pvs) {
        super(cargs, pvs);
        this.parentName = parentName;
    }

    public ChildBeanDefinition(String parentName, Class beanClass, ConstructorArgumentValues cargs, MutablePropertyValues pvs) {
        super(cargs, pvs);
        this.parentName = parentName;
        this.setBeanClass(beanClass);
    }

    public ChildBeanDefinition(String parentName, String beanClassName, ConstructorArgumentValues cargs, MutablePropertyValues pvs) {
        super(cargs, pvs);
        this.parentName = parentName;
        this.setBeanClassName(beanClassName);
    }

    public String getParentName() {
        return this.parentName;
    }

    public void validate() throws BeanDefinitionValidationException {
        super.validate();
        if (this.parentName == null) {
            throw new BeanDefinitionValidationException("parentName must be set in ChildBeanDefinition");
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof ChildBeanDefinition) || !super.equals(other)) {
            return false;
        }
        ChildBeanDefinition that = (ChildBeanDefinition)other;
        return ObjectUtils.nullSafeEquals(this.parentName, that.parentName);
    }

    public int hashCode() {
        return 29 * super.hashCode() + ObjectUtils.nullSafeHashCode(this.parentName);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Child bean with parent '");
        sb.append(this.parentName).append("': ").append(super.toString());
        return sb.toString();
    }
}

