/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arencrypt;

import com.bmc.arsys.arencrypt.ARCryptoConstants;
import com.bmc.arsys.arencrypt.AREncKeyBase;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.b;
import com.bmc.arsys.arencrypt.c;
import java.math.BigInteger;
import java.security.Key;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public abstract class ARPPKey
extends AREncKeyBase {
    private transient int l;
    private transient String k;
    private transient String j = "3";
    protected transient Key encKey;
    protected String keyID = "PPKey";
    protected boolean debug;

    protected ARPPKey() {
        this.setKeyID();
    }

    public void setAlgorithmParam(int n) throws AREncryptionException {
        if (!this.checkValidKeyEncAlgorithm(n)) {
            throw new AREncryptionException(9006);
        }
        this.a(n);
        this.for(ARCryptoConstants.ak[n - 1]);
        this.setModulusBitSize(ARCryptoConstants.O[n - 4]);
        this.setModulusBitSizeStr(ARCryptoConstants.P[n - 4]);
        this.if("RSA/ECB/OAEPWithSHA1AndMGF1Padding");
        this.do(this.getKeyID());
        this.a(ARCryptoConstants.p[this.getJCEProviderIdx()][n - 4]);
    }

    protected int getJCEProviderIdx() {
        int n = ARCryptoConstants.am > 0 ? ARCryptoConstants.am : ARCryptoConstants.I;
        return n;
    }

    protected int getModulusBitSize() {
        return this.l;
    }

    protected BigInteger getBigModulus() {
        return new BigInteger(1, this.getKey());
    }

    protected BigInteger getBigExponent() {
        return new BigInteger(this.j);
    }

    protected String getBigExponentStr() {
        return this.j;
    }

    protected void setBigExponent(String string) {
        this.j = string;
    }

    protected void setModulusBitSize(int n) {
        this.l = n;
    }

    protected abstract Key getRsaKey() throws AREncryptionException;

    protected void setModulusBitSizeStr(String string) {
        this.k = string;
    }

    protected boolean checkValidKeyEncAlgorithm(int n) throws AREncryptionException {
        boolean bl = false;
        if (byte != null && 2 == c.else) {
            for (int i = 0; i < ARCryptoConstants.char.length; ++i) {
                if (ARCryptoConstants.char[i] != n) continue;
                bl = true;
                break;
            }
        } else {
            bl = ARPPKey.isValidKeyAlg(n);
        }
        return bl;
    }

    static boolean isValidKeyAlg(int n) {
        boolean bl = false;
        for (int i = 0; i < ARCryptoConstants.h.length; ++i) {
            if (ARCryptoConstants.h[i] != n) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected void setKeyID() {
        this.keyID = "PPKey";
    }

    protected String getKeyID() {
        return this.keyID;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        if (this.case() != null) {
            stringBuilder.append("_P_").append(this.case());
        }
        if (this.k != null) {
            stringBuilder.append("_M_").append(this.k);
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append((Object)this.k).append((Object)this.keyID).toHashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof b)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        ARPPKey aRPPKey = (ARPPKey)object;
        return new EqualsBuilder().appendSuper(super.equals(object)).append((Object)this.k, (Object)aRPPKey.k).append((Object)this.keyID, (Object)aRPPKey.keyID).isEquals();
    }
}

