/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.plist;

import java.io.File;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.configuration.AbstractHierarchicalFileConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.configuration.plist.ParseException;
import org.apache.commons.configuration.plist.PropertyListParser;
import org.apache.commons.lang.StringUtils;

public class PropertyListConfiguration
extends AbstractHierarchicalFileConfiguration {
    private static final long serialVersionUID = 3227248503779092127L;
    private static final int INDENT_SIZE = 4;

    public PropertyListConfiguration() {
    }

    public PropertyListConfiguration(String fileName) throws ConfigurationException {
        super(fileName);
    }

    public PropertyListConfiguration(File file) throws ConfigurationException {
        super(file);
    }

    public PropertyListConfiguration(URL url) throws ConfigurationException {
        super(url);
    }

    public void load(Reader in) throws ConfigurationException {
        PropertyListParser parser = new PropertyListParser(in);
        try {
            PropertyListConfiguration config = parser.parse();
            this.setRoot(config.getRoot());
        }
        catch (ParseException e) {
            throw new ConfigurationException(e);
        }
    }

    public void save(Writer out) throws ConfigurationException {
        PrintWriter writer = new PrintWriter(out);
        this.printNode(writer, 0, this.getRoot());
        writer.flush();
    }

    private void printNode(PrintWriter out, int indentLevel, HierarchicalConfiguration.Node node) {
        HierarchicalConfiguration.Node child;
        String padding = StringUtils.repeat((String)" ", (int)(indentLevel * 4));
        if (node.getName() != null) {
            out.print(padding + this.quoteString(node.getName()) + " = ");
        }
        ArrayList children = new ArrayList(node.getChildren());
        Iterator it = children.iterator();
        while (it.hasNext()) {
            child = (HierarchicalConfiguration.Node)it.next();
            if (child.getValue() != null || child.getChildren() != null && !child.getChildren().isEmpty()) continue;
            it.remove();
        }
        if (!children.isEmpty()) {
            if (indentLevel > 0) {
                out.println();
            }
            out.println(padding + "{");
            it = children.iterator();
            while (it.hasNext()) {
                child = (HierarchicalConfiguration.Node)it.next();
                this.printNode(out, indentLevel + 1, child);
                Object value = child.getValue();
                if (value != null && !(value instanceof Map) && !(value instanceof Configuration)) {
                    out.println(";");
                }
                if (!it.hasNext() || value != null && !(value instanceof List)) continue;
                out.println();
            }
            out.print(padding + "}");
            if (node.getParent() != null) {
                out.println();
            }
        } else {
            Object value = node.getValue();
            this.printValue(out, indentLevel, value);
        }
    }

    private void printValue(PrintWriter out, int indentLevel, Object value) {
        String padding = StringUtils.repeat((String)" ", (int)(indentLevel * 4));
        if (value instanceof List) {
            out.print("( ");
            Iterator it = ((List)value).iterator();
            while (it.hasNext()) {
                this.printValue(out, indentLevel + 1, it.next());
                if (!it.hasNext()) continue;
                out.print(", ");
            }
            out.print(" )");
        } else if (value instanceof HierarchicalConfiguration) {
            this.printNode(out, indentLevel, ((HierarchicalConfiguration)value).getRoot());
        } else if (value instanceof Configuration) {
            out.println();
            out.println(padding + "{");
            Configuration config = (Configuration)value;
            Iterator it = config.getKeys();
            while (it.hasNext()) {
                String key = (String)it.next();
                HierarchicalConfiguration.Node node = new HierarchicalConfiguration.Node(key);
                node.setValue(config.getProperty(key));
                this.printNode(out, indentLevel + 1, node);
                out.println(";");
            }
            out.println(padding + "}");
        } else if (value instanceof Map) {
            Map map = (Map)value;
            this.printValue(out, indentLevel, new MapConfiguration(map));
        } else if (value instanceof byte[]) {
            out.print("<" + new String(Hex.encodeHex((byte[])((byte[])value))) + ">");
        } else if (value != null) {
            out.print(this.quoteString(String.valueOf(value)));
        }
    }

    String quoteString(String s) {
        if (s == null) {
            return null;
        }
        if (s.indexOf(32) != -1 || s.indexOf(9) != -1 || s.indexOf(13) != -1 || s.indexOf(10) != -1 || s.indexOf(34) != -1 || s.indexOf(40) != -1 || s.indexOf(41) != -1 || s.indexOf(123) != -1 || s.indexOf(125) != -1 || s.indexOf(61) != -1 || s.indexOf(44) != -1 || s.indexOf(59) != -1) {
            s = StringUtils.replace((String)s, (String)"\"", (String)"\\\"");
            s = "\"" + s + "\"";
        }
        return s;
    }
}

