/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.report;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARNativeAuthenticationInfo;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.EntryListFieldInfo;
import com.bmc.arsys.api.OutputInteger;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.SortInfo;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.VendorForm;
import com.bmc.arsys.arreporting.ReportDelegator;
import com.bmc.arsys.arreporting.Utilities;
import com.bmc.arsys.plugins.report.FieldInfoTable;
import com.bmc.arsys.plugins.report.IReportForm;
import com.bmc.arsys.plugins.report.PluginLogListener;
import com.bmc.arsys.plugins.report.ReportDesigner;
import com.bmc.arsys.pluginsvr.plugins.ARDBCPlugin;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARVendorField;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportForms
extends ARDBCPlugin {
    private static final String FORM_FIELD_INFO_TABLE = "AR System Form Field Info";
    private static final String REPORT_DESIGNER_TABLE = "AR System Report Designer";
    private static HashMap<String, IReportForm> MReportForms = new HashMap();
    private String serverName = "localhost";
    private static ReportDelegator delegator;
    private ARServerUser serverUser = null;

    public static void init(ARPluginContext aRPluginContext) {
        MReportForms.put(FORM_FIELD_INFO_TABLE, new FieldInfoTable());
        try {
            Properties properties = new Properties();
            String string = aRPluginContext.getConfigItem(aRPluginContext.getPluginInfo(), "birtinstallpath");
            if (string != null && string.length() > 0) {
                aRPluginContext.logMessage(0, "Birt runtime path - " + string);
                File file = new File(string);
                String string2 = file.getAbsolutePath() + System.getProperty("file.separator") + "ReportEngine";
                String string3 = string2 + System.getProperty("file.separator") + "templates";
                String string4 = file.getAbsolutePath() + System.getProperty("file.separator") + "logs";
                String string5 = file.getAbsolutePath() + System.getProperty("file.separator") + "reports";
                properties.setProperty("birt.engine", string2);
                properties.setProperty("birt.template.dir", string3);
                properties.setProperty("birt.log.dir", string4);
                properties.setProperty("birt.reports.dir", string5);
            }
            delegator = new ReportDelegator(properties, new PluginLogListener(aRPluginContext));
            delegator.initializeEngines();
            MReportForms.put(REPORT_DESIGNER_TABLE, new ReportDesigner(delegator));
            aRPluginContext.logMessage(0, "Delegator Intialized");
        }
        catch (ARException aRException) {
            aRPluginContext.logMessage(2, aRException.getMessage());
        }
    }

    @Override
    public void initialize(ARPluginContext aRPluginContext) throws ARException {
        int n;
        String[] stringArray = aRPluginContext.getCmdLineArgs();
        String string = "initialize method was invoked with args = ";
        if (stringArray.length >= 0) {
            for (n = 0; n < stringArray.length; ++n) {
                string = string + " " + stringArray[n];
            }
        }
        aRPluginContext.logMessage(0, string);
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].equals("-x")) continue;
            this.serverName = stringArray[n + 1];
            n = stringArray.length;
        }
        aRPluginContext.logMessage(0, "Server name = " + this.serverName);
        this.initServerUser(aRPluginContext);
    }

    @Override
    public List<ARVendorField> getMultipleFields(ARPluginContext aRPluginContext, VendorForm vendorForm) throws ARException {
        aRPluginContext.logMessage(0, "getMultipleFields()");
        this.initServerUser(aRPluginContext);
        IReportForm iReportForm = MReportForms.get(vendorForm.getTableName());
        if (iReportForm != null) {
            return iReportForm.getMultipleFields(aRPluginContext, this.serverUser, vendorForm);
        }
        return null;
    }

    @Override
    public List<Entry> getListEntryWithFields(ARPluginContext aRPluginContext, String string, List<ARVendorField> list, long l, QualifierInfo qualifierInfo, List<SortInfo> list2, List<EntryListFieldInfo> list3, int n, int n2, OutputInteger outputInteger) throws ARException {
        aRPluginContext.logMessage(0, "getListEntryWithFields()");
        aRPluginContext.logMessage(0, "getListEntryWithFields() " + qualifierInfo.toString());
        this.initServerUser(aRPluginContext);
        IReportForm iReportForm = MReportForms.get(string);
        if (iReportForm != null) {
            return iReportForm.getListEntryWithFields(aRPluginContext, this.serverUser, string, list, l, qualifierInfo, list2, list3, n, n2, outputInteger);
        }
        return null;
    }

    @Override
    public List<VendorForm> getListForms(ARPluginContext aRPluginContext) throws ARException {
        aRPluginContext.logMessage(0, "getListForms()");
        String string = aRPluginContext.getPluginInfo().getName();
        ArrayList<VendorForm> arrayList = new ArrayList<VendorForm>();
        arrayList.add(new VendorForm(string, FORM_FIELD_INFO_TABLE));
        arrayList.add(new VendorForm(string, REPORT_DESIGNER_TABLE));
        return arrayList;
    }

    @Override
    public Entry getEntry(ARPluginContext aRPluginContext, String string, List<ARVendorField> list, long l, String string2, int[] nArray) throws ARException {
        aRPluginContext.logMessage(0, "getEntry()");
        this.initServerUser(aRPluginContext);
        IReportForm iReportForm = MReportForms.get(string);
        if (iReportForm != null) {
            return iReportForm.getEntry(aRPluginContext, this.serverUser, string, list, l, string2, nArray);
        }
        return null;
    }

    @Override
    public String createEntry(ARPluginContext aRPluginContext, String string, List<ARVendorField> list, long l, Entry entry) throws ARException {
        aRPluginContext.logMessage(0, "getEntry()");
        this.initServerUser(aRPluginContext);
        IReportForm iReportForm = MReportForms.get(string);
        if (iReportForm != null) {
            return iReportForm.createEntry(aRPluginContext, this.serverUser, string, list, l, entry);
        }
        return null;
    }

    @Override
    public void setEntry(ARPluginContext aRPluginContext, String string, List<ARVendorField> list, long l, String string2, Entry entry, Timestamp timestamp) throws ARException {
        aRPluginContext.logMessage(0, "setEntry()");
        this.initServerUser(aRPluginContext);
        IReportForm iReportForm = MReportForms.get(string);
        if (iReportForm != null) {
            iReportForm.setEntry(aRPluginContext, this.serverUser, string, list, l, string2, entry, timestamp);
        }
    }

    private void initServerUser(ARPluginContext aRPluginContext) throws ARException {
        aRPluginContext.logMessage(0, "initServerUser()");
        if (this.serverUser == null) {
            this.serverUser = new ARServerUser((ARNativeAuthenticationInfo)aRPluginContext, "", this.serverName);
            int n = Utilities.getIntegerValue(aRPluginContext.getARConfigEntry("TCD-Specific-Port"));
            this.serverUser.setPort(n);
            int n2 = Utilities.getIntegerValue(aRPluginContext.getARConfigEntry("Plugin-Loopback-RPC-Socket"));
            if (n2 > 0) {
                this.serverUser.usePrivateRpcQueue(n2);
            }
            this.serverUser.setVUIType(1);
        }
        this.serverUser.setUserContext((ARNativeAuthenticationInfo)aRPluginContext);
    }
}

