/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.arealdap;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.plugins.arealdap.LDAPProps;
import com.bmc.arsys.pluginsvr.plugins.AREAPlugin;
import com.bmc.arsys.pluginsvr.plugins.AREAResponse;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class AREALdapPlugin
extends AREAPlugin {
    private ARPluginInfo pluginInfo = new ARPluginInfo("AREA.LDAP", this);

    public void initialize(ARPluginContext aRPluginContext) throws ARException {
        aRPluginContext.logMessage(0, "Initialising AREA LDAP plugin.");
    }

    public static void main(String[] stringArray) {
    }

    public boolean areaNeedSync(ARPluginContext aRPluginContext) throws ARException {
        return false;
    }

    public AREAResponse areaVerifyLogin(ARPluginContext aRPluginContext, String string, String string2, String string3, String string4) throws ARException {
        boolean bl = true;
        this.logInfoMessage(aRPluginContext, "areaVerifyLogin()");
        AREAResponse aREAResponse = new AREAResponse();
        LDAPProps lDAPProps = this.initLdapProps(aRPluginContext);
        if (string2 == null) {
            bl = false;
        }
        if (this.isEmpty(string2) && bl) {
            aRPluginContext.logMessage(this.pluginInfo, 2, "Password cannot be empty for external authentication");
            return null;
        }
        if (!lDAPProps.getUseSSL()) {
            try {
                Properties properties = this.configurePlainLdapProps(lDAPProps);
                this.logInfoMessage(aRPluginContext, "Connecting to LDAP: " + properties);
                InitialDirContext initialDirContext = new InitialDirContext(properties);
                if (initialDirContext != null) {
                    this.logInfoMessage(aRPluginContext, "Successully bound to LDAP Server");
                } else {
                    this.logErrorMessage(aRPluginContext, "Failed to bind to the ldap");
                }
                this.logInfoMessage(aRPluginContext, "connect timeout used: " + lDAPProps.getTimeout());
                String string5 = this.replaceKeywords(lDAPProps.getUserBase(), null, string, string4, string3);
                String string6 = this.replaceKeywords(lDAPProps.getUserFilter(), null, string, string4, string3);
                SearchControls searchControls = new SearchControls();
                searchControls.setSearchScope(2);
                NamingEnumeration namingEnumeration = this.searchLdapServer(initialDirContext, string5, searchControls, string6, lDAPProps.getChaseReferral());
                String string7 = this.populateUserDetails(namingEnumeration, aREAResponse, lDAPProps, string, string2);
                if (string7 != null && lDAPProps.getUseGroups() == 1 && string2 == null && lDAPProps.getGroupBase() != null && lDAPProps.getGroupFilter() != null) {
                    String string8;
                    String string9 = "cn";
                    String string10 = this.replaceKeywords(lDAPProps.getGroupBase(), string7, string, string4, string3);
                    NamingEnumeration namingEnumeration2 = this.searchLdapServer(initialDirContext, string10, searchControls, string8 = this.replaceKeywords(lDAPProps.getGroupFilter(), string7, string, string4, string3), lDAPProps.getChaseReferral());
                    if (namingEnumeration2 != null) {
                        while (namingEnumeration2.hasMoreElements()) {
                            SearchResult searchResult = (SearchResult)namingEnumeration.next();
                            Attribute attribute = searchResult.getAttributes().get(string9);
                            StringBuffer stringBuffer = new StringBuffer();
                            for (int i = 0; i < attribute.size(); ++i) {
                                stringBuffer.append(";" + attribute.get(i));
                            }
                            if (attribute.size() > 0) {
                                aREAResponse.setGroups(stringBuffer.toString());
                                continue;
                            }
                            aREAResponse.setGroups(lDAPProps.getDefaultGroups());
                        }
                    }
                }
                if (string7 != null) {
                    if (string2 != null) {
                        aREAResponse.setLoginStatus(0);
                        aREAResponse.setMessageText(null);
                        this.logInfoMessage(aRPluginContext, "Found valid user : " + string);
                    } else {
                        aREAResponse.setLoginStatus(2);
                        aREAResponse.setMessageText(null);
                        this.logInfoMessage(aRPluginContext, "Found user but password is bad");
                    }
                } else {
                    aREAResponse.setLoginStatus(1);
                    aREAResponse.setMessageText(null);
                    this.logInfoMessage(aRPluginContext, "We do not know the user");
                }
            }
            catch (NamingException namingException) {
                System.out.println(namingException.getMessage());
            }
        }
        return aREAResponse;
    }

    private String populateUserDetails(NamingEnumeration namingEnumeration, AREAResponse aREAResponse, LDAPProps lDAPProps, String string, String string2) throws NamingException {
        String string3 = null;
        if (namingEnumeration != null) {
            while (namingEnumeration.hasMoreElements()) {
                String string4;
                String string5;
                String string6;
                String string7;
                int n;
                CharSequence charSequence;
                Object object;
                Object object2;
                SearchResult searchResult = (SearchResult)namingEnumeration.next();
                string3 = searchResult.getNameInNamespace();
                Properties properties = this.configurePlainLdapProps(lDAPProps);
                properties.setProperty("java.naming.security.principal", string3);
                properties.setProperty("java.naming.security.credentials", string2);
                try {
                    object2 = new InitialDirContext(properties);
                }
                catch (NamingException namingException) {
                    string3 = null;
                    continue;
                }
                object2 = searchResult.getAttributes();
                String string8 = lDAPProps.getEmailAttribName();
                if (string8 != null) {
                    String string9 = (String)object2.get(string8).get();
                    if (this.isEmpty(string9)) {
                        aREAResponse.setEmail(this.replaceKeywords(lDAPProps.getDefaultEmail(), null, string, null, null));
                    } else {
                        aREAResponse.setEmail(string9.toUpperCase());
                    }
                }
                int n2 = lDAPProps.getUseGroups();
                String string10 = lDAPProps.getRolesAttribName();
                if (n2 == 0 && string10 != null) {
                    object = object2.get(string10);
                    charSequence = new StringBuffer();
                    for (n = 0; n < object.size(); ++n) {
                        ((StringBuffer)charSequence).append(";" + object.get(n));
                    }
                    if (object.size() > 0) {
                        aREAResponse.setGroups(((StringBuffer)charSequence).toString());
                    } else {
                        aREAResponse.setGroups(lDAPProps.getDefaultRoles());
                    }
                }
                if ((object = lDAPProps.getNotifyMeth()) != null) {
                    try {
                        int n3 = Integer.parseInt((String)object2.get((String)object).get());
                        if (n3 < 3) {
                            aREAResponse.setNotifyMech(n3);
                        } else {
                            aREAResponse.setNotifyMech(0);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        aREAResponse.setNotifyMech(lDAPProps.getDefaultNotifyMech());
                    }
                }
                if ((charSequence = lDAPProps.getLicenseMaskAttribName()) != null) {
                    try {
                        n = Integer.parseInt((String)object2.get((String)charSequence).get());
                        aREAResponse.setLicenseMask(n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if ((string7 = lDAPProps.getLicenseTypeAttribName()) != null) {
                    try {
                        int n4 = Integer.parseInt((String)object2.get(string7).get());
                        if (n4 == 3 || n4 == 2) {
                            aREAResponse.setLicenseWrite(n4);
                        } else {
                            aREAResponse.setLicenseWrite(0);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        aREAResponse.setLicenseWrite(0);
                    }
                }
                if ((string6 = lDAPProps.getLicenseFTSAttribName()) != null) {
                    try {
                        int n5 = Integer.parseInt((String)object2.get(string6).get());
                        if (n5 == 3) {
                            aREAResponse.setLicenseFTS(n5);
                        } else {
                            aREAResponse.setLicenseFTS(0);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        aREAResponse.setLicenseFTS(0);
                    }
                }
                if ((string5 = lDAPProps.getLicenseRes1AttribName()) != null) {
                    try {
                        int n6 = Integer.parseInt((String)object2.get(string5).get());
                        if (n6 == 3) {
                            aREAResponse.setLicenseRes1(n6);
                        } else {
                            aREAResponse.setLicenseRes1(0);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        aREAResponse.setLicenseRes1(0);
                    }
                }
                if ((string4 = lDAPProps.getLicenseAppAttribName()) == null) continue;
                String string11 = (String)object2.get(string4).get();
                aREAResponse.setLicenseApps(string11);
            }
        }
        return string3;
    }

    private void logErrorMessage(ARPluginContext aRPluginContext, String string) {
        aRPluginContext.logMessage(this.pluginInfo, 2, string);
    }

    private void logInfoMessage(ARPluginContext aRPluginContext, String string) {
        aRPluginContext.logMessage(this.pluginInfo, 0, string);
    }

    private Properties configurePlainLdapProps(LDAPProps lDAPProps) {
        Properties properties = new Properties();
        properties.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        properties.put("java.naming.provider.url", lDAPProps.getURL());
        properties.put("java.naming.security.authentication", "simple");
        properties.put("java.naming.security.principal", lDAPProps.getBindUser());
        properties.put("java.naming.security.credentials", lDAPProps.getBindPasswd());
        properties.put("com.sun.jndi.ldap.connect.timeout", Integer.toString(lDAPProps.getTimeout() * 1000));
        return properties;
    }

    private LDAPProps initLdapProps(ARPluginContext aRPluginContext) {
        LDAPProps lDAPProps = new LDAPProps();
        lDAPProps.init(aRPluginContext);
        return lDAPProps;
    }

    private boolean isEmpty(String string) {
        return string == null || string.equals("");
    }

    private String replaceKeywords(String string, String string2, String string3, String string4, String string5) {
        if (string2 != null) {
            string = string.replace("$\\DN$", string2);
        }
        if (string3 != null) {
            string = string.replace("$\\USER$", string3);
        }
        if (string4 != null) {
            string = string.replace("$\\AUTHSTRING$", string4);
        }
        if (string5 != null) {
            string = string.replace("$\\NETWORKADDR$", string5);
        }
        return string;
    }

    private NamingEnumeration searchLdapServer(DirContext dirContext, String string, SearchControls searchControls, String string2, String string3) throws NamingException {
        NamingEnumeration<SearchResult> namingEnumeration = null;
        if ("F".equalsIgnoreCase(string3)) {
            namingEnumeration = dirContext.search(string, string2, searchControls);
        }
        return namingEnumeration;
    }
}

