/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.server;

import java.io.IOException;
import java.net.Socket;
import org.acplt.oncrpc.OncRpcAuthenticationException;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcTcpSocketHelper;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrDecodingStream;
import org.acplt.oncrpc.XdrEncodingStream;
import org.acplt.oncrpc.XdrTcpDecodingStream;
import org.acplt.oncrpc.XdrTcpEncodingStream;
import org.acplt.oncrpc.server.OncRpcCallInformation;
import org.acplt.oncrpc.server.OncRpcDispatchable;
import org.acplt.oncrpc.server.OncRpcServerReplyMessage;
import org.acplt.oncrpc.server.OncRpcServerTransport;
import org.acplt.oncrpc.server.OncRpcServerTransportRegistrationInfo;
import org.acplt.oncrpc.server.OncRpcTcpServerTransport;

public class OncRpcTcpConnectionServerTransport
extends OncRpcServerTransport {
    private Socket socket;
    private OncRpcTcpSocketHelper socketHelper;
    private XdrTcpEncodingStream sendingXdr;
    private XdrTcpDecodingStream receivingXdr;
    private boolean pendingDecoding = false;
    private boolean pendingEncoding = false;
    private OncRpcTcpServerTransport parent;
    protected int transmissionTimeout;

    public OncRpcTcpConnectionServerTransport(OncRpcDispatchable oncRpcDispatchable, Socket socket, int n2, int n3, int n4, OncRpcTcpServerTransport oncRpcTcpServerTransport, int n5) throws OncRpcException, IOException {
        this(oncRpcDispatchable, socket, new OncRpcServerTransportRegistrationInfo[]{new OncRpcServerTransportRegistrationInfo(n2, n3)}, n4, oncRpcTcpServerTransport, n5);
    }

    public OncRpcTcpConnectionServerTransport(OncRpcDispatchable oncRpcDispatchable, Socket socket, OncRpcServerTransportRegistrationInfo[] oncRpcServerTransportRegistrationInfoArray, int n2, OncRpcTcpServerTransport oncRpcTcpServerTransport, int n3) throws OncRpcException, IOException {
        super(oncRpcDispatchable, 0, oncRpcServerTransportRegistrationInfoArray);
        this.parent = oncRpcTcpServerTransport;
        this.transmissionTimeout = n3;
        if (n2 < 1024) {
            n2 = 1024;
        }
        this.socket = socket;
        this.port = socket.getLocalPort();
        this.socketHelper = new OncRpcTcpSocketHelper(socket);
        if (this.socketHelper.getSendBufferSize() < n2) {
            this.socketHelper.setSendBufferSize(n2);
        }
        if (this.socketHelper.getReceiveBufferSize() < n2) {
            this.socketHelper.setReceiveBufferSize(n2);
        }
        this.sendingXdr = new XdrTcpEncodingStream(socket, n2);
        this.receivingXdr = new XdrTcpDecodingStream(socket, n2);
        this.setCharacterEncoding(oncRpcTcpServerTransport.getCharacterEncoding());
    }

    public void close() {
        Object object;
        if (this.socket != null) {
            object = this.socket;
            this.socket = null;
            try {
                ((Socket)object).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.sendingXdr != null) {
            object = this.sendingXdr;
            this.sendingXdr = null;
            try {
                ((XdrEncodingStream)object).close();
            }
            catch (IOException iOException) {
            }
            catch (OncRpcException oncRpcException) {
                // empty catch block
            }
        }
        if (this.receivingXdr != null) {
            object = this.receivingXdr;
            this.receivingXdr = null;
            try {
                ((XdrDecodingStream)object).close();
            }
            catch (IOException iOException) {
            }
            catch (OncRpcException oncRpcException) {
                // empty catch block
            }
        }
        if (this.parent != null) {
            this.parent.removeTransport(this);
            this.parent = null;
        }
    }

    protected void finalize() {
        if (this.parent != null) {
            this.parent.removeTransport(this);
        }
    }

    public void register() throws OncRpcException {
        throw new Error("OncRpcTcpServerTransport.register() is abstract and can not be called.");
    }

    public void retrieveCall(XdrAble xdrAble) throws OncRpcException, IOException {
        xdrAble.xdrDecode(this.receivingXdr);
        if (this.pendingDecoding) {
            this.pendingDecoding = false;
            this.receivingXdr.endDecoding();
        }
    }

    protected XdrDecodingStream getXdrDecodingStream() {
        return this.receivingXdr;
    }

    protected void endDecoding() throws OncRpcException, IOException {
        if (this.pendingDecoding) {
            this.pendingDecoding = false;
            this.receivingXdr.endDecoding();
        }
    }

    protected XdrEncodingStream getXdrEncodingStream() {
        return this.sendingXdr;
    }

    protected void beginEncoding(OncRpcCallInformation oncRpcCallInformation, OncRpcServerReplyMessage oncRpcServerReplyMessage) throws OncRpcException, IOException {
        if (this.pendingDecoding) {
            this.pendingDecoding = false;
            this.receivingXdr.endDecoding();
        }
        this.pendingEncoding = true;
        this.sendingXdr.beginEncoding(oncRpcCallInformation.peerAddress, oncRpcCallInformation.peerPort);
        oncRpcServerReplyMessage.xdrEncode(this.sendingXdr);
    }

    protected void endEncoding() throws OncRpcException, IOException {
        this.sendingXdr.endEncoding();
        this.pendingEncoding = false;
    }

    protected void reply(OncRpcCallInformation oncRpcCallInformation, OncRpcServerReplyMessage oncRpcServerReplyMessage, XdrAble xdrAble) throws OncRpcException, IOException {
        this.beginEncoding(oncRpcCallInformation, oncRpcServerReplyMessage);
        if (xdrAble != null) {
            xdrAble.xdrEncode(this.sendingXdr);
        }
        this.endEncoding();
    }

    public void listen() {
        Thread thread = new Thread("TCP server transport connection thread"){

            public void run() {
                OncRpcTcpConnectionServerTransport.this.initializeThreadData();
                OncRpcTcpConnectionServerTransport.this._listen();
                OncRpcTcpConnectionServerTransport.this.cleanUp();
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    private void _listen() {
        OncRpcCallInformation oncRpcCallInformation = new OncRpcCallInformation(this);
        while (true) {
            try {
                this.socket.setSoTimeout(0);
                this.pendingDecoding = true;
                this.receivingXdr.beginDecoding();
                oncRpcCallInformation.peerAddress = this.receivingXdr.getSenderAddress();
                oncRpcCallInformation.peerPort = this.receivingXdr.getSenderPort();
                this.socket.setSoTimeout(this.transmissionTimeout);
            }
            catch (IOException iOException) {
                this.close();
                return;
            }
            catch (OncRpcException oncRpcException) {
                this.close();
                return;
            }
            try {
                oncRpcCallInformation.callMessage.xdrDecode(this.receivingXdr);
            }
            catch (IOException iOException) {
                this.close();
                return;
            }
            catch (OncRpcException oncRpcException) {
                if (!this.pendingDecoding) continue;
                this.pendingDecoding = false;
                try {
                    this.receivingXdr.endDecoding();
                    continue;
                }
                catch (IOException iOException) {
                    this.close();
                    return;
                }
                catch (OncRpcException oncRpcException2) {
                    continue;
                }
            }
            try {
                this.dispatchCall(oncRpcCallInformation);
                continue;
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                exception.printStackTrace();
                if (this.pendingEncoding) {
                    this.close();
                    return;
                }
                if (this.pendingDecoding) {
                    this.pendingDecoding = false;
                    try {
                        this.receivingXdr.endDecoding();
                    }
                    catch (IOException iOException) {
                        this.close();
                        return;
                    }
                    catch (OncRpcException oncRpcException) {
                        // empty catch block
                    }
                }
                try {
                    if (exception instanceof OncRpcAuthenticationException) {
                        oncRpcCallInformation.failAuthenticationFailed(((OncRpcAuthenticationException)exception).getAuthStatus());
                        continue;
                    }
                    oncRpcCallInformation.failSystemError();
                    continue;
                }
                catch (IOException iOException) {
                    this.close();
                    return;
                }
                catch (OncRpcException oncRpcException) {
                    continue;
                }
            }
            break;
        }
    }

    public void setCharacterEncoding(String string) {
        this.sendingXdr.setCharacterEncoding(string);
        this.receivingXdr.setCharacterEncoding(string);
    }

    public String getCharacterEncoding() {
        return this.sendingXdr.getCharacterEncoding();
    }

    protected void setXdrTcpEncodingStream(XdrTcpEncodingStream xdrTcpEncodingStream) {
        this.sendingXdr = xdrTcpEncodingStream;
    }

    protected void setXdrTcpDecodingStream(XdrTcpDecodingStream xdrTcpDecodingStream) {
        this.receivingXdr = xdrTcpDecodingStream;
    }

    protected Socket getSocket() {
        return this.socket;
    }

    protected void dispatchCall(OncRpcCallInformation oncRpcCallInformation) throws IOException, OncRpcException {
        this.dispatcher.dispatchOncRpcCall(oncRpcCallInformation, oncRpcCallInformation.callMessage.program, oncRpcCallInformation.callMessage.version, oncRpcCallInformation.callMessage.procedure);
    }

    protected void initializeThreadData() {
    }

    protected void cleanUp() {
    }
}

