/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.text.SimpleDateFormat;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrEncodingStream;

public class XdrTcpEncodingStream
extends XdrEncodingStream {
    private static SimpleDateFormat formatter = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss.SSS");
    private static PrintWriter debugout = null;
    private Socket socket;
    OutputStream stream;
    private byte[] buffer;
    private int bufferIndex;
    private int bufferHighmark;
    private int bufferFragmentHeaderIndex;
    private static final byte[] paddingZeros = new byte[]{0, 0, 0, 0};

    public XdrTcpEncodingStream(Socket socket, int n2) throws IOException {
        this.socket = socket;
        this.stream = this.socket.getOutputStream();
        if (n2 < 1024) {
            n2 = 1024;
        }
        if ((n2 & 3) != 0) {
            n2 = n2 + 4 & 0xFFFFFFFC;
        }
        this.buffer = new byte[n2];
        this.bufferFragmentHeaderIndex = 0;
        this.bufferIndex = 4;
        this.bufferHighmark = n2 - 4;
    }

    protected XdrTcpEncodingStream(Socket socket, byte[] byArray) throws IOException {
        this.socket = socket;
        this.stream = this.socket.getOutputStream();
        this.buffer = byArray;
        this.bufferFragmentHeaderIndex = 0;
        this.bufferIndex = 4;
        this.bufferHighmark = byArray.length - 4;
    }

    public InetAddress getSenderAddress() {
        return this.socket.getInetAddress();
    }

    public int getSenderPort() {
        return this.socket.getPort();
    }

    public void beginEncoding(InetAddress inetAddress, int n2) throws OncRpcException, IOException {
    }

    public void endEncoding() throws OncRpcException, IOException {
        this.flush(true, false);
    }

    public void endEncoding(boolean bl) throws OncRpcException, IOException {
        this.flush(true, !bl);
    }

    private void flush(boolean bl, boolean bl2) throws OncRpcException, IOException {
        int n2 = this.bufferIndex - this.bufferFragmentHeaderIndex - 4;
        if (bl) {
            n2 |= Integer.MIN_VALUE;
        }
        this.buffer[this.bufferFragmentHeaderIndex] = (byte)(n2 >>> 24);
        this.buffer[this.bufferFragmentHeaderIndex + 1] = (byte)(n2 >>> 16);
        this.buffer[this.bufferFragmentHeaderIndex + 2] = (byte)(n2 >>> 8);
        this.buffer[this.bufferFragmentHeaderIndex + 3] = (byte)n2;
        if (debugout != null) {
            String string = "flush: lastFragment=" + bl + " batch=" + bl2 + " bufferIndex=" + this.bufferIndex + " bufferHighmark=" + this.bufferHighmark;
            string = "/* " + formatter.format(System.currentTimeMillis()) + " */" + string;
            debugout.println(string);
        }
        if (!bl || !bl2 || this.bufferIndex >= this.bufferHighmark) {
            this.streamFlush(bl);
            this.bufferFragmentHeaderIndex = 0;
            this.bufferIndex = 4;
        } else {
            this.bufferFragmentHeaderIndex = this.bufferIndex;
            this.bufferIndex += 4;
        }
    }

    protected void streamFlush(boolean bl) throws IOException {
        if (debugout != null) {
            String string = "streamFlush, bytes=" + this.bufferIndex;
            string = "/* " + formatter.format(System.currentTimeMillis()) + " */" + string;
            debugout.println(string);
        }
        this.stream.write(this.buffer, 0, this.bufferIndex);
        this.stream.flush();
    }

    public void close() throws OncRpcException, IOException {
        this.buffer = null;
        this.socket = null;
    }

    public void xdrEncodeInt(int n2) throws OncRpcException, IOException {
        if (this.bufferIndex > this.bufferHighmark) {
            this.flush(false, false);
        }
        this.buffer[this.bufferIndex++] = (byte)(n2 >>> 24);
        this.buffer[this.bufferIndex++] = (byte)(n2 >>> 16);
        this.buffer[this.bufferIndex++] = (byte)(n2 >>> 8);
        this.buffer[this.bufferIndex++] = (byte)n2;
    }

    public void xdrEncodeOpaque(byte[] byArray, int n2, int n3) throws OncRpcException, IOException {
        int n4 = 4 - (n3 & 3) & 3;
        while (n3 > 0) {
            int n5 = this.bufferHighmark - this.bufferIndex + 4;
            if (n5 >= n3) {
                System.arraycopy(byArray, n2, this.buffer, this.bufferIndex, n3);
                this.bufferIndex += n3;
                break;
            }
            System.arraycopy(byArray, n2, this.buffer, this.bufferIndex, n5);
            this.bufferIndex += n5;
            n2 += n5;
            n3 -= n5;
            this.flush(false, false);
        }
        System.arraycopy(paddingZeros, 0, this.buffer, this.bufferIndex, n4);
        this.bufferIndex += n4;
    }

    protected byte[] getBuffer() {
        return this.buffer;
    }

    public int getBufferIndex() {
        return this.bufferIndex;
    }

    protected void setBufferIndex(int n2) {
        this.bufferIndex = n2;
    }

    protected void setBufferHighmark(int n2) {
        this.bufferHighmark = n2;
    }

    protected void replaceBuffer(byte[] byArray) {
        this.buffer = byArray;
    }

    protected byte[] getBufferArray() {
        return this.buffer;
    }
}

