/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.net.InetAddress;
import org.acplt.oncrpc.OncRpcClientAuth;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcPortmapClient;
import org.acplt.oncrpc.OncRpcTcpClient;
import org.acplt.oncrpc.OncRpcUdpClient;
import org.acplt.oncrpc.XdrAble;

public abstract class OncRpcClient {
    protected InetAddress host;
    protected int timeout = 30000;
    protected int program;
    protected int version;
    protected int port;
    protected int xid;
    protected OncRpcClientAuth auth;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OncRpcClient(InetAddress inetAddress, int n2, int n3, int n4, int n5) throws OncRpcException, IOException {
        this.host = inetAddress;
        this.program = n2;
        this.version = n3;
        long l2 = System.currentTimeMillis();
        this.xid = (int)l2 ^ (int)(l2 >>> 32);
        if (n4 == 0 && n5 != -42) {
            OncRpcPortmapClient oncRpcPortmapClient = new OncRpcPortmapClient(inetAddress, n5);
            try {
                n4 = oncRpcPortmapClient.getPort(n2, n3, n5);
            }
            finally {
                oncRpcPortmapClient.close();
            }
        }
        this.port = n4;
    }

    public static OncRpcClient newOncRpcClient(InetAddress inetAddress, int n2, int n3, int n4) throws OncRpcException, IOException {
        return OncRpcClient.newOncRpcClient(inetAddress, n2, n3, 0, n4);
    }

    public static OncRpcClient newOncRpcClient(InetAddress inetAddress, int n2, int n3, int n4, int n5) throws OncRpcException, IOException {
        switch (n5) {
            case 17: {
                return new OncRpcUdpClient(inetAddress, n2, n3, n4);
            }
            case 6: {
                return new OncRpcTcpClient(inetAddress, n2, n3, n4);
            }
        }
        throw new OncRpcException(17);
    }

    public void close() throws OncRpcException {
    }

    public synchronized void call(int n2, XdrAble xdrAble, XdrAble xdrAble2) throws OncRpcException {
        this.call(n2, this.version, xdrAble, xdrAble2);
    }

    public abstract void call(int var1, int var2, XdrAble var3, XdrAble var4) throws OncRpcException;

    public void setTimeout(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("timeouts can not be negative.");
        }
        this.timeout = n2;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getProgram() {
        return this.program;
    }

    public int getVersion() {
        return this.version;
    }

    public InetAddress getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setAuth(OncRpcClientAuth oncRpcClientAuth) {
        this.auth = oncRpcClientAuth;
    }

    public OncRpcClientAuth getAuth() {
        return this.auth;
    }

    public abstract void setCharacterEncoding(String var1);

    public abstract String getCharacterEncoding();

    protected void nextXid() {
        ++this.xid;
        this.xid &= Integer.MAX_VALUE;
    }
}

