/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.transaction.annotation;

import com.bmc.thirdparty.org.springframework.core.annotation.AnnotationUtils;
import com.bmc.thirdparty.org.springframework.transaction.annotation.Transactional;
import com.bmc.thirdparty.org.springframework.transaction.interceptor.AbstractFallbackTransactionAttributeSource;
import com.bmc.thirdparty.org.springframework.transaction.interceptor.NoRollbackRuleAttribute;
import com.bmc.thirdparty.org.springframework.transaction.interceptor.RollbackRuleAttribute;
import com.bmc.thirdparty.org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import com.bmc.thirdparty.org.springframework.transaction.interceptor.TransactionAttribute;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class AnnotationTransactionAttributeSource
extends AbstractFallbackTransactionAttributeSource
implements Serializable {
    protected Collection findAllAttributes(Method method) {
        return Arrays.asList(AnnotationUtils.getAnnotations(method));
    }

    protected Collection findAllAttributes(Class clazz) {
        return Arrays.asList(clazz.getAnnotations());
    }

    protected TransactionAttribute findTransactionAttribute(Collection atts) {
        if (atts == null) {
            return null;
        }
        for (Object att : atts) {
            if (!(att instanceof Transactional)) continue;
            Transactional ruleBasedTx = (Transactional)att;
            RuleBasedTransactionAttribute rbta = new RuleBasedTransactionAttribute();
            rbta.setPropagationBehavior(ruleBasedTx.propagation().value());
            rbta.setIsolationLevel(ruleBasedTx.isolation().value());
            rbta.setTimeout(ruleBasedTx.timeout());
            rbta.setReadOnly(ruleBasedTx.readOnly());
            ArrayList<RollbackRuleAttribute> rollBackRules = new ArrayList<RollbackRuleAttribute>();
            Class<? extends Throwable>[] rbf = ruleBasedTx.rollbackFor();
            for (int i2 = 0; i2 < rbf.length; ++i2) {
                RollbackRuleAttribute rule = new RollbackRuleAttribute(rbf[i2]);
                rollBackRules.add(rule);
            }
            String[] rbfc = ruleBasedTx.rollbackForClassName();
            for (int i3 = 0; i3 < rbfc.length; ++i3) {
                RollbackRuleAttribute rule = new RollbackRuleAttribute(rbfc[i3]);
                rollBackRules.add(rule);
            }
            Class<? extends Throwable>[] nrbf = ruleBasedTx.noRollbackFor();
            for (int i4 = 0; i4 < nrbf.length; ++i4) {
                NoRollbackRuleAttribute rule = new NoRollbackRuleAttribute(nrbf[i4]);
                rollBackRules.add(rule);
            }
            String[] nrbfc = ruleBasedTx.noRollbackForClassName();
            for (int i5 = 0; i5 < nrbfc.length; ++i5) {
                NoRollbackRuleAttribute rule = new NoRollbackRuleAttribute(nrbfc[i5]);
                rollBackRules.add(rule);
            }
            rbta.getRollbackRules().addAll(rollBackRules);
            return rbta;
        }
        return null;
    }

    protected boolean allowPublicMethodsOnly() {
        return true;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof AnnotationTransactionAttributeSource;
    }

    public int hashCode() {
        return AnnotationTransactionAttributeSource.class.hashCode();
    }
}

