/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.orm.toplink;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.InitializingBean;
import com.bmc.thirdparty.org.springframework.dao.DataAccessException;
import com.bmc.thirdparty.org.springframework.jdbc.support.SQLExceptionTranslator;
import com.bmc.thirdparty.org.springframework.orm.toplink.SessionFactory;
import com.bmc.thirdparty.org.springframework.orm.toplink.SessionFactoryUtils;
import java.sql.SQLException;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.TopLinkException;

public abstract class TopLinkAccessor
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private SessionFactory sessionFactory;
    private SQLExceptionTranslator jdbcExceptionTranslator;

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setJdbcExceptionTranslator(SQLExceptionTranslator jdbcExceptionTranslator) {
        this.jdbcExceptionTranslator = jdbcExceptionTranslator;
    }

    public SQLExceptionTranslator getJdbcExceptionTranslator() {
        return this.jdbcExceptionTranslator;
    }

    public void afterPropertiesSet() {
        if (this.sessionFactory == null) {
            throw new IllegalArgumentException("sessionFactory is required");
        }
    }

    public DataAccessException convertTopLinkAccessException(TopLinkException ex) {
        Throwable internalEx;
        if (this.getJdbcExceptionTranslator() != null && ex instanceof DatabaseException && (internalEx = ex.getInternalException()) instanceof SQLException) {
            return this.getJdbcExceptionTranslator().translate("TopLink operation: " + ex.getMessage(), null, (SQLException)internalEx);
        }
        return SessionFactoryUtils.convertTopLinkAccessException(ex);
    }
}

