/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.jms.listener;

import com.bmc.thirdparty.org.springframework.beans.factory.DisposableBean;
import com.bmc.thirdparty.org.springframework.context.Lifecycle;
import com.bmc.thirdparty.org.springframework.jms.JmsException;
import com.bmc.thirdparty.org.springframework.jms.listener.SessionAwareMessageListener;
import com.bmc.thirdparty.org.springframework.jms.support.JmsUtils;
import com.bmc.thirdparty.org.springframework.jms.support.destination.JmsDestinationAccessor;
import com.bmc.thirdparty.org.springframework.util.Assert;
import com.bmc.thirdparty.org.springframework.util.ClassUtils;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;

public abstract class AbstractMessageListenerContainer
extends JmsDestinationAccessor
implements DisposableBean,
Lifecycle {
    private String clientId;
    private Object destination;
    private String messageSelector;
    private Object messageListener;
    private boolean subscriptionDurable = false;
    private String durableSubscriptionName;
    private ExceptionListener exceptionListener;
    private boolean exposeListenerSession = true;
    private boolean autoStartup = true;
    private Connection sharedConnection;
    private final Object sharedConnectionMonitor = new Object();
    private volatile boolean active = false;
    private boolean running = false;
    private final List pausedTasks = new LinkedList();
    private final Object lifecycleMonitor = new Object();
    static /* synthetic */ Class class$javax$jms$MessageListener;
    static /* synthetic */ Class class$org$springframework$jms$listener$SessionAwareMessageListener;

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    protected String getClientId() {
        return this.clientId;
    }

    public void setDestination(Destination destination) {
        Assert.notNull(destination, "destination must not be null");
        this.destination = destination;
        this.setPubSubDomain(destination instanceof Topic);
    }

    protected Destination getDestination() {
        return this.destination instanceof Destination ? (Destination)this.destination : null;
    }

    public void setDestinationName(String destinationName) {
        Assert.notNull(destinationName, "destinationName must not be null");
        this.destination = destinationName;
    }

    protected String getDestinationName() {
        return this.destination instanceof String ? (String)this.destination : null;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    protected String getMessageSelector() {
        return this.messageSelector;
    }

    public void setMessageListener(Object messageListener) {
        this.checkMessageListener(messageListener);
        this.messageListener = messageListener;
        if (this.durableSubscriptionName == null) {
            this.durableSubscriptionName = messageListener.getClass().getName();
        }
    }

    protected void checkMessageListener(Object messageListener) {
        if (!(messageListener instanceof MessageListener) && !(messageListener instanceof SessionAwareMessageListener)) {
            throw new IllegalArgumentException("messageListener needs to be of type [" + (class$javax$jms$MessageListener == null ? (class$javax$jms$MessageListener = AbstractMessageListenerContainer.class$("javax.jms.MessageListener")) : class$javax$jms$MessageListener).getName() + "] or [" + (class$org$springframework$jms$listener$SessionAwareMessageListener == null ? (class$org$springframework$jms$listener$SessionAwareMessageListener = AbstractMessageListenerContainer.class$("com.bmc.thirdparty.org.springframework.jms.listener.SessionAwareMessageListener")) : class$org$springframework$jms$listener$SessionAwareMessageListener).getName() + "]");
        }
    }

    protected Object getMessageListener() {
        return this.messageListener;
    }

    public void setSubscriptionDurable(boolean subscriptionDurable) {
        this.subscriptionDurable = subscriptionDurable;
    }

    protected boolean isSubscriptionDurable() {
        return this.subscriptionDurable;
    }

    public void setDurableSubscriptionName(String durableSubscriptionName) {
        Assert.notNull(durableSubscriptionName, "durableSubscriptionName must not be null");
        this.durableSubscriptionName = durableSubscriptionName;
    }

    protected String getDurableSubscriptionName() {
        return this.durableSubscriptionName;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    protected ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExposeListenerSession(boolean exposeListenerSession) {
        this.exposeListenerSession = exposeListenerSession;
    }

    protected boolean isExposeListenerSession() {
        return this.exposeListenerSession;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (this.destination == null) {
            throw new IllegalArgumentException("destination or destinationName is required");
        }
        if (this.messageListener == null) {
            throw new IllegalArgumentException("messageListener is required");
        }
        if (this.isSubscriptionDurable() && !this.isPubSubDomain()) {
            throw new IllegalArgumentException("A durable subscription requires a topic (pub-sub domain)");
        }
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws JmsException {
        try {
            Object object = this.lifecycleMonitor;
            synchronized (object) {
                this.active = true;
                this.lifecycleMonitor.notifyAll();
            }
            if (this.sharedConnectionEnabled()) {
                this.establishSharedConnection();
            }
            if (this.autoStartup) {
                this.doStart();
            }
            this.registerListener();
        }
        catch (JMSException ex) {
            Object object = this.sharedConnectionMonitor;
            synchronized (object) {
                JmsUtils.closeConnection(this.sharedConnection);
            }
            throw this.convertJmsAccessException(ex);
        }
    }

    protected void establishSharedConnection() throws JMSException {
        this.refreshSharedConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void refreshSharedConnection() throws JMSException {
        boolean running = this.isRunning();
        Object object = this.sharedConnectionMonitor;
        synchronized (object) {
            JmsUtils.closeConnection(this.sharedConnection, running);
            Connection con = this.createConnection();
            try {
                this.prepareSharedConnection(con);
            }
            catch (JMSException ex) {
                JmsUtils.closeConnection(con);
                throw ex;
            }
            this.sharedConnection = con;
        }
    }

    protected void prepareSharedConnection(Connection connection) throws JMSException {
        if (this.getClientId() != null) {
            connection.setClientID(this.getClientId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Connection getSharedConnection() {
        if (!this.sharedConnectionEnabled()) {
            throw new java.lang.IllegalStateException("This message listener container does not maintain a shared Connection");
        }
        Object object = this.sharedConnectionMonitor;
        synchronized (object) {
            if (this.sharedConnection == null) {
                throw new SharedConnectionNotInitializedException("This message listener container's shared Connection has not been initialized yet");
            }
            return this.sharedConnection;
        }
    }

    public void destroy() {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws JmsException {
        this.logger.debug("Shutting down message listener container");
        boolean wasRunning = false;
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            wasRunning = this.running;
            this.running = false;
            this.active = false;
            this.lifecycleMonitor.notifyAll();
        }
        try {
            this.destroyListener();
        }
        catch (JMSException ex) {
            throw this.convertJmsAccessException(ex);
        }
        finally {
            Object object2 = this.sharedConnectionMonitor;
            synchronized (object2) {
                JmsUtils.closeConnection(this.sharedConnection, wasRunning);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isActive() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.active;
        }
    }

    public void start() throws JmsException {
        try {
            this.doStart();
        }
        catch (JMSException ex) {
            throw this.convertJmsAccessException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws JMSException {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.running = true;
            this.lifecycleMonitor.notifyAll();
            Iterator it = this.pausedTasks.iterator();
            while (it.hasNext()) {
                this.doRescheduleTask(it.next());
                it.remove();
            }
        }
        if (this.sharedConnectionEnabled()) {
            this.startSharedConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startSharedConnection() throws JMSException {
        Object object = this.sharedConnectionMonitor;
        synchronized (object) {
            if (this.sharedConnection != null) {
                try {
                    this.sharedConnection.start();
                }
                catch (IllegalStateException ex) {
                    this.logger.debug("Ignoring Connection start exception - assuming already started", ex);
                }
            }
        }
    }

    public void stop() throws JmsException {
        try {
            this.doStop();
        }
        catch (JMSException ex) {
            throw this.convertJmsAccessException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws JMSException {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.running = false;
            this.lifecycleMonitor.notifyAll();
        }
        if (this.sharedConnectionEnabled()) {
            this.stopSharedConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopSharedConnection() throws JMSException {
        Object object = this.sharedConnectionMonitor;
        synchronized (object) {
            if (this.sharedConnection != null) {
                try {
                    this.sharedConnection.stop();
                }
                catch (IllegalStateException ex) {
                    this.logger.debug("Ignoring Connection stop exception - assuming already stopped", ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRunning() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.running;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void waitWhileNotRunning() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            while (this.active && !this.running) {
                try {
                    this.lifecycleMonitor.wait();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean rescheduleTaskIfNecessary(Object task) {
        Assert.notNull(task, "Task object must bot be null");
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.running) {
                this.doRescheduleTask(task);
                return true;
            }
            if (this.active) {
                this.pausedTasks.add(task);
                return true;
            }
            return false;
        }
    }

    protected void doRescheduleTask(Object task) {
        throw new UnsupportedOperationException(ClassUtils.getShortName(this.getClass()) + " does not support rescheduling of tasks");
    }

    protected void executeListener(Session session, Message message) {
        try {
            this.doExecuteListener(session, message);
        }
        catch (Throwable ex) {
            this.handleListenerException(ex);
        }
    }

    protected void doExecuteListener(Session session, Message message) throws JMSException {
        try {
            this.invokeListener(session, message);
        }
        catch (JMSException ex) {
            this.rollbackOnExceptionIfNecessary(session, ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            this.rollbackOnExceptionIfNecessary(session, ex);
            throw ex;
        }
        catch (Error err) {
            this.rollbackOnExceptionIfNecessary(session, err);
            throw err;
        }
        this.commitIfNecessary(session, message);
    }

    protected void invokeListener(Session session, Message message) throws JMSException {
        if (this.getMessageListener() instanceof SessionAwareMessageListener) {
            this.doInvokeListener((SessionAwareMessageListener)this.getMessageListener(), session, message);
        } else if (this.getMessageListener() instanceof MessageListener) {
            this.doInvokeListener((MessageListener)this.getMessageListener(), message);
        } else {
            throw new IllegalArgumentException("Only MessageListener and SessionAwareMessageListener supported");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInvokeListener(SessionAwareMessageListener listener, Session session, Message message) throws JMSException {
        Connection conToClose = null;
        Session sessionToClose = null;
        try {
            Session sessionToUse = session;
            if (!this.isExposeListenerSession()) {
                conToClose = this.createConnection();
                sessionToUse = sessionToClose = this.createSession(conToClose);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Invoking listener with message of type [" + message.getClass() + "] and session [" + sessionToUse + "]");
            }
            listener.onMessage(message, sessionToUse);
            if (sessionToUse != session && sessionToUse.getTransacted() && this.isSessionTransacted()) {
                JmsUtils.commitIfNecessary(sessionToUse);
            }
        }
        catch (Throwable throwable) {
            JmsUtils.closeSession(sessionToClose);
            JmsUtils.closeConnection(conToClose);
            throw throwable;
        }
        JmsUtils.closeSession(sessionToClose);
        JmsUtils.closeConnection(conToClose);
    }

    protected void doInvokeListener(MessageListener listener, Message message) throws JMSException {
        listener.onMessage(message);
    }

    protected void commitIfNecessary(Session session, Message message) throws JMSException {
        if (session.getTransacted()) {
            if (this.isSessionTransacted()) {
                JmsUtils.commitIfNecessary(session);
            }
        } else if (this.isClientAcknowledge(session)) {
            message.acknowledge();
        }
    }

    protected void rollbackOnExceptionIfNecessary(Session session, Throwable ex) throws JMSException {
        try {
            if (session.getTransacted() && this.isSessionTransacted()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Initiating transaction rollback on application exception", ex);
                }
                JmsUtils.rollbackIfNecessary(session);
            }
        }
        catch (java.lang.IllegalStateException ex2) {
            this.logger.debug("Could not roll back because Session already closed", ex2);
        }
        catch (JMSException ex2) {
            this.logger.error("Application exception overridden by rollback exception", ex);
            throw ex2;
        }
        catch (RuntimeException ex2) {
            this.logger.error("Application exception overridden by rollback exception", ex);
            throw ex2;
        }
        catch (Error err) {
            this.logger.error("Application exception overridden by rollback error", ex);
            throw err;
        }
    }

    protected void handleListenerException(Throwable ex) {
        if (ex instanceof JMSException) {
            this.invokeExceptionListener((JMSException)ex);
        }
        if (this.isActive()) {
            this.logger.error("Execution of JMS message listener failed", ex);
        } else {
            this.logger.debug("Listener exception after container shutdown", ex);
        }
    }

    protected void invokeExceptionListener(JMSException ex) {
        ExceptionListener exceptionListener = this.getExceptionListener();
        if (exceptionListener != null) {
            exceptionListener.onException(ex);
        }
    }

    protected abstract boolean sharedConnectionEnabled();

    protected abstract void registerListener() throws JMSException;

    protected abstract void destroyListener() throws JMSException;

    protected Connection createConnection() throws JMSException {
        return this.getConnectionFactory().createConnection();
    }

    protected Session createSession(Connection con) throws JMSException {
        return con.createSession(this.isSessionTransacted(), this.getSessionAcknowledgeMode());
    }

    protected boolean isClientAcknowledge(Session session) throws JMSException {
        return session.getAcknowledgeMode() == 2;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class SharedConnectionNotInitializedException
    extends RuntimeException {
        public SharedConnectionNotInitializedException(String msg) {
            super(msg);
        }
    }
}

