/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.apache.commons.configuration.tree.xpath;

import com.bmc.thirdparty.org.apache.commons.configuration.tree.ConfigurationNode;
import com.bmc.thirdparty.org.apache.commons.configuration.tree.xpath.ConfigurationNodeIteratorBase;
import com.bmc.thirdparty.org.apache.commons.jxpath.ri.QName;
import com.bmc.thirdparty.org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import com.bmc.thirdparty.org.apache.commons.jxpath.ri.compiler.NodeTest;
import com.bmc.thirdparty.org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import com.bmc.thirdparty.org.apache.commons.jxpath.ri.model.NodePointer;
import com.bmc.thirdparty.org.apache.commons.lang.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class ConfigurationNodeIteratorChildren
extends ConfigurationNodeIteratorBase {
    public ConfigurationNodeIteratorChildren(NodePointer parent, NodeTest nodeTest, boolean reverse, NodePointer startsWith) {
        super(parent, reverse);
        ConfigurationNode root = (ConfigurationNode)parent.getNode();
        List childNodes = this.createSubNodeList(root, nodeTest);
        this.initSubNodeList(childNodes);
        if (startsWith != null) {
            this.setStartOffset(this.findStartIndex(root, (ConfigurationNode)startsWith.getNode()));
        }
    }

    protected List createSubNodeList(ConfigurationNode node, NodeTest test) {
        NodeTypeTest typeTest;
        List children = node.getChildren();
        if (test == null) {
            return children;
        }
        if (test instanceof NodeNameTest) {
            NodeNameTest nameTest = (NodeNameTest)test;
            QName name = nameTest.getNodeName();
            if (name.getPrefix() == null) {
                if (nameTest.isWildcard()) {
                    return children;
                }
                ArrayList<ConfigurationNode> result = new ArrayList<ConfigurationNode>();
                Iterator it = children.iterator();
                while (it.hasNext()) {
                    ConfigurationNode child = (ConfigurationNode)it.next();
                    if (!StringUtils.equals(name.getName(), child.getName())) continue;
                    result.add(child);
                }
                return result;
            }
        } else if (test instanceof NodeTypeTest && ((typeTest = (NodeTypeTest)test).getNodeType() == 1 || typeTest.getNodeType() == 2)) {
            return children;
        }
        return Collections.EMPTY_LIST;
    }

    protected int findStartIndex(ConfigurationNode node, ConfigurationNode startNode) {
        int index = 0;
        while (index < node.getChildrenCount()) {
            if (node.getChild(index) == startNode) {
                return index;
            }
            ++index;
        }
        return -1;
    }
}

