/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.EscalationTimeCriteria;
import com.bmc.arsys.api.internal.ConversionUtil;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;

public class EscalationInterval
implements EscalationTimeCriteria,
Cloneable,
Serializable {
    public static final int MAX_DAYS = 24855;
    private static final long serialVersionUID = -8699130908029048067L;
    private long value;

    public EscalationInterval() {
    }

    public EscalationInterval(long l2) {
        this.value = l2;
    }

    public int getDays() {
        return (int)(this.value / 86400L);
    }

    public void setDays(int n2) {
        if (n2 < 0 || n2 > 24855) {
            throw new IllegalArgumentException(String.format("Days value must be between 0-%d", 24855));
        }
        int n3 = this.getHours();
        int n4 = this.getMinutes();
        this.value = n2 * 24 * 60 * 60 + n3 * 60 * 60 + n4 * 60;
    }

    public int getHours() {
        return (int)(this.value % 86400L) / 3600;
    }

    public void setHours(int n2) {
        if (n2 < 0 || n2 > 23) {
            throw new IllegalArgumentException("Hours value must be between 0-23");
        }
        int n3 = this.getDays();
        int n4 = this.getMinutes();
        this.value = n3 * 24 * 60 * 60 + n2 * 60 * 60 + n4 * 60;
    }

    public int getMinutes() {
        return (int)(this.value % 86400L % 3600L) / 60;
    }

    public void setMinutes(int n2) {
        if (n2 < 0 || n2 > 59) {
            throw new IllegalArgumentException("Minutes value must be between 0-59");
        }
        int n3 = this.getDays();
        int n4 = this.getHours();
        this.value = n3 * 24 * 60 * 60 + n4 * 60 * 60 + n2 * 60;
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long l2) {
        if (l2 < 0L || l2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("Value must be between 0-%d", Integer.MAX_VALUE));
        }
        this.value = l2;
    }

    public Object clone() throws CloneNotSupportedException {
        EscalationTimeCriteria escalationTimeCriteria = (EscalationTimeCriteria)super.clone();
        return escalationTimeCriteria;
    }

    public boolean equals(Object object) {
        if (!(object instanceof EscalationInterval)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        EscalationInterval escalationInterval = (EscalationInterval)object;
        return new EqualsBuilder().append(this.value, escalationInterval.value).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.value).toHashCode();
    }

    void fromVariant(Object[] objectArray, ARServerUser aRServerUser) {
        if (objectArray == null) {
            return;
        }
        this.value = ConversionUtil.getLongValue(ARTypeMgr.GetAt((Object)objectArray, 0));
    }

    Object toVariant(ARServerUser aRServerUser) {
        Object[] objectArray = new Object[]{1, new Long(this.getValue())};
        return objectArray;
    }

    static EscalationInterval createInstance(Object[] objectArray, ARServerUser aRServerUser) {
        if (objectArray == null) {
            return null;
        }
        EscalationInterval escalationInterval = new EscalationInterval();
        if (objectArray.length == 1) {
            escalationInterval.fromVariant(objectArray, aRServerUser);
        }
        return escalationInterval;
    }

    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).append("Value", this.value).toString();
    }
}

