/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.ws.wsdl;

import com.bmc.arsys.ws.util.ARWSException;
import com.bmc.arsys.ws.util.WsdlUtil;
import com.bmc.arsys.ws.wsdl.CustomXmlSchemaParser;
import com.bmc.arsys.ws.wsdl.WsdlOperation;
import com.bmc.arsys.ws.wsdl.WsdlPortBindingOperation;
import com.bmc.arsys.ws.wsdl.WsdlService;
import com.bmc.arsys.ws.wsdl.XMLSchemaParser;
import com.ibm.wsdl.ImportImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import org.apache.axis.Constants;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WsdlParser {
    protected String wsdlUri = null;
    protected Document doc = null;
    protected Definition def = null;
    protected Map<String, WsdlService> services = new HashMap<String, WsdlService>();
    protected String tempDir = null;
    protected XMLSchemaParser schemaParser = null;
    protected CustomXmlSchemaParser cSchemaParser = null;
    protected String description = null;
    protected StringBuffer warnings = new StringBuffer();
    protected Element types = null;

    public WsdlParser(String string, String string2, StringBuffer stringBuffer) {
        this.wsdlUri = string;
        this.warnings = stringBuffer;
        this.doc = WsdlUtil.newDocument(string, true);
        this.tempDir = string2;
        this.cSchemaParser = new CustomXmlSchemaParser(stringBuffer);
        try {
            WSDLReader wSDLReader = WSDLFactory.newInstance().newWSDLReader();
            this.def = wSDLReader.readWSDL(string, this.doc);
        }
        catch (WSDLException wSDLException) {
            throw new ARWSException(wSDLException);
        }
    }

    public WsdlOperation getOperation(String string, String string2, String string3) {
        WsdlPortBindingOperation wsdlPortBindingOperation;
        WsdlService wsdlService;
        WsdlOperation wsdlOperation = null;
        if (this.services != null && (wsdlService = this.services.get(string)) != null && (wsdlPortBindingOperation = wsdlService.getPortByName(string2)) != null) {
            wsdlOperation = wsdlPortBindingOperation.getOperation(string3);
        }
        return wsdlOperation;
    }

    public Map getOperations(String string, String string2) {
        WsdlPortBindingOperation wsdlPortBindingOperation;
        WsdlService wsdlService;
        Map map = null;
        if (this.services != null && (wsdlService = this.services.get(string)) != null && (wsdlPortBindingOperation = wsdlService.getPortByName(string2)) != null) {
            map = wsdlPortBindingOperation.getOperationMap();
        }
        return map;
    }

    public Document parseWsdl() {
        this.parseServiceAndBinding();
        return this.createMappingDoc();
    }

    public void parseServiceAndBinding() {
        for (Service service : this.def.getServices().values()) {
            WsdlUtil.trace("Service: " + service.getQName());
            WsdlService wsdlService = new WsdlService(service);
            wsdlService.parseServiceBinding();
            this.services.put(service.getQName().toString(), wsdlService);
        }
    }

    public Document createMappingDoc() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        ArrayList arrayList;
        Object object5;
        this.schemaParser = null;
        String string = this.extractSchemaFromWsdl();
        if (string == null) {
            object5 = this.def.getImports();
            arrayList = new ArrayList(object5.keySet());
            if (arrayList.size() != 0) {
                object4 = arrayList.get(0);
                object3 = object5.get(object4);
                object2 = new ArrayList((Collection)object3);
                object = (ImportImpl)((ArrayList)object2).get(0);
                String string2 = object.getLocationURI();
                string2 = XMLSchemaParser.expandSystemId(string2, this.wsdlUri);
                WsdlParser wsdlParser = new WsdlParser(string2, this.tempDir, this.warnings);
                string = wsdlParser.extractSchemaFromWsdl();
            }
            if (string != null) {
                this.schemaParser = new XMLSchemaParser(this.wsdlUri, string, this.warnings);
            }
        } else {
            this.schemaParser = new XMLSchemaParser(this.wsdlUri, this.tempDir, string, this.warnings);
        }
        object5 = null;
        object5 = WsdlUtil.newDocument();
        arrayList = object5.createElementNS(null, "webservices");
        object5.appendChild((Node)((Object)arrayList));
        object4 = "";
        object4 = this.def.getTargetNamespace();
        if (object4 == null) {
            object4 = this.cSchemaParser.getFirstNamespace();
        }
        object3 = this.services.values();
        object2 = object3.iterator();
        while (object2.hasNext()) {
            object = (WsdlService)object2.next();
            ((WsdlService)object).createMappingDoc((Document)object5, (String)object4, this.schemaParser, this.def, this.warnings);
        }
        return object5;
    }

    public String extractSchemaFromWsdl() {
        Object object;
        Object object2;
        NodeList nodeList = this.doc.getDocumentElement().getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            object2 = (Element)nodeList.item(i);
            if (object2.getLocalName().equals("types")) {
                this.types = object2;
                break;
            }
            if (!object2.getLocalName().equals("import") || (object = object2.getAttribute("schemaLocation")) == null || ((String)object).equals("")) continue;
            return XMLSchemaParser.expandSystemId((String)object, this.wsdlUri);
        }
        if (this.types == null) {
            return null;
        }
        ArrayList<Node> arrayList = new ArrayList<Node>(10);
        object2 = this.doc.getDocumentElement().getAttributes();
        object = null;
        for (int i = 0; i < object2.getLength(); ++i) {
            Node node = object2.item(i);
            if (node.getPrefix() != null && node.getPrefix().equals("xmlns")) {
                arrayList.add(node);
            }
            if (!node.getNodeValue().equals(Constants.URI_DEFAULT_SOAP_ENC)) continue;
            object = (Attr)node;
        }
        this.cSchemaParser.parseSchema(this.types);
        return this.cSchemaParser.writeSchemasToTempDir(this.tempDir, arrayList, (Node)object);
    }
}

