/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.ws.wsdl;

import com.bmc.arsys.ws.util.ARWSException;
import com.bmc.arsys.ws.util.WsdlUtil;
import com.bmc.arsys.ws.wsdl.XMLSchemaParser;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import org.apache.axis.Constants;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CustomXmlSchemaParser {
    protected LinkedList<OneXmlSchema> schemaDomList = new LinkedList();
    protected HashMap<String, OneXmlSchema> schemaDomMap = new HashMap();
    protected LinkedList globalElementList = new LinkedList();
    protected HashMap globalElementMap = new HashMap();
    protected LinkedList globalComplexTypesList = new LinkedList();
    protected HashMap globalComplexTypesMap = new HashMap();
    protected HashMap<String, String> nsPrefixMap = new HashMap();
    protected int currentNsPrefixIndex = 0;
    protected HashMap<String, String> externalNamespaces = new HashMap();
    protected StringBuffer warnings = new StringBuffer();
    protected boolean isLinked = false;

    public HashMap getNsPrefixMap() {
        return this.nsPrefixMap;
    }

    public HashMap getExternalNamespaces() {
        return this.externalNamespaces;
    }

    public boolean getIsLinked() {
        return this.isLinked;
    }

    public CustomXmlSchemaParser(StringBuffer stringBuffer) {
        this.warnings = stringBuffer;
    }

    public String parseSchema(String string, String string2) {
        if (string2 == null || string2.equals("")) {
            return null;
        }
        if (string2.indexOf("<?xml") != -1) {
            InputSource inputSource = new InputSource(new StringReader(string2));
            Document document = WsdlUtil.newDocument(inputSource);
            return this.parseSchema(document.getDocumentElement());
        }
        this.isLinked = true;
        String string3 = string2;
        return this.parseOneSchema(string, null, string3);
    }

    public String parseSchema(Element element) {
        this.isLinked = false;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !(element2 = (Element)node).getLocalName().equals("schema")) continue;
            OneXmlSchema oneXmlSchema = new OneXmlSchema(element2);
            String string = "ns" + this.currentNsPrefixIndex + ".xsd";
            if (this.nsPrefixMap.get(oneXmlSchema.targetNamespace) == null) {
                this.schemaDomMap.put(string, oneXmlSchema);
                this.schemaDomList.addLast(oneXmlSchema);
            }
            if (this.nsPrefixMap.get(oneXmlSchema.targetNamespace) == null) {
                this.nsPrefixMap.put(oneXmlSchema.targetNamespace, "ns" + this.currentNsPrefixIndex);
                ++this.currentNsPrefixIndex;
            } else if (oneXmlSchema.targetNamespace.length() == 0) {
                throw new ARWSException("INVALID_XSD", "Schema with empty targetnamespace already exists");
            }
            this.externalNamespaces.put(string, oneXmlSchema.targetNamespace);
            Node node2 = null;
            node = oneXmlSchema.schemaElem.getFirstChild();
            while (node != null) {
                node2 = node.getNextSibling();
                if (node.getNodeType() == 1) {
                    this.addGlobal(oneXmlSchema.targetNamespace, (Element)node, string);
                }
                node = node2;
            }
        }
        if (this.schemaDomList.size() > 0) {
            return this.schemaDomList.get((int)0).targetNamespace;
        }
        return null;
    }

    public void emdedSchemas(Element element) {
        HashMap<String, Element> hashMap = new HashMap<String, Element>();
        LinkedList<Element> linkedList = new LinkedList<Element>();
        for (OneXmlSchema object : this.schemaDomList) {
            Element element2 = object.schemaElem;
            Element element3 = (Element)element.getOwnerDocument().importNode(element2, true);
            String string = object.targetNamespace;
            Element element4 = (Element)hashMap.get(string);
            if (element4 == null) {
                hashMap.put(string, element3);
                linkedList.add(element3);
                continue;
            }
            NodeList nodeList = element3.getChildNodes();
            for (int i = nodeList.getLength(); i > 0; --i) {
                element4.appendChild(nodeList.item(0));
            }
        }
        for (Element element5 : linkedList) {
            element.appendChild(element5);
        }
    }

    public Document getSchemaInfo() {
        Document document = WsdlUtil.newDocument();
        Element element = document.createElementNS("http://schemas.xmlsoap.org/wsdl/", "wsdl:types");
        document.appendChild(element);
        this.emdedSchemas(element);
        return document;
    }

    public Document getGlobalElementsAndComplexTypes() {
        Element element;
        Document document = WsdlUtil.newDocument();
        Element element2 = document.createElementNS(null, "globals");
        document.appendChild(element2);
        for (QName qName : this.globalElementList) {
            element = document.createElementNS(null, "global");
            element2.appendChild(element);
            element.setAttributeNS(null, "namespace", qName.getNamespaceURI());
            element.setAttributeNS(null, "name", qName.getLocalPart());
            element.setAttributeNS(null, "type", "element");
        }
        for (QName qName : this.globalComplexTypesList) {
            element = document.createElementNS(null, "global");
            element2.appendChild(element);
            element.setAttributeNS(null, "namespace", qName.getNamespaceURI());
            element.setAttributeNS(null, "name", qName.getLocalPart());
            element.setAttributeNS(null, "type", "complexType");
        }
        return document;
    }

    public QName getFirstGlobalElement() {
        Iterator iterator = this.globalElementList.iterator();
        if (iterator != null && iterator.hasNext()) {
            return (QName)iterator.next();
        }
        return null;
    }

    public QName getFirstGlobalComplexType() {
        Iterator iterator = this.globalComplexTypesList.iterator();
        if (iterator != null && iterator.hasNext()) {
            return (QName)iterator.next();
        }
        return null;
    }

    public String parseOneSchema(String string, String string2, String string3) {
        String string4 = XMLSchemaParser.expandSystemId(string3, string2);
        OneXmlSchema oneXmlSchema = this.schemaDomMap.get(string4);
        if (oneXmlSchema != null) {
            return oneXmlSchema.targetNamespace;
        }
        oneXmlSchema = new OneXmlSchema(string4, string);
        this.schemaDomMap.put(string4, oneXmlSchema);
        this.schemaDomList.addLast(oneXmlSchema);
        if (string2 == null) {
            this.externalNamespaces.put(string3, oneXmlSchema.targetNamespace);
        }
        if (this.nsPrefixMap.get(oneXmlSchema.targetNamespace) == null) {
            this.nsPrefixMap.put(oneXmlSchema.targetNamespace, "ns" + this.currentNsPrefixIndex);
            ++this.currentNsPrefixIndex;
        }
        Node node = null;
        Node node2 = oneXmlSchema.schemaElem.getFirstChild();
        while (node2 != null) {
            node = node2.getNextSibling();
            if (node2.getNodeType() == 1) {
                Element element = (Element)node2;
                if (element.getLocalName().equals("import")) {
                    this.parseOneSchema(element.getAttribute("namespace"), string4, element.getAttribute("schemaLocation"));
                    element.removeAttribute("schemaLocation");
                } else if (element.getLocalName().equals("include")) {
                    this.parseOneSchema(oneXmlSchema.targetNamespace, string4, element.getAttribute("schemaLocation"));
                    element.getParentNode().removeChild(element);
                } else {
                    this.addGlobal(oneXmlSchema.targetNamespace, element, string4);
                }
            }
            node2 = node;
        }
        return oneXmlSchema.targetNamespace;
    }

    public void addGlobal(String string, Element element, String string2) {
        LinkedList linkedList;
        HashMap hashMap;
        String string3 = element.getLocalName();
        if (string3.equals("element")) {
            hashMap = this.globalElementMap;
            linkedList = this.globalElementList;
        } else if (string3.equals("complexType")) {
            hashMap = this.globalComplexTypesMap;
            linkedList = this.globalComplexTypesList;
        } else {
            return;
        }
        QName qName = new QName(string, element.getAttribute("name"));
        if (hashMap.get(qName) == null) {
            linkedList.add(qName);
            hashMap.put(qName, "");
        } else {
            element.getParentNode().removeChild(element);
            this.warnings.append("WARNING: Ignoring " + string3 + " " + qName + " from " + string2 + "as it already exists" + System.getProperty("line.separator"));
        }
    }

    public void AddImportsForExternalNamespaces(OneXmlSchema oneXmlSchema, Document document) {
        HashMap hashMap = this.getExternalNamespaces();
        Iterator iterator = hashMap.keySet().iterator();
        Element element = null;
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            String string = (String)iterator.next();
            String string2 = (String)hashMap.get(string);
            if (string2 == null || string2.equals(oneXmlSchema.targetNamespace)) continue;
            String string3 = this.nsPrefixMap.get(string2);
            NodeList nodeList = document.getDocumentElement().getElementsByTagNameNS("*", "import");
            boolean bl = false;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                object2 = (Element)nodeList.item(i);
                element = object2;
                object = object2.getAttribute("namespace");
                if (object == null || !string2.equals(object)) continue;
                bl = true;
                break;
            }
            if (bl || string3 == null || string2.equals("")) continue;
            Element element2 = document.getDocumentElement();
            object2 = element2.getPrefix();
            object = document.createElementNS("http://www.w3.org/2001/XMLSchema", object2 != null ? (String)object2 + ":import" : "import");
            object.setAttributeNS(null, "namespace", string2);
            object.setAttributeNS(null, "schemaLocation", string3 + ".xsd");
            if (element == null) {
                Node node;
                for (node = element2.getFirstChild(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
                }
                if (node != null && node.getNodeType() == 1) {
                    element = (Element)node;
                }
            }
            if (element == null) continue;
            element2.insertBefore((Node)object, element);
        }
    }

    public String writeSchemasToTempDir(String string, ArrayList arrayList, Node node) {
        if (this.schemaDomList.size() == 0) {
            return null;
        }
        String string2 = string + System.getProperty("file.separator");
        for (int i = 0; i < this.schemaDomList.size(); ++i) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            OneXmlSchema oneXmlSchema = this.schemaDomList.get(i);
            Document document = null;
            try {
                document = WsdlUtil.newDocument();
                object4 = document.importNode(oneXmlSchema.schemaElem, true);
                document.appendChild((Node)object4);
            }
            catch (DOMException dOMException) {
                throw new ARWSException("OTHER_ERROR", "DomException while importing" + dOMException, dOMException);
            }
            if (arrayList != null) {
                for (int j = 0; j < arrayList.size(); ++j) {
                    Attr attr = (Attr)arrayList.get(j);
                    object3 = document.getDocumentElement().getAttributes();
                    if (this.exists((NamedNodeMap)object3, attr)) continue;
                    object2 = (Attr)document.importNode(attr, true);
                    document.getDocumentElement().setAttributeNodeNS((Attr)object2);
                }
            }
            object4 = document.getDocumentElement().getElementsByTagNameNS("*", "import");
            boolean bl = false;
            for (int j = 0; j < object4.getLength(); ++j) {
                String string3;
                object2 = (Element)object4.item(j);
                object = object2.getAttribute("namespace");
                if (object == null) continue;
                if (((String)object).equals(Constants.URI_DEFAULT_SOAP_ENC)) {
                    bl = true;
                }
                if ((string3 = this.nsPrefixMap.get(object)) == null) continue;
                object2.setAttributeNS(null, "schemaLocation", string3 + ".xsd");
            }
            if (node != null && !bl) {
                Element element = document.getDocumentElement();
                object2 = element.getPrefix();
                object = document.createElementNS("http://www.w3.org/2001/XMLSchema", object2 != null ? (String)object2 + ":import" : "import");
                object.setAttributeNS(null, "namespace", Constants.URI_DEFAULT_SOAP_ENC);
                object.setAttributeNS(null, "schemaLocation", Constants.URI_DEFAULT_SOAP_ENC);
                element.insertBefore((Node)object, element.getFirstChild());
            }
            this.AddImportsForExternalNamespaces(oneXmlSchema, document);
            try {
                object3 = this.nsPrefixMap.get(oneXmlSchema.targetNamespace);
                object2 = new FileOutputStream(string2 + (String)object3 + ".xsd");
                XMLUtils.PrettyDocumentToWriter((Document)document, (Writer)new OutputStreamWriter((OutputStream)object2, "utf-8"));
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new ARWSException("CANT_CREATE_TEMP_FILES", "Cannot create file: " + string2 + "s" + i + ".xsd " + fileNotFoundException, fileNotFoundException);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new ARWSException("OTHER_ERROR", unsupportedEncodingException.getMessage(), unsupportedEncodingException);
            }
        }
        return string2 + "ns0.xsd";
    }

    public String getFirstNamespace() {
        if (this.schemaDomList.size() >= 1) {
            OneXmlSchema oneXmlSchema = this.schemaDomList.get(0);
            return oneXmlSchema.targetNamespace;
        }
        return null;
    }

    boolean exists(NamedNodeMap namedNodeMap, Attr attr) {
        boolean bl = false;
        Node node = namedNodeMap.getNamedItem(attr.getName());
        bl = node != null;
        return bl;
    }

    public class OneXmlSchema {
        protected String uri = null;
        protected String targetNamespace = null;
        protected Document schemaDom = null;
        protected Element schemaElem = null;

        public OneXmlSchema(String string, String string2) {
            this.schemaDom = WsdlUtil.newDocument(string, false);
            this.schemaElem = this.schemaDom.getDocumentElement();
            if (!this.schemaElem.getLocalName().equals("schema")) {
                throw new ARWSException("INVALID_XSD", "Schema " + string + " does not have root element as schema");
            }
            this.targetNamespace = this.schemaElem.getAttribute("targetNamespace");
            if (this.targetNamespace == null || this.targetNamespace.equals("")) {
                this.targetNamespace = string2;
                this.schemaElem.setAttributeNS(null, "targetNamespace", this.targetNamespace);
            }
        }

        public OneXmlSchema(Element element) {
            if (!element.getLocalName().equals("schema")) {
                throw new ARWSException("INVALID_XSD", "Schema " + this.uri + " does not have root element as schema");
            }
            this.schemaElem = element;
            this.schemaDom = element.getOwnerDocument();
            this.targetNamespace = element.getAttribute("targetNamespace");
        }
    }
}

