/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr.plugins;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.pluginsvr.ARPluginDefinition;
import com.bmc.arsys.pluginsvr.ARPluginDefinitionNodeI;
import com.bmc.arsys.pluginsvr.ARPluginServerConfiguration;
import com.bmc.arsys.pluginsvr.PluginGroup;
import com.bmc.arsys.pluginsvr.binding.ARPluginDynamicInstantiateHandler;
import com.bmc.arsys.pluginsvr.legacy.CARDBCPlugin;
import com.bmc.arsys.pluginsvr.legacy.CAREAPlugin;
import com.bmc.arsys.pluginsvr.legacy.CARFilterAPIPlugin;
import com.bmc.arsys.pluginsvr.legacy.PluginProxy;
import com.bmc.arsys.pluginsvr.plugins.ARDBCPluggable;
import com.bmc.arsys.pluginsvr.plugins.ARDBCPluginRepository;
import com.bmc.arsys.pluginsvr.plugins.AREAPluggable;
import com.bmc.arsys.pluginsvr.plugins.AREAPluginRepository;
import com.bmc.arsys.pluginsvr.plugins.ARFilterAPIPluggable;
import com.bmc.arsys.pluginsvr.plugins.ARFilterAPIPluginRepository;
import com.bmc.arsys.pluginsvr.plugins.ARPluggable;
import com.bmc.arsys.pluginsvr.plugins.ARPlugin;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import com.bmc.arsys.pluginsvr.plugins.PluginClassLoader;
import com.bmc.arsys.pluginsvr.plugins.PluginEnvelope;
import com.bmc.arsys.pluginsvr.plugins.TrustedAREAPluggable;
import com.bmc.arsys.utils.CatalogReader;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ARPluginLoaderRouter {
    private static ClassLoader rootCl = Thread.currentThread().getContextClassLoader();
    private static Logger LOGGER = Logger.getLogger(ARPluginLoaderRouter.class);
    private static ConcurrentHashMap<Thread, ARPluginLoaderRouter> MAP_THREAD_PLUGINSLOADERROUTER = new ConcurrentHashMap();
    private static HashMap<String, URLClassLoader> MAP_PLUGINSET_CLASS_LOADERS = new HashMap();
    private static HashMap<String, URLClassLoader> MAP_PLUGIN_CLASS_LOADERS = new HashMap();
    private static HashMap<String, Class<?>> MAP_PLUGIN_CLASSES = new HashMap();
    public final ARDBCPluginRepository ARDBC = new ARDBCPluginRepository();
    public final AREAPluginRepository AREA = new AREAPluginRepository();
    public final ARFilterAPIPluginRepository FILTERAPI = new ARFilterAPIPluginRepository();

    public static void addPluginRouter(Thread thread, ARPluginLoaderRouter aRPluginLoaderRouter) {
        MAP_THREAD_PLUGINSLOADERROUTER.put(thread, aRPluginLoaderRouter);
    }

    public static ARPluginLoaderRouter getPluginRouter(Thread thread) {
        return MAP_THREAD_PLUGINSLOADERROUTER.get(thread);
    }

    public static void removePluginRouter(Thread thread) {
        ARPluginLoaderRouter aRPluginLoaderRouter = MAP_THREAD_PLUGINSLOADERROUTER.remove(thread);
        aRPluginLoaderRouter.cleanUpPlugins();
    }

    private static synchronized URLClassLoader getPluginSetClassLoader(String string) {
        return MAP_PLUGINSET_CLASS_LOADERS.get(string);
    }

    private static synchronized void addPluginSetClassLoader(String string, URLClassLoader uRLClassLoader) {
        MAP_PLUGINSET_CLASS_LOADERS.put(string, uRLClassLoader);
    }

    static synchronized URLClassLoader getPluginClassLoader(String string) {
        return MAP_PLUGIN_CLASS_LOADERS.get(string);
    }

    private static synchronized void addPluginClassLoader(String string, URLClassLoader uRLClassLoader) {
        MAP_PLUGIN_CLASS_LOADERS.put(string, uRLClassLoader);
    }

    private static synchronized void addPluginClass(String string, Class<?> clazz) {
        MAP_PLUGIN_CLASSES.put(string, clazz);
    }

    private static synchronized Class<?> getPluginClass(String string) {
        return MAP_PLUGIN_CLASSES.get(string);
    }

    public static void initializeJavaPlugins() {
        LOGGER.info((Object)"Loading all Java Plugins and Plugin sets");
        String[] stringArray = ARPluginServerConfiguration.getInstance().getCmdLineArgs();
        ArrayList<ARPluginDefinition> arrayList = ARPluginServerConfiguration.getInstance().getConfiguredPlugins();
        ARPluginLoaderRouter.loadAllPlugins(null, arrayList, stringArray);
        HashMap<String, PluginGroup> hashMap = ARPluginServerConfiguration.getInstance().getConfiguredPluginGroups();
        ARPluginLoaderRouter.loadPluginGroups(hashMap, stringArray);
    }

    private static void logURLs(URL[] uRLArray) {
        if (uRLArray != null) {
            for (int i = 0; i < uRLArray.length; ++i) {
                LOGGER.info((Object)("URL" + (i + 1) + ": " + uRLArray[i].toString()));
            }
        }
    }

    private static void loadPluginGroups(HashMap<String, PluginGroup> hashMap, String[] stringArray) {
        Set<String> set = hashMap.keySet();
        for (String string : set) {
            URLClassLoader uRLClassLoader;
            PluginGroup pluginGroup;
            block4: {
                LOGGER.info((Object)("Loading Java PluginSet " + string));
                pluginGroup = hashMap.get(string);
                uRLClassLoader = null;
                uRLClassLoader = ARPluginLoaderRouter.getPluginSetClassLoader(string);
                try {
                    if (uRLClassLoader != null) break block4;
                    URL[] uRLArray = ARPluginLoaderRouter.getJarURLs(pluginGroup, true);
                    LOGGER.info((Object)("Number of shared URLs for group " + string + " is " + uRLArray.length));
                    ARPluginLoaderRouter.logURLs(uRLArray);
                    ClassLoader classLoader = null;
                    classLoader = pluginGroup.getParent().equals(ARPluginServerConfiguration.DEFAULT_SET_NAME) ? Thread.currentThread().getContextClassLoader() : ARPluginLoaderRouter.getPluginSetClassLoader(pluginGroup.getParent());
                    uRLClassLoader = new PluginClassLoader(uRLArray, classLoader, pluginGroup.getFolders(), ARPluginServerConfiguration.getInstance().getWorkingDirectory());
                    ARPluginLoaderRouter.addPluginSetClassLoader(string, uRLClassLoader);
                }
                catch (MalformedURLException malformedURLException) {
                    LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + " Group: " + string), (Throwable)malformedURLException);
                    continue;
                }
                catch (IOException iOException) {
                    LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + " Group: " + string), (Throwable)iOException);
                    continue;
                }
            }
            LOGGER.info((Object)("Loading all Java Plugins for the group " + string));
            ARPluginLoaderRouter.loadAllPlugins(uRLClassLoader, pluginGroup.getPlugins(), stringArray);
            ARPluginLoaderRouter.loadPluginGroups(pluginGroup.getGroups(), stringArray);
        }
    }

    private static void loadAllPlugins(URLClassLoader uRLClassLoader, ArrayList<ARPluginDefinition> arrayList, String[] stringArray) {
        for (ARPluginDefinition aRPluginDefinition : arrayList) {
            try {
                URLClassLoader uRLClassLoader2;
                block7: {
                    ClassLoader classLoader = null;
                    classLoader = uRLClassLoader == null ? Thread.currentThread().getContextClassLoader() : uRLClassLoader;
                    LOGGER.info((Object)("Attempting to load Java Plugin " + aRPluginDefinition.getPluginName()));
                    uRLClassLoader2 = ARPluginLoaderRouter.getPluginClassLoader(aRPluginDefinition.getPluginName());
                    try {
                        if (uRLClassLoader2 != null) break block7;
                        URL[] uRLArray = ARPluginLoaderRouter.getJarURLs(aRPluginDefinition, true);
                        LOGGER.info((Object)("Number of URLs for plugin " + aRPluginDefinition.getPluginName() + " is " + uRLArray.length));
                        ARPluginLoaderRouter.logURLs(uRLArray);
                        uRLClassLoader2 = new PluginClassLoader(uRLArray, classLoader, aRPluginDefinition.getClassPathFolders(), ARPluginServerConfiguration.getInstance().getWorkingDirectory());
                        ARPluginLoaderRouter.addPluginClassLoader(aRPluginDefinition.getPluginName(), uRLClassLoader2);
                    }
                    catch (MalformedURLException malformedURLException) {
                        LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + " Plugin: " + aRPluginDefinition.getPluginName()), (Throwable)malformedURLException);
                        aRPluginDefinition.setActive(false);
                        continue;
                    }
                    catch (IOException iOException) {
                        LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + " Plugin: " + aRPluginDefinition.getPluginName()), (Throwable)iOException);
                        aRPluginDefinition.setActive(false);
                        continue;
                    }
                }
                ARPluginLoaderRouter.loadClass(uRLClassLoader2, aRPluginDefinition, aRPluginDefinition.getFileName(), aRPluginDefinition.getClassName(), stringArray);
                if (aRPluginDefinition.isActive()) {
                    LOGGER.info((Object)("Successfully loaded Java Plugin " + aRPluginDefinition.getPluginName()));
                    continue;
                }
                LOGGER.info((Object)("Java Plugin " + aRPluginDefinition.getPluginName() + " is not active"));
            }
            catch (Throwable throwable) {
                LOGGER.error((Object)("Not able to load Java Plugin : " + aRPluginDefinition.getPluginName()));
                aRPluginDefinition.setActive(false);
            }
        }
    }

    static void loadClass(URLClassLoader uRLClassLoader, ARPluginDefinition aRPluginDefinition, String string, String string2, String[] stringArray) {
        String string3 = aRPluginDefinition.getPluginName();
        try {
            Class<?> clazz = ARPluginLoaderRouter.loadJars(uRLClassLoader, string3, string, string2, aRPluginDefinition, stringArray);
            ARPluginLoaderRouter.addPluginClass(string3, clazz);
        }
        catch (ARException aRException) {
            aRPluginDefinition.setActive(false);
        }
        catch (Throwable throwable) {
            LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + " Plugin: " + aRPluginDefinition.getPluginName()), throwable);
            aRPluginDefinition.setActive(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Class<?> loadJars(URLClassLoader uRLClassLoader, String string, String string2, String string3, ARPluginDefinition aRPluginDefinition, String[] stringArray) throws ARException {
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string3, true, uRLClassLoader);
            try {
                if (clazz != null) {
                    object = clazz.getMethod("init", ARPluginContext.class);
                    if (object != null) {
                        ARPluginContext aRPluginContext = new ARPluginContext();
                        aRPluginContext.setCmdLineArgs(stringArray);
                        ARPluginInfo aRPluginInfo = new ARPluginInfo(aRPluginDefinition.getPluginName(), aRPluginDefinition.getVersion(), true);
                        aRPluginContext.setPluginInfo(aRPluginInfo);
                        ((Method)object).invoke(null, aRPluginContext);
                    }
                    bl = true;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                LOGGER.info((Object)("No static init routine found, skipping init call - " + string));
            }
            catch (SecurityException securityException) {
                LOGGER.warn((Object)("Exception while finding static init method - " + string), (Throwable)securityException);
            }
            catch (InvocationTargetException invocationTargetException) {
                LOGGER.warn((Object)("Invocation exception for static init method - " + string), (Throwable)invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                LOGGER.warn((Object)("Illegal Access exception for static init method - " + string), (Throwable)illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.warn((Object)("Illegal argument exception for static init method - " + string), (Throwable)illegalArgumentException);
            }
            catch (Throwable throwable) {
                LOGGER.warn((Object)("Exception in static init method - " + string), throwable);
            }
            finally {
                if (bl) {
                    object = "Done invoking static init method in plugin " + string;
                    LOGGER.debug(object);
                }
            }
            bl2 = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + " Plugin: " + string), (Throwable)classNotFoundException);
                throw new ARException(2, 8756, classNotFoundException.getLocalizedMessage());
                catch (ClassCastException classCastException) {
                    LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + " Plugin: " + string), (Throwable)classCastException);
                    throw new ARException(2, 8756, classCastException.getLocalizedMessage());
                }
                catch (Throwable throwable) {
                    LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + " Plugin: " + string), throwable);
                    throw new ARException(2, 8756, throwable.getLocalizedMessage());
                }
            }
            catch (Throwable throwable) {
                String string4 = (bl2 ? "Done " : "Failed ") + " to call init plugin " + string;
                if (!bl2) {
                    LOGGER.error((Object)string4);
                    throw throwable;
                }
                LOGGER.info((Object)string4);
                throw throwable;
            }
        }
        object = (bl2 ? "Done " : "Failed ") + " to call init plugin " + string;
        if (!bl2) {
            LOGGER.error(object);
            return clazz;
        }
        LOGGER.info(object);
        return clazz;
    }

    private static URL[] getJarURLs(ARPluginDefinitionNodeI aRPluginDefinitionNodeI, boolean bl) throws IOException {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (aRPluginDefinitionNodeI != null) {
            Object object;
            Object object2;
            Object object3;
            ArrayList<String> arrayList2 = aRPluginDefinitionNodeI.getClassPathFolders();
            if (arrayList2 != null) {
                object3 = arrayList2.iterator();
                while (object3.hasNext()) {
                    object2 = (String)object3.next();
                    object = new File((String)object2);
                    if (!((File)object).exists()) continue;
                    arrayList.add(((File)object).toURI().toURL());
                }
            }
            if ((object3 = aRPluginDefinitionNodeI.getFileName()) != null && ((File)(object2 = new File((String)object3))).exists()) {
                arrayList.add(((File)object2).toURI().toURL());
            }
            if ((object2 = aRPluginDefinitionNodeI.getClassPathJars()) != null) {
                object = ((ArrayList)object2).iterator();
                while (object.hasNext()) {
                    String string = (String)object.next();
                    File file = new File(string);
                    if (!file.exists()) continue;
                    arrayList.add(file.toURI().toURL());
                }
            }
            ARPluginLoaderRouter.getAllManifest(bl, arrayList, (ArrayList<String>)object2, arrayList2);
        }
        return arrayList.toArray(new URL[0]);
    }

    private static void getAllManifest(boolean bl, List<URL> list, ArrayList<String> arrayList, ArrayList<String> arrayList2) throws IOException {
        if (arrayList != null && arrayList.size() > 0) {
            for (String string : arrayList) {
                try {
                    File file = new File(string);
                    JarFile jarFile = null;
                    try {
                        jarFile = new JarFile(file);
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    if (jarFile == null || arrayList2 == null || arrayList2.size() <= 0) continue;
                    for (String string2 : arrayList2) {
                        File file2 = new File(string2);
                        ARPluginLoaderRouter.getManifest(bl, list, jarFile, file2);
                    }
                }
                catch (Exception exception) {
                }
            }
        }
    }

    private static void getManifest(boolean bl, List<URL> list, JarFile jarFile, File file) throws IOException {
        Attributes attributes;
        String string;
        Manifest manifest = jarFile.getManifest();
        if (manifest != null && (string = (attributes = manifest.getMainAttributes()).getValue(Attributes.Name.CLASS_PATH)) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                URL uRL = ARPluginLoaderRouter.getDependentJarURL(jarFile, file, string2, bl);
                if (uRL == null) continue;
                list.add(uRL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URL getDependentJarURL(JarFile jarFile, File file, String string, boolean bl) throws IOException {
        ZipEntry zipEntry = jarFile.getEntry(string);
        if (zipEntry != null) {
            File file2 = new File(file, string);
            if (bl || !file2.exists()) {
                file2.getParentFile().mkdirs();
                InputStream inputStream = jarFile.getInputStream(zipEntry);
                try {
                    ARPluginLoaderRouter.copyStreamDataToFile(inputStream, file2);
                }
                finally {
                    inputStream.close();
                }
            }
            return file2.toURI().toURL();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyStreamDataToFile(InputStream inputStream, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        try {
            int n;
            byte[] byArray = new byte[8192];
            while ((n = inputStream.read(byArray)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
            }
        }
        finally {
            bufferedOutputStream.close();
        }
    }

    public ARPluginLoaderRouter() {
        String[] stringArray = ARPluginServerConfiguration.getInstance().getCmdLineArgs();
        ArrayList<ARPluginDefinition> arrayList = ARPluginServerConfiguration.getInstance().getConfiguredPlugins();
        this.instantiateAllPlugins(null, arrayList, stringArray);
        HashMap<String, PluginGroup> hashMap = ARPluginServerConfiguration.getInstance().getConfiguredPluginGroups();
        this.instantiatePluginGroups(hashMap, stringArray);
        ArrayList<ARPluginDefinition> arrayList2 = ARPluginServerConfiguration.getInstance().getNativePlugins();
        this.loadNativePluginWrappers(arrayList2);
    }

    public void initializeInstanceData(ARPluginContext aRPluginContext) {
    }

    public void cleanUpPlugins() {
        ARPluginContext aRPluginContext = new ARPluginContext();
        aRPluginContext.setCmdLineArgs(ARPluginServerConfiguration.getInstance().getCmdLineArgs());
        this.AREA.terminatePlugins(aRPluginContext);
        this.FILTERAPI.terminatePlugins(aRPluginContext);
        this.ARDBC.terminatePlugins(aRPluginContext);
    }

    private void loadNativePluginWrappers(ArrayList<ARPluginDefinition> arrayList) {
        if (PluginProxy.IsNativeMethodAccessible()) {
            for (int i = 0; i < arrayList.size(); ++i) {
                ARPluginDefinition aRPluginDefinition = arrayList.get(i);
                String string = aRPluginDefinition.getPluginCode();
                String string2 = aRPluginDefinition.getPluginType();
                String string3 = aRPluginDefinition.getPluginName();
                if (string == null || !string.equalsIgnoreCase("C")) continue;
                try {
                    PluginEnvelope pluginEnvelope;
                    ARPlugin aRPlugin;
                    if (string2.equalsIgnoreCase("FilterAPI")) {
                        aRPlugin = new CARFilterAPIPlugin(string3);
                        pluginEnvelope = new PluginEnvelope(aRPlugin, new ARPluginInfo(string3, 2, false));
                        this.FILTERAPI.addPlugin(string3, pluginEnvelope);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("ARDBC")) {
                        aRPlugin = new CARDBCPlugin(string3);
                        pluginEnvelope = new PluginEnvelope(aRPlugin, new ARPluginInfo(string3, 4, false));
                        this.ARDBC.addPlugin(string3, pluginEnvelope);
                        continue;
                    }
                    if (!string2.equalsIgnoreCase("AREA")) continue;
                    aRPlugin = new CAREAPlugin(string3);
                    pluginEnvelope = new PluginEnvelope(aRPlugin, new ARPluginInfo(string3, 3, false));
                    this.AREA.addPlugin(string3, pluginEnvelope);
                    continue;
                }
                catch (ARException aRException) {
                    LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8767) + " Plugin: " + string3), (Throwable)aRException);
                }
            }
        }
    }

    public void instantiatePluginGroups(HashMap<String, PluginGroup> hashMap, String[] stringArray) {
        Set<String> set = hashMap.keySet();
        for (String string : set) {
            LOGGER.info((Object)("Creating instances of all plugins in the group " + string));
            PluginGroup pluginGroup = hashMap.get(string);
            URLClassLoader uRLClassLoader = null;
            uRLClassLoader = ARPluginLoaderRouter.getPluginSetClassLoader(string);
            if (uRLClassLoader == null) {
                LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + " Group: " + string));
                continue;
            }
            this.instantiateAllPlugins(uRLClassLoader, pluginGroup.getPlugins(), stringArray);
            this.instantiatePluginGroups(pluginGroup.getGroups(), stringArray);
        }
    }

    public void instantiateAllPlugins(URLClassLoader uRLClassLoader, ArrayList<ARPluginDefinition> arrayList, String[] stringArray) {
        for (ARPluginDefinition aRPluginDefinition : arrayList) {
            if (!aRPluginDefinition.isActive()) continue;
            Class<?> clazz = null;
            LOGGER.info((Object)("Attempting to Create an instance of the plugin " + aRPluginDefinition.getPluginName()));
            URLClassLoader uRLClassLoader2 = ARPluginLoaderRouter.getPluginClassLoader(aRPluginDefinition.getPluginName());
            if (uRLClassLoader2 == null) {
                LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + aRPluginDefinition.getFileName()));
                continue;
            }
            clazz = ARPluginLoaderRouter.getPluginClass(aRPluginDefinition.getPluginName());
            if (clazz == null) {
                LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + aRPluginDefinition.getFileName()));
                continue;
            }
            this.loadPlugin(uRLClassLoader2, clazz, aRPluginDefinition, stringArray);
        }
    }

    void loadPlugin(URLClassLoader uRLClassLoader, Class<?> clazz, ARPluginDefinition aRPluginDefinition, String[] stringArray) {
        Object object;
        String string = aRPluginDefinition.getPluginName();
        boolean bl = false;
        try {
            object = this.instantiatePlugin(clazz, uRLClassLoader);
            ARPluginInfo aRPluginInfo = new ARPluginInfo(aRPluginDefinition.getPluginName(), aRPluginDefinition.getVersion(), !aRPluginDefinition.getPluginCode().equals("C"));
            PluginEnvelope pluginEnvelope = this.initializePlugin(string, stringArray, (ARPluggable)object, aRPluginInfo);
            if (pluginEnvelope == null) {
                aRPluginDefinition.setActive(false);
                return;
            }
            string = pluginEnvelope.getPluginName();
            if (object instanceof ARFilterAPIPluggable) {
                this.FILTERAPI.addPlugin(string, pluginEnvelope);
            } else if (object instanceof AREAPluggable) {
                TrustedAREAPluggable trustedAREAPluggable;
                int n;
                if (object instanceof TrustedAREAPluggable && (n = (trustedAREAPluggable = (TrustedAREAPluggable)object).secretKey()) > 0) {
                    pluginEnvelope.setTrustedAreaPluginFlag(true);
                }
                this.AREA.addPlugin(string, pluginEnvelope);
            } else if (object instanceof ARDBCPluggable) {
                this.ARDBC.addPlugin(string, pluginEnvelope);
            }
            bl = true;
        }
        catch (ARException aRException) {
            aRPluginDefinition.setActive(false);
        }
        catch (Throwable throwable) {
            LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + string), throwable);
            aRPluginDefinition.setActive(false);
        }
        object = "Thread " + Thread.currentThread().getId() + (bl ? " successfully created an instance of " : " failed to create an instance of ") + string;
        if (bl) {
            LOGGER.info(object);
        } else {
            LOGGER.error(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluginEnvelope initializePlugin(String string, String[] stringArray, ARPluggable aRPluggable, ARPluginInfo aRPluginInfo) throws ARException {
        assert (aRPluggable != null);
        ARPluginContext aRPluginContext = new ARPluginContext();
        if (aRPluggable == null) {
            return null;
        }
        String string2 = aRPluginInfo.getName();
        aRPluginContext.setCmdLineArgs(stringArray);
        aRPluginContext.setPluginInfo(aRPluginInfo);
        if (string2 != null) {
            PluginEnvelope pluginEnvelope = this.getPluginFromAnyMap(string2);
            Object var8_8 = null;
            if (pluginEnvelope == null) {
                try {
                    Thread.currentThread().setContextClassLoader(ARPluginLoaderRouter.getPluginClassLoader(string2));
                    aRPluggable.initialize(aRPluginContext);
                    PluginEnvelope pluginEnvelope2 = pluginEnvelope = new PluginEnvelope(aRPluggable, aRPluginInfo, var8_8);
                    return pluginEnvelope2;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(rootCl);
                }
            }
        }
        return null;
    }

    private PluginEnvelope getPluginFromAnyMap(String string) {
        PluginEnvelope pluginEnvelope = null;
        pluginEnvelope = this.FILTERAPI.getPlugin(string);
        if (pluginEnvelope != null) {
            return pluginEnvelope;
        }
        pluginEnvelope = this.AREA.getPlugin(string);
        if (pluginEnvelope != null) {
            return pluginEnvelope;
        }
        pluginEnvelope = this.ARDBC.getPlugin(string);
        return pluginEnvelope;
    }

    private ARPluggable instantiatePlugin(Class<?> clazz, URLClassLoader uRLClassLoader) throws ARException {
        ARPluggable aRPluggable = null;
        try {
            aRPluggable = (ARPluggable)clazz.newInstance();
            if (aRPluggable.getClass().getClassLoader() != uRLClassLoader) {
                LOGGER.info((Object)("The plugin " + aRPluggable.getClass() + " for " + clazz.getName() + " has been loaded by a parent classloader."));
            }
        }
        catch (InstantiationException instantiationException) {
            LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + clazz.getName()), (Throwable)instantiationException);
            throw new ARException(2, 8756, instantiationException.getLocalizedMessage());
        }
        catch (ClassCastException classCastException) {
            LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + clazz.getName()), (Throwable)classCastException);
            throw new ARException(2, 8756, classCastException.getLocalizedMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + clazz.getName()), (Throwable)illegalAccessException);
            throw new ARException(2, 8756, illegalAccessException.getLocalizedMessage());
        }
        catch (Throwable throwable) {
            LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + clazz.getName()), throwable);
            throw new ARException(2, 8756, throwable.getLocalizedMessage());
        }
        return aRPluggable;
    }

    public static void initializeNewJavaPlugins(ArrayList<ARPluginDefinition> arrayList, HashMap<String, PluginGroup> hashMap, String[] stringArray) {
        LOGGER.info((Object)"Loading all Newly configured Java Plugins and Plugin sets");
        ARPluginLoaderRouter.loadAllPlugins(null, arrayList, stringArray);
        ARPluginLoaderRouter.loadPluginGroups(hashMap, stringArray);
    }

    public static void instantiateNewJavaPlugins(ArrayList<ARPluginDefinition> arrayList, HashMap<String, PluginGroup> hashMap, String[] stringArray) {
        Thread thread = new Thread(new ARPluginDynamicInstantiateHandler(arrayList, hashMap, stringArray));
        thread.start();
    }

    public static Set<Thread> getAllThreads() {
        Set set = MAP_THREAD_PLUGINSLOADERROUTER.keySet();
        for (Thread thread : set) {
            LOGGER.trace((Object)("Exising thread " + thread.getId() + " " + thread.getName()));
            if (thread.isAlive()) continue;
            set.remove(thread);
        }
        return set;
    }

    public static boolean findThread(Thread thread) {
        Set set = MAP_THREAD_PLUGINSLOADERROUTER.keySet();
        boolean bl = false;
        for (Thread thread2 : set) {
            if (!thread2.isAlive()) {
                set.remove(thread2);
                continue;
            }
            if (!thread2.equals(thread)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static void prePluginCall(ARPluginContext aRPluginContext, String string) {
        aRPluginContext.setRemoteHostCharSet(string);
        if (aRPluginContext.getPluginInfo() != null && aRPluginContext.getPluginInfo().getName() != null) {
            URLClassLoader uRLClassLoader = ARPluginLoaderRouter.getPluginClassLoader(aRPluginContext.getPluginInfo().getName());
            Thread.currentThread().setContextClassLoader(uRLClassLoader);
        } else {
            Thread.currentThread().setContextClassLoader(rootCl);
        }
    }
}

