/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr.binding;

import com.bmc.arsys.pluginsvr.ARPluginSvrThreadLocalStorageBlock;
import com.bmc.arsys.pluginsvr.legacy.PluginProxy;
import com.bmc.arsys.pluginsvr.plugins.ARPluginLoaderRouter;
import com.bmc.arsys.utils.CatalogReader;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ARPluginSvrThreadPoolExecutor
extends ThreadPoolExecutor {
    private static Logger log = Logger.getLogger(ARPluginSvrThreadPoolExecutor.class);
    private static boolean readyForRpcCall;
    private static int prestartedThreadCount;
    private static int prestartInitializedCount;
    private static int skipCount;
    private final ReentrantLock lock = new ReentrantLock();

    public ARPluginSvrThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue) {
        super(n, n2, l, timeUnit, blockingQueue);
    }

    public ARPluginSvrThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory) {
        super(n, n2, l, timeUnit, blockingQueue, threadFactory);
    }

    @Override
    public int prestartAllCoreThreads() {
        prestartedThreadCount = super.prestartAllCoreThreads();
        String string = "Java plug-in server is initializing all plug-ins for " + prestartedThreadCount + " core threads. Please wait ...";
        if (log.isInfoEnabled()) {
            log.info((Object)string);
        } else {
            log.warn((Object)("INFO: " + string));
        }
        System.out.println(string);
        int n = 0;
        while (n < prestartedThreadCount + skipCount && !readyForRpcCall) {
            this.execute(new Runnable(){

                public void run() {
                }
            });
            if (++n < prestartedThreadCount) continue;
            this.checkSkipCountThread(n);
        }
        return prestartedThreadCount;
    }

    private void checkSkipCountThread(int n) {
        if (n >= prestartedThreadCount + skipCount || n % prestartedThreadCount == 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (skipCount > 0 && n > prestartedThreadCount * 3 && !readyForRpcCall && n % prestartedThreadCount == 0) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            log.warn((Object)("ThreadPoolExecutor initialized " + prestartInitializedCount + " threads to receive RPC calls." + " SkipCount : " + skipCount));
        }
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable runnable) {
        super.beforeExecute(thread, runnable);
        boolean bl = ARPluginSvrThreadLocalStorageBlock.isTLBExist();
        if (!bl) {
            log.info((Object)("Will iniPlugins for thread: " + thread.getId() + " " + thread));
            this.iniPlugins(thread);
        } else if (!readyForRpcCall) {
            ++skipCount;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Same thread: " + thread.getId() + " " + thread);
            ARPluginLoaderRouter aRPluginLoaderRouter = ARPluginLoaderRouter.getPluginRouter(thread);
            if (aRPluginLoaderRouter != null) {
                stringBuilder.append(" already instantiated.");
            } else {
                stringBuilder.append(" skipped");
            }
            log.info((Object)stringBuilder.toString());
        }
    }

    /*
     * Exception decompiling
     */
    protected boolean iniPlugins(Thread var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isReadyForRpcCall() {
        return readyForRpcCall;
    }

    @Override
    public void shutdown() {
        this.cleanUp();
        super.shutdown();
    }

    protected void cleanUp() {
        Set<Thread> set = ARPluginLoaderRouter.getAllThreads();
        for (Thread object : set) {
            if (!object.isAlive()) continue;
            try {
                ARPluginLoaderRouter throwable = ARPluginLoaderRouter.getPluginRouter(object);
                if (throwable == null) continue;
                throwable.cleanUpPlugins();
            }
            catch (Throwable throwable) {
                log.debug((Object)("Clean up plugins for thread " + object.getId()));
                log.error((Object)CatalogReader.getInstance().getMessage(8794), throwable);
            }
        }
        set.clear();
        log.info((Object)"Worker thread executor cleaned up routers and plugins.");
        try {
            if (PluginProxy.IsNativeMethodAccessible()) {
                log.info((Object)"clean up native plugins");
                PluginProxy throwable = PluginProxy.getInstance();
                if (throwable != null) {
                    throwable.deleteInstancesForThread();
                }
            }
        }
        catch (Throwable throwable) {
            log.error((Object)CatalogReader.getInstance().getMessage(8790), throwable);
        }
    }

    static {
        prestartInitializedCount = 0;
        skipCount = 0;
    }
}

