/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arreporting;

import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.Field;
import com.bmc.arsys.arreporting.Aggregation;
import com.bmc.arsys.arreporting.ChartType;
import com.bmc.arsys.arreporting.FieldInfo;
import com.bmc.arsys.arreporting.OutputFormat;
import com.bmc.arsys.arreporting.ReportConstants;
import com.bmc.arsys.arreporting.ReportStyle;
import com.bmc.arsys.arreporting.ReportType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportParameters {
    public static final String REPORT_DESIGNER = "reportDesigner";
    public static final String BIRT_DESIGNER = "BIRT_DESIGNER";
    public static final String AR_DESIGNER = "AR_DESIGNER";
    private String reportSet = null;
    private Properties properties = new Properties();
    private String midtierUrl = null;
    private String reportFile = null;
    private String qualification = null;
    private String resultList = null;
    private boolean forcePNG = true;
    private final List<FieldInfo> fields = new ArrayList<FieldInfo>();
    private final List<FieldInfo> groups = new ArrayList<FieldInfo>();
    private Map<Integer, String> fieldNameMap = null;
    private String footer;
    private ReportType type = null;
    private final ReportStyle style = null;
    private boolean overrideQualification = true;
    private int maxRecords = 0;
    private String entryId;

    public String getEncodedPrimaryQual() {
        return this.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_MAIN_QUERY_ID.toInt()));
    }

    public String getEncodedSecondaryQual() {
        return this.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_SECONDARY_QUERY_ID.toInt()));
    }

    public String getTitle() {
        return this.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_TITLE_ID.toInt()));
    }

    public String getFooter() {
        return this.footer;
    }

    public void setFooter(String string) {
        this.footer = string;
    }

    public List<FieldInfo> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public void addField(FieldInfo fieldInfo) {
        if (fieldInfo == null) {
            return;
        }
        if (this.fields.isEmpty()) {
            this.fields.add(fieldInfo);
        } else {
            FieldInfo fieldInfo2 = null;
            for (FieldInfo fieldInfo3 : this.fields) {
                if (fieldInfo.getFieldId() != fieldInfo3.getFieldId()) continue;
                fieldInfo2 = fieldInfo3;
                break;
            }
            if (fieldInfo2 != null) {
                this.fields.remove(fieldInfo2);
            }
            this.fields.add(fieldInfo);
        }
    }

    public void removeField(FieldInfo fieldInfo) {
        this.fields.remove(fieldInfo);
    }

    public FieldInfo getField(int n) {
        for (FieldInfo fieldInfo : this.fields) {
            if (n != fieldInfo.getFieldId()) continue;
            return fieldInfo;
        }
        return null;
    }

    public void removeField(int n) {
        FieldInfo fieldInfo = null;
        for (FieldInfo fieldInfo2 : this.fields) {
            if (n != fieldInfo2.getFieldId()) continue;
            fieldInfo = fieldInfo2;
            break;
        }
        if (fieldInfo != null) {
            this.fields.remove(fieldInfo);
        }
    }

    public void addGroup(FieldInfo fieldInfo) {
        if (fieldInfo == null) {
            return;
        }
        if (this.groups.isEmpty()) {
            this.groups.add(fieldInfo);
        } else {
            FieldInfo fieldInfo2 = null;
            for (FieldInfo fieldInfo3 : this.groups) {
                if (fieldInfo.getFieldId() != fieldInfo3.getFieldId()) continue;
                fieldInfo2 = fieldInfo3;
                break;
            }
            if (fieldInfo2 != null) {
                this.groups.remove(fieldInfo2);
            }
            this.groups.add(fieldInfo);
        }
    }

    public void removeGroup(FieldInfo fieldInfo) {
        this.groups.remove(fieldInfo);
    }

    public void removeGroup(int n) {
        FieldInfo fieldInfo = null;
        for (FieldInfo fieldInfo2 : this.groups) {
            if (n != fieldInfo2.getFieldId()) continue;
            fieldInfo = fieldInfo2;
            break;
        }
        if (fieldInfo != null) {
            this.groups.remove(fieldInfo);
        }
    }

    public List<FieldInfo> getGroups() {
        return Collections.unmodifiableList(this.groups);
    }

    public void setType(ReportType reportType) {
        this.type = reportType;
    }

    public ReportType getType() {
        return this.type;
    }

    public void setMaxRecords(int n) {
        this.maxRecords = n;
    }

    public int getMaxRecords() {
        return this.maxRecords;
    }

    public String getName() {
        return this.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_NAME_ID.toInt()));
    }

    public String getDescription() {
        return this.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_DESC_ID.toInt()));
    }

    public void setReportSet(String string) {
        this.reportSet = string;
    }

    public String getReportSet() {
        return this.reportSet;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void clearFields() {
        this.fields.clear();
    }

    public void clearGroups() {
        this.groups.clear();
    }

    public void setMidtierUrl(String string) {
        this.midtierUrl = string;
    }

    public String getMidtierUrl() {
        return this.midtierUrl;
    }

    public int getSeriesField() {
        String string = this.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_CHART_SERIES_ID.toInt()));
        if (string != null && string.length() > 0) {
            return Integer.parseInt(string);
        }
        return -1;
    }

    public int getCategoryField() {
        String string = this.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_CHART_CATEGORY_ID.toInt()));
        if (string != null && string.length() > 0) {
            return Integer.parseInt(string);
        }
        return -1;
    }

    public void setSeriesField(int n) {
        this.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_CHART_SERIES_ID.toInt()), Integer.toString(n));
    }

    public void setCategoryField(int n) {
        this.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_CHART_CATEGORY_ID.toInt()), Integer.toString(n));
    }

    public String getForm() {
        return this.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_FORM_NAME_ID.toInt()));
    }

    public void setForm(String string) {
        this.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_FORM_NAME_ID.toInt()), string);
    }

    public OutputFormat getOutputFormat() {
        String string = this.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_FORMAT_ID.toInt()));
        if (string != null && string.length() > 0) {
            return OutputFormat.fromPropValue(string);
        }
        return OutputFormat.HTML;
    }

    public void setOutputFormat(OutputFormat outputFormat) {
        if (outputFormat == null) {
            this.getProperties().remove(Integer.toString(ReportConstants.DESIGNER_REPORT_FORMAT_ID.toInt()));
        } else {
            this.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_FORMAT_ID.toInt()), outputFormat.getPropValue());
        }
    }

    public void setReportFile(String string) {
        this.reportFile = string;
    }

    public String getReportFile() {
        return this.reportFile;
    }

    public void setOverrideQualification(boolean bl) {
        this.overrideQualification = bl;
    }

    public boolean isOverrideQualification() {
        return this.overrideQualification;
    }

    public String getEntryId() {
        return this.entryId;
    }

    public void setEntryId(String string) {
        this.entryId = string;
    }

    public void setQualification(String string) {
        this.qualification = string;
    }

    public String getQualification() {
        return this.qualification;
    }

    public boolean isIncludeList() {
        ReportStyle reportStyle = this.getStyle();
        return ReportStyle.LIST.equals((Object)reportStyle) || ReportStyle.CHART_AND_LIST.equals((Object)reportStyle);
    }

    public boolean isIncludeChart() {
        return !ReportStyle.LIST.equals((Object)this.getStyle());
    }

    public int getVuiId() {
        String string = this.getProperties().getProperty(Integer.toString(ReportConstants.FIELD_INFO_VUI_ID.toInt()));
        if (string != null && string.length() > 0) {
            return Integer.parseInt(string);
        }
        return 0;
    }

    public void setResultList(String string) {
        this.resultList = string;
    }

    public String getResultList() {
        return this.resultList;
    }

    public void setForcePNG(boolean bl) {
        this.forcePNG = bl;
    }

    public boolean isForcePNG() {
        return this.forcePNG;
    }

    public void setChartType(ChartType chartType) {
        if (chartType == null) {
            this.getProperties().remove(Integer.toString(ReportConstants.DESIGNER_REPORT_CHART_ID.toInt()));
        } else {
            this.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_CHART_ID.toInt()), Integer.toString(chartType.getEnumValue()));
        }
    }

    public ChartType getChartType() {
        String string = this.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_CHART_ID.toInt()));
        if (string != null && string.length() > 0) {
            return ChartType.fromInt(Integer.parseInt(string));
        }
        return null;
    }

    public void setAggregation(Aggregation aggregation) {
        if (aggregation == null) {
            this.getProperties().remove(Integer.toString(ReportConstants.DESIGNER_CHART_AGGREGATE_BY.toInt()));
        } else {
            this.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_CHART_AGGREGATE_BY.toInt()), Integer.toString(aggregation.getEnumValue()));
        }
    }

    public Aggregation getAggregation() {
        String string = this.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_CHART_AGGREGATE_BY.toInt()));
        if (string != null && string.length() > 0) {
            return Aggregation.fromInt(Integer.parseInt(string));
        }
        return Aggregation.COUNT;
    }

    public void setStyle(ReportStyle reportStyle) {
        if (reportStyle == null) {
            this.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_TEMPLATE_ID.toInt()), Integer.toString(ReportStyle.LIST.getEnumValue()));
        } else {
            this.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_TEMPLATE_ID.toInt()), Integer.toString(reportStyle.getEnumValue()));
        }
    }

    public ReportStyle getStyle() {
        String string = this.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_TEMPLATE_ID.toInt()));
        if (string != null && string.length() > 0) {
            return ReportStyle.fromInt(Integer.parseInt(string));
        }
        return ReportStyle.LIST;
    }

    public String getSeriesLabel() {
        return this.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_CHART_SERIES_LABEL_ID.toInt()));
    }

    public String getCategoryLabel() {
        return this.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_CHART_CATEGORY_LABEL_ID.toInt()));
    }

    public String getFieldName(int n) {
        Object object;
        if (this.fieldNameMap == null || this.fieldNameMap != null && this.fieldNameMap.isEmpty()) {
            this.fieldNameMap = new HashMap<Integer, String>();
            object = this.getProperties().get("arFieldObjects");
            if (object != null && object instanceof List) {
                List list = (List)object;
                for (Field field : list) {
                    this.fieldNameMap.put(field.getFieldID(), field.getName());
                }
            }
        }
        if ((object = this.fieldNameMap.get(n)) != null) {
            return object;
        }
        return Integer.toString(n);
    }

    public int getFieldDataType(int n) {
        Object object;
        DataType dataType = null;
        FieldInfo fieldInfo = this.getField(n);
        if (fieldInfo != null && (dataType = fieldInfo.getDataType()) != null) {
            return dataType.toInt();
        }
        if (dataType == null && (object = this.getProperties().get("arFieldObjects")) != null && object instanceof List) {
            List list = (List)object;
            for (Field field : list) {
                if (field.getFieldID() != n) continue;
                return field.getDataType();
            }
        }
        return 0;
    }
}

