/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.data;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.apiext.data.ARImportException;
import com.bmc.arsys.apiext.data.BaseImporter;
import com.bmc.arsys.apiext.data.DataOptions;
import com.bmc.arsys.apiext.data.IParseListener;
import com.bmc.arsys.apiext.data.IParser;
import com.bmc.arsys.apiext.data.ImportErrors;
import com.bmc.arsys.apiext.data.ImportOptions;
import com.bmc.arsys.apiext.data.JAXBHandler;
import com.bmc.arsys.apiext.data.JIThreadPoolExecutor;
import com.bmc.arsys.apiext.data.Util;
import com.bmc.arsys.apiext.data.arm.ARMParser;
import com.bmc.arsys.apiext.data.arm.ARMXMLParser;
import com.bmc.arsys.apiext.data.arm.CustomXMLParser;
import com.bmc.arsys.apiext.data.arx.ARXImporter;
import com.bmc.arsys.apiext.data.ascii.ASCIIImporter;
import com.bmc.arsys.apiext.data.csv.CSVImporter;
import com.bmc.arsys.apiext.data.jaxb.options.Command;
import com.bmc.arsys.apiext.data.jaxb.options.Commands;
import com.bmc.arsys.apiext.data.jaxb.options.Global;
import com.bmc.arsys.apiext.data.jaxb.options.Import;
import com.bmc.arsys.apiext.data.jaxb.options.Parameter;
import com.bmc.arsys.apiext.data.jaxb.summary.DataFileList;
import com.bmc.arsys.apiext.data.jaxb.summary.Df;
import com.bmc.arsys.apiext.data.jaxb.summary.ObjectFactory;
import com.bmc.arsys.apiext.data.jaxb.summary.Summary;
import com.bmc.arsys.apiext.data.xml.ARXMLImporter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataImport {
    public static final String VERSION = "arimportcmd version 7.6.04 build002";
    public SimpleDateFormat simpleDateFormater = new SimpleDateFormat("EEE MMM dd HH:mm:ss.SSS");
    public Date importToolEntryTime = null;
    private ImportOptions else = null;
    private static final String do = "\"=\"";
    private Logger case = Logger.getLogger((String)"com.bmc.arsys.apiext.data");
    protected boolean commandLine = false;
    private boolean try = false;
    private Set<IParseListener> char = null;
    private int for = 50;
    private String byte = null;
    private long if = 1L;
    private Import int = null;
    private boolean a = false;
    private String new = System.getenv("DEBUG_JIT");

    public int getDebugLogLevel() {
        int n = 3;
        try {
            if (this.new != null && this.new.length() > 0) {
                n = Integer.parseInt(this.new.trim());
            }
        }
        catch (NumberFormatException numberFormatException) {
            n = 3;
        }
        return n;
    }

    public boolean isRIK() {
        return this.a;
    }

    public void setRIK(boolean bl) {
        this.a = bl;
    }

    public boolean isLogInitialized() {
        return this.try;
    }

    public void setLogInitialized(boolean bl) {
        this.try = bl;
    }

    public Logger getLogger() {
        return this.case;
    }

    public String getOptionsFile() {
        return this.byte;
    }

    public void setOptionsFile(String string) {
        this.byte = string;
    }

    public int getPoolSize() {
        return this.for;
    }

    public void setPoolSize(int n) {
        this.for = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws ARException, ARImportException, IOException {
        DataImport dataImport = new DataImport();
        dataImport.importToolEntryTime = new Date();
        try {
            dataImport.commandLine = true;
            dataImport.doImport(stringArray);
        }
        catch (Throwable throwable) {
            if (!dataImport.isLogInitialized()) {
                System.out.println(throwable);
            } else {
                dataImport.getLogger().error((Object)throwable);
            }
        }
        finally {
            System.exit(0);
        }
    }

    public void doImport(String[] stringArray) throws ARException, ARImportException, IOException {
        block12: {
            if (stringArray.length < 7) {
                boolean bl = false;
                for (String string : stringArray) {
                    if (!string.equals("--version")) continue;
                    bl = true;
                    System.out.println(VERSION);
                    System.exit(0);
                }
                if (!bl) {
                    this.printUsage();
                    System.exit(1);
                }
            } else {
                try {
                    this.else = this.parseCommandLine(stringArray);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ARImportException(MessageFormat.format(ImportErrors.ERROR_PARSING_CMD_ARGS.toDefMsg(), numberFormatException.getMessage()));
                }
                try {
                    this.startImport();
                }
                catch (ARImportException aRImportException) {
                    this.case.error((Object)MessageFormat.format(ImportErrors.IMPORT_FAILED.toDefMsg(), this.else.getFileOptions().getDataFile(), aRImportException), (Throwable)aRImportException);
                    if (!this.commandLine) {
                        throw aRImportException;
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.case.error((Object)MessageFormat.format(ImportErrors.DATA_FILE_NOT_OPENED.toDefMsg(), this.else.getFileOptions().getDataFile(), fileNotFoundException), (Throwable)fileNotFoundException);
                    if (!this.commandLine) {
                        throw fileNotFoundException;
                    }
                }
                catch (Exception exception) {
                    this.case.error((Object)MessageFormat.format(ImportErrors.IMPORT_FAILED.toDefMsg(), this.else.getFileOptions().getDataFile(), exception), (Throwable)exception);
                    if (this.commandLine) break block12;
                    throw new ARImportException(exception);
                }
            }
        }
    }

    public void applyAPITimeouts() {
        String string = System.getenv("ARAPITIMEOUTS");
        if (string != null && string.length() > 0) {
            String[] stringArray = string.split(":");
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    if (i == 0) {
                        this.else.getContext().setTimeoutNormal(Integer.parseInt(stringArray[i].trim()));
                        continue;
                    }
                    if (i == 1) {
                        this.else.getContext().setTimeoutLong(Integer.parseInt(stringArray[i].trim()));
                        continue;
                    }
                    this.else.getContext().setTimeoutXLong(Integer.parseInt(stringArray[i].trim()));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    public void startImport() throws ARImportException, IOException, ARException {
        String string;
        if (!this.isLogInitialized()) {
            if (this.else.getLogLevelInt() < this.getDebugLogLevel()) {
                this.else.setLogLevel(this.getDebugLogLevel());
            }
            this.initLogging(this.else.getLogFile(), this.else.getLogLevel());
            this.else.getLoggersList().put(this.else.getLogFile(), this.case);
        }
        if ((string = System.getProperty("isRik")) != null && string.trim().equalsIgnoreCase("1")) {
            this.setRIK(true);
        }
        this.applyAPITimeouts();
        try {
            this.validateOptions();
        }
        catch (ARImportException aRImportException) {
            this.case.error((Object)aRImportException);
            if (this.commandLine) {
                return;
            }
            throw aRImportException;
        }
        if (this.getOptions().getDataOptions().getBadRecordHandling() == DataOptions.BadRecords.ALERTUSER) {
            boolean bl = false;
            if (this.getOptions().getUserAlertListener() == null) {
                bl = true;
            }
            if (this.commandLine || bl) {
                this.case.info((Object)ImportErrors.BAD_RECORD_HANDLING_SET_TO_ALERT_USER_NO_WAY_TO_DO.toDefMsg());
                this.getOptions().getDataOptions().setBadRecordHandling(DataOptions.BadRecords.SKIP);
            }
        }
        this.else.getResults().reset();
        try {
            this.if();
        }
        catch (Exception exception) {
            throw new ARImportException(exception);
        }
        finally {
            this.a();
        }
    }

    private void if() throws ARException, ARImportException, Exception {
        JIThreadPoolExecutor jIThreadPoolExecutor = JIThreadPoolExecutor.getInstance();
        try {
            if (this.int != null) {
                List<Commands> list = this.int.getCommands();
                for (Commands commands : list) {
                    ImportOptions importOptions;
                    List<Command> list2;
                    if (commands.isIsSerial()) {
                        this.case.info((Object)ImportErrors.STARTING_SERIAL_IMPORT.toDefMsg());
                        list2 = commands.getCommand();
                        for (Command command : list2) {
                            importOptions = this.else.clone();
                            importOptions = this.populateOptions(importOptions, command.getParameter(), false);
                            this.a(importOptions, jIThreadPoolExecutor);
                        }
                        this.case.info((Object)ImportErrors.ENDING_SERIAL_IMPORT.toDefMsg());
                        continue;
                    }
                    this.case.info((Object)ImportErrors.STARTING_PARALLEL_IMPORT.toDefMsg());
                    jIThreadPoolExecutor.createPool(this.getPoolSize(), this.if, TimeUnit.MICROSECONDS);
                    list2 = commands.getCommand();
                    for (Command command : list2) {
                        importOptions = this.else.clone();
                        importOptions = this.populateOptions(importOptions, command.getParameter(), false);
                        this.if(importOptions, jIThreadPoolExecutor);
                    }
                    jIThreadPoolExecutor.join();
                    jIThreadPoolExecutor.deletePool();
                    this.case.info((Object)ImportErrors.ENDING_PARALLEL_IMPORT.toDefMsg());
                }
                this.a(this.byte, jIThreadPoolExecutor);
            } else {
                this.a(this.else, jIThreadPoolExecutor);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.case.error((Object)MessageFormat.format(ImportErrors.IMPORT_FAILED.toDefMsg(), this.else.getFileOptions().getDataFile(), "Insufficient Java heap space"));
            if (!this.commandLine) {
                throw outOfMemoryError;
            }
        }
        catch (InterruptedException interruptedException) {
            throw new ARImportException(interruptedException);
        }
        finally {
            jIThreadPoolExecutor.deleteFuture();
        }
    }

    private void a() {
        this.else.getLoggersList().clear();
        this.else.setLogersList(null);
        this.else.setLogersList(new LinkedHashMap<String, Logger>());
        this.setLogInitialized(false);
    }

    private void a(String string, JIThreadPoolExecutor jIThreadPoolExecutor) throws ARImportException {
        try {
            if (string != null && string.length() > 0) {
                Object object;
                String string2 = new String(string);
                string2 = string2.replace(".xml", "_summary.log");
                StringBuilder stringBuilder = new StringBuilder();
                Formatter formatter = new Formatter(stringBuilder);
                PatternLayout patternLayout = new PatternLayout();
                Logger logger = this.createLogger(string2, Level.INFO, patternLayout);
                List<Future<ImportOptions>> list = jIThreadPoolExecutor.getFuture();
                Future<ImportOptions> future = list.get(0);
                String string3 = future.get().getFileOptions().getDataFile();
                int n = string3 != null ? string3.length() + 100 : 100;
                String string4 = "%-" + n + "s" + " %-15s %-15s %-15s %-15s %-15s ";
                ObjectFactory objectFactory = new ObjectFactory();
                Summary summary = objectFactory.createSummary();
                DataFileList dataFileList = objectFactory.createDataFileList();
                if (!this.isRIK()) {
                    string4 = string4 + "%-50s ";
                }
                logger.info((Object)formatter.format(string4, "Data File", "Record Count", "Success Count", "Error Count", "Skip Count", "Warning Count", "Log File "));
                for (Future<ImportOptions> object2 : list) {
                    object = object2.get();
                    StringBuilder stringBuilder2 = new StringBuilder();
                    Formatter formatter2 = new Formatter(stringBuilder2);
                    logger.info((Object)formatter2.format(string4, ((ImportOptions)object).getFileOptions().getDataFile(), ((ImportOptions)object).getResults().getRecordCount(), ((ImportOptions)object).getResults().getSuccessCount(), ((ImportOptions)object).getResults().getErrorCount(), ((ImportOptions)object).getResults().getSkipCount(), ((ImportOptions)object).getResults().getWarningCount(), ((ImportOptions)object).getLogFile()));
                    if (!this.isRIK()) continue;
                    Df df = objectFactory.createDf();
                    String string5 = null;
                    String string6 = null;
                    if (((ImportOptions)object).getDataOptions().getDuplicateFields() != null) {
                        string5 = ((ImportOptions)object).getDataOptions().getDuplicateFields().toString();
                        string5 = string5.replace("[", "");
                        string5 = string5.replace("]", "").trim();
                    } else {
                        string5 = "";
                    }
                    df.setAltfid(string5);
                    string6 = ((ImportOptions)object).getLogFile() != null ? ((ImportOptions)object).getLogFile() : "";
                    df.setLog(string6);
                    df.setMode(new Integer(((ImportOptions)object).getDataOptions().getDuplicateIdHandling().getMergeOption()).toString());
                    df.setContent(((ImportOptions)object).getFileOptions().getDataFile());
                    dataFileList.getDf().add(df);
                }
                if (this.isRIK()) {
                    summary.setDataFileList(dataFileList);
                    JAXBHandler jAXBHandler = new JAXBHandler("com.bmc.arsys.apiext.data.jaxb.summary");
                    File file = new File(string);
                    object = file.getParent();
                    object = (String)object + System.getProperty("file.separator") + "DataImportSummary.xml";
                    jAXBHandler.setTargetFile(new File((String)object));
                    jAXBHandler.writeXML(summary);
                }
            }
        }
        catch (Exception exception) {
            throw new ARImportException(exception);
        }
    }

    private void a(ImportOptions importOptions, JIThreadPoolExecutor jIThreadPoolExecutor) throws ARImportException, InterruptedException, IOException, ARException {
        int n = 0;
        List<Callable<ImportOptions>> list = this.if(importOptions);
        if (list.size() <= 0) {
            Logger logger = importOptions.getLoggersList().get(importOptions.getLogFile());
            logger.error((Object)MessageFormat.format(ImportErrors.IMPORT_FAILED_WITH_NO_TASK_FOUND.toDefMsg(), importOptions.getFileOptions().getDataFile()));
            return;
        }
        n = this.getPoolSize() > list.size() ? list.size() : this.getPoolSize();
        jIThreadPoolExecutor.createPool(n, this.if, TimeUnit.MICROSECONDS);
        jIThreadPoolExecutor.addMultipleTask(list);
        jIThreadPoolExecutor.join();
        jIThreadPoolExecutor.deletePool();
    }

    private void if(ImportOptions importOptions, JIThreadPoolExecutor jIThreadPoolExecutor) throws ARImportException, InterruptedException, IOException, ARException {
        List<Callable<ImportOptions>> list = this.if(importOptions);
        if (list.size() <= 0) {
            Logger logger = importOptions.getLoggersList().get(importOptions.getLogFile());
            logger.error((Object)MessageFormat.format(ImportErrors.IMPORT_FAILED_WITH_NO_TASK_FOUND.toDefMsg(), importOptions.getFileOptions().getDataFile()));
            return;
        }
        jIThreadPoolExecutor.addMultipleTask(list);
    }

    private List<Callable<ImportOptions>> if(ImportOptions importOptions) throws ARImportException, InterruptedException {
        LinkedList<Callable<ImportOptions>> linkedList = new LinkedList<Callable<ImportOptions>>();
        BaseImporter baseImporter = null;
        importOptions = this.a(importOptions);
        ImportOptions importOptions2 = null;
        if (importOptions.getFileList() != null && importOptions.getFileList().size() > 0) {
            int n = importOptions.getFileList().size();
            for (int i = 0; i < n; ++i) {
                if (importOptions.getFileList().get(i).toUpperCase().endsWith("ARX")) {
                    importOptions.getFileOptions().setType("ARX");
                } else if (importOptions.getFileList().get(i).toUpperCase().endsWith("XML")) {
                    importOptions.getFileOptions().setType("XML");
                } else if (importOptions.getFileList().get(i).toUpperCase().endsWith("CSV")) {
                    importOptions.getFileOptions().setType("CSV");
                } else if (importOptions.getFileList().get(i).toUpperCase().endsWith("ASC")) {
                    importOptions.getFileOptions().setType("ASC");
                }
                importOptions2 = importOptions.clone();
                importOptions2.getFileOptions().setDataFile(importOptions.getFileList().get(i));
                if (importOptions2.getLogFile() == null || importOptions2.getLogFile().trim().length() == 0) {
                    Object object = importOptions2.getFileOptions().getDataFile();
                    object = ((String)object).substring(((String)object).lastIndexOf(System.getProperty("file.separator")) + 1);
                    importOptions2.setLogFile(((String)object).substring(0, ((String)object).lastIndexOf(".")) + ".log");
                    File file = new File(importOptions2.getLogFile());
                    importOptions2.setLogFile(file.getAbsolutePath());
                    Object var8_12 = null;
                    if (!importOptions2.getLoggersList().containsKey(importOptions2.getLogFile())) {
                        Logger logger = this.createLogger(importOptions2.getLogFile(), importOptions2.getLogLevel(), null);
                        importOptions2.getLoggersList().put(importOptions2.getLogFile(), logger);
                    }
                }
                if (importOptions2.getFileOptions().getType() != null) {
                    if (importOptions2.getFileOptions().getType().equals("ARX")) {
                        baseImporter = new ARXImporter(importOptions2);
                    } else if (importOptions2.getFileOptions().getType().equals("XML")) {
                        baseImporter = new ARXMLImporter(importOptions2);
                    } else if (importOptions2.getFileOptions().getType().equals("CSV")) {
                        baseImporter = new CSVImporter(importOptions2);
                    } else if (importOptions2.getFileOptions().getType().equals("ASC")) {
                        baseImporter = new ASCIIImporter(importOptions2);
                    }
                } else if (importOptions2.getFileOptions().getDataFile() != null) {
                    if (importOptions2.getFileOptions().getDataFile().toUpperCase().endsWith("ARX")) {
                        baseImporter = new ARXImporter(importOptions2);
                    } else if (importOptions2.getFileOptions().getDataFile().toUpperCase().endsWith("XML")) {
                        baseImporter = new ARXMLImporter(importOptions2);
                    } else if (importOptions2.getFileOptions().getDataFile().toUpperCase().endsWith("CSV")) {
                        baseImporter = new CSVImporter(importOptions2);
                    } else if (importOptions2.getFileOptions().getDataFile().toUpperCase().endsWith("ASC")) {
                        baseImporter = new ASCIIImporter(importOptions2);
                    }
                }
                if (baseImporter == null) continue;
                if (this.char != null && baseImporter.getParser() != null) {
                    for (IParseListener iParseListener : this.char) {
                        if (iParseListener == null) continue;
                        baseImporter.getParser().addListener(iParseListener);
                    }
                }
                linkedList.add(baseImporter);
            }
        } else {
            baseImporter = this.do(importOptions);
            if (baseImporter != null) {
                if (this.char != null && baseImporter.getParser() != null) {
                    for (IParseListener iParseListener : this.char) {
                        if (iParseListener == null) continue;
                        baseImporter.getParser().addListener(iParseListener);
                    }
                }
                linkedList.add(baseImporter);
            }
        }
        return linkedList;
    }

    private ImportOptions a(ImportOptions importOptions) throws ARImportException {
        String string = importOptions.getFileOptions().getDataFile();
        File file = null;
        if (string != null && string.length() > 0) {
            file = new File(string);
            if (!file.isDirectory()) {
                return importOptions;
            }
        } else {
            return importOptions;
        }
        if (importOptions.getFileList() != null && importOptions.getFileList().size() > 0) {
            for (int i = 0; i < importOptions.getFileList().size(); ++i) {
                String string2 = string + System.getProperty("file.separator") + importOptions.getFileList().get(i);
                importOptions.getFileList().set(i, string2);
            }
        } else if (importOptions.getFilePattern() != null && importOptions.getFilePattern().length() > 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            try {
                PatternFilter patternFilter = new PatternFilter(importOptions.getFilePattern());
                List<String> list = Arrays.asList(file.list(patternFilter));
                arrayList.addAll(list);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new ARImportException(MessageFormat.format(ImportErrors.INVALID_REGEX_PATTERN_SYNTAX.toDefMsg(), patternSyntaxException.getMessage()));
            }
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                String string3 = string + System.getProperty("file.separator") + arrayList.get(i);
                arrayList.set(i, string3);
            }
            importOptions.setFileList(arrayList);
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            FilenameFilter filenameFilter = new ARXFilter();
            List<String> list = Arrays.asList(file.list(filenameFilter));
            arrayList.addAll(list);
            filenameFilter = new CSVFilter();
            list = Arrays.asList(file.list(filenameFilter));
            arrayList.addAll(list);
            filenameFilter = new XMLFilter();
            list = Arrays.asList(file.list(filenameFilter));
            arrayList.addAll(list);
            filenameFilter = new ASCIIFilter();
            list = Arrays.asList(file.list(filenameFilter));
            arrayList.addAll(list);
            if (arrayList == null) {
                throw new ARImportException(ImportErrors.IO_ERROR_READING_DIRECTORY.toDefMsg() + string);
            }
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                String string4 = string + System.getProperty("file.separator") + arrayList.get(i);
                arrayList.set(i, string4);
            }
            importOptions.setFileList(arrayList);
        }
        if (importOptions.getFileList().size() < 1) {
            throw new ARImportException(MessageFormat.format(ImportErrors.NO_FILE_MATCHED_PATTERN.toDefMsg(), importOptions.getFilePattern()));
        }
        return importOptions;
    }

    private BaseImporter do(ImportOptions importOptions) throws ARImportException {
        if (importOptions.getFileOptions().getType() != null) {
            if (importOptions.getFileOptions().getType().equals("ARX")) {
                return new ARXImporter(importOptions);
            }
            if (importOptions.getFileOptions().getType().equals("XML")) {
                return new ARXMLImporter(importOptions);
            }
            if (importOptions.getFileOptions().getType().equals("CSV")) {
                return new CSVImporter(importOptions);
            }
            if (importOptions.getFileOptions().getType().equals("ASC")) {
                return new ASCIIImporter(importOptions);
            }
        } else if (importOptions.getFileOptions().getDataFile() != null) {
            if (importOptions.getFileOptions().getDataFile().toUpperCase().endsWith("ARX")) {
                return new ARXImporter(importOptions);
            }
            if (importOptions.getFileOptions().getDataFile().toUpperCase().endsWith("XML")) {
                return new ARXMLImporter(importOptions);
            }
            if (importOptions.getFileOptions().getDataFile().toUpperCase().endsWith("CSV")) {
                return new CSVImporter(importOptions);
            }
            if (importOptions.getFileOptions().getDataFile().toUpperCase().endsWith("ASC")) {
                return new ASCIIImporter(importOptions);
            }
        }
        this.case.error((Object)MessageFormat.format(ImportErrors.DATA_FILE_NOT_EXISTS.toDefMsg(), importOptions.getFileOptions().getDataFile()));
        return null;
    }

    public ImportOptions parseCommandLine(String[] stringArray) throws ARException, ARImportException, NumberFormatException {
        Global global;
        Object object;
        String string;
        ImportOptions importOptions = new ImportOptions();
        int n = 3;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        int n2 = 0;
        int n3 = 0;
        String string12 = null;
        String string13 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string14;
            string = stringArray[i];
            if (string.equals("-threads")) {
                String string15 = stringArray[++i];
                this.setPoolSize(Integer.parseInt(string15));
                continue;
            }
            if (string.equals("-z")) {
                this.byte = stringArray[++i];
                importOptions.setMultiThreaded(true);
                continue;
            }
            if (string.equals("-og")) {
                string11 = stringArray[++i];
                importOptions.setOverlayGroup(string11);
                continue;
            }
            if (string.equals("-filelist")) {
                String[] stringArray2 = stringArray[++i].split(",");
                ArrayList<String> arrayList = new ArrayList<String>(stringArray2.length);
                for (String string16 : stringArray2) {
                    arrayList.add(string16.trim());
                }
                importOptions.setFileList(arrayList);
                continue;
            }
            if (string.equals("-pattern")) {
                importOptions.setFilePattern(stringArray[++i]);
                continue;
            }
            if (string.equals("-custom")) {
                string5 = stringArray[++i];
                continue;
            }
            if (string.equals("-x")) {
                string7 = stringArray[++i];
                continue;
            }
            if (string.equals("-u")) {
                string9 = stringArray[++i];
                continue;
            }
            if (string.equals("-p")) {
                string10 = stringArray[++i];
                continue;
            }
            if (string.equals("-d")) {
                string2 = stringArray[++i];
                continue;
            }
            if (string.equals("-m")) {
                string3 = stringArray[++i];
                continue;
            }
            if (string.equals("-l")) {
                importOptions.setLogFile(stringArray[++i]);
                continue;
            }
            if (string.equals("-f")) {
                String string17;
                int n4;
                if ((n4 = (string17 = stringArray[++i]).indexOf(do)) < 0) {
                    importOptions.getFormMap().put("ARImport_Data_Holder", string17.substring(0, string17.length()));
                    continue;
                }
                object = string17.substring(1, n4);
                String string18 = string17.substring(n4 + do.length(), string17.length() - 1);
                importOptions.getFormMap().put(string18, (String)object);
                continue;
            }
            if (string.equals("-o")) {
                string8 = stringArray[++i];
                importOptions.getFileOptions().setDataFile(string8);
                importOptions.setMultiThreaded(new File(string8).isDirectory());
                if (importOptions.getFileOptions().getType() != null) continue;
                if (string8.toUpperCase().endsWith("ARX")) {
                    importOptions.getFileOptions().setType("ARX");
                    string13 = "ARX";
                    continue;
                }
                if (string8.toUpperCase().endsWith("XML")) {
                    importOptions.getFileOptions().setType("XML");
                    string13 = "XML";
                    continue;
                }
                if (string8.toUpperCase().endsWith("CSV")) {
                    importOptions.getFileOptions().setType("CSV");
                    string13 = "CSV";
                    continue;
                }
                if (!string8.toUpperCase().endsWith("ASC")) continue;
                importOptions.getFileOptions().setType("ASC");
                string13 = "ASC";
                continue;
            }
            if (string.equals("-M")) {
                string4 = stringArray[++i];
                continue;
            }
            if (string.equals("-D")) {
                int n5 = Integer.parseInt(stringArray[++i]);
                importOptions.getDataOptions().setDuplicateIdHandling(DataOptions.DuplicateHandling.fromARMValue(n5));
                continue;
            }
            if (string.equals("-a")) {
                n2 = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (string.equals("-r")) {
                n3 = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (string.equals("-e")) {
                String string19;
                if ((string19 = stringArray[++i]) == null || string19.trim().length() <= 0) continue;
                if (!string19.contains(";") && !string19.contains("=")) {
                    String[] stringArray3 = string19.split(",");
                    object = new ArrayList(stringArray3.length);
                    for (String string20 : stringArray3) {
                        int n6 = Integer.parseInt(string20.trim());
                        object.add(n6);
                    }
                    importOptions.getDataOptions().setDuplicateFields((List<Integer>)object);
                    continue;
                }
                importOptions.getDataOptions().setMultiDuplicateFields(string19);
                continue;
            }
            if (string.equals("-n")) {
                importOptions.getDataOptions().setSuppressFilters(true);
                continue;
            }
            if (string.equals("-v")) {
                importOptions.getContext().setOverridePrevIP(true);
                continue;
            }
            if (string.equals("-t")) {
                int n7 = Integer.parseInt(stringArray[++i]);
                importOptions.getDataOptions().setMultiMatch(DataOptions.MultiMatch.fromARMValue(n7));
                continue;
            }
            if (string.equals("-w")) {
                string12 = stringArray[++i];
                continue;
            }
            if (string.equals("-q")) {
                String string21 = stringArray[++i];
                boolean bl = false;
                if (string21.equalsIgnoreCase("1")) {
                    bl = true;
                }
                importOptions.getDataOptions().setDisableRequired(bl);
                continue;
            }
            if (string.equals("-c")) {
                String string22 = stringArray[++i];
                boolean bl = false;
                if (string22.equalsIgnoreCase("1")) {
                    bl = true;
                }
                importOptions.getDataOptions().setTruncate(bl);
                continue;
            }
            if (string.equals("-h")) {
                String string23 = stringArray[++i];
                boolean bl = false;
                if (string23.equalsIgnoreCase("1")) {
                    bl = true;
                }
                importOptions.getDataOptions().setDisablePattern(bl);
                continue;
            }
            if (string.equals("-i")) {
                String string24 = stringArray[++i];
                boolean bl = false;
                if (string24.equalsIgnoreCase("1")) {
                    bl = true;
                }
                importOptions.getDataOptions().setSuppressDefaults(bl);
                continue;
            }
            if (string.equals("-charset")) {
                string6 = stringArray[++i];
                importOptions.getFileOptions().setCharSet(string6);
                continue;
            }
            if (string.equals("-b")) {
                int n8 = Integer.parseInt(stringArray[++i]);
                importOptions.getDataOptions().setTransactionSize(n8);
                continue;
            }
            if (string.equals("-debug")) {
                try {
                    n = Integer.parseInt(stringArray[++i]);
                }
                catch (Exception exception) {
                    n = 3;
                }
                importOptions.setLogLevel(n);
                continue;
            }
            if (string.equals("-g")) {
                String string25;
                if (!(string25 = stringArray[++i]).equalsIgnoreCase("1")) continue;
                importOptions.getDataOptions().setForceBulk(true);
                continue;
            }
            if (!string.equals("-Q") || !(string14 = stringArray[++i].trim()).equalsIgnoreCase("1")) continue;
            importOptions.getDataOptions().setAllowNull(true);
        }
        if (importOptions.getLogLevelInt() < this.getDebugLogLevel()) {
            importOptions.setLogLevel(this.getDebugLogLevel());
        }
        Exception exception = null;
        string = null;
        if (this.byte != null && this.byte.trim().length() > 0) {
            File file = new File(this.byte);
            if (file.exists()) {
                try {
                    JAXBHandler jAXBHandler = new JAXBHandler("com.bmc.arsys.apiext.data.jaxb.options");
                    object = new File(this.byte);
                    this.int = (Import)jAXBHandler.readXML((File)object);
                }
                catch (Exception exception2) {
                    exception = exception2;
                }
            } else {
                string = MessageFormat.format(ImportErrors.OPTIONS_FILE_NOT_EXISTS.toDefMsg(), this.byte);
            }
        }
        if (this.int != null && (global = this.int.getGlobal()) != null) {
            List<Parameter> list = global.getParameter();
            importOptions = this.populateOptions(importOptions, list, true);
        }
        this.initLogging(importOptions.getLogFile(), importOptions.getLogLevel());
        importOptions.getLoggersList().put(importOptions.getLogFile(), this.case);
        if (exception != null) {
            this.case.error((Object)MessageFormat.format(ImportErrors.ERROR_PARSING_OPTIONS_XML_FILE.toDefMsg(), exception.getMessage() == null ? exception.getCause() : exception.getMessage()), (Throwable)exception);
            throw new ARImportException(exception);
        }
        if (string != null) {
            this.case.error((Object)string);
            throw new ARImportException(string);
        }
        importOptions = this.a(importOptions, string4, string8, string3, string2, string13);
        importOptions = this.a(importOptions, string5);
        if (string7 != null) {
            importOptions.getContext().setServer(string7);
        }
        if (string12 != null) {
            importOptions.getContext().setAuthentication(string12);
        }
        if (string9 != null) {
            importOptions.getContext().setUser(string9);
        }
        if (string10 != null) {
            importOptions.getContext().setPassword(string10);
        }
        if (n2 != 0) {
            importOptions.getContext().setPort(n2);
        }
        if (n3 != 0) {
            importOptions.getContext().usePrivateRpcQueue(n3);
        }
        if (string11 != null) {
            importOptions.getContext().setOverlayGroup(string11);
        }
        return importOptions;
    }

    public ImportOptions populateOptions(ImportOptions importOptions, List<Parameter> list, boolean bl) throws ARException, ARImportException, NumberFormatException {
        Object object;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        int n = 0;
        int n2 = 0;
        String string11 = null;
        String string12 = null;
        for (Parameter parameter : list) {
            String string13;
            Object object2;
            String string14 = parameter.getName();
            if (string14.equals("threads") && bl) {
                String string15 = parameter.getValue();
                this.setPoolSize(Integer.parseInt(string15));
                continue;
            }
            if (string14.equals("og")) {
                string10 = parameter.getValue();
                importOptions.setOverlayGroup(string10);
                continue;
            }
            if (string14.equals("filelist")) {
                String[] stringArray = parameter.getValue().split(",");
                ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
                for (String string16 : stringArray) {
                    arrayList.add(string16.trim());
                }
                importOptions.setFileList(arrayList);
                continue;
            }
            if (string14.equals("pattern")) {
                importOptions.setFilePattern(parameter.getValue());
                continue;
            }
            if (string14.equals("custom")) {
                string4 = parameter.getValue();
                continue;
            }
            if (string14.equals("x")) {
                string6 = parameter.getValue();
                continue;
            }
            if (string14.equals("u")) {
                string8 = parameter.getValue();
                continue;
            }
            if (string14.equals("p")) {
                string9 = parameter.getValue();
                continue;
            }
            if (string14.equals("d")) {
                string = parameter.getValue();
                continue;
            }
            if (string14.equals("m")) {
                string2 = parameter.getValue();
                continue;
            }
            if (string14.equals("l")) {
                importOptions.setLogFile(parameter.getValue());
                continue;
            }
            if (string14.equals("f")) {
                String string17 = parameter.getValue();
                int n3 = string17.indexOf(do);
                if (n3 < 0) {
                    importOptions.getFormMap().put("ARImport_Data_Holder", string17.substring(0, string17.length()));
                    continue;
                }
                object2 = string17.substring(1, n3);
                String string18 = string17.substring(n3 + do.length(), string17.length() - 1);
                importOptions.getFormMap().put(string18, (String)object2);
                continue;
            }
            if (string14.equals("o")) {
                string7 = parameter.getValue().trim();
                String string19 = importOptions.getFileOptions().getDataFile();
                if (string19 != null && string19.length() > 0) {
                    string7 = string19.trim() + System.getProperty("file.separator") + string7;
                }
                importOptions.getFileOptions().setDataFile(string7);
                importOptions.setMultiThreaded(new File(string7).isDirectory());
                if (importOptions.getFileOptions().getType() != null) continue;
                if (string7.toUpperCase().endsWith("ARX")) {
                    importOptions.getFileOptions().setType("ARX");
                    string12 = "ARX";
                    continue;
                }
                if (string7.toUpperCase().endsWith("XML")) {
                    importOptions.getFileOptions().setType("XML");
                    string12 = "XML";
                    continue;
                }
                if (string7.toUpperCase().endsWith("CSV")) {
                    importOptions.getFileOptions().setType("CSV");
                    string12 = "CSV";
                    continue;
                }
                if (!string7.toUpperCase().endsWith("ASC")) continue;
                importOptions.getFileOptions().setType("ASC");
                string12 = "ASC";
                continue;
            }
            if (string14.equals("M")) {
                string3 = parameter.getValue();
                continue;
            }
            if (string14.equals("D")) {
                int n4 = Integer.parseInt(parameter.getValue());
                importOptions.getDataOptions().setDuplicateIdHandling(DataOptions.DuplicateHandling.fromARMValue(n4));
                continue;
            }
            if (string14.equals("a")) {
                n = Integer.parseInt(parameter.getValue());
                continue;
            }
            if (string14.equals("r")) {
                n2 = Integer.parseInt(parameter.getValue());
                continue;
            }
            if (string14.equals("e")) {
                String string20 = parameter.getValue();
                if (!string20.contains(";") && !string20.contains("=")) {
                    String[] stringArray = string20.split(",");
                    object2 = new ArrayList(stringArray.length);
                    for (String string21 : stringArray) {
                        int n5 = Integer.parseInt(string21.trim());
                        object2.add(n5);
                    }
                    importOptions.getDataOptions().setDuplicateFields((List<Integer>)object2);
                    continue;
                }
                importOptions.getDataOptions().setMultiDuplicateFields(string20);
                continue;
            }
            if (string14.equals("n")) {
                importOptions.getDataOptions().setSuppressFilters(true);
                continue;
            }
            if (string14.equals("v")) {
                importOptions.getContext().setOverridePrevIP(true);
                continue;
            }
            if (string14.equals("t")) {
                int n6 = Integer.parseInt(parameter.getValue());
                importOptions.getDataOptions().setMultiMatch(DataOptions.MultiMatch.fromARMValue(n6));
                continue;
            }
            if (string14.equals("w")) {
                string11 = parameter.getValue();
                continue;
            }
            if (string14.equals("q")) {
                String string22 = parameter.getValue();
                boolean bl2 = false;
                if (string22.equalsIgnoreCase("1")) {
                    bl2 = true;
                }
                importOptions.getDataOptions().setDisableRequired(bl2);
                continue;
            }
            if (string14.equals("c")) {
                String string23 = parameter.getValue();
                boolean bl3 = false;
                if (string23.equalsIgnoreCase("1")) {
                    bl3 = true;
                }
                importOptions.getDataOptions().setTruncate(bl3);
                continue;
            }
            if (string14.equals("h")) {
                String string24 = parameter.getValue();
                boolean bl4 = false;
                if (string24.equalsIgnoreCase("1")) {
                    bl4 = true;
                }
                importOptions.getDataOptions().setDisablePattern(bl4);
                continue;
            }
            if (string14.equals("i")) {
                String string25 = parameter.getValue();
                boolean bl5 = false;
                if (string25.equalsIgnoreCase("1")) {
                    bl5 = true;
                }
                importOptions.getDataOptions().setSuppressDefaults(bl5);
                continue;
            }
            if (string14.equals("charset")) {
                string5 = parameter.getValue();
                importOptions.getFileOptions().setCharSet(string5);
                continue;
            }
            if (string14.equals("b")) {
                int n7 = Integer.parseInt(parameter.getValue());
                importOptions.getDataOptions().setTransactionSize(n7);
                continue;
            }
            if (string14.equals("debug") && bl) {
                int n8 = 3;
                try {
                    n8 = Integer.parseInt(parameter.getValue());
                }
                catch (Exception exception) {
                    n8 = 3;
                }
                importOptions.setLogLevel(n8);
                continue;
            }
            if (string14.equals("g")) {
                String string26 = parameter.getValue();
                if (!string26.equalsIgnoreCase("1")) continue;
                importOptions.getDataOptions().setForceBulk(true);
                continue;
            }
            if (!string14.equals("Q") || !(string13 = parameter.getValue()).equalsIgnoreCase("1")) continue;
            importOptions.getDataOptions().setAllowNull(true);
        }
        if (!(bl || importOptions.getLogFile() != null && importOptions.getLogFile().trim().length() != 0 || null != importOptions.getFilePattern() && importOptions.getFilePattern().trim().length() != 0)) {
            object = importOptions.getFileOptions().getDataFile();
            object = ((String)object).substring(((String)object).lastIndexOf(System.getProperty("file.separator")) + 1);
            importOptions.setLogFile(((String)object).substring(0, ((String)object).lastIndexOf(".")) + ".log");
        }
        if (importOptions.getLogFile() != null && importOptions.getLogFile().trim().length() > 0) {
            object = new File(importOptions.getLogFile());
            importOptions.setLogFile(((File)object).getAbsolutePath());
            object = null;
            if (!importOptions.getLoggersList().containsKey(importOptions.getLogFile())) {
                Parameter parameter;
                parameter = this.createLogger(importOptions.getLogFile(), importOptions.getLogLevel(), null);
                importOptions.getLoggersList().put(importOptions.getLogFile(), (Logger)parameter);
            }
        }
        importOptions = this.a(importOptions, string3, string7, string2, string, string12);
        importOptions = this.a(importOptions, string4);
        if (string6 != null) {
            importOptions.getContext().setServer(string6);
        }
        if (string11 != null) {
            importOptions.getContext().setAuthentication(string11);
        }
        if (string8 != null) {
            importOptions.getContext().setUser(string8);
        }
        if (string9 != null) {
            importOptions.getContext().setPassword(string9);
        }
        if (n != 0) {
            importOptions.getContext().setPort(n);
        }
        if (n2 != 0) {
            importOptions.getContext().usePrivateRpcQueue(n2);
        }
        if (string10 != null) {
            importOptions.getContext().setOverlayGroup(string10);
        }
        return importOptions;
    }

    private ImportOptions a(ImportOptions importOptions, String string) throws ARImportException {
        if (string != null && string.length() > 0) {
            try {
                CustomXMLParser customXMLParser = new CustomXMLParser(importOptions);
                customXMLParser.parseFile(string);
            }
            catch (Exception exception) {
                this.case.warn((Object)MessageFormat.format(ImportErrors.CUSTOM_FILE_NOT_PARSED.toDefMsg(), string, exception), (Throwable)exception);
                throw new ARImportException(exception);
            }
        }
        return importOptions;
    }

    private ImportOptions a(ImportOptions importOptions, String string, String string2, String string3, String string4, String string5) throws ARImportException {
        if (string == null && string3 != null) {
            try {
                string = Util.findMappingFile(string4, string3, importOptions.getFileOptions().getCharSet());
            }
            catch (IOException iOException) {
                this.case.warn((Object)ImportErrors.EXCEPTION_ON_MAPPING_FILE.toDefMsg(), (Throwable)iOException);
            }
        }
        if (string != null && string.length() > 0) {
            try {
                IParser iParser;
                if (string.toUpperCase().endsWith(".ARM")) {
                    iParser = new ARMParser(importOptions);
                    ((ARMParser)iParser).populateFromARM(importOptions, string, importOptions.getFileOptions().getCharSet());
                    if (string2 != null) {
                        importOptions.getFileOptions().setDataFile(string2);
                    }
                    if (string5 != null) {
                        importOptions.getFileOptions().setType(string5);
                    }
                }
                if (string.toUpperCase().endsWith(".ARMX")) {
                    iParser = new ARMXMLParser(importOptions);
                    ((ARMXMLParser)iParser).parseFile(string);
                    if (string2 != null) {
                        importOptions.getFileOptions().setDataFile(string2);
                    }
                    if (string5 != null) {
                        importOptions.getFileOptions().setType(string5);
                    }
                }
            }
            catch (Exception exception) {
                this.case.error((Object)MessageFormat.format(ImportErrors.PARSE_MAP_FILE_FAILED.toDefMsg(), string));
                this.case.error((Object)ImportErrors.MAPPING_FILE_NOT_PARSED.toDefMsg(), (Throwable)exception);
                throw new ARImportException(exception);
            }
        }
        return importOptions;
    }

    protected void printUsage() {
        System.out.println("Command Line Options:");
        System.out.println("    -u <user>          : Required login parameter that identifies the user account. ");
        System.out.println("    -p <password>      : Optional login parameter that identifies the password. Omit the option if the user account has no password.");
        System.out.println("    -x <servername>    : Login parameter that specifies the server to log in to. This option overrides the server specified in the mapping. If this option is not specified, the server name in the mapping is used.");
        System.out.println("    -w <authenticator> : Name of an external authentication string or Windows NT domain. This is related to the Login window Authentication field, which is discussed in the Configuring guide.");
        System.out.println("    -r <programnumber> : RPC program number. Private server, for example, if a dedicated import server is available. If not specified, the default is the admin server 390600.");
        System.out.println("    -a <tcpport>       : TCP port number. Port number for the server. This value is especially important in a multiple server environment. The option also identifies a TCP specific port, if chosen.");
        System.out.println("    -l <logfile>       : Full path name of the log file. Use this option to log details of the import execution.");
        System.out.println("    -e <fieldids>      : Duplicate fields. IDs of the fields to check for duplicate data. For example, for the Short Description field, you would enter the value 8. By default, the Request ID field (field ID 1) is used when -e parameter is omitted. Multiple values can be specified by separatng them with commas (2,4,8)");
        System.out.println("    -n <option>        : Suppress filters. When the system is merging entries on forms, this command instructs arimportcmd to suppress the merge filters.");
        System.out.println("    -t <option>        : Multiple match option. Use when more than one entry matches. Enter a value of 3 to affect the first match, and a value of 5 to affect all matches.");
        System.out.println("    -o <filename>      : Data file name. Name of the file containing data to import. If specified, this option overrides the data file specified in the mapping. If not specified, the data file specified in the mapping is used.");
        System.out.println("    -o <directory>     : To use multithreaded data import tool use this option with directory name. All the files under this directory will be imported. All this data will be imported in the schema provided in the command. If mapping file is provided and data dir contains different types of files like .arx,.csv,.xml and .asc then this mapping file should be same for all these files. ");
        System.out.println("    -f <formnames>     : Destination form name. Name of the form to import into. If specified, this option overrides the form specified in the mapping. If not specified, the form specified in the mapping is used.");
        System.out.println("    -v <option>        : Forces override. If the user has logged in from a different IP address, this option tells the server to use the new IP address of the BMC Remedy Import client and invalidates the old IP address.");
        System.out.println("    -i <option>        : Suppress default values. If specified this option is specified import will ignore the default values of fields if the value in the data file is null or not supplied.");
        System.out.println("    -M <mappingfile>   : Full path name of mapping file. Required fully qualified path name of the mapping file to use.");
        System.out.println("    -D <option>        : Duplicate ID. Defines how to process records that contain request IDs, which duplicate those already in the form. With this option, you must include one of the following numbers:");
        System.out.println("                            0 : Generate new ID for all records");
        System.out.println("                            1 : Reject duplicate records");
        System.out.println("                            2 : Generate new ID for duplicate records");
        System.out.println("                            3 : Replace old record with new record ");
        System.out.println("                            4 : Update old record with new records data (the default)");
        System.out.println("    -q <option>        : Suppresses the required field property for non core fields.");
        System.out.println("    -c <option>        : Truncates character values longer than the field length for character fields.");
        System.out.println("    -h <option>        : Suppresses pattern matching for fields. If supplied the $PATTERN$ field limit is ignored");
        System.out.println("    -charset <name>    : Specifies the character set used in the data file. The character set name must be supplied as listed in the IANA Charset Registry");
        System.out.println("    -b <option>        : Sets the transaction size to use.");
        System.out.println("    -threads <PoolSize>: Sets the Maximum Thread Pool size. This is optional parameter, if not specified then it is set to default value 50");
        System.out.println("    -filelist <files>  : Comma separated list of files(report.arx,test.csv,data.xml). When -o option is data directory then only this option can be used else this is of no use. This is optional and takes precedence over -pattern.");
        System.out.println("    -pattern <string>  : Specifies a pattern for matching file names and import them using multiple threads. When -o option is data directory then only this option can be used else this is of no use. This is optional. ");
        System.out.println("    -custom            : Full path name of the XML file containing user-defined custom options for handling date/time values and real numbers. This is optional.");
        System.out.println("    -z                 : Full path name of the options XML file which contains data import commands with its own Data/File(Import) options. This is optional.");
        System.out.println("    -g <option>        : Forces the bulk transaction to be used with -e option, for which it is switched off by default. This is optional and a value of 1 means enabled.");
        System.out.println("    -og <OverlayGroup> : Sets the Overlay Group. This is optional parameter, if not specified then it is set to default(No overlay group)");
        System.out.println("    -Q <option>   \t : Fall back to old behavior of Data Import Tool(Default is false i.e. 0)");
        System.out.println("");
        System.out.println("Usage - WITH MAPPING FILE: arimportcmd -x server -u user -p password -M mappingfile -o datafile -f targetform -e duplicatefield -n suppressfilters -t multimatchoption -l logfile -a portnumber -r rpcprogNum -w AuthenticationServer -i suppressdefaultvalues");
        System.out.println("    Values for Username and Password are required.");
        System.out.println("");
        System.out.println("Usage - WITHOUT MAPPING FILE: arimportcmd -x server -u user -p password -o datafile -f \"targetform=fileform\" -e duplicatefield -n suppressfilters -t multimatchoption -l logfile -a portnumber -r rpcprogNum -D DupId -w AuthenticationServer -i suppressdefaultvalues");
        System.out.println("    Values for Username, Password, Server, Datafile  are required.");
        System.out.println("");
        System.out.println("Usage - Multi Threaded Data Import WITH MAPPING FILE: arimportcmd -x server -u user -p password -M mappingfile -o datadir -f \"targetform=fileform\" -e duplicatefield -n suppressfilters -t multimatchoption -l logfile -a portnumber -r rpcprogNum -D DupId -w AuthenticationServer -i suppressdefaultvalues -threads poolSize -filelist files");
        System.out.println("    Values for Username, Password, Datadir  are required. Mapping file should be same for all the data files inside datadir");
        System.out.println("");
        System.out.println("Usage - Multi Threaded Data Import WITHOUT MAPPING FILE: arimportcmd -x server -u user -p password -o datadir -f \"targetform=fileform\" -e duplicatefield -n suppressfilters -t multimatchoption -l logfile -a portnumber -r rpcprogNum -D DupId -w AuthenticationServer -i suppressdefaultvalues -threads poolSize -filelist files");
        System.out.println("    Values for Username, Password, Server, Datadir  are required.");
    }

    public ImportOptions getOptions() {
        return this.else;
    }

    public void setOptions(ImportOptions importOptions) {
        this.else = importOptions;
    }

    protected void initLogging(String string, Level level) {
        Object object;
        this.case.setLevel(level);
        PatternLayout patternLayout = null;
        patternLayout = level.toInt() < Level.DEBUG.toInt() ? new PatternLayout("%d{[EEE MMM dd HH:mm:ss.SSS]} %-5p [%t] %C (%F:%L) - %m%n") : new PatternLayout("%d{[EEE MMM dd HH:mm:ss.SSS]} %-5p - %m%n");
        if (string != null && string.length() > 0) {
            try {
                FileAppender fileAppender = null;
                try {
                    fileAppender = this.commandLine ? new FileAppender((Layout)patternLayout, string, false) : new FileAppender((Layout)patternLayout, string, true);
                }
                catch (IOException iOException) {
                    object = new ConsoleAppender((Layout)patternLayout);
                    this.case.addAppender((Appender)object);
                    this.case.info((Object)"Unable to create specified log file, import will continue");
                    this.case.removeAllAppenders();
                    this.case.setLevel(Level.OFF);
                }
                if (fileAppender != null) {
                    fileAppender.setName("ARIMPORT_FILE_APPENDER");
                    fileAppender.setAppend(true);
                    Util.getInstance().setFileAppender(fileAppender);
                    this.case.removeAllAppenders();
                    this.case.addAppender((Appender)fileAppender);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (!this.commandLine) {
            this.importToolEntryTime = new Date();
            boolean bl = true;
            Enumeration enumeration = Logger.getRootLogger().getAllAppenders();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (!(object instanceof ConsoleAppender)) continue;
                bl = false;
                break;
            }
            if (bl) {
                enumeration = null;
                object = LogManager.getLoggerRepository().getCurrentLoggers();
                if (object != null) {
                    block5: while (object.hasMoreElements()) {
                        Logger logger = (Logger)object.nextElement();
                        enumeration = logger.getAllAppenders();
                        while (enumeration.hasMoreElements()) {
                            Object e = enumeration.nextElement();
                            if (!(e instanceof ConsoleAppender)) continue;
                            ((ConsoleAppender)e).setThreshold((Priority)Level.OFF);
                            bl = false;
                            continue block5;
                        }
                    }
                }
            }
            if (bl) {
                this.case.addAppender((Appender)new ConsoleAppender((Layout)patternLayout));
            }
        }
        this.setLogInitialized(true);
        this.case.info((Object)("AR System Import Tool 7.6.04 build002 " + this.simpleDateFormater.format(this.importToolEntryTime)));
    }

    public void addParseListener(IParseListener iParseListener) {
        if (this.char == null) {
            this.char = new HashSet<IParseListener>();
        }
        this.char.add(iParseListener);
    }

    public void removeParseListener(IParseListener iParseListener) {
        if (this.char != null) {
            this.char.remove(iParseListener);
        }
    }

    public void clearParseListeners() {
        if (this.char != null) {
            this.char.clear();
        }
    }

    public Set<IParseListener> getParseListeners() {
        return this.char;
    }

    public void validateOptions() throws ARImportException {
        File file;
        if (!this.else.isMultiThreaded() && this.getOptions().getFileOptions().getDataFile() == null) {
            throw new ARImportException(ImportErrors.DATA_FILE_NOT_AVAILABLE.toDefMsg());
        }
        if (!this.else.isMultiThreaded() && this.getOptions().getFileOptions().getDataFile().length() == 0) {
            throw new ARImportException(ImportErrors.DATA_FILE_NOT_AVAILABLE.toDefMsg());
        }
        if (!(this.else.isMultiThreaded() || (file = new File(this.getOptions().getFileOptions().getDataFile())).exists() && file.exists())) {
            throw new ARImportException(MessageFormat.format(ImportErrors.DATA_FILE_NOT_EXISTS.toDefMsg(), this.getOptions().getFileOptions().getDataFile()));
        }
        if (!this.else.isMultiThreaded() && this.getOptions().getFileOptions().getType() == null) {
            throw new ARImportException(MessageFormat.format(ImportErrors.UNKNOWN_DATA_FILE.toDefMsg(), this.getOptions().getFileOptions().getDataFile()));
        }
        if (this.getOptions().getContext().getServer() == null || this.getOptions().getContext().getServer().length() == 0) {
            throw new ARImportException(ImportErrors.SERVER_NOT_SPECIFIED.toDefMsg());
        }
        if (this.getOptions().getContext().getUser() == null || this.getOptions().getContext().getUser().length() == 0) {
            throw new ARImportException(ImportErrors.USER_NOT_SPECIFIED.toDefMsg());
        }
    }

    public Logger createLogger(String string, Level level, PatternLayout patternLayout) {
        if (string == null || string.length() < 0) {
            return null;
        }
        Logger logger = Logger.getLogger((String)string);
        logger.setLevel(level);
        if (patternLayout == null) {
            patternLayout = level.toInt() < Level.DEBUG.toInt() ? new PatternLayout("%d{[EEE MMM dd HH:mm:ss.SSS]} %-5p [%t] %C (%F:%L) - %m%n") : new PatternLayout("%d{[EEE MMM dd HH:mm:ss.SSS]} %-5p - %m%n");
        }
        if (string != null && string.length() > 0) {
            try {
                FileAppender fileAppender = new FileAppender((Layout)patternLayout, string, false);
                fileAppender.setName("ARIMPORT_FILE_APPENDER");
                fileAppender.setAppend(true);
                Util.getInstance().setFileAppender(fileAppender);
                logger.removeAllAppenders();
                logger.addAppender((Appender)fileAppender);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        logger.info((Object)("AR System Import Tool 7.6.04 build002 " + this.simpleDateFormater.format(new Date())));
        return logger;
    }

    class ASCIIFilter
    implements FilenameFilter {
        ASCIIFilter() {
        }

        public boolean accept(File file, String string) {
            return string.toLowerCase().endsWith(".asc");
        }
    }

    class XMLFilter
    implements FilenameFilter {
        XMLFilter() {
        }

        public boolean accept(File file, String string) {
            return string.toLowerCase().endsWith(".xml");
        }
    }

    class CSVFilter
    implements FilenameFilter {
        CSVFilter() {
        }

        public boolean accept(File file, String string) {
            return string.toLowerCase().endsWith(".csv");
        }
    }

    class ARXFilter
    implements FilenameFilter {
        ARXFilter() {
        }

        public boolean accept(File file, String string) {
            return string.toLowerCase().endsWith(".arx");
        }
    }

    class PatternFilter
    implements FilenameFilter {
        String filePattern = null;

        public PatternFilter(String string) {
            this.filePattern = string;
        }

        public boolean accept(File file, String string) {
            return Pattern.matches(this.filePattern, string);
        }
    }
}

