/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.orm.jpa.support;

import com.bmc.thirdparty.org.springframework.dao.DataAccessException;
import com.bmc.thirdparty.org.springframework.dao.DataAccessResourceFailureException;
import com.bmc.thirdparty.org.springframework.orm.jpa.EntityManagerFactoryAccessor;
import com.bmc.thirdparty.org.springframework.orm.jpa.EntityManagerHolder;
import com.bmc.thirdparty.org.springframework.transaction.support.TransactionSynchronizationManager;
import com.bmc.thirdparty.org.springframework.ui.ModelMap;
import com.bmc.thirdparty.org.springframework.web.context.request.WebRequest;
import com.bmc.thirdparty.org.springframework.web.context.request.WebRequestInterceptor;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;

public class OpenEntityManagerInViewInterceptor
extends EntityManagerFactoryAccessor
implements WebRequestInterceptor {
    public static final String PARTICIPATE_SUFFIX = ".PARTICIPATE";

    public void preHandle(WebRequest request) throws DataAccessException {
        if (TransactionSynchronizationManager.hasResource(this.getEntityManagerFactory())) {
            String participateAttributeName = this.getParticipateAttributeName();
            Integer count = (Integer)request.getAttribute(participateAttributeName, 0);
            int newCount = count != null ? count + 1 : 1;
            request.setAttribute(this.getParticipateAttributeName(), new Integer(newCount), 0);
        } else {
            this.logger.debug("Opening JPA EntityManager in OpenEntityManagerInViewInterceptor");
            try {
                EntityManager em = this.createEntityManager();
                TransactionSynchronizationManager.bindResource(this.getEntityManagerFactory(), new EntityManagerHolder(em));
            }
            catch (PersistenceException ex) {
                throw new DataAccessResourceFailureException("Could not create JPA EntityManager", ex);
            }
        }
    }

    public void postHandle(WebRequest request, ModelMap model) {
    }

    public void afterCompletion(WebRequest request, Exception ex) throws DataAccessException {
        String participateAttributeName = this.getParticipateAttributeName();
        Integer count = (Integer)request.getAttribute(participateAttributeName, 0);
        if (count != null) {
            if (count > 1) {
                request.setAttribute(participateAttributeName, new Integer(count - 1), 0);
            } else {
                request.removeAttribute(participateAttributeName, 0);
            }
        } else {
            EntityManagerHolder emHolder = (EntityManagerHolder)TransactionSynchronizationManager.unbindResource(this.getEntityManagerFactory());
            this.logger.debug("Closing JPA EntityManager in OpenEntityManagerInViewInterceptor");
            emHolder.getEntityManager().close();
        }
    }

    protected String getParticipateAttributeName() {
        return this.getEntityManagerFactory().toString() + PARTICIPATE_SUFFIX;
    }
}

