/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.core.io;

import com.bmc.thirdparty.org.springframework.core.io.DefaultResourceLoader;
import com.bmc.thirdparty.org.springframework.core.io.Resource;
import com.bmc.thirdparty.org.springframework.core.io.ResourceLoader;
import com.bmc.thirdparty.org.springframework.util.Assert;
import com.bmc.thirdparty.org.springframework.util.StringUtils;
import com.bmc.thirdparty.org.springframework.util.SystemPropertyUtils;
import java.beans.PropertyEditorSupport;
import java.io.IOException;

public class ResourceEditor
extends PropertyEditorSupport {
    private final ResourceLoader resourceLoader;

    public ResourceEditor() {
        this(new DefaultResourceLoader());
    }

    public ResourceEditor(ResourceLoader resourceLoader) {
        Assert.notNull(resourceLoader, "The 'resourceLoader' parameter cannot be null.");
        this.resourceLoader = resourceLoader;
    }

    public void setAsText(String text) {
        if (StringUtils.hasText(text)) {
            String locationToUse = this.resolvePath(text).trim();
            this.setValue(this.resourceLoader.getResource(locationToUse));
        } else {
            this.setValue(null);
        }
    }

    protected String resolvePath(String path) {
        return SystemPropertyUtils.resolvePlaceholders(path);
    }

    public String getAsText() {
        Resource value = (Resource)this.getValue();
        try {
            return value != null ? value.getURL().toExternalForm() : "";
        }
        catch (IOException ex) {
            return null;
        }
    }
}

