/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.beans.support;

import com.bmc.thirdparty.org.springframework.beans.BeanWrapperImpl;
import com.bmc.thirdparty.org.springframework.beans.PropertyEditorRegistry;
import com.bmc.thirdparty.org.springframework.beans.TypeConverter;
import com.bmc.thirdparty.org.springframework.beans.TypeMismatchException;
import com.bmc.thirdparty.org.springframework.util.ClassUtils;
import com.bmc.thirdparty.org.springframework.util.MethodInvoker;
import java.beans.PropertyEditor;
import java.lang.reflect.Method;

public class ArgumentConvertingMethodInvoker
extends MethodInvoker {
    private TypeConverter typeConverter = new BeanWrapperImpl();

    public void setTypeConverter(TypeConverter typeConverter) {
        this.typeConverter = typeConverter;
    }

    public TypeConverter getTypeConverter() {
        return this.typeConverter;
    }

    public void registerCustomEditor(Class requiredType, PropertyEditor propertyEditor) {
        if (!(this.typeConverter instanceof PropertyEditorRegistry)) {
            throw new IllegalStateException("TypeConverter does not implement PropertyEditorRegistry interface: " + this.typeConverter);
        }
        ((PropertyEditorRegistry)((Object)this.typeConverter)).registerCustomEditor(requiredType, propertyEditor);
    }

    protected Method findMatchingMethod() {
        Class<?>[] paramTypes;
        int i2;
        Method[] candidates = this.getTargetClass().getMethods();
        Object[] arguments = this.getArguments();
        int argCount = arguments.length;
        for (i2 = 0; i2 < candidates.length; ++i2) {
            if (!candidates[i2].getName().equals(this.getTargetMethod()) || (paramTypes = candidates[i2].getParameterTypes()).length != argCount) continue;
            int numberOfCorrectArguments = 0;
            for (int j2 = 0; j2 < argCount; ++j2) {
                if (!ClassUtils.isAssignableValue(paramTypes[j2], arguments[j2])) continue;
                ++numberOfCorrectArguments;
            }
            if (numberOfCorrectArguments != argCount) continue;
            return candidates[i2];
        }
        if (this.typeConverter != null) {
            for (i2 = 0; i2 < candidates.length; ++i2) {
                if (!candidates[i2].getName().equals(this.getTargetMethod()) || (paramTypes = candidates[i2].getParameterTypes()).length != argCount) continue;
                Object[] argumentsToUse = new Object[argCount];
                int numberOfCorrectArguments = 0;
                for (int j3 = 0; j3 < argCount; ++j3) {
                    try {
                        argumentsToUse[j3] = this.typeConverter.convertIfNecessary(arguments[j3], paramTypes[j3]);
                        ++numberOfCorrectArguments;
                        continue;
                    }
                    catch (TypeMismatchException ex) {
                        // empty catch block
                    }
                }
                if (numberOfCorrectArguments != argumentsToUse.length) continue;
                this.setArguments(argumentsToUse);
                return candidates[i2];
            }
        }
        return null;
    }
}

