/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.beans.factory.xml;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.beans.FatalBeanException;
import com.bmc.thirdparty.org.springframework.core.io.ClassPathResource;
import com.bmc.thirdparty.org.springframework.core.io.support.PropertiesLoaderUtils;
import com.bmc.thirdparty.org.springframework.util.Assert;
import java.io.IOException;
import java.util.Properties;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class PluggableSchemaResolver
implements EntityResolver {
    public static final String DEFAULT_SCHEMA_MAPPINGS_LOCATION = "META-INF/spring.schemas";
    private final Log logger = LogFactory.getLog(this.getClass());
    private final ClassLoader classLoader;
    private final Properties schemaMappings;

    public PluggableSchemaResolver(ClassLoader classLoader) {
        this(classLoader, DEFAULT_SCHEMA_MAPPINGS_LOCATION);
    }

    public PluggableSchemaResolver(ClassLoader classLoader, String schemaMappingsLocation) {
        Assert.notNull(classLoader, "ClassLoader must not be null");
        Assert.hasText(schemaMappingsLocation, "Schema mappings location must not be empty");
        this.classLoader = classLoader;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Loading schema mappings from [" + schemaMappingsLocation + "].");
        }
        try {
            this.schemaMappings = PropertiesLoaderUtils.loadAllProperties(schemaMappingsLocation, classLoader);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Loaded schema mappings: " + this.schemaMappings);
            }
        }
        catch (IOException e2) {
            throw new FatalBeanException("Unable to load schema mappings from location [" + schemaMappingsLocation + "].", e2);
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws IOException {
        String resourceLocation;
        if (systemId != null && (resourceLocation = this.schemaMappings.getProperty(systemId)) != null) {
            ClassPathResource resource = new ClassPathResource(resourceLocation, this.classLoader);
            InputSource source = new InputSource(resource.getInputStream());
            source.setPublicId(publicId);
            source.setSystemId(systemId);
            return source;
        }
        return null;
    }
}

