/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.AlertCallbackHandler;
import com.bmc.arsys.api.AlertMessageCriteria;
import com.bmc.arsys.api.AlertMessageInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.log4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AlertReceiver {
    private static Logger for = Logger.getLogger(AlertReceiver.class);
    private ServerSocket do = null;
    private int if = 0;
    private Thread int = null;
    private AlertCallbackHandler a;

    public AlertReceiver(AlertCallbackHandler alertCallbackHandler) throws IOException {
        this(alertCallbackHandler, 0);
    }

    public AlertReceiver(AlertCallbackHandler alertCallbackHandler, int n2) throws IOException {
        this.a = alertCallbackHandler;
        this.do = new ServerSocket(n2);
        this.if = this.do.getLocalPort();
    }

    public boolean beginReceive(ARServerUser aRServerUser) throws ARException {
        int n2 = 0;
        aRServerUser.registerForAlerts(this.if, n2);
        for.debug("Server registered for alerts: " + aRServerUser.getServer() + " on port: " + this.if);
        if (this.int == null) {
            this.int = new Thread(new ClientWorker());
            this.int.setPriority(1);
            this.int.start();
        }
        return true;
    }

    public void stopReceive(ARServerUser aRServerUser) throws ARException {
        aRServerUser.deregisterForAlerts(this.if);
        for.debug("Server deregistered for alerts: " + aRServerUser.getServer());
    }

    public void close() throws IOException {
        this.do.close();
    }

    protected void finalize() throws IOException {
        this.close();
    }

    class ClientWorker
    implements Runnable {
        ClientWorker() {
        }

        public void run() {
            Socket socket = null;
            try {
                while (true) {
                    socket = AlertReceiver.this.do.accept();
                    for.debug("New connection accepted " + socket.getInetAddress() + ":" + socket.getPort());
                    AlertMessageInfo alertMessageInfo = this.a(socket);
                    if (alertMessageInfo.getSourceType() != 3) {
                        AlertReceiver.this.a.onAlertRecieved(alertMessageInfo);
                    }
                    socket.close();
                }
            }
            catch (Exception exception) {
                for.error(exception);
                return;
            }
        }

        private AlertMessageInfo a(Socket socket) throws IOException, ARException {
            byte[] byArray = new byte[1024];
            int n2 = 0;
            InputStream inputStream = socket.getInputStream();
            PrintWriter printWriter = new PrintWriter(socket.getOutputStream(), true);
            while ((n2 = inputStream.available()) == 0) {
            }
            n2 = inputStream.read(byArray);
            this.a(printWriter);
            for.debug(" numBytes received is " + n2);
            AlertMessageInfo alertMessageInfo = AlertMessageInfo.DecodeAlertMessage(new AlertMessageCriteria(), byArray, n2);
            for.debug(" AlertSourceType : " + alertMessageInfo.getSourceType());
            for.debug(" AlertText : " + alertMessageInfo.getAlertText());
            for.debug(" from server : " + alertMessageInfo.getServerAddr());
            inputStream.close();
            printWriter.close();
            return alertMessageInfo;
        }

        private void a(PrintWriter printWriter) {
            printWriter.println("ack");
        }
    }
}

