/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.NoSuchElementException;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcPortmapClient;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrDecodingStream;
import org.acplt.oncrpc.XdrEncodingStream;
import org.acplt.oncrpc.server.OncRpcCallInformation;
import org.acplt.oncrpc.server.OncRpcDispatchable;
import org.acplt.oncrpc.server.OncRpcServerReplyMessage;
import org.acplt.oncrpc.server.OncRpcServerTransport;
import org.acplt.oncrpc.server.OncRpcServerTransportRegistrationInfo;
import org.acplt.oncrpc.server.OncRpcTcpConnectionServerTransport;

public class OncRpcTcpServerTransport
extends OncRpcServerTransport {
    private ServerSocket socket;
    private int bufferSize;
    private TransportList openTransports = new TransportList();
    protected int transmissionTimeout = 30000;
    private String characterEncoding = null;

    public OncRpcTcpServerTransport(OncRpcDispatchable oncRpcDispatchable, int n2, int n3, int n4, int n5) throws OncRpcException, IOException {
        this(oncRpcDispatchable, n2, new OncRpcServerTransportRegistrationInfo[]{new OncRpcServerTransportRegistrationInfo(n3, n4)}, n5);
    }

    public OncRpcTcpServerTransport(OncRpcDispatchable oncRpcDispatchable, int n2, OncRpcServerTransportRegistrationInfo[] oncRpcServerTransportRegistrationInfoArray, int n3) throws OncRpcException, IOException {
        this(oncRpcDispatchable, null, n2, oncRpcServerTransportRegistrationInfoArray, n3);
    }

    public OncRpcTcpServerTransport(OncRpcDispatchable oncRpcDispatchable, InetAddress inetAddress, int n2, OncRpcServerTransportRegistrationInfo[] oncRpcServerTransportRegistrationInfoArray, int n3) throws OncRpcException, IOException {
        super(oncRpcDispatchable, n2, oncRpcServerTransportRegistrationInfoArray);
        if (n3 < 1024) {
            n3 = 1024;
        }
        this.bufferSize = n3;
        this.socket = new ServerSocket(n2, 0, inetAddress);
        if (n2 == 0) {
            this.port = this.socket.getLocalPort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object;
        if (this.socket != null) {
            object = this.socket;
            this.socket = null;
            try {
                ((ServerSocket)object).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        object = this.openTransports;
        synchronized (object) {
            while (this.openTransports.size() > 0) {
                OncRpcTcpConnectionServerTransport oncRpcTcpConnectionServerTransport = (OncRpcTcpConnectionServerTransport)this.openTransports.removeFirst();
                oncRpcTcpConnectionServerTransport.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTransport(OncRpcTcpConnectionServerTransport oncRpcTcpConnectionServerTransport) {
        TransportList transportList = this.openTransports;
        synchronized (transportList) {
            this.openTransports.remove(oncRpcTcpConnectionServerTransport);
        }
    }

    public void register() throws OncRpcException {
        try {
            OncRpcPortmapClient oncRpcPortmapClient = new OncRpcPortmapClient(InetAddress.getByName("127.0.0.1"));
            int n2 = this.info.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                oncRpcPortmapClient.setPort(this.info[i2].program, this.info[i2].version, 6, this.port);
            }
        }
        catch (IOException iOException) {
            throw new OncRpcException(16);
        }
    }

    public void retrieveCall(XdrAble xdrAble) throws OncRpcException, IOException {
        throw new Error("OncRpcTcpServerTransport.retrieveCall() is abstract and can not be called.");
    }

    protected XdrDecodingStream getXdrDecodingStream() {
        throw new Error("OncRpcTcpServerTransport.getXdrDecodingStream() is abstract and can not be called.");
    }

    protected void endDecoding() throws OncRpcException, IOException {
        throw new Error("OncRpcTcpServerTransport.endDecoding() is abstract and can not be called.");
    }

    protected XdrEncodingStream getXdrEncodingStream() {
        throw new Error("OncRpcTcpServerTransport.getXdrEncodingStream() is abstract and can not be called.");
    }

    protected void beginEncoding(OncRpcCallInformation oncRpcCallInformation, OncRpcServerReplyMessage oncRpcServerReplyMessage) throws OncRpcException, IOException {
        throw new Error("OncRpcTcpServerTransport.beginEncoding() is abstract and can not be called.");
    }

    protected void endEncoding() throws OncRpcException, IOException {
        throw new Error("OncRpcTcpServerTransport.endEncoding() is abstract and can not be called.");
    }

    protected void reply(OncRpcCallInformation oncRpcCallInformation, OncRpcServerReplyMessage oncRpcServerReplyMessage, XdrAble xdrAble) throws OncRpcException, IOException {
        throw new Error("OncRpcTcpServerTransport.reply() is abstract and can not be called.");
    }

    public void listen() {
        Thread thread = new Thread("TCP server transport listener thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                while (true) {
                    try {
                        ServerSocket serverSocket;
                        while ((serverSocket = OncRpcTcpServerTransport.this.socket) != null) {
                            Socket socket = serverSocket.accept();
                            OncRpcTcpConnectionServerTransport oncRpcTcpConnectionServerTransport = OncRpcTcpServerTransport.this.getTCPConnectionServerTransport(socket, OncRpcTcpServerTransport.this.bufferSize);
                            TransportList transportList = OncRpcTcpServerTransport.this.openTransports;
                            synchronized (transportList) {
                                OncRpcTcpServerTransport.this.openTransports.add(oncRpcTcpConnectionServerTransport);
                            }
                            oncRpcTcpConnectionServerTransport.listen();
                        }
                        return;
                    }
                    catch (OncRpcException oncRpcException) {
                        continue;
                    }
                    catch (IOException iOException) {
                        if (OncRpcTcpServerTransport.this.socket == null) return;
                        continue;
                    }
                    break;
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    public void setTransmissionTimeout(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("transmission timeout must be > 0");
        }
        this.transmissionTimeout = n2;
    }

    public int getTransmissionTimeout() {
        return this.transmissionTimeout;
    }

    public void setCharacterEncoding(String string) {
        this.characterEncoding = string;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    protected OncRpcTcpConnectionServerTransport getTCPConnectionServerTransport(Socket socket, int n2) throws IOException, OncRpcException {
        return new OncRpcTcpConnectionServerTransport(this.dispatcher, socket, this.info, n2, this, this.transmissionTimeout);
    }

    private class TransportList {
        private Node head = new Node(null);
        private int size = 0;

        public TransportList() {
            this.head.next = this.head;
            this.head.prev = this.head;
        }

        public void add(Object object) {
            Node node = new Node(object);
            node.next = this.head.next;
            this.head.next = node;
            node.prev = this.head;
            node.next.prev = node;
            ++this.size;
        }

        public boolean remove(Object object) {
            Node node = this.head.next;
            while (node != this.head) {
                if (node.item == object) {
                    node.prev.next = node.next;
                    node.next.prev = node.prev;
                    --this.size;
                    return true;
                }
                node = node.next;
            }
            return false;
        }

        public Object removeFirst() {
            if (this.size == 0) {
                throw new NoSuchElementException();
            }
            Node node = this.head.next;
            this.head.next = node.next;
            node.next.prev = this.head;
            --this.size;
            return node.item;
        }

        public int size() {
            return this.size;
        }

        private class Node {
            Node next;
            Node prev;
            Object item;

            public Node(Object object) {
                this.item = object;
            }
        }
    }
}

