/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.instrument.classloading;

import com.bmc.thirdparty.org.springframework.instrument.InstrumentationSavingAgent;
import com.bmc.thirdparty.org.springframework.instrument.classloading.LoadTimeWeaver;
import com.bmc.thirdparty.org.springframework.instrument.classloading.SimpleThrowawayClassLoader;
import com.bmc.thirdparty.org.springframework.util.Assert;
import com.bmc.thirdparty.org.springframework.util.ClassUtils;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;

public class InstrumentationLoadTimeWeaver
implements LoadTimeWeaver {
    public void addTransformer(ClassFileTransformer transformer) {
        Assert.notNull(transformer, "Transformer must not be null");
        Instrumentation instrumentation = InstrumentationSavingAgent.getInstrumentation();
        if (instrumentation == null) {
            throw new IllegalStateException("Must start with Java agent to use InstrumentationLoadTimeWeaver. See Spring documentation.");
        }
        instrumentation.addTransformer(transformer);
    }

    public ClassLoader getInstrumentableClassLoader() {
        return ClassUtils.getDefaultClassLoader();
    }

    public ClassLoader getThrowawayClassLoader() {
        return new SimpleThrowawayClassLoader(this.getInstrumentableClassLoader());
    }
}

