/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.aop.config;

import com.bmc.thirdparty.org.springframework.beans.factory.config.BeanDefinition;
import com.bmc.thirdparty.org.springframework.beans.factory.parsing.BeanComponentDefinition;
import com.bmc.thirdparty.org.springframework.beans.factory.support.BeanDefinitionRegistry;
import com.bmc.thirdparty.org.springframework.beans.factory.support.RootBeanDefinition;
import com.bmc.thirdparty.org.springframework.beans.factory.xml.ParserContext;
import com.bmc.thirdparty.org.springframework.util.Assert;
import com.bmc.thirdparty.org.springframework.util.ClassUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class AopNamespaceUtils {
    public static final String AUTO_PROXY_CREATOR_BEAN_NAME = "com.bmc.thirdparty.org.springframework.aop.config.internalAutoProxyCreator";
    public static final String ASPECTJ_AUTO_PROXY_CREATOR_CLASS_NAME = "com.bmc.thirdparty.org.springframework.aop.aspectj.annotation.AnnotationAwareAspectJAutoProxyCreator";
    private static final List APC_PRIORITY_LIST = new ArrayList();
    static /* synthetic */ Class class$org$springframework$aop$framework$autoproxy$DefaultAdvisorAutoProxyCreator;
    static /* synthetic */ Class class$org$springframework$aop$aspectj$autoproxy$AspectJInvocationContextExposingAdvisorAutoProxyCreator;

    public static void registerAutoProxyCreatorIfNecessary(ParserContext parserContext, Object sourceElement) {
        AopNamespaceUtils.registryOrEscalateApcAsRequired(class$org$springframework$aop$framework$autoproxy$DefaultAdvisorAutoProxyCreator == null ? (class$org$springframework$aop$framework$autoproxy$DefaultAdvisorAutoProxyCreator = AopNamespaceUtils.class$("com.bmc.thirdparty.org.springframework.aop.framework.autoproxy.DefaultAdvisorAutoProxyCreator")) : class$org$springframework$aop$framework$autoproxy$DefaultAdvisorAutoProxyCreator, parserContext, sourceElement);
    }

    public static void registerAspectJAutoProxyCreatorIfNecessary(ParserContext parserContext, Object sourceElement) {
        AopNamespaceUtils.registryOrEscalateApcAsRequired(class$org$springframework$aop$aspectj$autoproxy$AspectJInvocationContextExposingAdvisorAutoProxyCreator == null ? (class$org$springframework$aop$aspectj$autoproxy$AspectJInvocationContextExposingAdvisorAutoProxyCreator = AopNamespaceUtils.class$("com.bmc.thirdparty.org.springframework.aop.aspectj.autoproxy.AspectJInvocationContextExposingAdvisorAutoProxyCreator")) : class$org$springframework$aop$aspectj$autoproxy$AspectJInvocationContextExposingAdvisorAutoProxyCreator, parserContext, sourceElement);
    }

    public static void registerAtAspectJAutoProxyCreatorIfNecessary(ParserContext parserContext, Object sourceElement) {
        Class cls = AopNamespaceUtils.getAspectJAutoProxyCreatorClassIfPossible();
        AopNamespaceUtils.registryOrEscalateApcAsRequired(cls, parserContext, sourceElement);
    }

    private static void registryOrEscalateApcAsRequired(Class cls, ParserContext parserContext, Object sourceElement) {
        Assert.notNull(parserContext, "ParserContext must not be null");
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        if (registry.containsBeanDefinition(AUTO_PROXY_CREATOR_BEAN_NAME)) {
            int requiredPriority;
            BeanDefinition apcDefinition = registry.getBeanDefinition(AUTO_PROXY_CREATOR_BEAN_NAME);
            if (cls.getName().equals(apcDefinition.getBeanClassName())) {
                return;
            }
            int currentPriority = AopNamespaceUtils.findPriorityForClass(apcDefinition.getBeanClassName());
            if (currentPriority < (requiredPriority = AopNamespaceUtils.findPriorityForClass(cls.getName()))) {
                apcDefinition.setBeanClassName(cls.getName());
            }
        } else {
            RootBeanDefinition beanDefinition = new RootBeanDefinition(cls);
            beanDefinition.setSource(parserContext.extractSource(sourceElement));
            beanDefinition.setRole(2);
            registry.registerBeanDefinition(AUTO_PROXY_CREATOR_BEAN_NAME, beanDefinition);
            beanDefinition.getPropertyValues().addPropertyValue("order", new Integer(Integer.MIN_VALUE));
            BeanComponentDefinition componentDefinition = new BeanComponentDefinition(beanDefinition, AUTO_PROXY_CREATOR_BEAN_NAME);
            parserContext.getReaderContext().fireComponentRegistered(componentDefinition);
        }
    }

    public static void forceAutoProxyCreatorToUseClassProxying(BeanDefinitionRegistry registry) {
        if (registry.containsBeanDefinition(AUTO_PROXY_CREATOR_BEAN_NAME)) {
            BeanDefinition definition = registry.getBeanDefinition(AUTO_PROXY_CREATOR_BEAN_NAME);
            definition.getPropertyValues().addPropertyValue("proxyTargetClass", Boolean.TRUE);
        }
    }

    private static Class getAspectJAutoProxyCreatorClassIfPossible() {
        try {
            return ClassUtils.forName(ASPECTJ_AUTO_PROXY_CREATOR_CLASS_NAME);
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Unable to load class [org.springframework.aop.aspectj.annotation.AnnotationAwareAspectJAutoProxyCreator]. Are you running on Java 1.5+? Root cause: " + ex);
        }
    }

    private static final int findPriorityForClass(String className) {
        Assert.notNull(className, "Class name must not be null");
        for (int i2 = 0; i2 < APC_PRIORITY_LIST.size(); ++i2) {
            String str = (String)APC_PRIORITY_LIST.get(i2);
            if (!className.equals(str)) continue;
            return i2;
        }
        throw new IllegalArgumentException("Class name [" + className + "] is not a known auto-proxy creator class");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        APC_PRIORITY_LIST.add((class$org$springframework$aop$framework$autoproxy$DefaultAdvisorAutoProxyCreator == null ? (class$org$springframework$aop$framework$autoproxy$DefaultAdvisorAutoProxyCreator = AopNamespaceUtils.class$("com.bmc.thirdparty.org.springframework.aop.framework.autoproxy.DefaultAdvisorAutoProxyCreator")) : class$org$springframework$aop$framework$autoproxy$DefaultAdvisorAutoProxyCreator).getName());
        APC_PRIORITY_LIST.add((class$org$springframework$aop$aspectj$autoproxy$AspectJInvocationContextExposingAdvisorAutoProxyCreator == null ? (class$org$springframework$aop$aspectj$autoproxy$AspectJInvocationContextExposingAdvisorAutoProxyCreator = AopNamespaceUtils.class$("com.bmc.thirdparty.org.springframework.aop.aspectj.autoproxy.AspectJInvocationContextExposingAdvisorAutoProxyCreator")) : class$org$springframework$aop$aspectj$autoproxy$AspectJInvocationContextExposingAdvisorAutoProxyCreator).getName());
        APC_PRIORITY_LIST.add(ASPECTJ_AUTO_PROXY_CREATOR_CLASS_NAME);
    }
}

