/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apitransport;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ProxyManager;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.session.ARRpcClientStub;
import com.bmc.arsys.apitransport.ApiProxyBase;
import com.bmc.arsys.apitransport.ApiUserContextI;
import com.bmc.arsys.apitransport.chunking.ARChunkProcessorFactory;
import com.bmc.arsys.apitransport.chunking.IARChunkReceivable;
import com.bmc.arsys.apitransport.chunking.IARChunkSendable;
import com.bmc.arsys.apitransport.chunking.IARChunkable;
import com.bmc.arsys.apitransport.session.ARServerContext;
import com.bmc.arsys.apitransport.session.ApiRpcTimeOutBase;
import com.bmc.arsys.apitransport.session.ApiThreadLocalStorageBlock;
import com.bmc.arsys.apitransport.session.ArRpcCallContext;
import com.bmc.arsys.apitransport.session.ArStatusInfo;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arrpc.ArTimestamp;
import com.bmc.arsys.arrpc.xdr.ArRpcControlStruct;
import com.bmc.arsys.arrpc.xdr.ArRpcXdrIn;
import com.bmc.arsys.arrpc.xdr.ArRpcXdrOut;
import com.bmc.arsys.utils.ProcessUtil;
import java.util.concurrent.locks.ReentrantLock;
import org.acplt.oncrpc.OncRpcAuthenticationException;
import org.acplt.oncrpc.OncRpcException;
import org.apache.log4j.Logger;

public abstract class ApiProxyJRpcBase
extends ApiProxyBase {
    private static Logger a = Logger.getLogger(ApiProxyJRpcBase.class);
    protected ARRpcClientStub rpcClient = null;
    protected final ReentrantLock lock = new ReentrantLock();

    protected abstract ARRpcClientStub getRpcClient(ApiUserContextI var1) throws ARException;

    private void a() {
        ApiThreadLocalStorageBlock.getTLB().setChunkProcessor(null);
    }

    protected void initThreadLocalInternalVariables() {
        ApiThreadLocalStorageBlock.getTLB().setInternalChunkingObj(null);
    }

    protected int getInitialXdrSize(ApiUserContextI apiUserContextI) {
        int n2 = 0;
        ARServerContext aRServerContext = ProxyManager.getARServerContext(apiUserContextI.getServer(), apiUserContextI.getPort());
        if (aRServerContext != null) {
            n2 = aRServerContext.getCurrentXDRBufferSize();
        }
        if (n2 <= 0 || n2 < 4096 || n2 > 10000000) {
            n2 = 500128;
        }
        return n2;
    }

    protected int connectionTry(ApiUserContextI apiUserContextI, int n2, Exception exception) throws ARException {
        if (n2 < apiUserContextI.getApiConfig().getConnectionMaxRetries()) {
            this.closeConnection();
            try {
                Thread.sleep(apiUserContextI.getApiConfig().getTimeLagBetweenRetriesMillSec());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } else {
            throw new ARException(2, 90, exception.getLocalizedMessage() + " " + apiUserContextI.getServer());
        }
        return ++n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void arCall(ApiUserContextI apiUserContextI, int n2, ArRpcXdrIn arRpcXdrIn, ArRpcXdrOut arRpcXdrOut) throws ARException {
        boolean bl = this.isPotentialMultiThreads();
        if (bl) {
            this.lock.lock();
        }
        try {
            this.a();
            this.a(apiUserContextI, n2, arRpcXdrIn, arRpcXdrOut, false);
            Object var7_6 = null;
            if (bl) {
                this.lock.unlock();
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (bl) {
                this.lock.unlock();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(ApiUserContextI apiUserContextI, int n2, ArRpcXdrIn arRpcXdrIn, ArRpcXdrOut arRpcXdrOut, boolean bl) throws ARException {
        apiUserContextI.logApiTime("+API call, Procedure #" + n2);
        long l2 = System.currentTimeMillis();
        StringBuilder stringBuilder = a.isDebugEnabled() ? new StringBuilder() : null;
        boolean bl2 = false;
        if (stringBuilder != null) {
            stringBuilder.append("ProcNumber ").append(n2).append(" to ARServer: ").append(apiUserContextI.getServer());
        }
        try {
            try {
                if (ARChunkProcessorFactory.isChunkingSupportedCall(n2)) {
                    int n3;
                    if (stringBuilder != null) {
                        stringBuilder.append(", with chunking ");
                    }
                    if ((n3 = this.a(apiUserContextI, n2, arRpcXdrIn, arRpcXdrOut)) > 0 && stringBuilder != null) {
                        stringBuilder.append(n3).append(" round call").append(n3 > 1 ? "s, " : ",");
                    }
                } else {
                    ARRpcClientStub aRRpcClientStub = this.getRpcClient(apiUserContextI);
                    this.a(apiUserContextI, aRRpcClientStub);
                    aRRpcClientStub.arCall(n2, arRpcXdrIn, arRpcXdrOut);
                }
                bl2 = true;
            }
            catch (OncRpcException oncRpcException) {
                if (stringBuilder != null) {
                    String string = stringBuilder.toString() + " received OncRpcException: " + oncRpcException.getLocalizedMessage();
                    a.debug(string);
                    System.out.println(string);
                }
                if (bl) {
                    this.resetChunkProcessor();
                    this.closeConnection();
                    throw this.a(oncRpcException, n2, apiUserContextI);
                }
                boolean bl3 = true;
                boolean bl4 = false;
                if (oncRpcException.getReason() == 7 && oncRpcException instanceof OncRpcAuthenticationException) {
                    switch (((OncRpcAuthenticationException)oncRpcException).getAuthStatus()) {
                        case 2: {
                            bl3 = false;
                            bl4 = true;
                            break;
                        }
                        case 1: {
                            this.getRpcClient(apiUserContextI).enableAPICallEncryption(false);
                            bl3 = false;
                            break;
                        }
                        case 5: {
                            this.getRpcClient(apiUserContextI).enableAPICallEncryption(true);
                            bl3 = false;
                            break;
                        }
                    }
                } else if (oncRpcException.getReason() == 11 || oncRpcException.getReason() == 2 || oncRpcException.getReason() == 1 || oncRpcException.getReason() == 10 || oncRpcException.getReason() == 5 || this.isArException(oncRpcException)) {
                    this.resetChunkProcessor();
                    this.closeConnection();
                    throw this.a(oncRpcException, n2, apiUserContextI);
                }
                if (bl4) {
                    try {
                        this.getRpcClient(apiUserContextI).handShake(apiUserContextI.getServer(), false, 0, 0);
                    }
                    catch (Exception exception) {
                        bl3 = true;
                    }
                }
                if (bl3) {
                    if (stringBuilder != null) {
                        stringBuilder.append(" connection ").append(this).append(" to ").append(apiUserContextI.getServer()).append(" re-established w reason : ").append(oncRpcException.getLocalizedMessage());
                        a.debug(stringBuilder.toString());
                    }
                    this.closeConnection();
                }
                stringBuilder = null;
                this.a(apiUserContextI, n2, arRpcXdrIn, arRpcXdrOut, true);
                Object var15_13 = null;
                this.updateUserContext(apiUserContextI, arRpcXdrOut);
                this.verifyStatus(apiUserContextI, arRpcXdrOut);
                apiUserContextI.logApiTime("-API call, Procedure #" + n2);
                if (stringBuilder == null) return;
                if (bl2 && !arRpcXdrOut.getStatus().hasError()) {
                    stringBuilder.append(" succeed,");
                } else {
                    stringBuilder.append(" returned error, ").append(new ARException(new ArStatusInfo(arRpcXdrOut.getStatus())).getLocalizedMessage());
                }
                ProcessUtil.getInstance().PrintProcessTime(l2, stringBuilder.toString());
                a.debug(stringBuilder.toString());
                System.out.println(stringBuilder);
                return;
            }
            Object var15_12 = null;
            this.updateUserContext(apiUserContextI, arRpcXdrOut);
        }
        catch (Throwable throwable) {
            Object var15_14 = null;
            this.updateUserContext(apiUserContextI, arRpcXdrOut);
            this.verifyStatus(apiUserContextI, arRpcXdrOut);
            apiUserContextI.logApiTime("-API call, Procedure #" + n2);
            if (stringBuilder == null) throw throwable;
            if (bl2 && !arRpcXdrOut.getStatus().hasError()) {
                stringBuilder.append(" succeed,");
            } else {
                stringBuilder.append(" returned error, ").append(new ARException(new ArStatusInfo(arRpcXdrOut.getStatus())).getLocalizedMessage());
            }
            ProcessUtil.getInstance().PrintProcessTime(l2, stringBuilder.toString());
            a.debug(stringBuilder.toString());
            System.out.println(stringBuilder);
            throw throwable;
        }
        this.verifyStatus(apiUserContextI, arRpcXdrOut);
        apiUserContextI.logApiTime("-API call, Procedure #" + n2);
        if (stringBuilder == null) return;
        if (bl2 && !arRpcXdrOut.getStatus().hasError()) {
            stringBuilder.append(" succeed,");
        } else {
            stringBuilder.append(" returned error, ").append(new ARException(new ArStatusInfo(arRpcXdrOut.getStatus())).getLocalizedMessage());
        }
        ProcessUtil.getInstance().PrintProcessTime(l2, stringBuilder.toString());
        a.debug(stringBuilder.toString());
        System.out.println(stringBuilder);
    }

    private void a(ApiUserContextI apiUserContextI, ARRpcClientStub aRRpcClientStub) throws ARException {
        ArRpcCallContext arRpcCallContext = aRRpcClientStub.getArRpcCallContext();
        for (int n2 : apiUserContextI.getUserSession().keySet()) {
            arRpcCallContext.setSessionVariable(n2, apiUserContextI.getUserSession().get(n2));
        }
    }

    protected boolean isArException(OncRpcException oncRpcException) {
        return oncRpcException.getReason() == 16 && oncRpcException.getCause() instanceof AREncryptionException;
    }

    protected IARChunkable getChunkProcessor(ApiUserContextI apiUserContextI, int n2) throws ARException {
        if (ApiThreadLocalStorageBlock.getTLB().getChunkProcessor() == null) {
            IARChunkable iARChunkable = ARChunkProcessorFactory.createProcessor(n2);
            iARChunkable.init(this.getInternalObj(apiUserContextI));
            ApiThreadLocalStorageBlock.getTLB().setChunkProcessor(iARChunkable);
        }
        return ApiThreadLocalStorageBlock.getTLB().getChunkProcessor();
    }

    protected void resetChunkProcessor() {
        ApiThreadLocalStorageBlock.getTLB().resetChunkingProcessor();
    }

    private int a(ApiUserContextI apiUserContextI, int n2, ArRpcXdrIn arRpcXdrIn, ArRpcXdrOut arRpcXdrOut) throws ARException, OncRpcException {
        ArRpcControlStruct arRpcControlStruct = arRpcXdrIn.getControl();
        ArStatusInfo arStatusInfo = new ArStatusInfo();
        IARChunkable iARChunkable = this.getChunkProcessor(apiUserContextI, n2);
        int n3 = iARChunkable.getRoundNumber();
        boolean bl = true;
        try {
            while (iARChunkable.hasNextRound()) {
                iARChunkable.nextRound();
                n3 = iARChunkable.getRoundNumber();
                if (n3 == 1) {
                    // empty if block
                }
                a.debug("arChunkingCall: Processor=" + iARChunkable + ", Proc Number=" + n2 + ", Round Number=" + n3);
                if (ARChunkProcessorFactory.isSendChunkingOnInputParamCall(n2)) {
                    ((IARChunkSendable)iARChunkable).loadOneChunkToParamIn(this.getArRpcCallContext(apiUserContextI).getSessionVariable(1).getIntValue(), arRpcXdrIn);
                }
                ARRpcClientStub aRRpcClientStub = this.getRpcClient(apiUserContextI);
                this.a(apiUserContextI, aRRpcClientStub);
                if (n3 <= 1 || !bl) {
                    // empty if block
                }
                aRRpcClientStub.arCall(n2, arRpcXdrIn, arRpcXdrOut);
                arStatusInfo.add(arRpcXdrOut.getStatus());
                if (arRpcXdrOut.getStatus().hasError()) break;
                if (ARChunkProcessorFactory.isReceiveChunkingOnOutputParamCall(n2)) {
                    ((IARChunkReceivable)iARChunkable).retrieveChunkingData(arRpcXdrOut);
                }
                arRpcControlStruct.setCacheId(arRpcXdrOut.getControl().getCacheId());
                arRpcControlStruct.setRequestId(arRpcXdrOut.getControl().getRequestId());
            }
            if (ARChunkProcessorFactory.isReceiveChunkingOnOutputParamCall(n2)) {
                ((IARChunkReceivable)iARChunkable).postProcess(arRpcXdrOut);
                a.debug("arChunkingCall: Done with postProcess");
            }
            this.resetChunkProcessor();
        }
        catch (OncRpcException oncRpcException) {
            iARChunkable.setRoundNumber(--n3);
            throw oncRpcException;
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeConnection() throws ARException {
        boolean bl = this.isPotentialMultiThreads();
        if (bl) {
            this.lock.lock();
        }
        try {
            if (this.rpcClient != null) {
                try {
                    this.rpcClient.close();
                    this.rpcClient = null;
                }
                catch (OncRpcException oncRpcException) {
                    throw this.convertException(oncRpcException);
                }
            }
            Object var4_3 = null;
            if (bl) {
                this.lock.unlock();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (bl) {
                this.lock.unlock();
            }
            throw throwable;
        }
    }

    protected void updateUserContext(ApiUserContextI apiUserContextI, ArRpcXdrOut arRpcXdrOut) {
        if (arRpcXdrOut == null || apiUserContextI == null) {
            return;
        }
        ArRpcControlStruct arRpcControlStruct = arRpcXdrOut.getControl();
        if (arRpcControlStruct != null) {
            if (apiUserContextI.getImpersonatedUser() != null && apiUserContextI.getImpersonatedUser().length() != 0) {
                apiUserContextI.setImpersonatedCacheId(arRpcControlStruct.getCacheId());
            } else {
                apiUserContextI.setCacheId(arRpcControlStruct.getCacheId());
            }
            ArTimestamp arTimestamp = arRpcControlStruct.getOperationTime();
            if (arTimestamp != null) {
                apiUserContextI.setOperationTime(new Timestamp(arTimestamp.value));
            }
            if (apiUserContextI.getOverridePrevIP()) {
                apiUserContextI.setOverridePrevIP(false);
            }
        }
    }

    protected void verifyStatus(ApiUserContextI apiUserContextI, ArRpcXdrOut arRpcXdrOut) throws ARException {
        if (apiUserContextI == null || arRpcXdrOut == null || arRpcXdrOut.getStatus() == null) {
            return;
        }
        ArStatusInfo arStatusInfo = new ArStatusInfo(arRpcXdrOut.getStatus());
        apiUserContextI.setLastStatus(arStatusInfo);
        apiUserContextI.setMultiLastStatus(null);
        if (arRpcXdrOut.getStatus().hasError()) {
            a.debug(arStatusInfo);
            throw new ARException(new ArStatusInfo(arRpcXdrOut.getStatus()));
        }
    }

    protected ARException convertException(OncRpcException oncRpcException) {
        return this.a(oncRpcException, 0);
    }

    private ARException a(OncRpcException oncRpcException, int n2) {
        return this.a(oncRpcException, 0, null);
    }

    private ARException a(OncRpcException oncRpcException, int n2, ApiUserContextI apiUserContextI) {
        ARException aRException = null;
        aRException = this.isArException(oncRpcException) ? new ARException(2, ((AREncryptionException)oncRpcException.getCause()).getErrorNum(), ((AREncryptionException)oncRpcException.getCause()).getMessage()) : (oncRpcException.getReason() == 5 && n2 > 0 && apiUserContextI != null ? new ARException(2, this.a(apiUserContextI, n2), oncRpcException.getLocalizedMessage()) : (oncRpcException.getReason() == 10 ? new ARException(2, 341, oncRpcException.getLocalizedMessage()) : new ARException(2, 91, oncRpcException.getLocalizedMessage())));
        return aRException;
    }

    protected String getServerCharSetName(ApiUserContextI apiUserContextI) throws ARException {
        return this.getArRpcCallContext(apiUserContextI).getServerCharSetName();
    }

    protected Object getInternalObj(ApiUserContextI apiUserContextI) throws ARException {
        return ApiThreadLocalStorageBlock.getTLB().getInternalChunkingObj();
    }

    protected void setInternalObj(ApiUserContextI apiUserContextI, Object object) throws ARException {
        ApiThreadLocalStorageBlock.getTLB().setInternalChunkingObj(object);
    }

    protected void cleanUpTL() {
        if (ApiThreadLocalStorageBlock.isTLBExist()) {
            ApiThreadLocalStorageBlock.getTLB().cleanUp();
        }
    }

    protected ArRpcCallContext getArRpcCallContext(ApiUserContextI apiUserContextI) throws ARException {
        return this.getRpcClient(apiUserContextI).getArRpcCallContext();
    }

    protected String ARInitApiSourceGuid(ApiUserContextI apiUserContextI) throws ARException {
        return null;
    }

    private int a(ApiUserContextI apiUserContextI, int n2) {
        return ((ApiRpcTimeOutBase)apiUserContextI.getApiPropertyManager().get("AR_PROPERTY_RPC_TIMEOUT")).getErrorCode(n2);
    }

    protected boolean isPotentialMultiThreads() {
        return !ProxyManager.isUseConnectionPooling();
    }
}

