/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apitransport;

import com.bmc.arsys.api.ConfigKey;
import com.bmc.arsys.apitransport.ApiConfigI;
import com.bmc.arsys.apitransport.ApiConfigManager;
import com.bmc.thirdparty.org.apache.commons.configuration.Configuration;
import com.bmc.thirdparty.org.apache.commons.configuration.ConfigurationException;
import com.bmc.thirdparty.org.apache.commons.configuration.ConfigurationFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.NullEnumeration;
import org.apache.log4j.varia.NullAppender;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ApiConfig
implements ApiConfigI {
    private static Logger do = Logger.getLogger(ApiConfig.class);
    public static final String PROPERTY_NAME = "APICONFIG";
    public static final String MAINCONFIG_NAME = "ARApiConfig";
    private String for;
    private String if;
    private String a;
    protected boolean jrpcMode;
    protected boolean jrpcModeSet;
    protected int clientRpcVersion;
    protected int minimumSupportedServerRpcVersion;
    protected int maxProxiesPerServer;
    protected int connectionMaxRetries;
    protected int timeLagBetweenRetriesMillSec;
    protected int apiRecordingMode;
    protected int jniLoadMode;
    protected Configuration config;

    public ApiConfig(String string, String string2) {
        this.initializeLogger();
        this.setConfigName(string);
        this.setConfigFileName(string2);
        try {
            this.applyDefaults();
        }
        catch (Exception exception) {
            do.error("Can not initialize Config defaults", exception);
        }
        try {
            this.a(string2);
            this.applyConfigFileSettings();
        }
        catch (ConfigurationException configurationException) {
            do.error("Default settings are used since we could not load the config from file " + configurationException.getLocalizedMessage());
        }
        catch (Exception exception) {
            do.error("Default settings are used since we can not initialize Config from file", exception);
        }
    }

    protected void initializeLogger() {
        Logger logger = Logger.getRootLogger();
        if (logger.getAllAppenders().getClass().equals(NullEnumeration.class)) {
            logger.addAppender(new NullAppender());
            logger.setLevel(Level.OFF);
        }
    }

    private void a(String string) throws ConfigurationException {
        ConfigurationFactory configurationFactory = new ConfigurationFactory(string);
        this.config = configurationFactory.getConfiguration();
    }

    protected Configuration getConfiguration() {
        return this.config;
    }

    protected void applyDefaults() {
        this.setJrpcMode(Boolean.parseBoolean(ConfigKey.JrpcMode.getDefaultValue()));
        this.jrpcModeSet = false;
        this.maxProxiesPerServer = Integer.parseInt(ConfigKey.MaxProxiesPerServer.getDefaultValue());
        this.setClientRpcVersion(Integer.parseInt(ConfigKey.ClientRpcVersion.getDefaultValue()));
        this.setMinimumSupportedServerRpcVersion(Integer.parseInt(ConfigKey.MinimumSupportedServerRpcVersion.getDefaultValue()));
        this.setRpcClientStubType(ConfigKey.RpcClientStubType.getDefaultValue());
        this.setConnectionMaxRetries(Integer.parseInt(ConfigKey.ConnectionMaxRetries.getDefaultValue()));
        this.setTimeLagBetweenRetriesMillSec(Integer.parseInt(ConfigKey.TimeLagBetweenRetriesMillSec.getDefaultValue()));
        this.setApiRecordingMode(Integer.parseInt(ConfigKey.ApiRecordingMode.getDefaultValue()));
        this.setJniLoadMode(Integer.parseInt(ConfigKey.JniLoadMode.getDefaultValue()));
    }

    protected void applyConfigFileSettings() {
        this.setJrpcMode(this.config);
        this.setClientRpcVersion(this.config.getInt(ConfigKey.ClientRpcVersion.getKey(), this.clientRpcVersion));
        this.setRpcClientStubType(this.config.getString(ConfigKey.RpcClientStubType.getKey(), this.a));
        this.setMinimumSupportedServerRpcVersion(this.config.getInt(ConfigKey.MinimumSupportedServerRpcVersion.getKey(), this.minimumSupportedServerRpcVersion));
        this.maxProxiesPerServer = this.config.getInt(ConfigKey.MaxProxiesPerServer.getKey(), this.maxProxiesPerServer);
        this.setConnectionMaxRetries(this.config.getInt(ConfigKey.ConnectionMaxRetries.getKey(), this.connectionMaxRetries));
        this.setTimeLagBetweenRetriesMillSec(this.config.getInt(ConfigKey.TimeLagBetweenRetriesMillSec.getKey(), this.timeLagBetweenRetriesMillSec));
        this.setApiRecordingMode(this.config.getInt(ConfigKey.ApiRecordingMode.getKey(), this.apiRecordingMode));
        this.setJniLoadMode(this.config.getInt(ConfigKey.JniLoadMode.getKey(), this.jniLoadMode));
    }

    protected void setConfigName(String string) {
        this.for = string;
    }

    public String getConfigName() {
        return this.for;
    }

    protected void setConfigFileName(String string) {
        this.if = string;
    }

    protected String getConfigFileName() {
        return this.if;
    }

    public static void register(ApiConfig apiConfig) {
        ApiConfigManager.getInstance().register(apiConfig.getConfigName(), apiConfig);
    }

    public void setJrpcMode(Configuration configuration) {
        if (!this.jrpcModeSet) {
            this.setJrpcMode(configuration.getBoolean(ConfigKey.JrpcMode.getKey(), this.jrpcMode));
            do.info("jrpcMode: " + this.jrpcMode);
        }
    }

    public void setJrpcMode(boolean bl) {
        this.jrpcMode = bl;
    }

    public boolean getJrpcMode() {
        return this.jrpcMode;
    }

    public void setClientRpcVersion(int n2) {
        this.clientRpcVersion = n2;
    }

    public int getClientRpcVersion() {
        return this.clientRpcVersion;
    }

    public void setJniLoadMode(int n2) {
        this.jniLoadMode = n2;
    }

    public int getJniLoadMode() {
        return this.jniLoadMode;
    }

    public void setApiRecordingMode(int n2) {
        this.apiRecordingMode = n2;
    }

    public int getApiRecording() {
        return this.apiRecordingMode;
    }

    public void setMinimumSupportedServerRpcVersion(int n2) {
        this.minimumSupportedServerRpcVersion = n2;
    }

    public int getMinimumSupportedServerRpcVersion() {
        return this.minimumSupportedServerRpcVersion;
    }

    public void setConnectionMaxRetries(int n2) {
        this.connectionMaxRetries = n2;
    }

    public int getConnectionMaxRetries() {
        return this.connectionMaxRetries;
    }

    public void setTimeLagBetweenRetriesMillSec(int n2) {
        this.timeLagBetweenRetriesMillSec = n2;
    }

    public int getTimeLagBetweenRetriesMillSec() {
        return this.timeLagBetweenRetriesMillSec;
    }

    public int getMaxProxiesPerServer() {
        return this.maxProxiesPerServer;
    }

    public void setRpcClientStubType(String string) {
        this.a = string;
    }

    public String getRpcClientStubType() {
        return this.a;
    }
}

