/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.data.arm;

import com.bmc.arsys.api.Keyword;
import com.bmc.arsys.apiext.data.ARImportException;
import com.bmc.arsys.apiext.data.DataOptions;
import com.bmc.arsys.apiext.data.FieldInformation;
import com.bmc.arsys.apiext.data.FormInformation;
import com.bmc.arsys.apiext.data.ImportErrors;
import com.bmc.arsys.apiext.data.ImportOptions;
import com.bmc.arsys.apiext.data.Mapping;
import com.bmc.arsys.apiext.data.MappingOptions;
import com.bmc.arsys.apiext.data.Parser;
import com.bmc.arsys.apiext.data.ThreadLocalStorage;
import com.bmc.arsys.apiext.data.Util;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ARMParser
extends Parser {
    public static final String DELIMETER = "$";
    private static final String bo = " ";
    private ImportOptions bn = null;
    private static final String bp = "\r\n";

    public ARMParser(ImportOptions importOptions) {
        this.bn = importOptions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Mapping parseMapping(String string, FormInformation formInformation) {
        Mapping mapping = new Mapping();
        String string2 = string.trim();
        int n = Util.countDelimeters(string, DELIMETER);
        switch (n) {
            case 0: 
            case 1: {
                mapping.setType(Mapping.Type.CONSTANT);
                mapping.setConstant(string);
                return mapping;
            }
            case 2: {
                if (string2.length() == 2 && string2.startsWith(DELIMETER) && string2.endsWith(DELIMETER)) {
                    mapping.setType(Mapping.Type.CONSTANT);
                    mapping.setConstant("");
                    return mapping;
                }
                if ("$--1$".equals(string2)) {
                    mapping.setType(Mapping.Type.KEYWORD);
                    mapping.setKeyword(-1);
                    return mapping;
                }
                if (string2.startsWith(DELIMETER) && string2.endsWith(DELIMETER)) {
                    string2 = string2.substring(1, string2.length() - 1);
                    try {
                        int n2 = Integer.parseInt(string2);
                        if (n2 > 0) {
                            mapping.setType(Mapping.Type.FIELDID);
                            mapping.setFieldId(n2);
                            return mapping;
                        }
                        mapping.setType(Mapping.Type.KEYWORD);
                        mapping.setKeyword(Keyword.toKeyword((int)(n2 *= -1)));
                        if (mapping.getKeyword() != null) return mapping;
                        throw new ARImportException("Unable to convert value to keyword : " + string2);
                    }
                    catch (Exception exception) {
                        if ("$NULL$".equals(string.trim())) {
                            mapping.setType(Mapping.Type.KEYWORD);
                            mapping.setKeyword(new Integer(-1));
                        } else {
                            for (int i = 0; i < Mapping.keywords.length; ++i) {
                                if (!string.equals(Mapping.keywords[i].toString())) continue;
                                mapping.setType(Mapping.Type.KEYWORD);
                                mapping.setKeyword(Mapping.keywords[i]);
                                break;
                            }
                        }
                        if (mapping.getType() != Mapping.Type.NONE) return mapping;
                        if (formInformation != null) {
                            for (FieldInformation fieldInformation : formInformation.getFields().values()) {
                                if (string2.equals(fieldInformation.getName())) {
                                    mapping.setType(Mapping.Type.FIELDID);
                                    mapping.setFieldName(fieldInformation.getName());
                                    mapping.setFieldId(fieldInformation.getFieldId());
                                    mapping.setTokenIndex(fieldInformation.getTokenIndex());
                                    continue;
                                }
                                if (!string2.equals(Long.toString(fieldInformation.getFieldId()))) continue;
                                mapping.setType(Mapping.Type.FIELDID);
                                mapping.setFieldName(fieldInformation.getName());
                                mapping.setFieldId(fieldInformation.getFieldId());
                                mapping.setTokenIndex(fieldInformation.getTokenIndex());
                            }
                            return mapping;
                        }
                        mapping.setType(Mapping.Type.FIELDNAME);
                        mapping.setFieldName(string2);
                        if (!this.bn.getFileOptions().getType().equals("CSV") && !this.bn.getFileOptions().getType().equals("ASC") || !mapping.getFieldName().startsWith("Field-")) return mapping;
                        String string3 = mapping.getFieldName().replace("Field-", "").trim();
                        Integer n3 = Integer.parseInt(string3);
                        mapping.setFieldId(n3 - 1);
                        mapping.setTokenIndex(n3 - 1);
                        return mapping;
                    }
                }
                mapping.setType(Mapping.Type.COMPOUND);
                String string4 = this.a(string, formInformation);
                mapping.setCompound(string4);
                return mapping;
            }
            default: {
                String string5 = this.a(string, formInformation);
                mapping.setType(Mapping.Type.COMPOUND);
                mapping.setCompound(string5);
            }
        }
        return mapping;
    }

    private String a(String string, FormInformation formInformation) {
        String string2 = string;
        if (formInformation != null) {
            string2 = string2.replace("$NULL$", "$--1$");
            for (int i = 0; i < Mapping.keywords.length; ++i) {
                string2 = string2.replace(Mapping.keywords[i].toString(), "$-" + Mapping.keywords[i].toInt() + '$');
            }
            for (FieldInformation fieldInformation : formInformation.getFields().values()) {
                string2 = string2.replace(DELIMETER + fieldInformation.getName() + DELIMETER, DELIMETER + fieldInformation.getFieldId() + DELIMETER);
            }
        }
        return string2;
    }

    private boolean do(String string) throws ARImportException {
        if (string.length() > "Allow-Too-Few-Fields:".length() + 1) {
            return Integer.parseInt(string.substring("Allow-Too-Few-Fields:".length()).trim()) == 1;
        }
        throw new ARImportException("Allow-Too-Few-Fields:is not defined");
    }

    private boolean long(String string) throws ARImportException {
        if (string.length() > "Allow-Too-Many-Fields:".length() + 1) {
            return Integer.parseInt(string.substring("Allow-Too-Many-Fields:".length()).trim()) == 1;
        }
        throw new ARImportException("Allow-Too-Many-Fields:is not defined");
    }

    private DataOptions.BadRecords i(String string) throws ARImportException {
        if (string.length() > "Bad-Record-Handling:".length() + 1) {
            int n = Integer.parseInt(string.substring("Bad-Record-Handling:".length()).trim());
            return DataOptions.BadRecords.fromARMValue(n);
        }
        throw new ARImportException("Bad-Record-Handling:is not defined");
    }

    private boolean b(String string) throws ARImportException {
        if (string.length() > "Disable-Pattern:".length() + 1) {
            return Integer.parseInt(string.substring("Disable-Pattern:".length()).trim()) == 1;
        }
        throw new ARImportException("Disable-Pattern:is not defined");
    }

    private boolean d(String string) throws ARImportException {
        if (string.length() > "Disable-Required-ness:".length() + 1) {
            return Integer.parseInt(string.substring("Disable-Required-ness:".length()).trim()) == 1;
        }
        throw new ARImportException("Disable-Required-ness:is not defined");
    }

    private DataOptions.DuplicateHandling j(String string) throws ARImportException {
        if (string.length() > "Duplicate-Id-Handling:".length() + 1) {
            int n = Integer.parseInt(string.substring("Duplicate-Id-Handling:".length()).trim());
            return DataOptions.DuplicateHandling.fromARMValue(n);
        }
        throw new ARImportException("Duplicate-Id-Handling:is not defined");
    }

    private String try(String string) throws ARImportException {
        if (string.length() > "Import-Field-Separator:".length() + 1) {
            return string.substring("Import-Field-Separator:".length()).trim();
        }
        return "";
    }

    private boolean l(String string) throws ARImportException {
        if (string.length() > "Import-Field-Titles:".length() + 1) {
            return Integer.parseInt(string.substring("Import-Field-Titles:".length()).trim()) == 1;
        }
        throw new ARImportException("Import-Field-Titles:is not defined");
    }

    private String else(String string) throws ARImportException {
        if (string.length() > "Import-File-Format:".length() + 1) {
            int n = Integer.parseInt(string.substring("Import-File-Format:".length()).trim());
            switch (n) {
                case 3: {
                    return "ARX";
                }
                case 1: {
                    return "ASC";
                }
                case 2: {
                    return "CSV";
                }
                case 4: {
                    return "XML";
                }
            }
            throw new ARImportException("Import-File-Format: has an unsupported value");
        }
        throw new ARImportException("Import-File-Format:is not defined");
    }

    private String char(String string) throws ARImportException {
        Logger logger = ThreadLocalStorage.getLogger();
        if (this.getOptions() != null && this.getOptions().getFileOptions().getDataFile() != null && this.getOptions().getFileOptions().getDataFile().length() > 0) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)MessageFormat.format(ImportErrors.EXTRACT_IMPORT_FILE_NAME.toDefMsg(), this.getOptions().getFileOptions().getDataFile()));
            }
            return this.getOptions().getFileOptions().getDataFile();
        }
        if (string.length() > "Import-Filename:".length() + 1) {
            return string.substring("Import-Filename:".length()).trim();
        }
        throw new ARImportException("Import-Filename:is not defined");
    }

    private void a(String string, boolean bl, MappingOptions mappingOptions) throws ARImportException {
        Logger logger = ThreadLocalStorage.getLogger();
        String string2 = null;
        string2 = bl ? string.substring("Fallback-Mapping:".length()).trim() : string.substring("Mapping:".length()).trim();
        int n = string2.indexOf("=");
        String string3 = string2.substring(0, n).trim();
        Mapping mapping = this.parseMapping(string2.substring(n + 1), null);
        int n2 = Integer.parseInt(string3);
        if (bl) {
            mappingOptions.addFallback(n2, mapping);
        } else {
            mappingOptions.addMapping(n2, mapping);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)MessageFormat.format(ImportErrors.EXTRACT_MAPPING.toDefMsg(), bl, mapping));
        }
    }

    private String c(String string) throws ARImportException {
        if (string.length() > "SchemaName:".length() + 1) {
            return string.substring("SchemaName:".length()).trim();
        }
        return null;
    }

    private String if(String string) throws ARImportException {
        Logger logger = ThreadLocalStorage.getLogger();
        if (this.getOptions() != null && this.getOptions().getContext().getServer() != null && this.getOptions().getContext().getServer().length() > 0) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)MessageFormat.format(ImportErrors.EXTRACT_SERVER_NAME.toDefMsg(), this.getOptions().getContext().getServer()));
            }
            return this.getOptions().getContext().getServer();
        }
        if (string.length() > "ServerName:".length() + 1) {
            return string.substring("ServerName:".length()).trim();
        }
        return null;
    }

    private boolean goto(String string) throws ARImportException {
        if (string.length() > "Strip-White-Space:".length() + 1) {
            return Integer.parseInt(string.substring("Strip-White-Space:".length()).trim()) == 1;
        }
        throw new ARImportException("Strip-White-Space:is not defined");
    }

    private boolean a(String string) throws ARImportException {
        if (string.length() > "Truncate-Values:".length() + 1) {
            return Integer.parseInt(string.substring("Truncate-Values:".length()).trim()) == 1;
        }
        throw new ARImportException("Truncate-Values:is not defined");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void populateFromARM(ImportOptions importOptions, String string, String string2) throws FileNotFoundException, UnsupportedEncodingException, ARImportException {
        String string3;
        Logger logger = ThreadLocalStorage.getLogger();
        FileInputStream fileInputStream = new FileInputStream(string);
        InputStreamReader inputStreamReader = null;
        inputStreamReader = string2 != null && string2.length() > 0 ? new InputStreamReader((InputStream)fileInputStream, string2) : new InputStreamReader(fileInputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        importOptions.setFromARM(true);
        MappingOptions mappingOptions = new MappingOptions();
        boolean bl = true;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(System.getProperty("line.separator"));
        while ((string3 = bufferedReader.readLine()) != null && !bl2) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)MessageFormat.format(ImportErrors.PROCESSING.toDefMsg(), string3));
            }
            stringBuffer.append(string3).append(System.getProperty("line.separator"));
            if (bl) {
                mappingOptions.setMappingName(string3);
                bl = false;
            }
            if (string3.startsWith("SchemaName:")) {
                String string4 = this.c(string3);
                importOptions.addMappingOptions("ARImport_Data_Holder", string4, mappingOptions);
                importOptions.setImportAllDataSets(false);
                importOptions.getFormMap().put("ARImport_Data_Holder", string4);
                continue;
            }
            if (string3.startsWith("ServerName:")) {
                importOptions.getContext().setServer(this.if(string3));
                continue;
            }
            if (string3.startsWith("Import-Filename:")) {
                importOptions.getFileOptions().setDataFile(this.char(string3));
                continue;
            }
            if (string3.startsWith("Import-File-Format:")) {
                importOptions.getFileOptions().setType(this.else(string3));
                continue;
            }
            if (string3.startsWith("Import-Field-Titles:")) {
                importOptions.getFileOptions().setHasTitles(this.l(string3));
                continue;
            }
            if (string3.startsWith("Import-Field-Separator:")) {
                importOptions.getFileOptions().setSeparator(this.try(string3));
                continue;
            }
            if (string3.startsWith("Bad-Record-Handling:")) {
                importOptions.getDataOptions().setBadRecordHandling(this.i(string3));
                continue;
            }
            if (string3.startsWith("Duplicate-Id-Handling:")) {
                importOptions.getDataOptions().setDuplicateIdHandling(this.j(string3));
                continue;
            }
            if (string3.startsWith("Strip-White-Space:")) {
                boolean bl3 = this.goto(string3);
                importOptions.getDataOptions().setStripLeading(bl3);
                importOptions.getDataOptions().setStripTrailing(bl3);
                continue;
            }
            if (string3.startsWith("Truncate-Values:")) {
                importOptions.getDataOptions().setTruncate(this.a(string3));
                continue;
            }
            if (string3.startsWith("Disable-Required-ness:")) {
                importOptions.getDataOptions().setDisableRequired(this.d(string3));
                continue;
            }
            if (string3.startsWith("Disable-Pattern:")) {
                importOptions.getDataOptions().setDisablePattern(this.b(string3));
                continue;
            }
            if (string3.startsWith("Allow-Too-Many-Fields:")) {
                importOptions.getDataOptions().setAllowTooMany(this.long(string3));
                continue;
            }
            if (string3.startsWith("Allow-Too-Few-Fields:")) {
                importOptions.getDataOptions().setAllowTooFew(this.do(string3));
                continue;
            }
            if (string3.startsWith("Mapping:")) {
                this.a(string3, false, mappingOptions);
                continue;
            }
            if (string3.startsWith("Fallback-Mapping:")) {
                this.a(string3, true, mappingOptions);
                continue;
            }
            if (string3.startsWith("end")) {
                bl2 = true;
                continue;
            }
            if (string3.startsWith("Import-Log-Filename:")) {
                importOptions.setLogFile(this.e(string3));
                continue;
            }
            if (string3.startsWith("24-Hour-Format:")) {
                importOptions.getDataOptions().setUse24Hour(this.h(string3));
                continue;
            }
            if (string3.startsWith("Time-Separator:")) {
                importOptions.getDataOptions().setTimeSeperator(this.byte(string3));
                continue;
            }
            if (string3.startsWith("Date-Separator:")) {
                importOptions.getDataOptions().setDateSeperator(this.int(string3));
                continue;
            }
            if (string3.startsWith("Long-Date-Format:")) {
                importOptions.getDataOptions().setDateTimeFormat(this.void(string3));
                continue;
            }
            if (string3.startsWith("Short-Date-Format:")) {
                importOptions.getDataOptions().setDateFormat(this.new(string3));
                continue;
            }
            if (string3.startsWith("Morning-String:")) {
                importOptions.getDataOptions().setAMString(this.for(string3));
                continue;
            }
            if (string3.startsWith("Afternoon-String:")) {
                importOptions.getDataOptions().setPMString(this.case(string3));
                continue;
            }
            if (string3.startsWith("Digit-Group-Separator:")) {
                importOptions.getDataOptions().setDigitGroupSeparator(this.g(string3));
                continue;
            }
            if (!string3.startsWith("Decimal-Separator:")) continue;
            importOptions.getDataOptions().setDecimalSeparator(this.k(string3));
        }
        stringBuffer.append(System.getProperty("line.separator"));
        if (logger.isInfoEnabled()) {
            logger.info((Object)MessageFormat.format(ImportErrors.MAPPING.toDefMsg(), string, stringBuffer.toString()));
        }
        if (fileInputStream == null) return;
        try {
            fileInputStream.close();
            return;
        }
        catch (IOException iOException) {
            logger.warn((Object)MessageFormat.format(ImportErrors.NOT_CLOSE_ARM_FILE.toDefMsg(), System.getProperty("line.separator"), iOException.getMessage()));
        }
        return;
        catch (IOException iOException) {
            try {
                if (logger.isEnabledFor((Priority)Level.ERROR)) {
                    logger.error((Object)MessageFormat.format(ImportErrors.EXCEPTION_AT_PARSING_ARM.toDefMsg(), iOException.getMessage()));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)ImportErrors.EXCEPTION_AT_PARSING_ARM_FILE.toDefMsg(), (Throwable)iOException);
                }
                if (fileInputStream == null) return;
            }
            catch (Throwable throwable) {
                if (fileInputStream == null) throw throwable;
                try {
                    fileInputStream.close();
                    throw throwable;
                }
                catch (IOException iOException2) {
                    logger.warn((Object)MessageFormat.format(ImportErrors.NOT_CLOSE_ARM_FILE.toDefMsg(), System.getProperty("line.separator"), iOException2.getMessage()));
                }
                throw throwable;
            }
            try {
                fileInputStream.close();
                return;
            }
            catch (IOException iOException3) {
                logger.warn((Object)MessageFormat.format(ImportErrors.NOT_CLOSE_ARM_FILE.toDefMsg(), System.getProperty("line.separator"), iOException3.getMessage()));
            }
            return;
        }
    }

    private boolean h(String string) throws ARImportException {
        if (string.length() > "24-Hour-Format:".length() + 1) {
            return Integer.parseInt(string.substring("24-Hour-Format:".length()).trim()) == 1;
        }
        throw new ARImportException("24-Hour-Format:is not defined");
    }

    private String byte(String string) throws ARImportException {
        if (string.length() > "Time-Separator:".length() + 1) {
            return string.substring("Time-Separator:".length()).trim();
        }
        throw new ARImportException("Time-Separator:is not defined");
    }

    private String int(String string) throws ARImportException {
        if (string.length() > "Date-Separator:".length() + 1) {
            return string.substring("Date-Separator:".length()).trim();
        }
        throw new ARImportException("Date-Separator:is not defined");
    }

    private String new(String string) throws ARImportException {
        if (string.length() > "Short-Date-Format:".length() + 1) {
            return string.substring("Short-Date-Format:".length()).trim();
        }
        throw new ARImportException("Short-Date-Format:is not defined");
    }

    private String void(String string) throws ARImportException {
        if (string.length() > "Long-Date-Format:".length() + 1) {
            return string.substring("Long-Date-Format:".length()).trim();
        }
        throw new ARImportException("Long-Date-Format:is not defined");
    }

    private String for(String string) throws ARImportException {
        if (string.length() > "Morning-String:".length() + 1) {
            return string.substring("Morning-String:".length()).trim();
        }
        throw new ARImportException("Morning-String:is not defined");
    }

    private String case(String string) throws ARImportException {
        if (string.length() > "Afternoon-String:".length() + 1) {
            return string.substring("Afternoon-String:".length()).trim();
        }
        throw new ARImportException("Afternoon-String:is not defined");
    }

    private String g(String string) throws ARImportException {
        if (string.length() > "Digit-Group-Separator:".length() + 1) {
            return string.substring("Digit-Group-Separator:".length()).trim();
        }
        throw new ARImportException("Digit-Group-Separator:is not defined");
    }

    private String k(String string) throws ARImportException {
        if (string.length() > "Decimal-Separator:".length() + 1) {
            return string.substring("Decimal-Separator:".length()).trim();
        }
        throw new ARImportException("Decimal-Separator:is not defined");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToARM(ImportOptions importOptions, String string, boolean bl) throws IOException, ARImportException, NullPointerException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = bl ? new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8") : new OutputStreamWriter(fileOutputStream);
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            if (importOptions.getFirstFileForm() == null) {
                throw new ARImportException("No Form Information found in the data file");
            }
            String string2 = importOptions.getFirstFileForm().getName();
            MappingOptions mappingOptions = importOptions.getMappingOptions(string2, string2);
            if (mappingOptions == null) {
                throw new NullPointerException("Mapping information cannot be null");
            }
            if (mappingOptions.getMappingName() == null || mappingOptions.getMappingName().length() < 1) {
                mappingOptions.setMappingName(string);
            }
            bufferedWriter.write(mappingOptions.getMappingName() + bp);
            bufferedWriter.write("SchemaName: " + string2 + bp);
            bufferedWriter.write("ServerName: " + importOptions.getContext().getServer() + bp);
            bufferedWriter.write("Import-Filename: " + importOptions.getFileOptions().getDataFile() + bp);
            bufferedWriter.write("Import-File-Format: " + Integer.toString(this.f(importOptions.getFileOptions().getType())) + bp);
            bufferedWriter.write("Import-Field-Titles: " + (importOptions.getFileOptions().isHasTitles() ? "1" : "0") + bp);
            bufferedWriter.write("Import-Field-Separator: " + importOptions.getFileOptions().getSeparator() + bp);
            bufferedWriter.write("Bad-Record-Handling: " + Integer.toString(importOptions.getDataOptions().getBadRecordHandling().getARMValue()) + bp);
            bufferedWriter.write("Duplicate-Id-Handling: " + Integer.toString(importOptions.getDataOptions().getDuplicateIdHandling().getARMValue()) + bp);
            bufferedWriter.write("Strip-White-Space: " + (importOptions.getDataOptions().isStripLeading() || importOptions.getDataOptions().isStripTrailing() ? "1" : "0") + bp);
            bufferedWriter.write("Truncate-Values: " + (importOptions.getDataOptions().isTruncate() ? "1" : "0") + bp);
            bufferedWriter.write("Disable-Required-ness: " + (importOptions.getDataOptions().isDisableRequired() ? "1" : "0") + bp);
            bufferedWriter.write("Disable-Pattern: " + (importOptions.getDataOptions().isDisablePattern() ? "1" : "0") + bp);
            bufferedWriter.write("Allow-Too-Many-Fields: " + (importOptions.getDataOptions().isAllowTooMany() ? "1" : "0") + bp);
            bufferedWriter.write("Allow-Too-Few-Fields: " + (importOptions.getDataOptions().isAllowTooFew() ? "1" : "0") + bp);
            if (importOptions.getLogFile() != null && importOptions.getLogFile().length() > 0) {
                bufferedWriter.write("Import-Log-Filename: " + importOptions.getLogFile() + bp);
            }
            bufferedWriter.write("24-Hour-Format: " + (importOptions.getDataOptions().is24Hour() ? "1" : "0") + bp);
            if (importOptions.getDataOptions().getTimeSeperator() != null && importOptions.getDataOptions().getTimeSeperator().length() > 0) {
                bufferedWriter.write("Time-Separator: " + importOptions.getDataOptions().getTimeSeperator() + bp);
            }
            if (importOptions.getDataOptions().getDateSeperator() != null && importOptions.getDataOptions().getDateSeperator().length() > 0) {
                bufferedWriter.write("Date-Separator: " + importOptions.getDataOptions().getDateSeperator() + bp);
            }
            if (importOptions.getDataOptions().getDateTimeFormat() != null && importOptions.getDataOptions().getDateTimeFormat().length() > 0) {
                bufferedWriter.write("Long-Date-Format: " + importOptions.getDataOptions().getDateTimeFormat() + bp);
            }
            if (importOptions.getDataOptions().getDateFormat() != null && importOptions.getDataOptions().getDateFormat().length() > 0) {
                bufferedWriter.write("Short-Date-Format: " + importOptions.getDataOptions().getDateFormat() + bp);
            }
            if (importOptions.getDataOptions().getAMString() != null && importOptions.getDataOptions().getAMString().length() > 0) {
                bufferedWriter.write("Morning-String: " + importOptions.getDataOptions().getAMString() + bp);
            }
            if (importOptions.getDataOptions().getPMString() != null && importOptions.getDataOptions().getPMString().length() > 0) {
                bufferedWriter.write("Afternoon-String: " + importOptions.getDataOptions().getPMString() + bp);
            }
            bufferedWriter.write("Digit-Group-Separator: " + importOptions.getDataOptions().getDigitGroupSeparator() + bp);
            bufferedWriter.write("Decimal-Separator: " + importOptions.getDataOptions().getDecimalSeparator() + bp);
            if (mappingOptions.getMappings() != null) {
                for (int n : mappingOptions.getMappings().keySet()) {
                    bufferedWriter.write("Mapping: " + n + mappingOptions.getMappings().get(n).toARMString() + bp);
                }
            }
            if (mappingOptions.getFallbacks() != null) {
                for (int n : mappingOptions.getFallbacks().keySet()) {
                    bufferedWriter.write("Fallback-Mapping: " + n + '=' + mappingOptions.getFallbacks().get(n).fallBackToArmString() + bp);
                }
            }
            bufferedWriter.write("end\r\n");
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    private int f(String string) throws ARImportException {
        if (string != null) {
            if (string.equals("ARX")) {
                return 3;
            }
            if (string.equals("XML")) {
                return 4;
            }
            if (string.equals("CSV")) {
                return 2;
            }
            if (string.equals("ASC")) {
                return 1;
            }
        }
        throw new ARImportException("Unsupported data file type specified");
    }

    private String e(String string) throws ARImportException {
        if (string.length() > "Import-Log-Filename:".length() + 1) {
            return string.substring("Import-Log-Filename:".length()).trim();
        }
        throw new ARImportException("Import-Log-Filename:is not defined");
    }

    public final ImportOptions getOptions() {
        return this.bn;
    }

    public final void setOptions(ImportOptions importOptions) {
        this.bn = importOptions;
    }
}

