/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.data;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.Field;
import com.bmc.arsys.apiext.data.FieldInformation;
import com.bmc.arsys.apiext.data.FormInformation;
import com.bmc.arsys.apiext.data.ImportErrors;
import com.bmc.arsys.apiext.data.ImportOptions;
import com.bmc.arsys.apiext.data.Mapping;
import com.bmc.arsys.apiext.data.MappingOptions;
import com.bmc.arsys.apiext.data.ThreadLocalStorage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Util {
    private static final Util a = new Util();
    private static final String do = "Field ";
    public static final String ARIMPORT_FILE_APPENDER = "ARIMPORT_FILE_APPENDER";
    private static final PatternLayout if = new PatternLayout("%m%n");
    private FileAppender for = null;
    public static final String dot = ".";

    private Util() {
    }

    public static int countDelimeters(String string, String string2) {
        int n = string2.length();
        int n2 = 0;
        int n3 = string.indexOf(string2);
        while (n3 != -1) {
            ++n2;
            n3 = string.indexOf(string2, n3 + n);
        }
        return n2;
    }

    public static long secondsSinceMidnight(Calendar calendar) {
        Calendar calendar2 = calendar;
        if (calendar2 == null) {
            calendar2 = Calendar.getInstance();
            calendar2.setTime(new Date());
        }
        return calendar2.get(39600) + calendar2.get(720) + calendar2.get(13);
    }

    public static MappingOptions generateMappingsForARX(FormInformation formInformation, FormInformation formInformation2) {
        Logger logger = ThreadLocalStorage.getLogger();
        MappingOptions mappingOptions = new MappingOptions();
        if (logger.isInfoEnabled()) {
            logger.info((Object)ImportErrors.GENERATE_MAPPING_INFO.toDefMsg());
        }
        for (FieldInformation fieldInformation : formInformation.getFields().values()) {
            if (fieldInformation.getDataType() == null) continue;
            Mapping mapping = new Mapping();
            mapping.setType(Mapping.Type.FIELDID);
            mapping.setFieldId(fieldInformation.getFieldId());
            mapping.setFieldName(fieldInformation.getName());
            FieldInformation fieldInformation2 = formInformation2.getFields().get(fieldInformation.getFieldId());
            if (fieldInformation2 == null || !fieldInformation.getDataType().equals((Object)fieldInformation2.getDataType())) continue;
            mapping.setTokenIndex(fieldInformation2.getTokenIndex());
            mappingOptions.addMapping(fieldInformation.getFieldId(), mapping);
        }
        return mappingOptions;
    }

    public static MappingOptions generateMappingsForTextFiles(FormInformation formInformation, List<String> list, boolean bl) {
        Logger logger = ThreadLocalStorage.getLogger();
        MappingOptions mappingOptions = new MappingOptions();
        if (logger.isInfoEnabled()) {
            logger.info((Object)ImportErrors.GENERATE_MAPPING_INFO.toDefMsg());
        }
        for (FieldInformation fieldInformation : formInformation.getFields().values()) {
            int n;
            if (fieldInformation.getFieldId() == 15 || (n = list.indexOf(fieldInformation.getName())) == -1) continue;
            Mapping mapping = new Mapping();
            mapping.setType(Mapping.Type.FIELDID);
            mapping.setFieldId(n);
            mapping.setTokenIndex(n);
            if (bl) {
                mapping.setFieldName(list.get(n));
            } else {
                mapping.setFieldName(do + n);
            }
            mappingOptions.addMapping(fieldInformation.getFieldId(), mapping);
        }
        return mappingOptions;
    }

    public static MappingOptions generateMappingsForTextFiles(FormInformation formInformation, FormInformation formInformation2) {
        Logger logger = ThreadLocalStorage.getLogger();
        MappingOptions mappingOptions = new MappingOptions();
        if (logger.isInfoEnabled()) {
            logger.info((Object)ImportErrors.GENERATE_MAPPING_INFO.toDefMsg());
        }
        for (FieldInformation fieldInformation : formInformation.getFields().values()) {
            int n;
            if (fieldInformation.getFieldId() == 15) continue;
            FieldInformation fieldInformation2 = null;
            for (FieldInformation fieldInformation3 : formInformation2.getFields().values()) {
                if (!fieldInformation.getName().equals(fieldInformation3.getName())) continue;
                fieldInformation2 = fieldInformation3;
                break;
            }
            if (fieldInformation2 == null || (n = fieldInformation2.getTokenIndex()) == -1) continue;
            Mapping mapping = new Mapping();
            mapping.setType(Mapping.Type.FIELDID);
            mapping.setFieldId(n);
            mapping.setTokenIndex(n);
            mapping.setFieldName(fieldInformation2.getName());
            mappingOptions.addMapping(fieldInformation.getFieldId(), mapping);
        }
        return mappingOptions;
    }

    public static Util getInstance() {
        return a;
    }

    public static FormInformation getServerForm(ImportOptions importOptions, String string) throws ARException {
        FormInformation formInformation = new FormInformation();
        List list = importOptions.getContext().getListFieldObjects(string, 1);
        if (list != null) {
            for (Field field : list) {
                FieldInformation fieldInformation = new FieldInformation();
                fieldInformation.setFieldId(field.getFieldID());
                fieldInformation.setDataType(DataType.toDataType((int)field.getDataType()));
                fieldInformation.setDefaultValue(field.getDefaultValue());
                fieldInformation.setLimit(field.getFieldLimit());
                fieldInformation.setName(field.getName());
                fieldInformation.setFieldOption(field.getFieldOption());
                formInformation.getFields().put(fieldInformation.getFieldId(), fieldInformation);
            }
        }
        formInformation.setName(string);
        formInformation.setServer(importOptions.getContext().getServer());
        return formInformation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String findMappingFile(String string, String string2, String string3) throws IOException {
        String string4 = null;
        if (string == null || string.length() == 0) {
            string = new File(dot).getCanonicalPath();
        }
        File file = new File(string);
        String[] stringArray = file.list();
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.toUpperCase().endsWith(".ARM");
            }
        };
        stringArray = file.list(filenameFilter);
        if (stringArray == null) {
            throw new IOException(ImportErrors.IO_ERROR_ON_MAPPING_DIR_RETRIEVE.toDefMsg() + string);
        }
        for (String string5 : stringArray) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file.getCanonicalPath() + System.getProperty("file.separator") + string5);
                InputStreamReader inputStreamReader = null;
                inputStreamReader = string3 != null && string3.length() > 0 ? new InputStreamReader((InputStream)fileInputStream, string3) : new InputStreamReader(fileInputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string6 = bufferedReader.readLine();
                if (string6 != null && string6.equals(string2)) {
                    string4 = string5;
                }
                bufferedReader.close();
            }
            finally {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
        }
        return string + "/" + string4;
    }

    public static void logEntry(String string) {
        Logger logger = ThreadLocalStorage.getLogger();
        if (logger.isInfoEnabled() && Util.getInstance().getFileAppender() != null) {
            Layout layout = Util.getInstance().getFileAppender().getLayout();
            Util.getInstance().getFileAppender().setLayout((Layout)if);
            logger.info((Object)string);
            Util.getInstance().getFileAppender().setLayout(layout);
        }
    }

    public void setFileAppender(FileAppender fileAppender) {
        this.for = fileAppender;
    }

    public FileAppender getFileAppender() {
        return this.for;
    }
}

