/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.data;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.CurrencyValue;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.apiext.data.ARImportException;
import com.bmc.arsys.apiext.data.BaseObject;
import com.bmc.arsys.apiext.data.Converter;
import com.bmc.arsys.apiext.data.DataOptions;
import com.bmc.arsys.apiext.data.FieldInformation;
import com.bmc.arsys.apiext.data.FormInformation;
import com.bmc.arsys.apiext.data.IParser;
import com.bmc.arsys.apiext.data.ImportErrors;
import com.bmc.arsys.apiext.data.ImportOptions;
import com.bmc.arsys.apiext.data.KeywordExpander;
import com.bmc.arsys.apiext.data.Mapping;
import com.bmc.arsys.apiext.data.MappingOptions;
import com.bmc.arsys.apiext.data.RecordResult;
import com.bmc.arsys.apiext.data.ThreadLocalStorage;
import java.text.MessageFormat;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryFactory
extends BaseObject {
    private ImportOptions bq = null;
    private FormInformation bs = null;
    private FormInformation bt = null;
    private Converter br = null;
    private KeywordExpander bv = null;
    private IParser bu = null;
    public static final String dollar = "$";
    public static final char currencySeparator = '\u0004';

    public EntryFactory(IParser iParser, ImportOptions importOptions, String string, String string2, Converter converter, KeywordExpander keywordExpander) throws ARImportException {
        this.bu = iParser;
        this.bq = importOptions;
        this.bs = importOptions.getFileForms().get(string);
        this.bt = importOptions.getServerForms().get(string2);
        if (this.bs == null || this.bt == null) {
            throw new ARImportException(ImportErrors.FORMS_NOT_FOUND.toDefMsg());
        }
        this.br = converter;
        this.bv = keywordExpander;
    }

    public EntryFactory(IParser iParser, ImportOptions importOptions, String string, String string2) throws ARImportException {
        this(iParser, importOptions, string2, string2, new Converter(importOptions), new KeywordExpander(importOptions));
    }

    public EntryFactory(IParser iParser, ImportOptions importOptions, FormInformation formInformation, FormInformation formInformation2) throws ARImportException {
        this.bu = iParser;
        this.bq = importOptions;
        this.bs = formInformation;
        this.bt = formInformation2;
        if (formInformation == null || formInformation2 == null) {
            throw new ARImportException(ImportErrors.FORMS_NOT_FOUND.toDefMsg());
        }
        this.br = new Converter(importOptions);
        this.bv = new KeywordExpander(importOptions);
    }

    public ImportOptions getOptions() {
        return this.bq;
    }

    public void setOptions(ImportOptions importOptions) {
        this.bq = importOptions;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Entry createEntry(List<String> list, String string) throws ARImportException, NullPointerException, ARException, Exception {
        Entry entry;
        Logger logger;
        block50: {
            Object object;
            Object object2;
            logger = ThreadLocalStorage.getLogger();
            entry = new Entry();
            MappingOptions mappingOptions = this.bq.getMappingOptions(this.bs.getName(), this.bt.getName());
            if (mappingOptions == null) {
                mappingOptions = this.bq.getMappingOptions("ARImport_Data_Holder", this.bt.getName());
            }
            if (mappingOptions == null) {
                throw new NullPointerException(ImportErrors.MAP_INFO_NULL.toDefMsg());
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)MessageFormat.format(ImportErrors.CREATE_ENTRY.toDefMsg(), list));
            }
            this.applyMappings(mappingOptions, this.bs, this.bt, list);
            for (Integer n : mappingOptions.getMappings().keySet()) {
                Value value;
                Object object3;
                FieldInformation fieldInformation;
                try {
                    object2 = mappingOptions.getMappings().get(n);
                    fieldInformation = this.bt.getFields().get(n);
                    if (fieldInformation == null || fieldInformation.getDataType() == null) continue;
                    if (((Mapping)object2).getType() == Mapping.Type.CONSTANT) {
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)MessageFormat.format(ImportErrors.SET_VALUE_FOR_CONSTANT.toDefMsg(), String.valueOf(fieldInformation.getFieldId()), object2));
                        }
                        entry.put(Integer.valueOf(fieldInformation.getFieldId()), new Value(((Mapping)object2).getConstant()));
                        continue;
                    }
                    if (((Mapping)object2).getType() == Mapping.Type.COMPOUND) {
                        Value value2 = this.br.convertToARValue(fieldInformation, ((Mapping)object2).getCompoundValue());
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)MessageFormat.format(ImportErrors.SET_VALUE_FOR_FIELD.toDefMsg(), String.valueOf(fieldInformation.getFieldId()), value2, object2));
                        }
                        entry.put(Integer.valueOf(fieldInformation.getFieldId()), value2);
                        continue;
                    }
                    if (((Mapping)object2).getType() == Mapping.Type.KEYWORD) {
                        Value value3 = this.br.getKeywordValue(fieldInformation, (Mapping)object2);
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)MessageFormat.format(ImportErrors.SET_VALUE_FOR_FIELD.toDefMsg(), String.valueOf(fieldInformation.getFieldId()), value3, object2));
                        }
                        entry.put(Integer.valueOf(fieldInformation.getFieldId()), value3);
                        continue;
                    }
                    int n2 = ((Mapping)object2).getTokenIndex();
                    if (n2 <= -1 || n2 > list.size() - 1) continue;
                    object3 = list.get(n2);
                    value = this.br.convertToARValue(fieldInformation, (String)object3);
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)MessageFormat.format(ImportErrors.SET_VALUE_FOR_FIELD.toDefMsg(), String.valueOf(fieldInformation.getFieldId()), value, object2));
                    }
                    entry.put(Integer.valueOf(fieldInformation.getFieldId()), value);
                }
                catch (Exception exception) {
                    fieldInformation = this.bt.getFields().get(n);
                    int n3 = fieldInformation.getFieldId();
                    this.applyFallbackMappings(mappingOptions, this.bs, this.bt, list, n3);
                    if (!mappingOptions.getFallbacks().keySet().contains(n3)) {
                        throw exception;
                    }
                    object3 = mappingOptions.getFallbacks().get(n3);
                    if (object3 == null) continue;
                    if (((Mapping)object3).getType() == Mapping.Type.CONSTANT) {
                        entry.put(Integer.valueOf(n3), new Value(((Mapping)object3).getConstant()));
                        continue;
                    }
                    if (((Mapping)object3).getType() == Mapping.Type.COMPOUND) {
                        value = this.br.convertToARValue(fieldInformation, ((Mapping)object3).getCompoundValue());
                        entry.put(Integer.valueOf(n3), value);
                        continue;
                    }
                    if (((Mapping)object3).getType() == Mapping.Type.KEYWORD) {
                        value = this.br.getKeywordValue(fieldInformation, (Mapping)object3);
                        entry.put(Integer.valueOf(n3), value);
                        continue;
                    }
                    int n4 = ((Mapping)object3).getTokenIndex();
                    if (n4 <= -1 || n4 > list.size() - 1) continue;
                    String string2 = list.get(n4);
                    Value value4 = this.br.convertToARValue(fieldInformation, string2);
                    entry.put(Integer.valueOf(n3), value4);
                }
            }
            if (entry.isEmpty()) {
                if (this.bq.getDataOptions().getBadRecordHandling().equals((Object)DataOptions.BadRecords.SKIP) && logger.isInfoEnabled()) {
                    logger.info((Object)MessageFormat.format(ImportErrors.UNABLE_TO_DETERMINE_FIELD_VALUE_FOR_RECORD.toDefMsg(), list.size(), this.bt.getFields().size(), System.getProperty("line.separator"), string));
                }
            } else if (this.bt.getFormType() == 1 && this.bq.getDataOptions().isDisableRequired()) {
                for (Integer n : this.getTargetForm().getFields().keySet()) {
                    if (n <= 8 || entry.containsKey((Object)n) || (object2 = this.getTargetForm().getFields().get(n)) == null || ((FieldInformation)object2).getFieldOption() != 1 || this.bq.getDataOptions().getDuplicateIdHandling().getMergeOption() == 4 || ((FieldInformation)object2).getDefaultValue().getValue() != null) continue;
                    entry.put(n, new Value());
                }
            }
            if (this.bq.getFileForms().get(this.bs.getName()).getFields().size() > list.size()) {
                if (!this.bq.getDataOptions().isAllowTooFew()) {
                    object = MessageFormat.format(ImportErrors.TOO_FEW_FIELDS.toDefMsg(), list.size(), this.bq.getFileForms().get(this.bs.getName()).getFields().size());
                    if (this.bq.getDataOptions().getBadRecordHandling() == DataOptions.BadRecords.ALERTUSER) {
                        if (this.bq.getUserAlertListener() != null) {
                            int n = this.bq.getUserAlertListener().handleUserAlert(this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), string, (String)object);
                            switch (n) {
                                case 0: {
                                    if (logger.isInfoEnabled()) {
                                        logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_ERROR.toDefMsg(), this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), object, System.getProperty("line.separator"), string));
                                        logger.info((Object)ImportErrors.STOP_ON_FIRST_FAILURE_BY_USER.toDefMsg());
                                    }
                                    if (this.a() == null) break;
                                    this.a().setAbort(true);
                                    break;
                                }
                                case 2: {
                                    if (logger.isInfoEnabled()) {
                                        logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_ERROR.toDefMsg(), this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), object, System.getProperty("line.separator"), string));
                                        logger.info((Object)ImportErrors.STOP_ON_FIRST_FAILURE_BY_USER_COPY_REST.toDefMsg());
                                    }
                                    if (this.a() == null) break;
                                    this.a().setAbort(true);
                                    this.a().setCopyToLog(true);
                                    break;
                                }
                                default: {
                                    if (!logger.isInfoEnabled()) break;
                                    logger.info((Object)ImportErrors.SKIP_RECORD_INSTRUCTED_BY_USER.toDefMsg());
                                    logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_ERROR.toDefMsg(), this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), object, System.getProperty("line.separator"), string));
                                }
                            }
                            this.getOptions().getResults().addError(this.bt.getName(), new RecordResult(this.bs.getName(), this.bt.getName(), RecordResult.Status.ERROR, this.getOptions().getResults().getRecordCount(this.bt.getName()), (String)object, null));
                            return null;
                        }
                        break block50;
                    } else {
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)ImportErrors.SKIP_RECORD.toDefMsg());
                            logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_ERROR.toDefMsg(), this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), object, System.getProperty("line.separator"), string));
                        }
                        this.getOptions().getResults().addError(this.bt.getName(), new RecordResult(this.bs.getName(), this.bt.getName(), RecordResult.Status.ERROR, this.getOptions().getResults().getRecordCount(this.bt.getName()), (String)object, null));
                        return null;
                    }
                }
                object = MessageFormat.format(ImportErrors.TOO_FEW_FIELDS_FOUND.toDefMsg(), list.size(), this.bq.getFileForms().get(this.bs.getName()).getFields().size(), System.getProperty("line.separator"), string);
                if (logger.isEnabledFor((Priority)Level.WARN)) {
                    logger.warn(object);
                }
                this.getOptions().getResults().addWarning(this.bt.getName(), new RecordResult(this.bs.getName(), this.bt.getName(), RecordResult.Status.WARN, this.getOptions().getResults().getRecordCount(this.bt.getName()), (String)object, null));
            } else if (this.bq.getFileForms().get(this.bs.getName()).getFields().size() < list.size()) {
                if (!this.bq.getDataOptions().isAllowTooMany()) {
                    object = MessageFormat.format(ImportErrors.TOO_MANY_FIELDS.toDefMsg(), list.size(), this.bq.getFileForms().get(this.bs.getName()).getFields().size());
                    if (this.bq.getDataOptions().getBadRecordHandling() == DataOptions.BadRecords.ALERTUSER) {
                        if (this.bq.getUserAlertListener() != null) {
                            int n = this.bq.getUserAlertListener().handleUserAlert(this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), string, (String)object);
                            switch (n) {
                                case 0: {
                                    if (logger.isInfoEnabled()) {
                                        logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_ERROR.toDefMsg(), this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), object, System.getProperty("line.separator"), string));
                                        logger.info((Object)ImportErrors.STOP_ON_FIRST_FAILURE_BY_USER.toDefMsg());
                                    }
                                    if (this.a() == null) break;
                                    this.a().setAbort(true);
                                    break;
                                }
                                case 2: {
                                    if (logger.isInfoEnabled()) {
                                        logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_ERROR.toDefMsg(), this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), object, System.getProperty("line.separator"), string));
                                        logger.info((Object)ImportErrors.STOP_ON_FIRST_FAILURE_BY_USER_COPY_REST.toDefMsg());
                                    }
                                    if (this.a() == null) break;
                                    this.a().setAbort(true);
                                    this.a().setCopyToLog(true);
                                    break;
                                }
                                default: {
                                    if (!logger.isInfoEnabled()) break;
                                    logger.info((Object)ImportErrors.SKIP_RECORD_INSTRUCTED_BY_USER.toDefMsg());
                                    logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_ERROR.toDefMsg(), this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), object, System.getProperty("line.separator"), string));
                                }
                            }
                            this.getOptions().getResults().addError(this.bt.getName(), new RecordResult(this.bs.getName(), this.bt.getName(), RecordResult.Status.ERROR, this.getOptions().getResults().getRecordCount(this.bt.getName()), (String)object, null));
                            return null;
                        }
                        break block50;
                    } else {
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)ImportErrors.SKIP_RECORD.toDefMsg());
                            logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_ERROR.toDefMsg(), this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), object, System.getProperty("line.separator"), string));
                        }
                        this.getOptions().getResults().addError(this.bt.getName(), new RecordResult(this.bs.getName(), this.bt.getName(), RecordResult.Status.ERROR, this.getOptions().getResults().getRecordCount(this.bt.getName()), (String)object, null));
                        return null;
                    }
                }
                object = MessageFormat.format(ImportErrors.TOO_MANY_FIELDS_FOUND.toDefMsg(), list.size(), this.bq.getFileForms().get(this.bs.getName()).getFields().size(), System.getProperty("line.separator"), string);
                if (logger.isEnabledFor((Priority)Level.WARN)) {
                    logger.warn(object);
                }
                this.getOptions().getResults().addWarning(this.bt.getName(), new RecordResult(this.bs.getName(), this.bt.getName(), RecordResult.Status.WARN, this.getOptions().getResults().getRecordCount(this.bt.getName()), (String)object, null));
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)MessageFormat.format(ImportErrors.NEW_ENTRY.toDefMsg(), entry));
        }
        return entry;
    }

    public void applyMappings(MappingOptions mappingOptions, FormInformation formInformation, FormInformation formInformation2, List<String> list) throws ARException {
        boolean bl = this.bq.getDataOptions().isSuppressDefaults();
        for (Integer n : mappingOptions.getMappings().keySet()) {
            Mapping mapping = mappingOptions.getMappings().get(n);
            FieldInformation fieldInformation = formInformation2.getFields().get(n);
            if (mapping.getType() == Mapping.Type.COMPOUND) {
                String string = this.bv.expandAllKeywords(mapping.getCompound(), formInformation2, fieldInformation);
                if (string != null) {
                    string = this.a(string, formInformation, formInformation2, list);
                }
                mapping.setCompoundValue(string);
                continue;
            }
            int n2 = mapping.getTokenIndex();
            if (n2 <= -1 || n2 > list.size() - 1) continue;
            String string = list.get(n2);
            if (bl || string != null && string.length() != 0 || fieldInformation == null || fieldInformation.getDefaultValue() == null || fieldInformation.getDefaultValue().getDataType().equals((Object)DataType.NULL)) continue;
            string = fieldInformation.getDataType() == DataType.CURRENCY ? this.a(fieldInformation.getDefaultValue()) : fieldInformation.getDefaultValue().getValue().toString();
            string = this.bv.expandAllKeywords(string, formInformation2, fieldInformation);
            list.set(n2, string);
        }
    }

    private String a(Value value) {
        CurrencyValue currencyValue = (CurrencyValue)value.getValue();
        String string = currencyValue.getValueString() + Character.toString('\u0004') + currencyValue.getCurrencyCode() + Character.toString('\u0004') + currencyValue.getConversionDate().getValue() + Character.toString('\u0004');
        return string;
    }

    protected String getFieldValue(FormInformation formInformation, String string, List<String> list) {
        int n = -1;
        for (FieldInformation fieldInformation : formInformation.getFields().values()) {
            if (!fieldInformation.getName().equals(string)) continue;
            n = fieldInformation.getFieldId();
            break;
        }
        return this.getFieldValue(formInformation, n, list);
    }

    protected String getFieldValue(FormInformation formInformation, int n, List<String> list) {
        int n2 = -1;
        if (formInformation.getFields().containsKey(n)) {
            n2 = formInformation.getFields().get(n).getTokenIndex();
        }
        return list.get(n2);
    }

    private String a(String string, FormInformation formInformation, FormInformation formInformation2, List<String> list) {
        for (FieldInformation fieldInformation : formInformation.getFields().values()) {
            String string2 = dollar + fieldInformation.getFieldId() + dollar;
            String string3 = list.get(fieldInformation.getTokenIndex());
            string = string.replace(string2, string3);
        }
        return string;
    }

    public FormInformation getSourceForm() {
        return this.bs;
    }

    public void setSourceForm(FormInformation formInformation) {
        this.bs = formInformation;
    }

    public FormInformation getTargetForm() {
        return this.bt;
    }

    public void setTargetForm(FormInformation formInformation) {
        this.bt = formInformation;
    }

    private IParser a() {
        return this.bu;
    }

    protected void setLastId(String string) {
        if (this.bv != null) {
            this.bv.setLastId(string);
        }
    }

    public void applyFallbackMappings(MappingOptions mappingOptions, FormInformation formInformation, FormInformation formInformation2, List<String> list, Integer n) throws ARException {
        Mapping mapping = mappingOptions.getFallbacks().get(n);
        if (mapping != null && mapping.getType() == Mapping.Type.COMPOUND) {
            FieldInformation fieldInformation = formInformation2.getFields().get(n);
            if (fieldInformation == null) {
                throw new NullPointerException("Field id " + n + "does not exist on schema: " + formInformation2.getName());
            }
            String string = this.bv.expandAllKeywords(mapping.getCompound(), formInformation2, fieldInformation);
            if (string != null) {
                string = this.a(string, formInformation, formInformation2, list);
            }
            mapping.setCompoundValue(string);
        }
    }
}

