/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr.plugins;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.arrpc.ArEsControlStruct4;
import com.bmc.arsys.arrpc.ArEsFilterApi4In;
import com.bmc.arsys.arrpc.ArEsFilterApi4Out;
import com.bmc.arsys.arrpc.ArStatusList6;
import com.bmc.arsys.arrpc.ArStatusStruct6;
import com.bmc.arsys.arrpc.ArValueList;
import com.bmc.arsys.arrpc.ArValueStruct;
import com.bmc.arsys.pluginsvr.ARPluginSvrThreadLocalStorageBlock;
import com.bmc.arsys.pluginsvr.mapping.ApiToRpcMapping;
import com.bmc.arsys.pluginsvr.plugins.ARFilterAPIPluggable;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import com.bmc.arsys.pluginsvr.plugins.ARPluginRepository;
import com.bmc.arsys.pluginsvr.plugins.PluginEnvelope;
import com.bmc.arsys.pluginsvr.plugins.ValueObjectFactory;
import com.bmc.arsys.utils.CatalogReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ARFilterAPIPluginRepository
extends ARPluginRepository {
    private static Logger LOGGER = Logger.getLogger(ARFilterAPIPluginRepository.class);
    protected ConcurrentHashMap<String, PluginEnvelope> mPlugins = new ConcurrentHashMap();

    ARFilterAPIPluginRepository() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArEsFilterApi4Out ARFilterApiCall(ArEsFilterApi4In arg1) {
        ArEsFilterApi4Out argOut = new ArEsFilterApi4Out();
        String pluginName = ApiToRpcMapping.getInstance().getEncodedString(arg1.getServiceName().value);
        ARFilterAPIPluggable plugin = null;
        ARPluginInfo info = null;
        PluginEnvelope envelope = this.mPlugins.get(pluginName);
        if (envelope != null) {
            plugin = (ARFilterAPIPluggable)envelope.mPlugin;
            info = envelope.mPluginInfo;
        }
        if (plugin == null) {
            ARException e = new ARException();
            LOGGER.error((Object)("ARFilterApiCall FAIL " + pluginName), (Throwable)e);
            ArStatusList6 status = new ArStatusList6();
            status.value = new ArStatusStruct6[1];
            status.value[0] = new ArStatusStruct6(2, 8755, CatalogReader.getInstance().getMessage(8755), pluginName);
            argOut.setStatus(status);
            return argOut;
        }
        LOGGER.trace((Object)("getting the value list from incoming arguments before filterAPIcall to " + pluginName));
        ArValueStruct[] inValuesRaw = arg1.getInValues().value;
        ArrayList<Value> inValuesCooked = new ArrayList<Value>();
        try {
            this.validateClient(arg1.getControl().getPassword());
            for (int i = 0; i < inValuesRaw.length; ++i) {
                inValuesCooked.add(i, ValueObjectFactory.getValueObject(inValuesRaw[i]));
            }
            LOGGER.trace((Object)("mapped fromRpc in, calling filterAPI to " + pluginName));
            List<Value> outValuesCooked = plugin.filterAPICall(ApiToRpcMapping.getInstance().getContextFromControl((ArEsControlStruct4)arg1.getControl(), info), inValuesCooked);
            LOGGER.trace((Object)("after filterAPI returned from " + pluginName));
            ArValueList outValuesList = null;
            if (outValuesCooked != null) {
                ArValueStruct[] outValuesRaw = new ArValueStruct[outValuesCooked.size()];
                for (int i = 0; i < outValuesRaw.length; ++i) {
                    outValuesRaw[i] = ValueObjectFactory.setValueObject(outValuesCooked.get(i), ARPluginSvrThreadLocalStorageBlock.getTLB().getRemoteHostCharSet());
                }
                outValuesList = new ArValueList(outValuesRaw);
            } else {
                outValuesList = new ArValueList();
            }
            argOut = new ArEsFilterApi4Out(arg1.getControl(), outValuesList, new ArStatusList6());
            LOGGER.trace((Object)("after mapping toRpc out for after filterAPIcall from " + pluginName));
        }
        catch (ARException e) {
            LOGGER.error((Object)("ARFilterApiCall FAILs in plugin: " + pluginName), (Throwable)e);
            argOut.setStatus(ApiToRpcMapping.getInstance().getRpcStatusFromStatusInfo(e.getLastStatus()));
        }
        catch (Throwable e) {
            LOGGER.error((Object)("ARFilterApiCall FAILs in plugin: " + pluginName), e);
            ArStatusList6 status = new ArStatusList6();
            status.value = new ArStatusStruct6[1];
            status.value[0] = new ArStatusStruct6(2, 8753, CatalogReader.getInstance().getMessage(8753), pluginName);
            argOut.setStatus(status);
        }
        return argOut;
    }

    @Override
    void addPlugin(String pName, PluginEnvelope pEnvelope) throws ARException {
        assert (pName != null && pEnvelope != null && pEnvelope.mPlugin != null);
        this.mPlugins.put(pName, pEnvelope);
    }

    @Override
    PluginEnvelope getPlugin(String pName) {
        return this.mPlugins.get(pName);
    }

    @Override
    public List<StatusInfo> onEvent(ARPluginContext context, int eventId) {
        ArrayList<StatusInfo> status = new ArrayList<StatusInfo>();
        Collection<PluginEnvelope> plugins = this.mPlugins.values();
        for (PluginEnvelope env : plugins) {
            StringBuilder sb = new StringBuilder();
            try {
                context.setPluginInfo(env.mPluginInfo);
                sb.append(env.mPluginInfo.getName()).append("; version: ").append(env.mPluginInfo.getVersion()).append("; eventId = ").append(eventId);
                LOGGER.debug((Object)("calling " + sb.toString()));
                env.mPlugin.onEvent(context, eventId);
            }
            catch (ARException e) {
                status.addAll(e.getLastStatus());
            }
        }
        return status;
    }

    @Override
    void terminatePlugins(ARPluginContext context) {
        Collection<PluginEnvelope> plugins = this.mPlugins.values();
        for (PluginEnvelope env : plugins) {
            try {
                context.setPluginInfo(env.mPluginInfo);
                env.mPlugin.terminate(context);
            }
            catch (ARException e) {
                LOGGER.warn((Object)(CatalogReader.getInstance().getMessage(8794) + env.getPluginName() + " for thread Id: " + Thread.currentThread().getId()), (Throwable)e);
            }
        }
    }
}

