/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.ftsplugin;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.AttachmentValue;
import com.bmc.arsys.api.DiaryListValue;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.plugins.ftsplugin.FTSPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.BasicConfigurator;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FTSPluginTest {
    private FTSPlugin plugin;
    public static final int schemaid = 41;
    public static final String char_field = "536870913";
    public static final String char_field2 = "536870914";
    public static final String attach_field = "536870915";
    public static final String diary_field = "536870916";
    public static final String entryid = "011";
    public static final String entryid2 = "012";
    public static final String entryid3 = "013";
    public static final String entryid4 = "014";
    public static final String char_returnField1 = "536770001";
    public static final String char_returnField2 = "536770002";
    public static String delimStr = new String(new Character('\u0001').toString());

    @BeforeClass
    public static void beforeClass() throws Exception {
        System.out.println("FTS plugin tests started ");
        FTSPluginTest.copyDirectory(new File("..\\..\\tests\\data\\plugins\\ftsplugin"), new File("c:\\temp"));
        FTSPluginTest.copyDirectory(new File("..\\..\\src\\etc\\arfts\\conf"), new File("c:\\temp\\config"));
    }

    @AfterClass
    public static void afterClass() {
        System.out.println("Done with FTS plugin tests ");
    }

    @Before
    public void beforeTest() throws Exception {
        this.plugin = new FTSPlugin();
        FTSPlugin.init(null);
        this.initFTS();
    }

    @After
    public void afterTest() throws Exception {
        this.deleteAllIndices();
        this.plugin.terminate(null);
    }

    @Test
    public void testInitOperation() throws Exception {
        System.out.println("testInitOperation");
        this.initFTS();
    }

    @Test
    public void testSetDocBoost() throws Exception {
        System.out.println("testSetDocBoostEffectOnRelevancy");
        this.test_setDocBoostEffectOnRelevancy();
    }

    @Test
    public void testIndexCharField() throws Exception {
        System.out.println("testIndexCharField");
        this.indexFTS(41, char_field, entryid, new Value("apple"), false, 1);
    }

    @Test
    public void testIndexCharFieldMultiple() throws Exception {
        System.out.println("testmultipleIndexCharField");
        this.indexFTS(41, char_field, entryid, new Value("apple"), false, 1);
        this.indexFTS(41, char_field, entryid2, new Value("sour"), false, 1);
        this.indexFTS(41, char_field, entryid3, new Value("sour grape"), false, 1);
    }

    @Test
    public void testSearchIndex() throws Exception {
        System.out.println("testSearchIndex");
        this.indexFTS(41, char_field, entryid, new Value("apple"), false, 1);
        List<Value> returnList = this.getFTS(41, char_field, "%apple%");
        Assert.assertNotNull(returnList);
        Assert.assertEquals((Object)2, (Object)returnList.size());
        Assert.assertEquals((Object)entryid, (Object)returnList.get(0).toString());
    }

    @Test
    public void testSearchMultipleIndex() throws Exception {
        System.out.println("testSearchMultipleIndex");
        this.indexFTS(41, char_field, entryid, new Value("apple"), false, 1);
        this.indexFTS(41, char_field, entryid2, new Value("sour"), false, 1);
        this.indexFTS(41, char_field, entryid3, new Value("sour grape"), false, 1);
        List<Value> returnList = this.getFTS(41, char_field, "%sour%");
        Assert.assertNotNull(returnList);
        Assert.assertEquals((Object)4, (Object)returnList.size());
        for (Value val : returnList) {
            if (val.getDataType().toInt() == 3) continue;
            if (entryid3.equals(val.toString())) {
                Assert.assertEquals((Object)entryid3, (Object)val.toString());
                continue;
            }
            Assert.assertEquals((Object)entryid2, (Object)val.toString());
        }
    }

    @Test
    public void testIndexSearchAnotherCharField() throws Exception {
        System.out.println("testIndexSearchAnotherCharField");
        this.indexFTS(41, char_field, entryid, new Value("apple"), false, 1);
        this.indexFTS(41, char_field2, entryid, new Value("sweet orange"), false, 1);
        List<Value> returnList = this.getFTS(41, char_field2, "%orange%");
        Assert.assertNotNull(returnList);
        Assert.assertEquals((Object)2, (Object)returnList.size());
        Assert.assertEquals((Object)entryid, (Object)returnList.get(0).toString());
    }

    @Test
    public void testUpdateIndexCharField() throws Exception {
        System.out.println("testUpdateIndexCharField");
        this.indexFTS(41, char_field, entryid, new Value("banana"), false, 1);
        this.indexFTS(41, char_field2, entryid, new Value("sweet orange"), false, 1);
        this.indexFTS(41, char_field, entryid, new Value("An apple a day keeps the doctor away"), false, 1);
        List<Value> returnList = this.getFTS(41, char_field, "%doctor%");
        Assert.assertNotNull(returnList);
        Assert.assertEquals((Object)2, (Object)returnList.size());
        Assert.assertEquals((Object)entryid, (Object)returnList.get(0).toString());
        returnList = this.getFTS(41, char_field2, "%orange%");
        Assert.assertNotNull(returnList);
        Assert.assertEquals((Object)2, (Object)returnList.size());
        Assert.assertEquals((Object)entryid, (Object)returnList.get(0).toString());
        returnList = this.getFTS(41, char_field, "banana");
        Assert.assertNull(returnList);
    }

    @Test
    public void testIndexSearchAttachFieldTextFile() throws Exception {
        String filename = "c:\\temp\\fts.txt";
        System.out.println("testIndexSearchAttachFieldTextFile: " + filename);
        this.testIndexSearchAttachField(filename, "%text%");
    }

    @Test
    public void testIndexSearchAttachFieldLargeTextFile() throws Exception {
        String filename = "c:\\temp\\ftslarge.txt";
        System.out.println("testIndexSearchAttachFieldLargeTextFile: " + filename);
        this.testIndexSearchAttachField(filename, "%ANDROMEDE%");
    }

    @Test
    public void testIndexSearchAttachFieldDocFile() throws Exception {
        String filename = "c:\\temp\\fts.doc";
        System.out.println("testIndexSearchAttachFieldDocFile: " + filename);
        this.testIndexSearchAttachField(filename, "%word%");
    }

    @Test
    public void testIndexSearchAttachFieldLargeDocFile() throws Exception {
        String filename = "c:\\temp\\ftslarge.doc";
        System.out.println("testIndexSearchAttachFieldLargeDocFile: " + filename);
        this.testIndexSearchAttachField(filename, "%GENEMEDE%");
    }

    @Test
    public void testIndexSearchAttachFieldPDFFile() throws Exception {
        String filename = "c:\\temp\\fts.pdf";
        System.out.println("testIndexSearchAttachFieldPDFFile: " + filename);
        this.testIndexSearchAttachField(filename, "%Restart IIS%");
    }

    @Test
    public void testIndexSearchAttachFieldPPTFile() throws Exception {
        String filename = "c:\\temp\\fts.ppt";
        System.out.println("testIndexSearchAttachFieldPPTFile: " + filename);
        this.testIndexSearchAttachField(filename, "%powerpoint%");
    }

    @Test
    public void testIndexSearchAttachFieldXMLFile() throws Exception {
        String filename = "c:\\temp\\fts.xml";
        System.out.println("testIndexSearchAttachFieldXMLFile: " + filename);
        this.testIndexSearchAttachField(filename, "%clover%");
    }

    @Test
    public void testIndexSearchAttachFieldHTMLFile() throws Exception {
        String filename = "c:\\temp\\fts.html";
        System.out.println("testIndexSearchAttachFieldHTMLFile: " + filename);
        this.testIndexSearchAttachField(filename, "%webservice%");
    }

    @Test
    public void testIndexSearchAttachFieldRTFFile() throws Exception {
        String filename = "c:\\temp\\fts.rtf";
        System.out.println("testIndexSearchAttachFieldRTFFile: " + filename);
        this.testIndexSearchAttachField(filename, "%TikaDocHandler%");
    }

    @Test
    public void testIndexSearchAttachFieldACTFile() throws Exception {
        String filename = "c:\\temp\\fts.act";
        System.out.println("testIndexSearchAttachFieldACTFile: " + filename);
        this.testIndexSearchAttachField(filename, "%UserGroup%");
    }

    @Test
    public void testIndexSearchAttachFieldJPGFile() throws Exception {
        String filename = "c:\\temp\\fts.jpg";
        System.out.println("testIndexSearchAttachFieldJPGFile: " + filename);
        this.testIndexSearchAttachField(filename, "%jpg%");
    }

    @Test
    public void testIndexSearchAttachFieldMultiFile() throws Exception {
        String filename = "c:\\temp\\fts.doc";
        System.out.println("testIndexSearchAttachFieldMultiFile: " + filename);
        this.testIndexSearchAttachField(filename, "%fts%");
        filename = "c:\\temp\\fts.bat";
        this.testIndexSearchAttachField(filename, "%build%");
    }

    @Test
    public void testIndexSearchAttachFieldZeroLenFile() throws Exception {
        String filename = "c:\\temp\\zero.zip";
        System.out.println("testIndexSearchAttachFieldZeroLenFile: " + filename);
        this.testIndexSearchAttachField(filename, "%zip%");
    }

    private void testIndexSearchAttachField(String filename, String searchString) throws Exception {
        AttachmentValue attach = new AttachmentValue(filename, filename);
        if (attach.getLocationType() != 1 && attach.getLocationType() != 2) {
            Assert.fail((String)"Bad Location type in Attachment, probably file does not exist");
        }
        this.indexFTS(41, attach_field, entryid4, new Value(attach), false, 1);
        List<Value> returnList = this.getFTS(41, attach_field, searchString);
        Assert.assertNotNull(returnList);
        Assert.assertEquals((Object)2, (Object)returnList.size());
        Assert.assertEquals((Object)entryid4, (Object)returnList.get(0).toString());
        this.deleteFTS(41, attach_field, entryid4);
        attach.setLocationType(1);
        attach.setFilePath(filename);
        this.indexFTS(41, attach_field, entryid4, new Value(attach), false, 1);
        returnList = this.getFTS(41, attach_field, searchString);
        Assert.assertNotNull(returnList);
        Assert.assertEquals((Object)2, (Object)returnList.size());
        Assert.assertEquals((Object)entryid4, (Object)returnList.get(0).toString());
    }

    @Test
    public void testIndexSearchDiaryField() throws Exception {
        System.out.println("testIndexSearchDiaryField");
        boolean expectedExceptionOccured = false;
        DiaryListValue diaryList = new DiaryListValue();
        diaryList.setAppendedText("added new entry");
        try {
            this.indexFTS(41, diary_field, entryid4, new Value(diaryList), false, 1);
        }
        catch (ARException e) {
            expectedExceptionOccured = true;
            Assert.assertEquals((Object)663, (Object)((int)((StatusInfo)e.getLastStatus().get(0)).getMessageNum()));
        }
        Assert.assertEquals((Object)true, (Object)expectedExceptionOccured);
    }

    @Test
    public void testDeletingDocuments1() throws Exception {
        System.out.println("testDeletingDocuments1");
        this.indexFTS(41, char_field, entryid, new Value("apple"), false, 1);
        this.deleteFTS(41, null, null);
        List<Value> returnList = this.getFTS(41, char_field, "apple");
        Assert.assertNull(returnList);
    }

    @Test
    public void testDeletingDocuments2() throws Exception {
        System.out.println("testDeletingDocuments2");
        this.indexFTS(41, char_field, entryid, new Value("apple"), false, 1);
        this.deleteFTS(41, null, entryid);
        List<Value> returnList = this.getFTS(41, char_field, "apple");
        Assert.assertNull(returnList);
    }

    @Test
    public void testDeletingDocuments3() throws Exception {
        System.out.println("testDeletingDocuments3");
        this.indexFTS(41, char_field, entryid, new Value("apple"), false, 1);
        this.deleteFTS(41, char_field, null);
        List<Value> returnList = this.getFTS(41, char_field, "apple");
        Assert.assertNull(returnList);
    }

    @Test
    public void testDeletingDocuments4() throws Exception {
        System.out.println("testDeletingDocuments4");
        this.indexFTS(41, char_field, entryid, new Value("apple"), false, 1);
        this.indexFTS(41, char_field2, entryid, new Value("banana"), false, 1);
        this.deleteFTS(41, char_field, entryid);
        List<Value> returnList = this.getFTS(41, char_field2, "banana");
        Assert.assertNotNull(returnList);
        Assert.assertEquals((Object)2, (Object)returnList.size());
        Assert.assertEquals((Object)entryid, (Object)returnList.get(0).toString());
        returnList = this.getFTS(41, char_field, "apple");
        Assert.assertNull(returnList);
    }

    @Test
    public void testDeletingDocuments5() throws Exception {
        System.out.println("testDeletingDocuments5");
        this.indexFTS(41, char_field, entryid, new Value("apple"), false, 1);
        this.deleteFTS(0, null, null);
        try {
            List<Value> returnList = this.getFTS(41, char_field, "apple");
            Assert.assertTrue((boolean)false);
        }
        catch (ARException are) {
            String arMsg = are.getMessage();
            Assert.assertTrue((boolean)arMsg.contains("Likely cause is index does not exist"));
        }
    }

    @Test
    public void testMultiGetOperation_noReturnFields_Opt_0() throws Exception {
        System.out.println("testMultiGetOperation_noReturnFields_Opt_0");
        int schemaId1 = 100;
        int schemaId2 = 102;
        int schemaId3 = 103;
        this.prepareIndexForMultiGetOperation(schemaId1, schemaId2, schemaId3, false);
        ArrayList<Value> inputValues = new ArrayList<Value>();
        inputValues.add(new Value(8));
        StringBuffer sb = new StringBuffer();
        sb.append(schemaId1 + ";");
        sb.append(schemaId2 + ";");
        sb.append(schemaId3);
        inputValues.add(new Value(sb.toString()));
        this.prepareComplexInputArguments(inputValues, sb, false, 0);
        List<Value> returnList = this.plugin.filterAPICall(null, inputValues);
        Assert.assertNotNull(returnList);
        Assert.assertEquals((Object)4, (Object)returnList.size());
        Assert.assertEquals((Object)"3", (Object)returnList.get(0).toString().trim());
        for (int i = 1; i < returnList.size(); ++i) {
            String resultStr = returnList.get(i).toString();
            String[] resultElements = resultStr.split(";");
            Assert.assertTrue((resultElements.length >= 8 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testMultiGetOperation_withReturnFields_Opt_0() throws Exception {
        System.out.println("testMultiGetOperation_withReturnFields_Opt_0");
        int schemaId1 = 100;
        int schemaId2 = 102;
        int schemaId3 = 103;
        this.prepareIndexForMultiGetOperation(schemaId1, schemaId2, schemaId3, true);
        ArrayList<Value> inputValues = new ArrayList<Value>();
        inputValues.add(new Value(8));
        StringBuffer sb = new StringBuffer();
        sb.append(schemaId1 + ";");
        sb.append(schemaId2 + ";");
        sb.append(schemaId3);
        inputValues.add(new Value(sb.toString()));
        this.prepareComplexInputArguments(inputValues, sb, true, 0);
        List<Value> returnList = this.plugin.filterAPICall(null, inputValues);
        Assert.assertNotNull(returnList);
        Assert.assertEquals((Object)4, (Object)returnList.size());
        Assert.assertEquals((Object)"3", (Object)returnList.get(0).toString().trim());
        for (int i = 1; i < returnList.size(); ++i) {
            String resultStr = returnList.get(i).toString();
            String[] resultElements = resultStr.split(";");
            Assert.assertTrue((resultElements.length == 14 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)resultElements[7].equalsIgnoreCase("3"));
            String rcvdSchemaId = resultElements[0];
            Assert.assertTrue((boolean)resultElements[8].equalsIgnoreCase(delimStr + char_returnField1 + delimStr));
            Assert.assertTrue((boolean)resultElements[9].equalsIgnoreCase(delimStr + rcvdSchemaId + "_returnField1" + delimStr));
            Assert.assertTrue((boolean)resultElements[10].equalsIgnoreCase(delimStr + char_returnField2 + delimStr));
            Assert.assertTrue((boolean)resultElements[11].equalsIgnoreCase(delimStr + rcvdSchemaId + "_returnField2" + delimStr));
            Assert.assertTrue((boolean)resultElements[12].equalsIgnoreCase(delimStr + "title" + delimStr));
            Assert.assertTrue((boolean)resultElements[13].equalsIgnoreCase(delimStr + rcvdSchemaId + "_title" + delimStr));
        }
    }

    @Test
    public void testMultiGetOperation_noReturnFields_Opt_1() throws Exception {
        System.out.println("testMultiGetOperation_noReturnFields_Opt_1");
        int schemaId1 = 100;
        int schemaId2 = 102;
        int schemaId3 = 103;
        this.prepareIndexForMultiGetOperation(schemaId1, schemaId2, schemaId3, false);
        ArrayList<Value> inputValues = new ArrayList<Value>();
        inputValues.add(new Value(8));
        StringBuffer sb = new StringBuffer();
        sb.append(schemaId1 + ";");
        sb.append(schemaId2 + ";");
        sb.append(schemaId3);
        inputValues.add(new Value(sb.toString()));
        this.prepareComplexInputArguments(inputValues, sb, false, 1);
        List<Value> returnList = this.plugin.filterAPICall(null, inputValues);
        Assert.assertNotNull(returnList);
        Assert.assertEquals((Object)4, (Object)returnList.size());
        Assert.assertEquals((Object)"3", (Object)returnList.get(0).toString().trim());
        for (int i = 1; i < returnList.size(); ++i) {
            String resultStr = returnList.get(i).toString();
            String[] resultElements = resultStr.split(";");
            Assert.assertTrue((resultElements.length >= 8 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testMultiGetOperation_withReturnFields_Opt_1() throws Exception {
        System.out.println("testMultiGetOperation_withReturnFields_Opt_1");
        int schemaId1 = 100;
        int schemaId2 = 102;
        int schemaId3 = 103;
        this.prepareIndexForMultiGetOperation(schemaId1, schemaId2, schemaId3, true);
        ArrayList<Value> inputValues = new ArrayList<Value>();
        inputValues.add(new Value(8));
        StringBuffer sb = new StringBuffer();
        sb.append(schemaId1 + ";");
        sb.append(schemaId2 + ";");
        sb.append(schemaId3);
        inputValues.add(new Value(sb.toString()));
        this.prepareComplexInputArguments(inputValues, sb, true, 1);
        List<Value> returnList = this.plugin.filterAPICall(null, inputValues);
        Assert.assertNotNull(returnList);
        Assert.assertEquals((Object)4, (Object)returnList.size());
        Assert.assertEquals((Object)"3", (Object)returnList.get(0).toString().trim());
        for (int i = 1; i < returnList.size(); ++i) {
            String resultStr = returnList.get(i).toString();
            String[] resultElements = resultStr.split(";");
            Assert.assertTrue((resultElements.length == 14 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)resultElements[7].equalsIgnoreCase("3"));
            String rcvdSchemaId = resultElements[0];
            Assert.assertTrue((boolean)resultElements[8].equalsIgnoreCase(delimStr + char_returnField1 + delimStr));
            Assert.assertTrue((boolean)resultElements[9].equalsIgnoreCase(delimStr + rcvdSchemaId + "_returnField1" + delimStr));
            Assert.assertTrue((boolean)resultElements[10].equalsIgnoreCase(delimStr + char_returnField2 + delimStr));
            Assert.assertTrue((boolean)resultElements[11].equalsIgnoreCase(delimStr + rcvdSchemaId + "_returnField2" + delimStr));
            Assert.assertTrue((boolean)resultElements[12].equalsIgnoreCase(delimStr + "title" + delimStr));
            Assert.assertTrue((boolean)resultElements[13].equalsIgnoreCase(delimStr + rcvdSchemaId + "_title" + delimStr));
        }
    }

    @Test
    public void testMultiGetOperation_noReturnFields_Opt_2() throws Exception {
        System.out.println("testMultiGetOperation_noReturnFields_Opt_2");
        int schemaId1 = 100;
        int schemaId2 = 102;
        int schemaId3 = 103;
        this.prepareIndexForMultiGetOperation(schemaId1, schemaId2, schemaId3, false);
        ArrayList<Value> inputValues = new ArrayList<Value>();
        inputValues.add(new Value(8));
        StringBuffer sb = new StringBuffer();
        sb.append(schemaId1 + ";");
        sb.append(schemaId2 + ";");
        sb.append(schemaId3);
        inputValues.add(new Value(sb.toString()));
        this.prepareComplexInputArguments(inputValues, sb, false, 2);
        List<Value> returnList = this.plugin.filterAPICall(null, inputValues);
        Assert.assertNotNull(returnList);
        Assert.assertEquals((Object)4, (Object)returnList.size());
        Assert.assertEquals((Object)"3", (Object)returnList.get(0).toString().trim());
        for (int i = 1; i < returnList.size(); ++i) {
            String resultStr = returnList.get(i).toString();
            String[] resultElements = resultStr.split(";");
            Assert.assertTrue((resultElements.length >= 8 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testMultiGetOperation_withReturnFields_Opt_2() throws Exception {
        System.out.println("testMultiGetOperation_withReturnFields_Opt_2");
        int schemaId1 = 100;
        int schemaId2 = 102;
        int schemaId3 = 103;
        this.prepareIndexForMultiGetOperation(schemaId1, schemaId2, schemaId3, true);
        ArrayList<Value> inputValues = new ArrayList<Value>();
        inputValues.add(new Value(8));
        StringBuffer sb = new StringBuffer();
        sb.append(schemaId1 + ";");
        sb.append(schemaId2 + ";");
        sb.append(schemaId3);
        inputValues.add(new Value(sb.toString()));
        this.prepareComplexInputArguments(inputValues, sb, true, 2);
        List<Value> returnList = this.plugin.filterAPICall(null, inputValues);
        Assert.assertNotNull(returnList);
        Assert.assertEquals((Object)4, (Object)returnList.size());
        Assert.assertEquals((Object)"3", (Object)returnList.get(0).toString().trim());
        for (int i = 1; i < returnList.size(); ++i) {
            String resultStr = returnList.get(i).toString();
            String[] resultElements = resultStr.split(";");
            Assert.assertTrue((resultElements.length == 14 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)resultElements[7].equalsIgnoreCase("3"));
            String rcvdSchemaId = resultElements[0];
            Assert.assertTrue((boolean)resultElements[8].equalsIgnoreCase(delimStr + char_returnField1 + delimStr));
            Assert.assertTrue((boolean)resultElements[9].equalsIgnoreCase(delimStr + rcvdSchemaId + "_returnField1" + delimStr));
            Assert.assertTrue((boolean)resultElements[10].equalsIgnoreCase(delimStr + char_returnField2 + delimStr));
            Assert.assertTrue((boolean)resultElements[11].equalsIgnoreCase(delimStr + rcvdSchemaId + "_returnField2" + delimStr));
            Assert.assertTrue((boolean)resultElements[12].equalsIgnoreCase(delimStr + "title" + delimStr));
            Assert.assertTrue((boolean)resultElements[13].equalsIgnoreCase(delimStr + rcvdSchemaId + "_title" + delimStr));
        }
    }

    @Test
    public void testMultiGetOperation_noReturnFields_Opt_3() throws Exception {
        System.out.println("testMultiGetOperation_noReturnFields_Opt_3");
        int schemaId1 = 100;
        int schemaId2 = 102;
        int schemaId3 = 103;
        this.prepareIndexForMultiGetOperation(schemaId1, schemaId2, schemaId3, false);
        ArrayList<Value> inputValues = new ArrayList<Value>();
        inputValues.add(new Value(8));
        StringBuffer sb = new StringBuffer();
        sb.append(schemaId1 + ";");
        sb.append(schemaId2 + ";");
        sb.append(schemaId3);
        inputValues.add(new Value(sb.toString()));
        this.prepareComplexInputArguments(inputValues, sb, false, 3);
        List<Value> returnList = this.plugin.filterAPICall(null, inputValues);
        Assert.assertNotNull(returnList);
        Assert.assertEquals((Object)1, (Object)returnList.size());
        Assert.assertEquals((Object)"3", (Object)returnList.get(0).toString().trim());
    }

    @Test
    public void testMultiGetOperation_withReturnFields_Opt_3() throws Exception {
        System.out.println("testMultiGetOperation_withReturnFields_Opt_3");
        int schemaId1 = 100;
        int schemaId2 = 102;
        int schemaId3 = 103;
        this.prepareIndexForMultiGetOperation(schemaId1, schemaId2, schemaId3, true);
        ArrayList<Value> inputValues = new ArrayList<Value>();
        inputValues.add(new Value(8));
        StringBuffer sb = new StringBuffer();
        sb.append(schemaId1 + ";");
        sb.append(schemaId2 + ";");
        sb.append(schemaId3);
        inputValues.add(new Value(sb.toString()));
        this.prepareComplexInputArguments(inputValues, sb, true, 3);
        List<Value> returnList = this.plugin.filterAPICall(null, inputValues);
        Assert.assertNotNull(returnList);
        Assert.assertEquals((Object)1, (Object)returnList.size());
        Assert.assertEquals((Object)"3", (Object)returnList.get(0).toString().trim());
    }

    private void prepareComplexInputArguments(List<Value> inputValues, StringBuffer sb, boolean include_returnFilters, int resultOpt) {
        this.prepareFieldListStr(inputValues, sb);
        this.prepareFTOptionListStr(inputValues, sb);
        inputValues.add(new Value(""));
        inputValues.add(new Value("apple OR banana OR grape"));
        inputValues.add(new Value(""));
        inputValues.add(new Value(""));
        inputValues.add(new Value(resultOpt));
        inputValues.add(new Value("1;2"));
        if (include_returnFilters) {
            inputValues.add(new Value("536770001;536770002;title"));
        } else {
            inputValues.add(new Value(""));
        }
        inputValues.add(new Value(0));
        inputValues.add(new Value(""));
    }

    private void prepareIndexForMultiGetOperation(int schemaId1, int schemaId2, int schemaId3, boolean include_returnFilters) throws Exception {
        int curSchemaId = schemaId1;
        this.indexFTS(curSchemaId, char_field, entryid, new Value("apple"), false, 1);
        this.indexFTS(curSchemaId, char_field2, entryid, new Value("apple1"), false, 1);
        this.indexFTS(curSchemaId, "title", entryid, new Value(curSchemaId + "_title"), false, 1);
        if (include_returnFilters) {
            this.indexFTS(curSchemaId, char_returnField1, entryid, new Value(curSchemaId + "_returnField1"), false, 1);
            this.indexFTS(curSchemaId, char_returnField2, entryid, new Value(curSchemaId + "_returnField2"), false, 1);
        }
        curSchemaId = schemaId2;
        this.indexFTS(curSchemaId, char_field, entryid, new Value("banana"), false, 1);
        this.indexFTS(curSchemaId, char_field2, entryid, new Value("banana1"), false, 1);
        this.indexFTS(curSchemaId, "title", entryid, new Value(curSchemaId + "_title"), false, 1);
        if (include_returnFilters) {
            this.indexFTS(curSchemaId, char_returnField1, entryid, new Value(curSchemaId + "_returnField1"), false, 1);
            this.indexFTS(curSchemaId, char_returnField2, entryid, new Value(curSchemaId + "_returnField2"), false, 1);
        }
        curSchemaId = schemaId3;
        this.indexFTS(curSchemaId, char_field, entryid, new Value("grape"), false, 1);
        this.indexFTS(curSchemaId, "title", entryid, new Value(curSchemaId + "_title"), false, 1);
        if (include_returnFilters) {
            this.indexFTS(curSchemaId, char_returnField1, entryid, new Value(curSchemaId + "_returnField1"), false, 1);
            this.indexFTS(curSchemaId, char_returnField2, entryid, new Value(curSchemaId + "_returnField2"), false, 1);
        }
    }

    private void prepareFieldListStr(List<Value> inputValues, StringBuffer sb) {
        sb.delete(0, sb.length());
        sb.append("536870913;");
        sb.append(char_field2);
        sb.append("#");
        sb.append("536870913;");
        sb.append(char_field2);
        sb.append("#");
        sb.append(char_field);
        inputValues.add(new Value(sb.toString()));
    }

    private void prepareFTOptionListStr(List<Value> inputValues, StringBuffer sb) {
        sb.delete(0, sb.length());
        sb.append(Integer.toString(1) + ";");
        sb.append(Integer.toString(1));
        sb.append("#");
        sb.append(Integer.toString(1) + ";");
        sb.append(Integer.toString(1));
        sb.append("#");
        sb.append(Integer.toString(1));
        inputValues.add(new Value(sb.toString()));
    }

    private void deleteAllIndices() throws Exception {
        this.deleteFTS(0, null, null);
    }

    private void initFTS() throws Exception {
        ArrayList<Value> inputValues = new ArrayList<Value>();
        inputValues.add(new Value(0));
        inputValues.add(new Value("c:\\arfts\\index\\test"));
        inputValues.add(new Value("c:\\temp\\config"));
        inputValues.add(new Value(1));
        inputValues.add(new Value("c:\\arfts\\stop.txt"));
        inputValues.add(new Value(500));
        inputValues.add(new Value("en"));
        this.plugin.filterAPICall(null, inputValues);
    }

    private void indexFTS(int schemaId, String fieldId, String entryId, Value val, boolean update, int commitFlag) throws Exception {
        ArrayList<Value> inputValues = new ArrayList<Value>();
        if (update) {
            inputValues.add(new Value(2));
        } else {
            inputValues.add(new Value(1));
        }
        inputValues.add(new Value(schemaId));
        inputValues.add(new Value(fieldId));
        inputValues.add(new Value(entryId));
        inputValues.add(new Value(0));
        inputValues.add(new Value(0));
        inputValues.add(val);
        inputValues.add(new Value(1));
        inputValues.add(new Value(commitFlag));
        this.plugin.filterAPICall(null, inputValues);
    }

    private void deleteFTS(int schemaId, String fieldId, String entryId) throws Exception {
        ArrayList<Value> inputValues = new ArrayList<Value>();
        inputValues.add(new Value(3));
        if (schemaId != 0) {
            inputValues.add(new Value(41));
            if (fieldId != null && fieldId.length() != 0 || entryId != null) {
                inputValues.add(new Value(fieldId));
                if (entryId != null) {
                    inputValues.add(new Value(entryid));
                }
            }
        }
        this.plugin.filterAPICall(null, inputValues);
    }

    private List<Value> getFTS(int schemaId, String fieldId, String searchQuery) throws Exception {
        ArrayList<Value> inputValues = new ArrayList<Value>();
        inputValues.add(new Value(4));
        inputValues.add(new Value(schemaId));
        inputValues.add(new Value(fieldId));
        inputValues.add(new Value(searchQuery));
        inputValues.add(new Value(1));
        return this.plugin.filterAPICall(null, inputValues);
    }

    private void test_setDocBoostEffectOnRelevancy() throws Exception {
        List<Value> retVals = null;
        ArrayList<Object> inputValues = null;
        float[] startRelevancy = new float[4];
        float[] boostUpRelevancy = new float[4];
        float[] boostDwnRelevancy = new float[4];
        float[] resetRelevancy = new float[4];
        this.indexFTS(41, char_field, entryid, new Value("toasteronthemaxsetting one"), false, 1);
        this.indexFTS(41, char_field, entryid2, new Value("toasteronthemaxsetting two"), false, 1);
        this.indexFTS(41, char_field, entryid3, new Value("toasteronthemaxsetting three"), false, 1);
        this.indexFTS(41, char_field, entryid4, new Value("toasteronthemaxsetting four"), false, 1);
        for (int i_entryid = 11; i_entryid <= 14; ++i_entryid) {
            inputValues = new ArrayList<Value>();
            inputValues.add(new Value(9));
            inputValues.add(new Value(41));
            inputValues.add(new Value(Integer.toString(i_entryid)));
            inputValues.add(new Value(1.0));
            this.plugin.filterAPICall(null, inputValues);
        }
        retVals = this.getFTS(41, char_field, "toasteronthemaxsetting");
        Assert.assertNotNull(retVals);
        Assert.assertEquals((Object)8, (Object)retVals.size());
        startRelevancy[0] = (float)retVals.get(1).getDoubleValue();
        startRelevancy[1] = (float)retVals.get(3).getDoubleValue();
        startRelevancy[2] = (float)retVals.get(5).getDoubleValue();
        startRelevancy[3] = (float)retVals.get(7).getDoubleValue();
        Assert.assertEquals((Object)Float.valueOf(100.0f), (Object)Float.valueOf(startRelevancy[0]));
        Assert.assertEquals((Object)Float.valueOf(100.0f), (Object)Float.valueOf(startRelevancy[1]));
        Assert.assertEquals((Object)Float.valueOf(100.0f), (Object)Float.valueOf(startRelevancy[2]));
        Assert.assertEquals((Object)Float.valueOf(100.0f), (Object)Float.valueOf(startRelevancy[3]));
        inputValues = new ArrayList();
        inputValues.add(new Value(9));
        inputValues.add(new Value(41));
        inputValues.add(new Value(entryid2));
        inputValues.add(new Value(1.5));
        this.plugin.filterAPICall(null, inputValues);
        retVals = this.getFTS(41, char_field, "toasteronthemaxsetting");
        Assert.assertNotNull(retVals);
        Assert.assertEquals((Object)8, (Object)retVals.size());
        boostUpRelevancy[0] = (float)retVals.get(1).getDoubleValue();
        boostUpRelevancy[1] = (float)retVals.get(3).getDoubleValue();
        boostUpRelevancy[2] = (float)retVals.get(5).getDoubleValue();
        boostUpRelevancy[3] = (float)retVals.get(7).getDoubleValue();
        Assert.assertTrue((boostUpRelevancy[1] == 100.0f ? 1 : 0) != 0);
        Assert.assertTrue((boostUpRelevancy[0] < boostUpRelevancy[1] ? 1 : 0) != 0);
        Assert.assertTrue((boostUpRelevancy[2] < boostUpRelevancy[1] ? 1 : 0) != 0);
        Assert.assertTrue((boostUpRelevancy[3] < boostUpRelevancy[1] ? 1 : 0) != 0);
        inputValues = new ArrayList();
        inputValues.add(new Value(9));
        inputValues.add(new Value(41));
        inputValues.add(new Value(entryid3));
        inputValues.add(new Value(0.5));
        this.plugin.filterAPICall(null, inputValues);
        retVals = this.getFTS(41, char_field, "toasteronthemaxsetting");
        Assert.assertNotNull(retVals);
        Assert.assertEquals((Object)8, (Object)retVals.size());
        boostDwnRelevancy[0] = (float)retVals.get(1).getDoubleValue();
        boostDwnRelevancy[1] = (float)retVals.get(3).getDoubleValue();
        boostDwnRelevancy[2] = (float)retVals.get(5).getDoubleValue();
        boostDwnRelevancy[3] = (float)retVals.get(7).getDoubleValue();
        Assert.assertTrue((boostDwnRelevancy[1] == 100.0f ? 1 : 0) != 0);
        Assert.assertTrue((boostDwnRelevancy[0] < boostDwnRelevancy[1] ? 1 : 0) != 0);
        Assert.assertTrue((boostDwnRelevancy[3] < boostDwnRelevancy[1] ? 1 : 0) != 0);
        Assert.assertTrue((boostDwnRelevancy[2] < boostDwnRelevancy[3] ? 1 : 0) != 0);
        inputValues = new ArrayList();
        inputValues.add(new Value(9));
        inputValues.add(new Value(41));
        inputValues.add(new Value(entryid2));
        inputValues.add(new Value(1.0));
        this.plugin.filterAPICall(null, inputValues);
        inputValues = new ArrayList();
        inputValues.add(new Value(9));
        inputValues.add(new Value(41));
        inputValues.add(new Value(entryid3));
        inputValues.add(new Value(1.0));
        this.plugin.filterAPICall(null, inputValues);
        retVals = this.getFTS(41, char_field, "toasteronthemaxsetting");
        Assert.assertNotNull(retVals);
        Assert.assertEquals((Object)8, (Object)retVals.size());
        resetRelevancy[0] = (float)retVals.get(1).getDoubleValue();
        resetRelevancy[1] = (float)retVals.get(3).getDoubleValue();
        resetRelevancy[2] = (float)retVals.get(5).getDoubleValue();
        resetRelevancy[3] = (float)retVals.get(7).getDoubleValue();
        Assert.assertEquals((Object)Float.valueOf(100.0f), (Object)Float.valueOf(resetRelevancy[0]));
        Assert.assertEquals((Object)Float.valueOf(100.0f), (Object)Float.valueOf(resetRelevancy[1]));
        Assert.assertEquals((Object)Float.valueOf(100.0f), (Object)Float.valueOf(resetRelevancy[2]));
        Assert.assertEquals((Object)Float.valueOf(100.0f), (Object)Float.valueOf(resetRelevancy[3]));
    }

    private static void copyDirectory(File sourceLocation, File targetLocation) throws IOException {
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists()) {
                targetLocation.mkdir();
            }
            String[] children = sourceLocation.list();
            for (int i = 0; i < children.length; ++i) {
                FTSPluginTest.copyDirectory(new File(sourceLocation, children[i]), new File(targetLocation, children[i]));
            }
        } else {
            int len;
            FileInputStream in = new FileInputStream(sourceLocation);
            FileOutputStream out = new FileOutputStream(targetLocation);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    static {
        BasicConfigurator.configure();
    }
}

