/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.fts.impl.lucene.analyzers;

import java.io.File;
import java.io.FileReader;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class FTSAnalyzerConfigReader
extends DefaultHandler {
    private boolean isLocale = false;
    private static String locale = "en";
    private static String regex = "";
    private static String stopword = "";
    private static String rootword = "";
    private static String thesaurus = "";
    private static String stemmer = "";
    private static String indexAnalyzer = "";
    private static String searchAnalyzer = "";
    private static boolean foundLocale = false;
    private String whichItem = "";
    String lastWhich = "xxx";
    String lastValue = "";

    public FTSAnalyzerConfig readConfig(String configDir, String locale) throws Exception {
        if (locale != null || !locale.equals("")) {
            FTSAnalyzerConfigReader.locale = locale;
        }
        XMLReader xr = XMLReaderFactory.createXMLReader();
        FTSAnalyzerConfigReader handler = new FTSAnalyzerConfigReader();
        xr.setContentHandler(handler);
        xr.setErrorHandler(handler);
        String configFile = configDir + File.separator + "FTSLocaleConfig.xml";
        FileReader r = new FileReader(configFile);
        xr.parse(new InputSource(r));
        FTSAnalyzerConfig config = new FTSAnalyzerConfig();
        config.indexAnalyzer = indexAnalyzer;
        if (regex != null && !regex.equals("")) {
            config.regexfile = configDir + File.separator + regex;
        }
        if (rootword != null && !rootword.equals("")) {
            config.rootwordfile = configDir + File.separator + rootword;
        }
        config.searchAnalyzer = searchAnalyzer;
        config.stemmer = stemmer;
        if (stopword != null && !stopword.equals("")) {
            config.stopwordfile = configDir + File.separator + stopword;
        }
        if (thesaurus != null && !thesaurus.equals("")) {
            config.thesaurusfile = configDir + File.separator + thesaurus;
        }
        r.close();
        if (!foundLocale && locale.length() > 2) {
            return this.readConfig(configDir, locale.substring(0, 2));
        }
        return config;
    }

    public FTSAnalyzerConfigReader(String configDir) {
    }

    public FTSAnalyzerConfigReader() {
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void startElement(String uri, String name, String qName, Attributes atts) {
        if (qName.equals("locale") && atts.getValue("locale").equals(locale)) {
            this.isLocale = true;
            foundLocale = true;
        }
        if (this.isLocale) {
            this.whichItem = qName;
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("locale")) {
            this.isLocale = false;
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.isLocale) {
            String theValue;
            StringBuffer stringBuffer = new StringBuffer("");
            for (int i = start; i < start + length; ++i) {
                stringBuffer.append(ch[i]);
            }
            if (!this.lastWhich.equals(this.whichItem)) {
                this.lastValue = "";
            }
            if (!(theValue = this.lastValue + stringBuffer.toString().trim()).equals("")) {
                if (this.whichItem.equals("stopwordfile")) {
                    stopword = theValue;
                } else if (this.whichItem.equals("rootwordfile")) {
                    rootword = theValue;
                } else if (this.whichItem.equals("thesaurusfile")) {
                    thesaurus = theValue;
                } else if (this.whichItem.equals("stemmer")) {
                    stemmer = theValue;
                } else if (this.whichItem.equals("regexfile")) {
                    regex = theValue;
                } else if (this.whichItem.equals("indexAnalyzer")) {
                    indexAnalyzer = theValue;
                } else if (this.whichItem.equals("searchAnalyzer")) {
                    searchAnalyzer = theValue;
                }
                this.lastValue = theValue;
                this.lastWhich = this.whichItem;
            }
        }
    }

    public class FTSAnalyzerConfig {
        public String stopwordfile = null;
        public String rootwordfile = null;
        public String thesaurusfile = null;
        public String stemmer = null;
        public String regexfile = null;
        public String indexAnalyzer = null;
        public String searchAnalyzer = null;
    }
}

