/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.web.jsf;

import com.bmc.thirdparty.org.springframework.util.Assert;
import com.bmc.thirdparty.org.springframework.web.context.WebApplicationContext;
import com.bmc.thirdparty.org.springframework.web.jsf.FacesContextUtils;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.VariableResolver;

public class WebApplicationContextVariableResolver
extends VariableResolver {
    public static final String WEB_APPLICATION_CONTEXT_VARIABLE_NAME = "webApplicationContext";
    protected final VariableResolver originalVariableResolver;

    public WebApplicationContextVariableResolver(VariableResolver originalVariableResolver) {
        Assert.notNull(originalVariableResolver, "Original JSF VariableResolver must not be null");
        this.originalVariableResolver = originalVariableResolver;
    }

    protected final VariableResolver getOriginalVariableResolver() {
        return this.originalVariableResolver;
    }

    public Object resolveVariable(FacesContext context, String name) throws EvaluationException {
        Object value = null;
        if (WEB_APPLICATION_CONTEXT_VARIABLE_NAME.equals(name)) {
            value = this.getWebApplicationContext(context);
        }
        if (value == null) {
            value = this.getOriginalVariableResolver().resolveVariable(context, name);
        }
        return value;
    }

    protected WebApplicationContext getWebApplicationContext(FacesContext facesContext) {
        return FacesContextUtils.getWebApplicationContext(facesContext);
    }
}

