/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.orm.hibernate3;

import com.bmc.thirdparty.org.springframework.core.Ordered;
import com.bmc.thirdparty.org.springframework.dao.DataAccessException;
import com.bmc.thirdparty.org.springframework.dao.DataAccessResourceFailureException;
import com.bmc.thirdparty.org.springframework.jdbc.support.SQLExceptionTranslator;
import com.bmc.thirdparty.org.springframework.orm.hibernate3.SessionFactoryUtils;
import com.bmc.thirdparty.org.springframework.orm.hibernate3.SessionHolder;
import com.bmc.thirdparty.org.springframework.transaction.support.TransactionSynchronizationAdapter;
import com.bmc.thirdparty.org.springframework.transaction.support.TransactionSynchronizationManager;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.SessionImplementor;

class SpringSessionSynchronization
extends TransactionSynchronizationAdapter
implements Ordered {
    private final SessionHolder sessionHolder;
    private final SessionFactory sessionFactory;
    private final SQLExceptionTranslator jdbcExceptionTranslator;
    private final boolean newSession;
    private boolean hibernateTransactionCompletion = false;
    private Transaction jtaTransaction;
    private boolean holderActive = true;

    public SpringSessionSynchronization(SessionHolder sessionHolder, SessionFactory sessionFactory, SQLExceptionTranslator jdbcExceptionTranslator, boolean newSession) {
        this.sessionHolder = sessionHolder;
        this.sessionFactory = sessionFactory;
        this.jdbcExceptionTranslator = jdbcExceptionTranslator;
        this.newSession = newSession;
        TransactionManager jtaTm = SessionFactoryUtils.getJtaTransactionManager(sessionFactory, sessionHolder.getAnySession());
        if (jtaTm != null) {
            this.hibernateTransactionCompletion = true;
            try {
                int jtaStatus = jtaTm.getStatus();
                if (jtaStatus == 0 || jtaStatus == 1) {
                    this.jtaTransaction = jtaTm.getTransaction();
                }
            }
            catch (SystemException ex) {
                throw new DataAccessResourceFailureException("Could not check JTA transaction", ex);
            }
        }
    }

    public int getOrder() {
        return 900;
    }

    public void suspend() {
        if (this.holderActive) {
            TransactionSynchronizationManager.unbindResource(this.sessionFactory);
        }
    }

    public void resume() {
        if (this.holderActive) {
            TransactionSynchronizationManager.bindResource(this.sessionFactory, this.sessionHolder);
        }
    }

    public void beforeCommit(boolean readOnly) throws DataAccessException {
        if (!readOnly) {
            Session session = null;
            if (this.jtaTransaction != null) {
                session = this.sessionHolder.getSession(this.jtaTransaction);
            }
            if (session == null) {
                session = this.sessionHolder.getSession();
            }
            if (!session.getFlushMode().lessThan(FlushMode.COMMIT)) {
                try {
                    SessionFactoryUtils.logger.debug("Flushing Hibernate Session on transaction synchronization");
                    session.flush();
                }
                catch (HibernateException ex) {
                    if (this.jdbcExceptionTranslator != null && ex instanceof JDBCException) {
                        JDBCException jdbcEx = (JDBCException)ex;
                        throw this.jdbcExceptionTranslator.translate("Hibernate flushing: " + jdbcEx.getMessage(), jdbcEx.getSQL(), jdbcEx.getSQLException());
                    }
                    throw SessionFactoryUtils.convertHibernateAccessException(ex);
                }
            }
        }
    }

    public void beforeCompletion() {
        Session session;
        if (this.jtaTransaction != null && (session = this.sessionHolder.removeSession(this.jtaTransaction)) != null) {
            if (this.sessionHolder.isEmpty()) {
                if (TransactionSynchronizationManager.hasResource(this.sessionFactory)) {
                    TransactionSynchronizationManager.unbindResource(this.sessionFactory);
                }
                this.holderActive = false;
            }
            if (session != this.sessionHolder.getSession()) {
                SessionFactoryUtils.closeSessionOrRegisterDeferredClose(session, this.sessionFactory);
            } else if (this.sessionHolder.getPreviousFlushMode() != null) {
                session.setFlushMode(this.sessionHolder.getPreviousFlushMode());
            }
            return;
        }
        if (this.newSession) {
            TransactionSynchronizationManager.unbindResource(this.sessionFactory);
            this.holderActive = false;
            if (this.hibernateTransactionCompletion) {
                SessionFactoryUtils.closeSessionOrRegisterDeferredClose(this.sessionHolder.getSession(), this.sessionFactory);
            }
        } else if (this.sessionHolder.getPreviousFlushMode() != null) {
            this.sessionHolder.getSession().setFlushMode(this.sessionHolder.getPreviousFlushMode());
        }
    }

    public void afterCompletion(int status) {
        Session session;
        if (!this.hibernateTransactionCompletion || !this.newSession) {
            session = this.sessionHolder.getSession();
            if (session instanceof SessionImplementor) {
                ((SessionImplementor)session).afterTransactionCompletion(status == 0, null);
            }
            if (this.newSession) {
                SessionFactoryUtils.closeSessionOrRegisterDeferredClose(session, this.sessionFactory);
            }
        }
        if (!this.newSession) {
            session = this.sessionHolder.getSession();
            if (status != 0) {
                session.clear();
            }
        }
        if (this.sessionHolder.doesNotHoldNonDefaultSession()) {
            this.sessionHolder.setSynchronizedWithTransaction(false);
        }
    }
}

