/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.jms.connection;

import com.bmc.thirdparty.org.springframework.jms.connection.JmsResourceHolder;
import com.bmc.thirdparty.org.springframework.jms.connection.SynchedLocalTransactionFailedException;
import com.bmc.thirdparty.org.springframework.transaction.support.TransactionSynchronizationAdapter;
import com.bmc.thirdparty.org.springframework.transaction.support.TransactionSynchronizationManager;
import com.bmc.thirdparty.org.springframework.util.Assert;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;

public abstract class ConnectionFactoryUtils {
    static /* synthetic */ Class class$javax$jms$Session;
    static /* synthetic */ Class class$javax$jms$QueueSession;
    static /* synthetic */ Class class$javax$jms$QueueConnection;
    static /* synthetic */ Class class$javax$jms$TopicSession;
    static /* synthetic */ Class class$javax$jms$TopicConnection;

    public static Session getTransactionalSession(final ConnectionFactory cf, final Connection existingCon, final boolean synchedLocalTransactionAllowed) throws JMSException {
        return ConnectionFactoryUtils.doGetTransactionalSession(cf, new ResourceFactory(){

            public Session getSession(JmsResourceHolder holder) {
                return holder.getSession(class$javax$jms$Session == null ? (class$javax$jms$Session = ConnectionFactoryUtils.class$("javax.jms.Session")) : class$javax$jms$Session, existingCon);
            }

            public Connection getConnection(JmsResourceHolder holder) {
                return existingCon != null ? existingCon : holder.getConnection();
            }

            public Connection createConnection() throws JMSException {
                return cf.createConnection();
            }

            public Session createSession(Connection con) throws JMSException {
                return con.createSession(synchedLocalTransactionAllowed, 1);
            }

            public boolean isSynchedLocalTransactionAllowed() {
                return synchedLocalTransactionAllowed;
            }
        });
    }

    public static QueueSession getTransactionalQueueSession(final QueueConnectionFactory cf, final QueueConnection existingCon, final boolean synchedLocalTransactionAllowed) throws JMSException {
        return (QueueSession)ConnectionFactoryUtils.doGetTransactionalSession(cf, new ResourceFactory(){

            public Session getSession(JmsResourceHolder holder) {
                return holder.getSession(class$javax$jms$QueueSession == null ? (class$javax$jms$QueueSession = ConnectionFactoryUtils.class$("javax.jms.QueueSession")) : class$javax$jms$QueueSession, (Connection)existingCon);
            }

            public Connection getConnection(JmsResourceHolder holder) {
                return existingCon != null ? existingCon : holder.getConnection(class$javax$jms$QueueConnection == null ? (class$javax$jms$QueueConnection = ConnectionFactoryUtils.class$("javax.jms.QueueConnection")) : class$javax$jms$QueueConnection);
            }

            public Connection createConnection() throws JMSException {
                return cf.createQueueConnection();
            }

            public Session createSession(Connection con) throws JMSException {
                return ((QueueConnection)con).createQueueSession(synchedLocalTransactionAllowed, 1);
            }

            public boolean isSynchedLocalTransactionAllowed() {
                return synchedLocalTransactionAllowed;
            }
        });
    }

    public static TopicSession getTransactionalTopicSession(final TopicConnectionFactory cf, final TopicConnection existingCon, final boolean synchedLocalTransactionAllowed) throws JMSException {
        return (TopicSession)ConnectionFactoryUtils.doGetTransactionalSession(cf, new ResourceFactory(){

            public Session getSession(JmsResourceHolder holder) {
                return holder.getSession(class$javax$jms$TopicSession == null ? (class$javax$jms$TopicSession = ConnectionFactoryUtils.class$("javax.jms.TopicSession")) : class$javax$jms$TopicSession, (Connection)existingCon);
            }

            public Connection getConnection(JmsResourceHolder holder) {
                return existingCon != null ? existingCon : holder.getConnection(class$javax$jms$TopicConnection == null ? (class$javax$jms$TopicConnection = ConnectionFactoryUtils.class$("javax.jms.TopicConnection")) : class$javax$jms$TopicConnection);
            }

            public Connection createConnection() throws JMSException {
                return cf.createTopicConnection();
            }

            public Session createSession(Connection con) throws JMSException {
                return ((TopicConnection)con).createTopicSession(synchedLocalTransactionAllowed, 1);
            }

            public boolean isSynchedLocalTransactionAllowed() {
                return synchedLocalTransactionAllowed;
            }
        });
    }

    public static Session doGetTransactionalSession(Object resourceKey, ResourceFactory resourceFactory) throws JMSException {
        Session session;
        Assert.notNull(resourceKey, "Resource key must not be null");
        Assert.notNull(resourceKey, "ResourceFactory must not be null");
        JmsResourceHolder resourceHolder = (JmsResourceHolder)TransactionSynchronizationManager.getResource(resourceKey);
        if (resourceHolder != null && ((session = resourceFactory.getSession(resourceHolder)) != null || resourceHolder.isFrozen())) {
            return session;
        }
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            return null;
        }
        JmsResourceHolder conHolderToUse = resourceHolder;
        if (conHolderToUse == null) {
            conHolderToUse = new JmsResourceHolder();
        }
        Connection con = resourceFactory.getConnection(conHolderToUse);
        Session session2 = null;
        try {
            boolean isExistingCon;
            boolean bl = isExistingCon = con != null;
            if (!isExistingCon) {
                con = resourceFactory.createConnection();
                conHolderToUse.addConnection(con);
            }
            session2 = resourceFactory.createSession(con);
            conHolderToUse.addSession(session2, con);
            if (!isExistingCon) {
                con.start();
            }
        }
        catch (JMSException ex) {
            if (session2 != null) {
                try {
                    session2.close();
                }
                catch (Throwable ex2) {
                    // empty catch block
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (Throwable ex2) {
                    // empty catch block
                }
            }
            throw ex;
        }
        if (conHolderToUse != resourceHolder) {
            TransactionSynchronizationManager.registerSynchronization(new JmsResourceSynchronization(resourceKey, conHolderToUse, resourceFactory.isSynchedLocalTransactionAllowed()));
            conHolderToUse.setSynchronizedWithTransaction(true);
            TransactionSynchronizationManager.bindResource(resourceKey, conHolderToUse);
        }
        return session2;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class JmsResourceSynchronization
    extends TransactionSynchronizationAdapter {
        private final Object resourceKey;
        private final JmsResourceHolder resourceHolder;
        private final boolean transacted;
        private boolean holderActive = true;

        public JmsResourceSynchronization(Object resourceKey, JmsResourceHolder resourceHolder, boolean transacted) {
            this.resourceKey = resourceKey;
            this.resourceHolder = resourceHolder;
            this.transacted = transacted;
        }

        public void suspend() {
            if (this.holderActive) {
                TransactionSynchronizationManager.unbindResource(this.resourceKey);
            }
        }

        public void resume() {
            if (this.holderActive) {
                TransactionSynchronizationManager.bindResource(this.resourceKey, this.resourceHolder);
            }
        }

        public void beforeCompletion() {
            TransactionSynchronizationManager.unbindResource(this.resourceKey);
            this.holderActive = false;
            if (!this.transacted) {
                this.resourceHolder.closeAll();
            }
        }

        public void afterCommit() {
            if (this.transacted) {
                try {
                    this.resourceHolder.commitAll();
                }
                catch (JMSException ex) {
                    throw new SynchedLocalTransactionFailedException("Local JMS transaction failed to commit", ex);
                }
            }
        }

        public void afterCompletion(int status) {
            if (this.transacted) {
                this.resourceHolder.closeAll();
            }
        }
    }

    public static interface ResourceFactory {
        public Session getSession(JmsResourceHolder var1);

        public Connection getConnection(JmsResourceHolder var1);

        public Connection createConnection() throws JMSException;

        public Session createSession(Connection var1) throws JMSException;

        public boolean isSynchedLocalTransactionAllowed();
    }
}

