/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.beans.factory.xml;

import com.bmc.thirdparty.org.springframework.beans.factory.config.BeanDefinition;
import com.bmc.thirdparty.org.springframework.beans.factory.config.BeanDefinitionHolder;
import com.bmc.thirdparty.org.springframework.beans.factory.parsing.BeanComponentDefinition;
import com.bmc.thirdparty.org.springframework.beans.factory.support.AbstractBeanDefinition;
import com.bmc.thirdparty.org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import com.bmc.thirdparty.org.springframework.beans.factory.support.BeanDefinitionRegistry;
import com.bmc.thirdparty.org.springframework.beans.factory.xml.BeanDefinitionParser;
import com.bmc.thirdparty.org.springframework.beans.factory.xml.ParserContext;
import com.bmc.thirdparty.org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public abstract class AbstractBeanDefinitionParser
implements BeanDefinitionParser {
    public static final String ID_ATTRIBUTE = "id";

    public final BeanDefinition parse(Element element, ParserContext parserContext) {
        AbstractBeanDefinition definition = this.parseInternal(element, parserContext);
        String id = this.resolveId(element, definition, parserContext);
        if (!StringUtils.hasText(id) && !parserContext.isNested()) {
            throw new IllegalArgumentException("Id is required for element '" + element.getLocalName() + "' when used as a top-level tag");
        }
        BeanDefinitionHolder holder = new BeanDefinitionHolder(definition, id);
        this.registerBeanDefinition(holder, parserContext.getRegistry(), parserContext.isNested());
        if (this.shouldFireEvents()) {
            BeanComponentDefinition componentDefinition = new BeanComponentDefinition(holder);
            this.postProcessComponentDefinition(componentDefinition);
            parserContext.getReaderContext().fireComponentRegistered(componentDefinition);
        }
        return definition;
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) {
        if (this.shouldGenerateId()) {
            return BeanDefinitionReaderUtils.generateBeanName(definition, parserContext.getRegistry(), parserContext.isNested());
        }
        return element.getAttribute(ID_ATTRIBUTE);
    }

    protected void registerBeanDefinition(BeanDefinitionHolder bean, BeanDefinitionRegistry registry, boolean isNested) {
        if (!isNested) {
            BeanDefinitionReaderUtils.registerBeanDefinition(bean, registry);
        }
    }

    protected abstract AbstractBeanDefinition parseInternal(Element var1, ParserContext var2);

    protected boolean shouldGenerateId() {
        return false;
    }

    protected boolean shouldFireEvents() {
        return true;
    }

    protected void postProcessComponentDefinition(BeanComponentDefinition componentDefinition) {
    }
}

