/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.demo.javadriver;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.LoggingInfo;
import com.bmc.arsys.api.ProxyManager;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.WfdBreakpoint;
import com.bmc.arsys.api.WfdDebugLocation;
import com.bmc.arsys.api.WfdUserContext;
import com.bmc.arsys.demo.javadriver.InputReader;
import com.bmc.arsys.demo.javadriver.JavaDriver;
import com.bmc.arsys.demo.javadriver.LocaleCharSet;
import com.bmc.arsys.demo.javadriver.SyncObject;
import com.bmc.arsys.demo.javadriver.ThreadControlBlock;
import com.bmc.arsys.demo.javadriver.ThreadStartInfo;
import com.bmc.arsys.demo.javadriver.WfdCommands;
import com.bmc.arsys.demo.javadriver.WfdOutputWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class WFD
extends JavaDriver {
    boolean executeCommand = true;
    static int quietMode = 0;
    static int randomNumberSeed;
    static String resultDirectory;
    boolean primaryThread = false;
    static String[] commandLineArgs;
    static int maxConnectionPerServer;
    static WfdOutputWriter outputWriter;
    static int currentRpcQueue;
    static boolean javaDriverOnly;
    static int SUPPRESS_RESULTS;
    static int SUPPRESS_HEADERS;
    static int SUPPRESS_PROMPTS;
    static int SUPPRESS_MENU;
    static int SUPPRESS_ERRORS;
    static int SUPPRESS_WARNINGS;
    static int SUPPRESS_TIME;
    static int SUPPRESS_DATE;
    static int SUPPRESS_FOR_WFD;
    static int MAX_NESTED_LOOP_DEPTH;
    static int RAND_MAX;
    static List<WfdBreakpoint> Breakpoints;

    void printAuxillaryStatus() {
    }

    public ARServerUser getControlStructObject() {
        ThreadControlBlock threadControlBlock = WFD.getThreadControlBlockPtr();
        return threadControlBlock.getContext();
    }

    public void setPrimaryThread(boolean bl) {
        this.primaryThread = bl;
    }

    public boolean isPrimaryThread() {
        return this.primaryThread;
    }

    public void setCommandLineArgs(String[] stringArray) {
        commandLineArgs = stringArray;
    }

    public String[] getCommandLineArgs() {
        return commandLineArgs;
    }

    public static void setResultDirectory(String string) {
        resultDirectory = string;
    }

    public static String getResultDirectory() {
        return resultDirectory;
    }

    public static void setQuietMode(int n) {
        quietMode = n;
    }

    public static int getQuietMode() {
        return quietMode;
    }

    public static void setRandomNumberSeed(int n) {
        randomNumberSeed = n;
    }

    public static int getRandomNumberSeed() {
        return randomNumberSeed;
    }

    public static boolean notWfdQuiet() {
        return (quietMode & SUPPRESS_FOR_WFD) != 0;
    }

    int getNextCommand(StringBuilder stringBuilder) throws IOException {
        ThreadControlBlock threadControlBlock = WFD.getThreadControlBlockPtr();
        threadControlBlock.setArgs(null);
        outputWriter.driverPrintPrompt("\nCommand: ");
        int n = -99;
        while (n == -99) {
            String string;
            InputReader.getInputLine();
            String string2 = string = threadControlBlock.getBuffer();
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) != ' ') continue;
                char[] cArray = new char[string.length() - i - 1];
                string.getChars(i + 1, string.length(), cArray, 0);
                String string3 = new String(cArray);
                threadControlBlock.setArgs(string3);
                char[] cArray2 = new char[i];
                string.getChars(0, i, cArray2, 0);
                string2 = new String(cArray2);
                break;
            }
            if (string2.length() == 0 || string2.charAt(0) == '#') {
                outputWriter.driverPrintPrompt("\nCommand: ");
                continue;
            }
            if (string2.length() > 6) {
                outputWriter.driverPrintError(" ***Command too long, unrecognized ****\n");
                outputWriter.driverPrintPrompt("\nCommand: ");
                continue;
            }
            if (string2.equals("h") || string2.equals("?")) {
                outputWriter.driverPrintHelp();
                outputWriter.driverPrintPrompt("\nCommand: ");
                continue;
            }
            if (string2.equals("e") || string2.equals("q") || string2.equals("x")) {
                n = -1;
                continue;
            }
            n = WfdCommands.getCommandCode(string2);
            if (n != -2) {
                threadControlBlock.setCurrentCommand(string2);
                continue;
            }
            outputWriter.driverPrintError(" *** Command not recognized ***\n");
            outputWriter.driverPrintPrompt("\nCommand: ");
        }
        return n;
    }

    public void processCommands() throws IOException {
        int n = -1;
        StringBuilder stringBuilder = new StringBuilder();
        InputReader.setNullPromptOption(true);
        if (this.getControlStructObject().getServer() != null) {
            try {
                this.getControlStructObject().wfdSetDebugMode(65535);
            }
            catch (ARException aRException) {
                aRException.printStackTrace();
            }
        }
        block38: while ((n = this.getNextCommand(stringBuilder)) != -1) {
            stringBuilder = new StringBuilder();
            switch (n) {
                case 0: {
                    this.getARServerUser();
                    continue block38;
                }
                case 1: {
                    this.wfdInitialization();
                    continue block38;
                }
                case 2: {
                    this.termination();
                    continue block38;
                }
                case 3: {
                    this.setServerPort();
                    continue block38;
                }
                case 4: {
                    this.wfdExec(0);
                    this.wfdGetCurrentLocation();
                    continue block38;
                }
                case 28: {
                    this.releaseRunThread();
                    continue block38;
                }
                case 5: {
                    this.wfdGoToBp();
                    this.wfdGetCurrentLocation();
                    continue block38;
                }
                case 6: {
                    this.wfdGetCurrentLocation();
                    continue block38;
                }
                case 7: {
                    this.wfdGetFieldValues();
                    continue block38;
                }
                case 8: {
                    this.wfdSetFieldValues();
                    continue block38;
                }
                case 9: {
                    this.wfdGetDebugMode();
                    continue block38;
                }
                case 10: {
                    this.wfdSetDebugMode();
                    continue block38;
                }
                case 29: {
                    this.wfdDoSetDebugMode(65535);
                    continue block38;
                }
                case 30: {
                    this.wfdDoSetDebugMode(0);
                    continue block38;
                }
                case 11: {
                    this.wfdGetFilterQual();
                    continue block38;
                }
                case 12: {
                    this.wfdSetQualifierResult();
                    continue block38;
                }
                case 13: {
                    this.wfdSetBreakPt();
                    continue block38;
                }
                case 14: {
                    this.wfdClrBreakPt();
                    continue block38;
                }
                case 15: {
                    this.wfdListBreakPt();
                    continue block38;
                }
                case 16: {
                    this.wfdClearBpList();
                    continue block38;
                }
                case 17: {
                    this.wfdTerminateAPI();
                    continue block38;
                }
                case 18: {
                    this.wfdGetStackLocation();
                    continue block38;
                }
                case 20: {
                    this.wfdDumpStack();
                    continue block38;
                }
                case 19: {
                    this.wfdFinishAPI();
                    continue block38;
                }
                case 22: {
                    this.wfdGetKeyword();
                    continue block38;
                }
                case 23: {
                    this.wfdGetUserContext();
                    continue block38;
                }
                case 24: {
                    this.wfdRmtSetBreakPt();
                    continue block38;
                }
                case 25: {
                    this.wfdRmtClrBreakPt();
                    continue block38;
                }
                case 26: {
                    this.wfdRmtListBreakPt();
                    continue block38;
                }
                case 27: {
                    this.wfdRmtClearBpList();
                    continue block38;
                }
                case 31: {
                    outputWriter.printExtraHelp();
                    continue block38;
                }
                case 21: {
                    this.wfdRestart();
                    continue block38;
                }
            }
            outputWriter.driverPrintNotSupportCommand(n);
        }
        if (this.getControlStructObject().getServer() != null) {
            try {
                this.getControlStructObject().wfdSetDebugMode(0);
            }
            catch (ARException aRException) {
                aRException.printStackTrace();
            }
        }
    }

    void setClientType() {
        this.getControlStructObject().setClientType(3);
    }

    boolean processCommandLine() {
        String[] stringArray = this.getCommandLineArgs();
        int n = 0;
        String string = null;
        int n2 = 0;
        ThreadControlBlock threadControlBlock = WFD.getThreadControlBlockPtr();
        int n3 = 0;
        if (stringArray != null) {
            n3 = stringArray.length;
        }
        block23: for (int i = 0; i < n3; ++i) {
            if (stringArray[i].charAt(0) != '-' || stringArray[i].charAt(1) != 'u' && stringArray[i].charAt(1) != 'p' && stringArray[i].charAt(1) != 'l' && stringArray[i].charAt(1) != 's' && stringArray[i].charAt(1) != 'x' && stringArray[i].charAt(1) != 'o' && stringArray[i].charAt(1) != 'd' && stringArray[i].charAt(1) != 'q' && stringArray[i].charAt(1) != 'g' && stringArray[i].charAt(1) != 'c' && stringArray[i].charAt(1) != 'a' && stringArray[i].charAt(1) != 'S') {
                outputWriter.driverPrintError("Unrecognized option " + stringArray[i] + "\n");
                return false;
            }
            char c = stringArray[i].charAt(1);
            if (stringArray[i].length() > 2) {
                int n4 = stringArray[i].length() - 2;
                char[] cArray = new char[n4];
                stringArray[i].getChars(2, stringArray[i].length(), cArray, 0);
                string = new String(cArray);
            } else if (++i < n3) {
                string = stringArray[i];
            } else {
                outputWriter.driverPrintError("Missing value for -" + c + "  option\n");
                return false;
            }
            switch (c) {
                case 'a': 
                case 'l': 
                case 'p': 
                case 's': 
                case 'u': {
                    n = 254;
                    break;
                }
                case 'd': 
                case 'x': {
                    n = 255;
                    break;
                }
                case 'o': 
                case 'q': {
                    n = 3;
                    break;
                }
                case 'S': 
                case 'g': {
                    n = 10;
                    break;
                }
                case 'c': {
                    n = 5;
                }
            }
            if (string.length() > n) {
                outputWriter.driverPrintError("Value for -" + c + "  option is too long: " + string + "\n");
                return false;
            }
            char[] cArray = null;
            switch (c) {
                case 'u': {
                    int n5;
                    boolean bl = false;
                    for (n5 = 0; n5 < string.length(); ++n5) {
                        if (string.charAt(n5) != '\\') continue;
                        cArray = new char[n5];
                        string.getChars(0, n5, cArray, 0);
                        threadControlBlock.setAuthentication(new String(cArray));
                        bl = true;
                        break;
                    }
                    if (bl) {
                        int n6 = string.length() - n5 - 1;
                        cArray = new char[n6];
                        string.getChars(n5 + 1, string.length(), cArray, 0);
                        threadControlBlock.setUser(new String(cArray));
                    } else {
                        threadControlBlock.setUser(string);
                    }
                    outputWriter.printString("Setting user to " + string + "\n");
                    continue block23;
                }
                case 'a': {
                    threadControlBlock.setAuthentication(string);
                    continue block23;
                }
                case 'p': {
                    threadControlBlock.setPassword(string);
                    continue block23;
                }
                case 'l': {
                    threadControlBlock.setLocale(string);
                    continue block23;
                }
                case 's': {
                    threadControlBlock.setServer(string);
                    outputWriter.printString("Setting server to " + string + "\n");
                    continue block23;
                }
                case 'S': {
                    n2 = new Integer(string);
                    continue block23;
                }
                case 'x': {
                    this.openInputFile(string);
                    continue block23;
                }
                case 'o': {
                    this.setOutputSetting(string);
                    continue block23;
                }
                case 'd': {
                    resultDirectory = string;
                    continue block23;
                }
                case 'q': {
                    quietMode = new Integer(string);
                    continue block23;
                }
                case 'g': {
                    randomNumberSeed = new Integer(string);
                    continue block23;
                }
                case 'c': {
                    this.setOutputCount(string);
                }
            }
        }
        if (n2 != 0) {
            try {
                this.getControlStructObject().usePrivateRpcQueue(n2);
                currentRpcQueue = n2;
            }
            catch (ARException aRException) {
                outputWriter.printARException(aRException);
            }
        }
        outputWriter.printString("Setting RPC Queue to " + n2 + "\n");
        return true;
    }

    protected void setOutputSetting(String string) {
        ProxyManager.setConnectionLimits(maxConnectionPerServer);
    }

    protected void setOutputCount(String string) {
    }

    void getARServerUser() {
        try {
            InputReader.getARServerUser();
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            outputWriter.printString("Bad User or Password...\n");
        }
    }

    void openInputFile(String string) {
        try {
            InputReader.openInputFile(string);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
    }

    void closeOutputFile() {
        outputWriter.closeOutputFile();
    }

    void openOutputFile() {
        try {
            String string = InputReader.getString("Filename of output file (): ", "");
            outputWriter.openOutputFile(string);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
    }

    void startRecording() {
        String string = null;
        try {
            ThreadControlBlock threadControlBlock = WFD.getThreadControlBlockPtr();
            if (threadControlBlock.getRecordFile() != null) {
                outputWriter.driverPrintWarning(" **** Recording already active; stop previous to start new\n");
            } else {
                string = InputReader.getString("Filename of record file (): ", "");
                if (string == null || string.length() == 0) {
                    outputWriter.driverPrintError(" **** No filename specified so no recording started\n");
                } else {
                    threadControlBlock.setRecordFile(new PrintWriter(new FileOutputStream(new File(string))));
                }
            }
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...or opening the file " + string + "  .\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
    }

    void stopRecording() {
        try {
            ThreadControlBlock threadControlBlock = WFD.getThreadControlBlockPtr();
            if (threadControlBlock.getRecordFile() == null) {
                outputWriter.driverPrintWarning(" **** Recording is not active\n");
            } else {
                threadControlBlock.setRecordFile(null);
            }
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
    }

    void beginLoop() {
        try {
            outputWriter.driverPrintHeader("BEGIN LOOP");
            ThreadControlBlock threadControlBlock = WFD.getThreadControlBlockPtr();
            if (threadControlBlock.isCurrentInputSourceStdInput()) {
                outputWriter.driverPrintError("\n*** Command must be issued from input file\n");
                return;
            }
            int n = InputReader.getInt("Number of iterations (1): ", 1);
            if (n <= 0) {
                n = 1;
            }
            if (threadControlBlock.getCurrentLoopDepth() == MAX_NESTED_LOOP_DEPTH - 1) {
                outputWriter.driverPrintError("\n*** Maximum nested loop depth exceeded\n");
                threadControlBlock.incrementNumFailedBeginLoop();
                return;
            }
            threadControlBlock.incrementCurrentLoopDepth();
            threadControlBlock.setNumberOfIterations(threadControlBlock.getCurrentLoopDepth(), n);
            threadControlBlock.setLoopBeginFilePos(threadControlBlock.getCurrentLoopDepth(), threadControlBlock.getCurrentInputFilePos());
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
    }

    void endLoop() throws IOException, FileNotFoundException {
        try {
            outputWriter.driverPrintHeader("END LOOP");
            ThreadControlBlock threadControlBlock = WFD.getThreadControlBlockPtr();
            if (threadControlBlock.isCurrentInputSourceStdInput()) {
                outputWriter.driverPrintError("\n*** Command must be issued from input file\n");
                return;
            }
            if (threadControlBlock.getCurrentLoopDepth() < 0) {
                outputWriter.driverPrintWarning("\n*** Command ignored because no corresponding begin loop issued\n");
                return;
            }
            if (threadControlBlock.getNumFailedBeginLoop() > 0) {
                outputWriter.driverPrintWarning("\n*** Command ignored because previous begin loop failed\n");
                threadControlBlock.reduceNumFailedBeginLoop();
                return;
            }
            long l = threadControlBlock.getNumberOfIterations(threadControlBlock.getCurrentLoopDepth());
            threadControlBlock.reduceNumberOfIterations(threadControlBlock.getCurrentLoopDepth());
            if (l - 1L > 0L) {
                int n = threadControlBlock.getCurrentLoopDepth();
                long l2 = threadControlBlock.getLoopBeginFilePos(n);
                threadControlBlock.setCurrentInputFileReadingPostion(l2);
            } else {
                threadControlBlock.reduceCurrentLoopDepth();
            }
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
    }

    void setLogging() {
        try {
            boolean bl = InputReader.getBooleanForChangingInfo("enable logging? (T):", true);
            long l = 0L;
            long l2 = 0L;
            String string = null;
            if (bl) {
                l = InputReader.getLong("Logging Type NONE(0), SQL(1), Filter(2), API(16)? (0): ", 0L);
                l2 = InputReader.getLong("Return logging records to file(1), status list(2)? (1): ", 1L);
                if ((int)(l2 & 1L) == 1) {
                    string = InputReader.getString("Name of file to hold returned records: ", "");
                }
            }
            LoggingInfo loggingInfo = new LoggingInfo(bl, l, l2, string);
            this.getControlStructObject().setLogging(loggingInfo);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void wfdExecute() {
        try {
            if (WFD.notWfdQuiet()) {
                outputWriter.driverPrintHeader("WFD EXECUTE");
            }
            int n = InputReader.getInt("Execute mode ? (0): ", 0);
            this.beginAPICall();
            this.getControlStructObject().wfdExecute(n);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Wfd Get Current Location Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void wfdGetCurrentLocation() {
        WfdDebugLocation wfdDebugLocation = null;
        try {
            if (WFD.notWfdQuiet()) {
                outputWriter.driverPrintHeader("WFD GET CURRENT LOCATION");
            }
            wfdDebugLocation = this.getControlStructObject().wfdGetDebugLocation(0);
            outputWriter.printCurrentLocation("Current Location:\n", wfdDebugLocation);
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void wfdGetDebugMode() {
        try {
            if (WFD.notWfdQuiet()) {
                outputWriter.driverPrintHeader("WFD GET DEBUG MODE");
            }
            this.beginAPICall();
            int n = this.getControlStructObject().wfdGetDebugMode();
            this.endAPICall(this.getControlStructObject().getLastStatus());
            System.out.print("Current DebugMode (stop at):\n" + ((n & 1) != 0 ? "   Begin API\n" : "") + ((n & 4) != 0 ? "   Qualfier\n" : "") + ((n & 8) != 0 ? "   Phase 1\n" : "") + ((n & 0x10) != 0 ? "   Phase 2\n" : "") + ((n & 0x20) != 0 ? "   Phase 3\n" : "") + ((n & 2) != 0 ? "   End API\n" : "") + ((n & 0x40) != 0 ? "   Esc Action\n" : "") + ((n & 0x80) != 0 ? "   CMDB\n" : ""));
            List<StatusInfo> list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Wfd Get Debug Mode Status", list);
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void wfdDoSetDebugMode(int n) {
        try {
            if (WFD.notWfdQuiet()) {
                outputWriter.driverPrintHeader("WFD SET DEBUG MODE");
            }
            this.beginAPICall();
            this.getControlStructObject().wfdSetDebugMode(n);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Wfd Set Debug Mode Status", list);
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void wfdSetDebugMode() {
        int n = 0;
        try {
            if (WFD.notWfdQuiet()) {
                outputWriter.driverPrintHeader("WFD SET DEBUG MODE");
            }
            outputWriter.driverPrintHeader("Debug Mode to set (stop at)? : ");
            n = InputReader.getBoolean("   Begin API (T): ", true) ? (n |= 1) : (n &= 0xFFFFFFFE);
            n = InputReader.getBoolean("   Qualifier (T): ", true) ? (n |= 4) : (n &= 0xFFFFFFFB);
            n = InputReader.getBoolean("   Phase 1 (T): ", true) ? (n |= 8) : (n &= 0xFFFFFFF7);
            n = InputReader.getBoolean("   Phase 2 (T): ", true) ? (n |= 0x10) : (n &= 0xFFFFFFEF);
            n = InputReader.getBoolean("   Phase 3 (T): ", true) ? (n |= 0x20) : (n &= 0xFFFFFFDF);
            n = InputReader.getBoolean("   End API (T): ", true) ? (n |= 2) : (n &= 0xFFFFFFFD);
            n = InputReader.getBoolean("   Esc Action (T): ", true) ? (n |= 0x40) : (n &= 0xFFFFFFBF);
            n = InputReader.getBoolean("   CMDB (T): ", true) ? (n |= 0x80) : (n &= 0xFFFFFF7F);
            this.wfdDoSetDebugMode(n);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
    }

    void wfdGetFieldValues() {
        try {
            if (WFD.notWfdQuiet()) {
                outputWriter.driverPrintHeader("WFD GET FIELD VALUES");
            }
            int n = InputReader.getInt("Field from stack frame ? (0): ", 0);
            this.beginAPICall();
            List<Entry> list = this.getControlStructObject().wfdGetFieldValues(n);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printEntry("", "Transaction Fields - ", list.get(0));
            outputWriter.printEntry("", "Database Fields - ", list.get(1));
            List<StatusInfo> list2 = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Wfd Get Field Values Status", list2);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void wfdSetFieldValues() {
        try {
            if (WFD.notWfdQuiet()) {
                outputWriter.driverPrintHeader("WFD Set Field Values");
            }
            ArrayList<Entry> arrayList = new ArrayList<Entry>(2);
            outputWriter.driverPrintPrompt("Field/value pairs to set in transaction list:\n");
            Entry entry = InputReader.getEntry();
            outputWriter.driverPrintPrompt("Field/value pairs to set in database list:\n");
            Entry entry2 = InputReader.getEntry();
            arrayList.add(0, entry);
            arrayList.add(1, entry2);
            this.beginAPICall();
            this.getControlStructObject().wfdSetFieldValues(arrayList);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Wfd Set Debug Mode Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void wfdGetFilterQual() {
        try {
            if (WFD.notWfdQuiet()) {
                outputWriter.driverPrintHeader("WFD GET FILTER QUALIFIER");
            }
            this.beginAPICall();
            QualifierInfo qualifierInfo = this.getControlStructObject().wfdGetFilterQual();
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printQualifierInfo("", "Filter Qualifier:\n", qualifierInfo);
            List<StatusInfo> list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Wfd Get Filter Qualifier Status", list);
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void wfdTerminateAPI() {
        try {
            if (WFD.notWfdQuiet()) {
                outputWriter.driverPrintHeader("WFD Terminate API");
            }
            int n = InputReader.getInt("Error Code to return (AR_ERROR_TERMINATED_BY_DEBUGGER): ", 9871);
            this.beginAPICall();
            this.getControlStructObject().wfdTerminateAPI(n);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Wfd Terminate API Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void wfdSetQualifierResult() {
        try {
            if (WFD.notWfdQuiet()) {
                outputWriter.driverPrintHeader("WFD Set Qualifier Result");
            }
            boolean bl = InputReader.getNullPromptOption();
            InputReader.setNullPromptOption(true);
            boolean bl2 = InputReader.getBoolean("Set Qualfier Result, T/F? (T): ", true);
            InputReader.setNullPromptOption(bl);
            this.beginAPICall();
            this.getControlStructObject().wfdSetQualifierResult(bl2);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Wfd Set Qualifier Result Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void wfdGetKeyword() {
        try {
            if (WFD.notWfdQuiet()) {
                outputWriter.driverPrintHeader("WFD Get Keyword Value");
            }
            int n = InputReader.getInt("Keyword ID ? (1): ", 1);
            Value value = new Value();
            this.beginAPICall();
            value = this.getControlStructObject().wfdGetKeywordValue(n);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printValue("", "Keyword Value:", value);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void wfdGetUserContext() {
        try {
            if (WFD.notWfdQuiet()) {
                outputWriter.driverPrintHeader("WFD Get User Context");
            }
            int n = InputReader.getInt("Context Mask? (0): ", 0);
            this.beginAPICall();
            WfdUserContext wfdUserContext = this.getControlStructObject().wfdGetUserContext(n);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printWfdUserContext("User Context:", wfdUserContext);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    WfdBreakpoint FindEmptyBP() {
        WfdBreakpoint wfdBreakpoint;
        int n;
        for (n = 0; n < Breakpoints.size(); ++n) {
            wfdBreakpoint = Breakpoints.get(n);
            if (wfdBreakpoint == null) {
                wfdBreakpoint = new WfdBreakpoint();
                Breakpoints.add(n, wfdBreakpoint);
                wfdBreakpoint.id = n;
                continue;
            }
            if (wfdBreakpoint.filter.length() != 0) continue;
            return wfdBreakpoint;
        }
        wfdBreakpoint = new WfdBreakpoint();
        Breakpoints.add(n, wfdBreakpoint);
        return wfdBreakpoint;
    }

    void wfdSetBreakPt() {
        WfdBreakpoint wfdBreakpoint = this.FindEmptyBP();
        if (wfdBreakpoint != null) {
            try {
                wfdBreakpoint.filter = InputReader.getString("  BP location -\n  Filter: ", "");
                wfdBreakpoint.schema = InputReader.getString("  Schema (*): ", "*");
                wfdBreakpoint.stage = 3 + InputReader.getInt("  Stage PreQual/Phase1/Phase2/Phase3/Escl/CMDB (0-5) (1): ", 1);
                if (wfdBreakpoint.stage < 3 || wfdBreakpoint.stage > 8) {
                    wfdBreakpoint.filter = null;
                    wfdBreakpoint.schema = null;
                    outputWriter.printString("Invalid stage " + wfdBreakpoint.stage);
                    return;
                }
                wfdBreakpoint.elsePath = InputReader.getBoolean("  Else path? (0): ", false);
                wfdBreakpoint.actionNo = InputReader.getInt("  Action number (0): ", 0);
                wfdBreakpoint.disable = false;
                wfdBreakpoint.passcount = 0;
            }
            catch (IOException iOException) {
                outputWriter.printString("Problem in getting the input...Driver problem..\n");
            }
            return;
        }
        outputWriter.printString("Problem allocating BreakPoint!\n");
    }

    void wfdClearBpList() {
        for (int i = 0; i < Breakpoints.size(); ++i) {
            WfdBreakpoint wfdBreakpoint = Breakpoints.get(i);
            if (wfdBreakpoint == null) continue;
            wfdBreakpoint.filter = "";
        }
    }

    void wfdClrBreakPt() {
        int n = 0;
        try {
            n = InputReader.getInt("Breakpoint to clear (0): ", 0);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        try {
            WfdBreakpoint wfdBreakpoint = Breakpoints.get(n);
            if (wfdBreakpoint != null) {
                wfdBreakpoint.filter = "";
            }
        }
        catch (RuntimeException runtimeException) {
            outputWriter.printString("Breakpoint " + n + " not found..\n");
        }
    }

    void wfdListBreakPt() {
        for (int i = 0; i < Breakpoints.size(); ++i) {
            WfdBreakpoint wfdBreakpoint = Breakpoints.get(i);
            if (wfdBreakpoint.filter.length() == 0) continue;
            outputWriter.printBreakpoint("", wfdBreakpoint, true);
        }
    }

    boolean checkForBP(WfdDebugLocation wfdDebugLocation) {
        for (int i = 0; i < Breakpoints.size(); ++i) {
            WfdBreakpoint wfdBreakpoint = Breakpoints.get(i);
            if (wfdBreakpoint.filter.length() == 0 || !wfdBreakpoint.filter.equals(wfdDebugLocation.Filter) || !wfdBreakpoint.schema.equals("*") && !wfdBreakpoint.schema.equals(wfdDebugLocation.SchemaName) || wfdBreakpoint.stage != wfdDebugLocation.Stage || wfdBreakpoint.elsePath != wfdDebugLocation.ElsePath || wfdBreakpoint.actionNo != wfdDebugLocation.ActionNo) continue;
            outputWriter.printString("*** BreakPoint #" + i + " encountered:\n");
            return true;
        }
        return false;
    }

    void wfdGoToBp() {
        WfdDebugLocation wfdDebugLocation = null;
        outputWriter.printString("WFD Run To BP");
        try {
            while (true) {
                this.getControlStructObject().wfdExecute(0);
                wfdDebugLocation = this.getControlStructObject().wfdGetDebugLocation(0);
                if (wfdDebugLocation.Stage != 0) break;
                WFD.sleep(500L);
            }
            while (true) {
                wfdDebugLocation = this.getControlStructObject().wfdGetDebugLocation(0);
                if (wfdDebugLocation.Stage != 0 && !this.checkForBP(wfdDebugLocation)) {
                    if (wfdDebugLocation.Stage == 1) continue;
                    this.getControlStructObject().wfdExecute(0);
                    continue;
                }
                break;
            }
        }
        catch (ARException aRException) {
            outputWriter.printARException(aRException);
        }
        catch (InterruptedException interruptedException) {
            outputWriter.printString("Interrupted while waiting for breakpoint.\n");
            interruptedException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchThread(boolean bl) {
        block11: {
            ThreadStartInfo threadStartInfo = new ThreadStartInfo();
            try {
                SyncObject syncObject;
                ThreadControlBlock threadControlBlock = WFD.getThreadControlBlockPtr();
                threadStartInfo.setOutputToStdOut();
                threadStartInfo.setAuthentication(this.getControlStructObject().getAuthentication());
                threadStartInfo.setUser(this.getControlStructObject().getUser());
                threadStartInfo.setPassword(this.getControlStructObject().getPassword());
                LocaleCharSet localeCharSet = new LocaleCharSet(this.getControlStructObject().getLocale());
                threadStartInfo.setLocale(localeCharSet.getLocale());
                threadStartInfo.setCharset(localeCharSet.getCharSet());
                threadStartInfo.setServer(this.getControlStructObject().getServer());
                threadStartInfo.setUpperBound(0L);
                threadStartInfo.setWaitFlag(bl);
                if (bl) {
                    threadStartInfo.setWaitObject(threadControlBlock.getWaitObject());
                    threadStartInfo.setReleaseObject(threadControlBlock.getReleaseObject());
                }
                WFD wFD = this.instantiateWFD();
                wFD.setThreadStartInfo(threadStartInfo);
                wFD.setPrimaryThread(false);
                wFD.start();
                threadControlBlock.addThreadHandle(wFD);
                if (!bl) break block11;
                SyncObject syncObject2 = syncObject = threadControlBlock.getWaitObject();
                synchronized (syncObject2) {
                    try {
                        while (!syncObject.getFlag()) {
                            syncObject.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        syncObject.setFlag(true);
                        System.out.println("Interrupted Exception ...in simplethread run");
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                try {
                    threadStartInfo.cleanUp();
                    outputWriter.driverPrintException(nullPointerException);
                }
                catch (IOException iOException) {
                    outputWriter.printString("Problem in cleaning up the thread start info..\n");
                }
            }
        }
    }

    protected WFD instantiateWFD() {
        return new WFD();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void threadStartFunction() throws IOException {
        SyncObject syncObject;
        ThreadControlBlock threadControlBlock = WFD.getThreadControlBlockPtr();
        threadControlBlock.setCurrentInputToStdIn();
        threadControlBlock.setOutputFile(this.threadStartInfoObject.getOutputFile(), this.threadStartInfoObject.getOutputFileName(), this.threadStartInfoObject.getIsStdOut());
        threadControlBlock.setAuthentication(this.threadStartInfoObject.getAuthentication());
        threadControlBlock.setUser(this.threadStartInfoObject.getUser());
        threadControlBlock.setPassword(this.threadStartInfoObject.getPassword());
        threadControlBlock.setLocale(this.threadStartInfoObject.getLocale());
        threadControlBlock.setServer(this.threadStartInfoObject.getServer());
        if (currentRpcQueue != 0) {
            try {
                this.getControlStructObject().usePrivateRpcQueue(currentRpcQueue);
            }
            catch (ARException aRException) {
                outputWriter.printARException(aRException);
            }
        }
        threadControlBlock.setPrimaryThread(false);
        SyncObject syncObject2 = syncObject = this.threadStartInfoObject.getWaitObject();
        synchronized (syncObject2) {
            syncObject.setFlag(true);
            syncObject.notify();
        }
        syncObject2 = this.threadStartInfoObject.getReleaseObject();
        syncObject2.setFlag(true);
        SyncObject syncObject3 = syncObject2;
        synchronized (syncObject3) {
            try {
                int n = currentRpcQueue;
                while (true) {
                    syncObject2.wait();
                    if (!syncObject2.getFlag()) break;
                    if (n != currentRpcQueue) {
                        try {
                            this.getControlStructObject().usePrivateRpcQueue(currentRpcQueue);
                        }
                        catch (ARException aRException) {
                            outputWriter.printARException(aRException);
                        }
                    }
                    this.wfdExec(1);
                    this.wfdGetCurrentLocation();
                    n = this.getControlStructObject().getServerRpcQueueNumber();
                }
            }
            catch (InterruptedException interruptedException) {
                syncObject2.setFlag(false);
                System.out.println("Interrupted Exception ...in simplethread run");
            }
        }
        this.threadStartInfoObject.cleanUp();
        this.threadStartInfoObject = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized void run() {
        block29: {
            Object v0;
            boolean bl;
            block26: {
                bl = false;
                ThreadControlBlock threadControlBlock = WFD.getThreadControlBlockPtr();
                if (threadControlBlock == null) {
                    threadControlBlock = this.initThreadControlBlockPtr();
                }
                WFD.setQuietMode(SUPPRESS_HEADERS | SUPPRESS_FOR_WFD);
                threadControlBlock.setCurrentInputToStdIn();
                threadControlBlock.setOutputToStdOut();
                if (this.isPrimaryThread()) {
                    threadControlBlock.setPrimaryThread(true);
                    if (!this.processCommandLine()) {
                        System.exit(1);
                    }
                    outputWriter.driverPrintHelp();
                    this.initCommandProcessing();
                    this.launchThread(true);
                    this.processCommands();
                    break block26;
                }
                threadControlBlock.setPrimaryThread(false);
                this.threadStartFunction();
            }
            Object var5_3 = null;
            try {
                try {
                    this.terminateRunThread();
                    this.destroyThreadControlBlockPtr(bl);
                    v0 = null;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    v0 = null;
                }
            }
            catch (Throwable throwable) {
                v0 = null;
            }
            Object var8_15 = v0;
            this.termCommandProcessing();
            if (this.isPrimaryThread()) {
                this.cleanupThreadEnvironment();
            }
            if (this.isPrimaryThread()) {
                System.exit(0);
            }
            break block29;
            {
                catch (IOException iOException) {
                    Object v1;
                    iOException.printStackTrace();
                    outputWriter.printString("IOException caught\n");
                    Object var5_4 = null;
                    try {
                        try {
                            this.terminateRunThread();
                            this.destroyThreadControlBlockPtr(bl);
                            v1 = null;
                        }
                        catch (IOException iOException2) {
                            iOException2.printStackTrace();
                            v1 = null;
                        }
                    }
                    catch (Throwable throwable) {
                        v1 = null;
                    }
                    Object var8_16 = v1;
                    this.termCommandProcessing();
                    if (this.isPrimaryThread()) {
                        this.cleanupThreadEnvironment();
                    }
                    if (this.isPrimaryThread()) {
                        System.exit(0);
                    }
                    break block29;
                }
                catch (Exception exception) {
                    Object v2;
                    exception.printStackTrace();
                    outputWriter.printString("Exception caught" + exception.getLocalizedMessage() + "\n");
                    System.out.println(exception.getLocalizedMessage());
                    bl = true;
                    Object var5_5 = null;
                    try {
                        try {
                            this.terminateRunThread();
                            this.destroyThreadControlBlockPtr(bl);
                            v2 = null;
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                            v2 = null;
                        }
                    }
                    catch (Throwable throwable) {
                        v2 = null;
                    }
                    Object var8_17 = v2;
                    this.termCommandProcessing();
                    if (this.isPrimaryThread()) {
                        this.cleanupThreadEnvironment();
                    }
                    if (this.isPrimaryThread()) {
                        System.exit(0);
                    }
                }
            }
            catch (Throwable throwable) {
                Object v3;
                Object var5_6 = null;
                try {
                    try {
                        this.terminateRunThread();
                        this.destroyThreadControlBlockPtr(bl);
                        v3 = null;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        v3 = null;
                    }
                }
                catch (Throwable throwable2) {
                    v3 = null;
                }
                Object var8_18 = v3;
                this.termCommandProcessing();
                if (this.isPrimaryThread()) {
                    this.cleanupThreadEnvironment();
                }
                if (this.isPrimaryThread()) {
                    System.exit(0);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyThreadControlBlockPtr(boolean bl) throws IOException {
        ThreadControlBlock threadControlBlock = WFD.getThreadControlBlockPtr();
        try {
            threadControlBlock.closeOutputFile();
            threadControlBlock.closeInputFiles();
            threadControlBlock.closeRecordFile();
            Thread thread = (Thread)threadControlBlock.getThreadHandle();
            while (thread != null) {
                if (!bl && thread.isAlive()) {
                    try {
                        Thread.sleep(30L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                threadControlBlock.deleteThreadHandle();
                thread = (Thread)threadControlBlock.getThreadHandle();
            }
            Object var6_5 = null;
            threadControlBlock.setWaitObjectToNull();
            threadControlBlock.setReleaseObjectToNull();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            threadControlBlock.setWaitObjectToNull();
            threadControlBlock.setReleaseObjectToNull();
            throw throwable;
        }
    }

    public static void main(String[] stringArray) {
        try {
            ProxyManager.setUseConnectionPooling(false);
            WFD wFD = new WFD();
            wFD.setCommandLineArgs(stringArray);
            wFD.setPrimaryThread(true);
            wFD.start();
        }
        catch (Exception exception) {
            outputWriter.printString("Error in executing the command\n");
        }
    }

    void termination() {
        this.getControlStructObject().logout();
    }

    void setServerPort() {
        try {
            if (WFD.notWfdQuiet()) {
                outputWriter.driverPrintHeader("SET SERVER PORT");
            }
            int n = InputReader.getInt("The port number of server (0):", 0);
            int n2 = InputReader.getInt("The RPC program number of Server (0):", 0);
            ARServerUser aRServerUser = this.getControlStructObject();
            aRServerUser.setPort(n);
            aRServerUser.usePrivateRpcQueue(n2);
            currentRpcQueue = n2;
            List<StatusInfo> list = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Set Server Port Status", list);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void wfdExec(int n) {
        try {
            int[] nArray = this.getControlStructObject().wfdExecute(n);
            switch (nArray[0]) {
                case 1: {
                    outputWriter.print("", "", "Workflow Step");
                    break;
                }
                case 2: {
                    outputWriter.print("", "", "Server Breakpoint Encountered: #" + nArray[1]);
                    break;
                }
                case 3: {
                    outputWriter.print("", "", "User Break\n");
                    break;
                }
                default: {
                    List<StatusInfo> list = this.getControlStructObject().getLastStatus();
                    outputWriter.printStatusInfoList("", "WFD Execute Status", list);
                    break;
                }
            }
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void wfdInitialization() {
        outputWriter.print("", "", "Initialization.\nOK\n");
    }

    void wfdRestart() {
        outputWriter.print("", "", "Restart.\nOK\n");
    }

    void notImplementedYet() {
        outputWriter.print("", "", "Sorry not implemented yet.\n");
    }

    void wfdFinishAPI() {
        try {
            int n = this.getControlStructObject().wfdGetDebugMode();
            this.getControlStructObject().wfdSetDebugMode(0);
            while (true) {
                this.getControlStructObject().wfdExecute(0);
                WfdDebugLocation wfdDebugLocation = this.getControlStructObject().wfdGetDebugLocation(0);
                if (wfdDebugLocation.Stage == 0) break;
                if (wfdDebugLocation.Stage != 1) continue;
            }
            this.getControlStructObject().wfdSetDebugMode(n);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    void wfdGetStackLocation() {
        WfdDebugLocation wfdDebugLocation = null;
        try {
            if (WFD.notWfdQuiet()) {
                outputWriter.driverPrintHeader("WFD GET CURRENT LOCATION");
            }
            int n = InputReader.getInt("Stack frame ? (0): ", 0);
            wfdDebugLocation = this.getControlStructObject().wfdGetDebugLocation(n);
            outputWriter.printCurrentLocation("Current Location:\n", wfdDebugLocation);
        }
        catch (IOException iOException) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException nullPointerException) {
            outputWriter.driverPrintException(nullPointerException);
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseRunThread() {
        SyncObject syncObject;
        ThreadControlBlock threadControlBlock = WFD.getThreadControlBlockPtr();
        SyncObject syncObject2 = syncObject = threadControlBlock.getReleaseObject();
        synchronized (syncObject2) {
            syncObject.setFlag(true);
            syncObject.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminateRunThread() {
        SyncObject syncObject;
        ThreadControlBlock threadControlBlock = WFD.getThreadControlBlockPtr();
        SyncObject syncObject2 = syncObject = threadControlBlock.getReleaseObject();
        synchronized (syncObject2) {
            syncObject.setFlag(false);
            syncObject.notifyAll();
        }
    }

    void wfdDumpStack() {
        WfdDebugLocation wfdDebugLocation;
        Stack<WfdDebugLocation> stack = new Stack<WfdDebugLocation>();
        try {
            int n = 0;
            while (true) {
                wfdDebugLocation = this.getControlStructObject().wfdGetDebugLocation(n);
                stack.push(wfdDebugLocation);
                if (wfdDebugLocation.Stage != 0) {
                    ++n;
                    continue;
                }
                break;
            }
        }
        catch (ARException aRException) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(aRException);
        }
        outputWriter.driverPrintHeader("Current Stack:");
        while (!stack.isEmpty()) {
            wfdDebugLocation = (WfdDebugLocation)stack.pop();
            outputWriter.printCurrentLocation("Current Location:\n", wfdDebugLocation);
        }
    }

    static {
        commandLineArgs = null;
        maxConnectionPerServer = 250;
        outputWriter = new WfdOutputWriter();
        currentRpcQueue = 0;
        javaDriverOnly = true;
        SUPPRESS_RESULTS = 1;
        SUPPRESS_HEADERS = 2;
        SUPPRESS_PROMPTS = 4;
        SUPPRESS_MENU = 8;
        SUPPRESS_ERRORS = 16;
        SUPPRESS_WARNINGS = 32;
        SUPPRESS_TIME = 64;
        SUPPRESS_DATE = 128;
        SUPPRESS_FOR_WFD = 256;
        MAX_NESTED_LOOP_DEPTH = 10;
        RAND_MAX = Short.MAX_VALUE;
        Breakpoints = new ArrayList<WfdBreakpoint>(10);
    }
}

