/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.fts.impl.lucene.query;

import com.bmc.arsys.fts.FTSService;
import com.bmc.arsys.fts.FTSServiceException;
import com.bmc.arsys.fts.impl.lucene.LuceneFTSService;
import com.bmc.arsys.fts.impl.lucene.analyzers.FTSAnalyzer;
import com.bmc.arsys.fts.impl.lucene.query.WildcardPhraseQuery;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermsFilter;
import org.apache.lucene.search.WildcardQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FTSQueryParser {
    private FTSAnalyzer analyzer;
    private static final Logger LOGGER = Logger.getLogger(LuceneFTSService.class);
    private static final int kAND = 1;
    private static final int kOR = 2;
    private static final int kNOT = 3;
    private static final int kParenth = 4;
    private static final int kPlainToken = 1;
    private static final int kParenthToken = 2;
    private static final int kOp = 3;
    private final int kEqualType = 1;
    private final int kGreaterEqualType = 2;
    private final int kLesserEqualType = 3;
    private final int kGreaterType = 4;
    private final int kLesserlType = 5;

    public FTSQueryParser(FTSAnalyzer fTSAnalyzer) {
        BooleanQuery.setMaxClauseCount((int)2048);
        this.analyzer = fTSAnalyzer;
    }

    public Query docIdQuery(Hashtable<String, String> hashtable) {
        LOGGER.debug((Object)("The number of entrys that should be returned are: " + hashtable.size()));
        TermsFilter termsFilter = new TermsFilter();
        Iterator<String> iterator = hashtable.keySet().iterator();
        while (iterator.hasNext()) {
            Term term = new Term("docId", iterator.next());
            termsFilter.addTerm(term);
        }
        return new ConstantScoreQuery((Filter)termsFilter);
    }

    public Query createDeleteFieldQuery(String string, String[] stringArray, String[] stringArray2) {
        BooleanQuery booleanQuery = new BooleanQuery();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray2[i] == null) continue;
            Term term = new Term(stringArray[i], stringArray2[i]);
            TermQuery termQuery = new TermQuery(term);
            booleanQuery.add((Query)termQuery, BooleanClause.Occur.MUST);
        }
        return booleanQuery;
    }

    public Query createQuery(String string, String[] stringArray, String[] stringArray2, BitSet[] bitSetArray, boolean bl) {
        BooleanQuery booleanQuery = new BooleanQuery();
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray2[i] == null || stringArray2[i].length() <= 0) continue;
            String string2 = stringArray2[i].replaceAll("\\(", "").replaceAll("\\)", "").replaceAll("\\\\_", "_").replaceAll("%\"", "\"").replaceAll("\"%", "\"").replaceAll("%'", "").replaceAll("'%", "").trim();
            LOGGER.debug((Object)("Query Field/Value: " + stringArray[i] + "/" + string2));
            if (string2 == null || string2.length() <= 0) continue;
            if (string2.startsWith("NOT ")) {
                bl3 = true;
                string2 = string2.substring(4);
            } else {
                bl3 = false;
            }
            Query query = this.buildQuery(string, stringArray[i], string2, bitSetArray[i], bl);
            if (query == null) continue;
            if (bl3) {
                booleanQuery.add(query, BooleanClause.Occur.MUST_NOT);
            } else {
                booleanQuery.add(query, BooleanClause.Occur.MUST);
            }
            bl2 = true;
        }
        if (bl2) {
            booleanQuery.add(this.schemaQuery(string), BooleanClause.Occur.MUST);
        }
        return booleanQuery;
    }

    public Filter createGlobalFilter(String string, boolean bl) throws FTSServiceException {
        Query query = this.syntaxGlobalQuery(string, null, bl, true);
        QueryWrapperFilter queryWrapperFilter = new QueryWrapperFilter(query);
        return queryWrapperFilter;
    }

    public Query createGlobalQuery(String string, String string2, String string3, ArrayList<FTSService.QuerySchemas> arrayList, boolean bl) throws FTSServiceException {
        BooleanQuery booleanQuery = new BooleanQuery();
        if (string != null && string != "") {
            booleanQuery.add(this.createGlobalQuery(string, arrayList, bl, false), BooleanClause.Occur.SHOULD);
        }
        if (string2 != null && string2 != "") {
            booleanQuery.add(this.createGlobalQuery(string2, arrayList, bl, true), BooleanClause.Occur.MUST);
        }
        if (string3 != null && string3 != "") {
            booleanQuery.add(this.createGlobalQuery(string3, arrayList, bl, false), BooleanClause.Occur.MUST_NOT);
        }
        return booleanQuery;
    }

    private Query createGlobalQuery(String string, ArrayList<FTSService.QuerySchemas> arrayList, boolean bl, boolean bl2) throws FTSServiceException {
        BooleanQuery booleanQuery = new BooleanQuery();
        for (FTSService.QuerySchemas querySchemas : arrayList) {
            BooleanQuery booleanQuery2 = new BooleanQuery();
            booleanQuery2.add(this.schemaQuery(querySchemas.schemaId), BooleanClause.Occur.MUST);
            booleanQuery2.add(this.buildGlobalQuery(string, querySchemas, bl, bl2), BooleanClause.Occur.MUST);
            booleanQuery.add((Query)booleanQuery2, BooleanClause.Occur.SHOULD);
        }
        return booleanQuery;
    }

    private Query buildGlobalQuery(String string, FTSService.QuerySchemas querySchemas, boolean bl, boolean bl2) throws FTSServiceException {
        if (string.indexOf("(") > -1 || string.indexOf("AND") > -1 || string.indexOf("OR") > -1 || string.indexOf("NOT") > -1) {
            Query query = null;
            query = this.syntaxGlobalQuery(string, querySchemas, bl, false);
            return query;
        }
        if (bl2 && string.indexOf(",") > -1) {
            return this.mustAccrueQuery(string, querySchemas, bl);
        }
        if (bl2 && string.indexOf("\"") == -1 && string.indexOf(" ") > -1) {
            return this.mustAccrueQuery(string.replaceAll(" ", ", "), querySchemas, bl);
        }
        BooleanQuery booleanQuery = new BooleanQuery();
        ArrayList<String> arrayList = querySchemas.queryFieldNames;
        ArrayList<BitSet> arrayList2 = querySchemas.fullTextOptions;
        int n = 0;
        for (String string2 : arrayList) {
            Query query = this.buildQuery(querySchemas.schemaId, string2, string, arrayList2.get(n), bl, true);
            if (query != null) {
                booleanQuery.add(query, BooleanClause.Occur.SHOULD);
            }
            ++n;
        }
        return booleanQuery;
    }

    private Query mustAccrueQuery(String string, FTSService.QuerySchemas querySchemas, boolean bl) {
        BooleanQuery booleanQuery = new BooleanQuery();
        String[] stringArray = string.split(",");
        ArrayList<String> arrayList = querySchemas.queryFieldNames;
        ArrayList<BitSet> arrayList2 = querySchemas.fullTextOptions;
        for (int i = 0; i < stringArray.length; ++i) {
            BooleanQuery booleanQuery2 = new BooleanQuery();
            int n = 0;
            for (String string2 : arrayList) {
                Query query = this.buildQuery(querySchemas.schemaId, string2, stringArray[i].trim(), arrayList2.get(n), bl);
                if (query != null) {
                    booleanQuery2.add(query, BooleanClause.Occur.SHOULD);
                }
                ++n;
            }
            if (booleanQuery2.clauses().size() == 0) continue;
            booleanQuery.add((Query)booleanQuery2, BooleanClause.Occur.MUST);
        }
        return booleanQuery;
    }

    private Query buildQuery(String string, String string2, String string3, BitSet bitSet, boolean bl) {
        return this.buildQuery(string, string2, string3, bitSet, bl, false);
    }

    private Query buildQuery(String string, String string2, String string3, BitSet bitSet, boolean bl, boolean bl2) {
        Query query = null;
        String string4 = string3.trim();
        query = string3.indexOf(",") > -1 && !bitSet.get(1) ? this.accrueQuery(string, string2, string4, bitSet, bl) : (string3.indexOf("OR") > -1 ? this.orQuery(string, string2, string4, bitSet, bl) : (bl2 && string3.indexOf("%") > -1 && string4.indexOf(" ") > -1 && !bitSet.get(1) && string3.indexOf("\"") == -1 ? this.accrueQuery(string, string2, string4.replace(" ", ", "), bitSet, bl) : (string3.indexOf("%") > -1 && string4.indexOf(" ") > -1 && !bitSet.get(1) ? this.wildcardPhraseQuery(string, string2, string4, bitSet, bl) : (string3.indexOf("%") > -1 ? this.wildcardQuery(string, string2, string4, bitSet, bl) : (bl2 && string3.indexOf("\"") > -1 && !bitSet.get(1) ? this.phraseQuery(string, string2, string4, bitSet, bl) : (bl2 && string3.indexOf(" ") > -1 && !bitSet.get(1) ? this.accrueQuery(string, string2, string4.replace(" ", ", "), bitSet, bl) : (!bl2 && string3.indexOf(" ") > -1 && !bitSet.get(1) ? this.phraseQuery(string, string2, string4, bitSet, bl) : this.termQuery(string, string2, string4, bitSet, bl))))))));
        return query;
    }

    private WordToken getNextToken(String string) throws FTSServiceException {
        if (string == null || string.equals("")) {
            return null;
        }
        string = string.trim();
        WordToken wordToken = new WordToken();
        int n = string.length();
        int n2 = 0;
        int n3 = string.indexOf("AND");
        int n4 = string.indexOf("OR");
        int n5 = string.indexOf("NOT");
        int n6 = string.indexOf("(");
        if (n3 > -1 && n3 < n) {
            n = n3;
            n2 = 1;
        }
        if (n4 > -1 && n4 < n) {
            n = n4;
            n2 = 2;
        }
        if (n5 > -1 && n5 < n) {
            n = n5;
            n2 = 3;
        }
        if (n6 > -1 && n6 < n) {
            n = n6;
            n2 = 4;
        }
        if (n2 == 0) {
            wordToken.token = string;
            wordToken.position = n;
            wordToken.type = 1;
            wordToken.remainingText = null;
        } else if ((n2 == 1 || n2 == 2 || n2 == 3) && n == 0) {
            wordToken.token = string.substring(0, this.getOpCharCount(n2)).trim();
            wordToken.position = n;
            wordToken.type = 3;
            wordToken.remainingText = this.getRemainingText(string, this.getOpCharCount(n2));
        } else if (n == 0 && n2 == 4) {
            int n7 = this.getClosingParenth(string);
            wordToken.token = string.substring(n, n7 + 1).trim();
            wordToken.position = n;
            wordToken.type = 2;
            wordToken.remainingText = this.getRemainingText(string, n7);
        } else {
            wordToken.token = string.substring(0, n - 1).trim();
            wordToken.position = n;
            wordToken.type = 1;
            wordToken.remainingText = this.getRemainingText(string, n - 1);
        }
        return wordToken;
    }

    private int getOpCharCount(int n) {
        if (n == 2) {
            return 2;
        }
        return 3;
    }

    private String getRemainingText(String string, int n) {
        if (n == string.length()) {
            return null;
        }
        return string.substring(n + 1).trim();
    }

    private ArrayList<WordToken> tokenize(String string) throws FTSServiceException {
        ArrayList<WordToken> arrayList = new ArrayList<WordToken>();
        String string2 = string = string.replaceAll("LIKE", "").replaceAll("AND NOT", "NOT");
        boolean bl = true;
        WordToken wordToken = null;
        while (bl) {
            wordToken = this.getNextToken(string2);
            if (wordToken == null) {
                bl = false;
                break;
            }
            string2 = wordToken.remainingText;
            arrayList.add(wordToken);
        }
        BooleanClause.Occur occur = BooleanClause.Occur.SHOULD;
        for (int i = 0; i < arrayList.size(); ++i) {
            WordToken wordToken2 = arrayList.get(i);
            wordToken2.operator = occur;
            if (wordToken2.type != 3) continue;
            if (wordToken2.token.equals("OR")) {
                occur = BooleanClause.Occur.SHOULD;
                continue;
            }
            if (wordToken2.token.equals("NOT")) {
                occur = BooleanClause.Occur.MUST_NOT;
                continue;
            }
            if (!wordToken2.token.equals("AND")) continue;
            occur = BooleanClause.Occur.MUST;
            if (i == 0) continue;
            arrayList.get((int)(i - 1)).operator = occur;
        }
        return arrayList;
    }

    public Query syntaxGlobalQuery(String string, FTSService.QuerySchemas querySchemas, boolean bl, boolean bl2) throws FTSServiceException {
        BooleanQuery booleanQuery = new BooleanQuery();
        ArrayList<WordToken> arrayList = this.tokenize(string);
        if (arrayList.size() != 0 && arrayList.get((int)0).type == 3) {
            throw new FTSServiceException(this.getClass().getName() + ": Illegal construct, a segment should not begin with \"AND\", \"OR\", \"AND NOT\", or \"NOT\": " + string);
        }
        BitSet bitSet = new BitSet(1);
        bitSet.set(1);
        String string2 = null;
        String string3 = null;
        long l = 0L;
        long l2 = 0L;
        String string4 = null;
        boolean bl3 = false;
        FieldTermPair fieldTermPair = null;
        BooleanClause.Occur occur = null;
        for (WordToken wordToken : arrayList) {
            occur = wordToken.operator;
            if (wordToken.type == 2) {
                booleanQuery.add(this.syntaxGlobalQuery(wordToken.token.substring(1, wordToken.token.length() - 1), querySchemas, bl, bl2), wordToken.operator);
                continue;
            }
            if (wordToken.token == null || wordToken.token.equals("") || wordToken.type == 3) continue;
            if (bl2) {
                fieldTermPair = this.getFieldTermPair(wordToken.token);
                if (fieldTermPair.opType > 1 && (fieldTermPair.field.equals("createTime") || fieldTermPair.field.equals("modifiedTime"))) {
                    NumericRangeQuery numericRangeQuery;
                    boolean bl4 = true;
                    if (string4 == null || string4.equals(fieldTermPair.field)) {
                        if (this.isUpperRange(fieldTermPair)) {
                            string2 = fieldTermPair.field;
                            l = this.convertDate(fieldTermPair.field, fieldTermPair.term);
                        } else {
                            string3 = fieldTermPair.field;
                            l2 = this.convertDate(fieldTermPair.field, fieldTermPair.term);
                        }
                    }
                    if (string2 != null && string3 != null && string4.equals(fieldTermPair.field)) {
                        numericRangeQuery = NumericRangeQuery.newLongRange((String)string2, (Long)l2, (Long)l, (boolean)this.isInclusive(fieldTermPair), (boolean)this.isInclusive(fieldTermPair));
                        booleanQuery.add((Query)numericRangeQuery, occur);
                        string2 = null;
                        l = 0L;
                        string3 = null;
                        l2 = 0L;
                        string4 = null;
                        bl4 = false;
                    } else if (string4 != null && !string4.equals(fieldTermPair.field)) {
                        numericRangeQuery = null;
                        numericRangeQuery = string2 != null ? NumericRangeQuery.newLongRange((String)string2, null, (Long)l, (boolean)bl3, (boolean)bl3) : NumericRangeQuery.newLongRange((String)string3, (Long)l2, null, (boolean)bl3, (boolean)bl3);
                        booleanQuery.add((Query)numericRangeQuery, occur);
                        if (this.isUpperRange(fieldTermPair)) {
                            string2 = fieldTermPair.field;
                            l = this.convertDate(fieldTermPair.field, fieldTermPair.term);
                            string3 = null;
                            l2 = 0L;
                        } else {
                            string3 = fieldTermPair.field;
                            l2 = this.convertDate(fieldTermPair.field, fieldTermPair.term);
                            string2 = null;
                            l = 0L;
                        }
                    }
                    if (bl4) {
                        string4 = fieldTermPair.field;
                    }
                    bl3 = this.isInclusive(fieldTermPair);
                    continue;
                }
                if (fieldTermPair.opType == 1 && (fieldTermPair.field.equals("createTime") || fieldTermPair.field.equals("modifiedTime"))) {
                    Long l3 = this.convertDate(fieldTermPair.field, fieldTermPair.term);
                    booleanQuery.add((Query)NumericRangeQuery.newLongRange((String)fieldTermPair.field, (Long)l3, (Long)l3, (boolean)true, (boolean)true), occur);
                    continue;
                }
                if (fieldTermPair.term == null || fieldTermPair.term.length() <= 0) continue;
                booleanQuery.add(this.termQuery(null, fieldTermPair.field, fieldTermPair.term, bitSet, bl), occur);
                continue;
            }
            booleanQuery.add(this.buildGlobalQuery(wordToken.token, querySchemas, bl, false), wordToken.operator);
        }
        if (string4 != null && (string2 != null || string3 != null)) {
            NumericRangeQuery numericRangeQuery = null;
            numericRangeQuery = string2 != null && string3 == null ? NumericRangeQuery.newLongRange(string2, null, (Long)l, (boolean)bl3, (boolean)bl3) : (string2 == null && string3 != null ? NumericRangeQuery.newLongRange(string3, (Long)l2, null, (boolean)bl3, (boolean)bl3) : NumericRangeQuery.newLongRange(string2, (Long)l2, (Long)l, (boolean)bl3, (boolean)bl3));
            booleanQuery.add((Query)numericRangeQuery, occur);
            string2 = null;
            l = 0L;
            string3 = null;
            l2 = 0L;
            string4 = null;
        }
        return booleanQuery;
    }

    private long convertDate(String string, String string2) {
        long l = 0L;
        if (string.equals("createTime") || string.endsWith("modifiedTime")) {
            try {
                String string3 = null;
                if (string2.indexOf(":") > -1) {
                    string3 = "MM/dd/yyyy hh:mm:ss aa";
                } else if (string2.indexOf("/") > -1) {
                    string3 = "MM/dd/yyyy";
                } else {
                    if (string2.startsWith("J")) {
                        Double d = (Double.parseDouble(string2.substring(1)) - 2440587.5) * 86400.0;
                        return d.longValue();
                    }
                    return Long.parseLong(string2);
                }
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string3);
                Date date = simpleDateFormat.parse(string2);
                l = date.getTime() / 1000L;
            }
            catch (Exception exception) {
                LOGGER.error((Object)("Problem converting date " + exception.getLocalizedMessage()));
            }
        }
        return l;
    }

    private boolean isUpperRange(FieldTermPair fieldTermPair) {
        boolean bl = false;
        if (fieldTermPair.opType == 2 || fieldTermPair.opType == 4) {
            if (!fieldTermPair.isFieldLeft) {
                bl = true;
            }
        } else if (fieldTermPair.isFieldLeft) {
            bl = true;
        }
        return bl;
    }

    private boolean isInclusive(FieldTermPair fieldTermPair) {
        boolean bl = false;
        if (fieldTermPair != null && (fieldTermPair.opType == 2 || fieldTermPair.opType == 3)) {
            bl = true;
        }
        return bl;
    }

    private FieldTermPair getFieldTermPair(String string) throws FTSServiceException {
        FieldTermPair fieldTermPair = new FieldTermPair();
        int n = string.indexOf("'");
        int n2 = string.indexOf("'", n + 1);
        if (n == -1 || n2 == -1) {
            throw new FTSServiceException(this.getClass().getName() + ": The filter parser identified a missing single quote in the construct: " + string);
        }
        fieldTermPair.field = string.substring(n + 1, n2);
        int n3 = string.indexOf("\"");
        int n4 = string.indexOf("\"", n3 + 1);
        if (n3 == -1 || n4 == -1) {
            throw new FTSServiceException(this.getClass().getName() + ": The filter parser identified a missing double quote in the construct: " + string);
        }
        fieldTermPair.term = string.substring(n3 + 1, n4);
        if (string.indexOf(">=") > -1 || string.indexOf("=>") > -1) {
            fieldTermPair.opType = 2;
        } else if (string.indexOf("<=") > -1 || string.indexOf("=<") > -1) {
            fieldTermPair.opType = 3;
        } else if (string.indexOf(">") > -1) {
            fieldTermPair.opType = 4;
        } else if (string.indexOf("<") > -1) {
            fieldTermPair.opType = 5;
        } else if (string.indexOf("=") > -1) {
            fieldTermPair.opType = 1;
        } else {
            throw new FTSServiceException(this.getClass().getName() + ": The filter parser identified an invalid operator in the construct: " + string);
        }
        fieldTermPair.isFieldLeft = n < n3;
        return fieldTermPair;
    }

    private int getClosingParenth(String string) throws FTSServiceException {
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        int n4 = n = string.indexOf("(", n);
        int n5 = n;
        int n6 = 0;
        int n7 = string.length();
        while (n3 != 0) {
            n6 = string.indexOf(")", n5);
            if (string.indexOf("(", n4 + 1) > -1) {
                n7 = string.indexOf("(", n4 + 1);
            }
            if (n6 < n7) {
                n2 = n6;
                --n3;
                continue;
            }
            ++n3;
            n4 = n7;
            n7 = string.length();
            n5 = n6 + 1;
        }
        if (n2 < 1) {
            throw new FTSServiceException(this.getClass().getName() + ": The filter parser identified missmatched parenthesis in the construct: " + string);
        }
        return n2;
    }

    private Query accrueQuery(String string, String string2, String string3, BitSet bitSet, boolean bl) {
        BooleanQuery booleanQuery = new BooleanQuery();
        String[] stringArray = string3.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            Query query = this.buildQuery(string, string2, stringArray[i].trim(), bitSet, bl);
            if (query == null) continue;
            booleanQuery.add(query, BooleanClause.Occur.SHOULD);
        }
        return booleanQuery;
    }

    private Query orQuery(String string, String string2, String string3, BitSet bitSet, boolean bl) {
        BooleanQuery booleanQuery = new BooleanQuery();
        String[] stringArray = string3.split("OR");
        for (int i = 0; i < stringArray.length; ++i) {
            Query query = this.buildQuery(string, string2, stringArray[i].trim(), bitSet, bl);
            if (query == null) continue;
            booleanQuery.add(query, BooleanClause.Occur.SHOULD);
        }
        return booleanQuery;
    }

    private Query wildcardPhraseQuery(String string, String string2, String string3, BitSet bitSet, boolean bl) {
        String string4 = string3.replaceAll("%", "*");
        String string5 = this.getFullFieldName(string2, bitSet, bl, true);
        Iterator<Term> iterator = this.analyzer.analyzeSearchPhrase(string5, string4, true).iterator();
        WildcardPhraseQuery wildcardPhraseQuery = new WildcardPhraseQuery();
        while (iterator.hasNext()) {
            wildcardPhraseQuery.add(iterator.next());
        }
        return wildcardPhraseQuery;
    }

    private Query wildcardQuery(String string, String string2, String string3, BitSet bitSet, boolean bl) {
        String string4 = string3.replaceAll("%", "*");
        Term term = this.analyzer.analyzeSearchTerm(this.getFullFieldName(string2, bitSet, bl, true), string4, true);
        WildcardQuery wildcardQuery = new WildcardQuery(term);
        return wildcardQuery;
    }

    private Query phraseQuery(String string, String string2, String string3, BitSet bitSet, boolean bl) {
        String string4 = this.getFullFieldName(string2, bitSet, bl, false);
        Iterator<Term> iterator = this.analyzer.analyzeSearchPhrase(string4, string3, false).iterator();
        PhraseQuery phraseQuery = new PhraseQuery();
        int n = 0;
        while (iterator.hasNext()) {
            Term term = iterator.next();
            if (term != null) {
                phraseQuery.add(term, n);
            }
            ++n;
        }
        return phraseQuery;
    }

    private Query termQuery(String string, String string2, String string3, BitSet bitSet, boolean bl) {
        Term term = this.analyzer.analyzeSearchTerm(this.getFullFieldName(string2, bitSet, bl, false), string3, false);
        TermQuery termQuery = null;
        if (term != null) {
            termQuery = new TermQuery(term);
        }
        return termQuery;
    }

    public Query schemaQuery(String string) {
        Term term = new Term("schemaId", string);
        TermQuery termQuery = new TermQuery(term);
        return termQuery;
    }

    private String getFullFieldName(String string, BitSet bitSet, boolean bl, boolean bl2) {
        String string2 = null;
        string2 = string.equals("entryId") || string.equals("docId") || string.equals("schemaId") || string.equals("createTime") || string.equals("modifiedTime") ? string : (bitSet.get(1) ? (bl ? string + "_literalCase" : string + "_literal") : (bl ? string + "_case" : string));
        return string2;
    }

    private class WordToken {
        public String token;
        public int type;
        public BooleanClause.Occur operator;
        public int position;
        public String remainingText;

        private WordToken() {
        }
    }

    private class GetOccur {
        private BooleanClause.Occur lastOccur = BooleanClause.Occur.SHOULD;

        private GetOccur() {
        }

        private BooleanClause.Occur getOccur(int n) {
            BooleanClause.Occur occur = null;
            switch (n) {
                case 0: {
                    occur = this.lastOccur;
                    break;
                }
                case 1: {
                    occur = BooleanClause.Occur.MUST;
                    break;
                }
                case 2: {
                    occur = BooleanClause.Occur.SHOULD;
                    break;
                }
                case 3: {
                    occur = BooleanClause.Occur.MUST_NOT;
                }
            }
            if (occur == BooleanClause.Occur.MUST_NOT) {
                occur = this.lastOccur;
                this.lastOccur = BooleanClause.Occur.MUST_NOT;
            } else if (this.lastOccur == BooleanClause.Occur.MUST_NOT) {
                this.lastOccur = occur;
                occur = BooleanClause.Occur.MUST_NOT;
            } else if (this.lastOccur == BooleanClause.Occur.MUST) {
                this.lastOccur = occur;
                occur = BooleanClause.Occur.MUST;
            } else {
                this.lastOccur = occur;
            }
            return occur;
        }
    }

    private class FieldTermPair {
        String field;
        String term;
        int opType;
        boolean isFieldLeft;

        private FieldTermPair() {
        }
    }
}

