/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.fts.impl.lucene;

import com.bmc.arsys.fts.FTSService;
import com.bmc.arsys.fts.FTSServiceException;
import com.bmc.arsys.fts.impl.FTSConfiguration;
import com.bmc.arsys.fts.impl.lucene.LuceneFTSService;
import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.BasicConfigurator;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneFTSServiceTest {
    static FTSService service = LuceneFTSService.getLuceneFTSService();
    public static String schemaid;
    public static String fieldID;
    public static String[] field;
    public static String[][] values;
    public static BitSet[] ftsOption;
    public static BitSet[] literalFtsOption;
    private static FTSConfiguration config;

    @BeforeClass
    public static void beforeClass() {
        System.out.println("Lucene FTS Service tests started ");
    }

    @AfterClass
    public static void afterClass() {
        System.out.println("Done with Lucene FTS Service tests ");
    }

    @Before
    public void beforeTest() {
    }

    @Test
    public void testFTSServiceConstructor() {
        System.out.println("--Test creating a new FTS Service.");
        LuceneFTSService luceneFTSService = LuceneFTSService.getLuceneFTSService();
        Assert.assertNotNull((Object)luceneFTSService);
        try {
            luceneFTSService.close();
        }
        catch (FTSServiceException fTSServiceException) {
            // empty catch block
        }
    }

    private FTSConfiguration getConfig() {
        if (config == null) {
            config = new FTSConfiguration();
            config.setFullTextCaseInSensitive(false);
            config.setFullTextCollectionDir("C://Temp//Lucene");
            config.setFullTextConfigurationDir("C://Temp//config");
            config.setFullTextLocale("en");
            config.setFullTextOptimizeThreshold(500);
        }
        return config;
    }

    @Test
    public void testInit() {
        System.out.println("--Test FTS Service init().");
        LuceneFTSService luceneFTSService = LuceneFTSService.getLuceneFTSService();
        try {
            luceneFTSService.init(this.getConfig());
            luceneFTSService.close();
        }
        catch (FTSServiceException fTSServiceException) {
            // empty catch block
        }
    }

    @Test
    public void testIndexEntryFields() {
        System.out.println("--Test FTS Service indexEntryFields. ");
        LuceneFTSService luceneFTSService = LuceneFTSService.getLuceneFTSService();
        luceneFTSService.doLiteral = true;
        luceneFTSService.doLiteralCase = true;
        luceneFTSService.doNormal = true;
        luceneFTSService.doNormalCase = true;
        try {
            int n;
            luceneFTSService.init(this.getConfig());
            ftsOption[0].set(1);
            literalFtsOption[0].set(1);
            for (n = 0; n < values.length; ++n) {
                luceneFTSService.indexEntryFields(schemaid, n + "", 1.0f, field, values[n], ftsOption, null, 1);
            }
            n = luceneFTSService.getIndexCount();
            Assert.assertEquals((Object)16, (Object)n);
            luceneFTSService.close();
        }
        catch (FTSServiceException fTSServiceException) {
            // empty catch block
        }
    }

    @Test
    public void testLiteralFTS() {
        LuceneFTSService luceneFTSService = LuceneFTSService.getLuceneFTSService();
        try {
            luceneFTSService.init(this.getConfig());
            literalFtsOption[0].clear();
            literalFtsOption[0].set(1);
            System.out.println("\n************************     testLiteralFTS     ********************************");
            List<FTSService.EntryData> list = null;
            String string = "";
            String[] stringArray = new String[]{new String(fieldID)};
            string = "firewall";
            list = luceneFTSService.getEntryIdsByQuery(schemaid, stringArray, new String[]{string}, literalFtsOption);
            this.compareResults(list, new String[0], string);
            string = luceneFTSService.isCaseSensitive() ? "firewall will block AcceSS" : "Firewall will BlocK access";
            list = luceneFTSService.getEntryIdsByQuery(schemaid, stringArray, new String[]{string}, literalFtsOption);
            this.compareResults(list, new String[]{"2"}, string);
            string = "%firewall%";
            list = luceneFTSService.getEntryIdsByQuery(schemaid, stringArray, new String[]{string}, literalFtsOption);
            this.compareResults(list, new String[]{"1", "2", "3", "4", "5", "6", "7"}, string);
            string = "firewall%";
            list = luceneFTSService.getEntryIdsByQuery(schemaid, stringArray, new String[]{string}, literalFtsOption);
            this.compareResults(list, new String[]{"1", "2", "3", "4", "5", "7"}, string);
            string = "blocks";
            list = luceneFTSService.getEntryIdsByQuery(schemaid, stringArray, new String[]{string}, literalFtsOption);
            this.compareResults(list, new String[0], string);
            string = "%blocks%";
            list = luceneFTSService.getEntryIdsByQuery(schemaid, stringArray, new String[]{string}, literalFtsOption);
            this.compareResults(list, new String[]{"1"}, string);
            string = "%firewall block%";
            list = luceneFTSService.getEntryIdsByQuery(schemaid, stringArray, new String[]{string}, literalFtsOption);
            this.compareResults(list, new String[]{"1", "3", "4", "6"}, string);
            string = "user retested";
            list = luceneFTSService.getEntryIdsByQuery(schemaid, stringArray, new String[]{string}, literalFtsOption);
            this.compareResults(list, new String[]{"14"}, string);
            luceneFTSService.close();
        }
        catch (FTSServiceException fTSServiceException) {
            // empty catch block
        }
    }

    @Test
    public void testSimpleFTS() {
        System.out.println("\n************************     testSimpleFTS     ********************************");
        LuceneFTSService luceneFTSService = LuceneFTSService.getLuceneFTSService();
        try {
            luceneFTSService.init(this.getConfig());
            ftsOption[0].clear();
            ftsOption[0].set(0);
            List<FTSService.EntryData> list = null;
            String string = "";
            String[] stringArray = new String[]{new String(fieldID)};
            string = "%test";
            list = luceneFTSService.getEntryIdsByQuery(schemaid, stringArray, new String[]{string}, ftsOption);
            this.compareResults(list, new String[]{"9", "10", "13"}, string);
            string = "%test%";
            list = luceneFTSService.getEntryIdsByQuery(schemaid, stringArray, new String[]{string}, ftsOption);
            this.compareResults(list, new String[]{"9", "10", "11", "12", "13", "14", "15"}, string);
            string = "test%";
            list = luceneFTSService.getEntryIdsByQuery(schemaid, stringArray, new String[]{string}, ftsOption);
            this.compareResults(list, new String[]{"9", "10", "11", "12", "15"}, string);
            string = "firewall blocked";
            list = luceneFTSService.getEntryIdsByQuery(schemaid, stringArray, new String[]{string}, ftsOption);
            this.compareResults(list, new String[]{"1", "3", "4", "6"}, string);
            string = "blocks\\_xxx";
            list = luceneFTSService.getEntryIdsByQuery(schemaid, stringArray, new String[]{string}, ftsOption);
            this.compareResults(list, new String[]{"1", "2", "3", "4", "5", "6", "8"}, string);
            string = "%blocks%";
            list = luceneFTSService.getEntryIdsByQuery(schemaid, stringArray, new String[]{string}, ftsOption);
            this.compareResults(list, new String[]{"1"}, string);
            string = "blocks%";
            list = luceneFTSService.getEntryIdsByQuery(schemaid, stringArray, new String[]{string}, ftsOption);
            this.compareResults(list, new String[]{"1"}, string);
            string = "blocked%";
            list = luceneFTSService.getEntryIdsByQuery(schemaid, stringArray, new String[]{string}, ftsOption);
            this.compareResults(list, new String[]{"4"}, string);
            string = "%firewall blocks%";
            list = luceneFTSService.getEntryIdsByQuery(schemaid, stringArray, new String[]{string}, ftsOption);
            this.compareResults(list, new String[]{"1"}, string);
            string = "%firewall block";
            list = luceneFTSService.getEntryIdsByQuery(schemaid, stringArray, new String[]{string}, ftsOption);
            this.compareResults(list, new String[]{"6"}, string);
            string = "%firewall block%";
            list = luceneFTSService.getEntryIdsByQuery(schemaid, stringArray, new String[]{string}, ftsOption);
            this.compareResults(list, new String[]{"1", "3", "4", "6"}, string);
            string = "firewall block%";
            list = luceneFTSService.getEntryIdsByQuery(schemaid, stringArray, new String[]{string}, ftsOption);
            this.compareResults(list, new String[]{"1", "3", "4", "6"}, string);
            string = "firewall blocks%";
            list = luceneFTSService.getEntryIdsByQuery(schemaid, stringArray, new String[]{string}, ftsOption);
            this.compareResults(list, new String[]{"1"}, string);
            string = "";
            list = luceneFTSService.getEntryIdsByQuery(schemaid, stringArray, new String[]{string}, ftsOption);
            System.out.println("search for empty string");
            for (FTSService.EntryData entryData : list) {
                System.out.println(entryData.entryId);
            }
            luceneFTSService.close();
        }
        catch (FTSServiceException fTSServiceException) {
            // empty catch block
        }
    }

    @Test
    public void testAccrueFTS() {
        System.out.println("\n************************     testAccrueFTS     ********************************");
        LuceneFTSService luceneFTSService = LuceneFTSService.getLuceneFTSService();
        try {
            luceneFTSService.init(this.getConfig());
            ftsOption[0].clear();
            ftsOption[0].set(0);
            List<FTSService.EntryData> list = null;
            String string = "";
            String[] stringArray = new String[]{new String(fieldID)};
            string = "firewall,blocking";
            list = luceneFTSService.getEntryIdsByQuery(schemaid, stringArray, new String[]{string}, ftsOption);
            this.compareResults(list, new String[]{"1", "2", "3", "4", "5", "6", "7", "8"}, string);
            string = "firewall,blocked%";
            list = luceneFTSService.getEntryIdsByQuery(schemaid, stringArray, new String[]{string}, ftsOption);
            this.compareResults(list, new String[]{"1", "2", "3", "4", "5", "6", "7"}, string);
            luceneFTSService.close();
        }
        catch (FTSServiceException fTSServiceException) {
            // empty catch block
        }
    }

    @Test
    public void testdeleteDocumentsContainingField() {
        System.out.println("--Test FTS Service deleteDocumentsContainingField.");
        LuceneFTSService luceneFTSService = LuceneFTSService.getLuceneFTSService();
        try {
            luceneFTSService.init(this.getConfig());
            List<FTSService.EntryData> list = null;
            String string = "";
            String[] stringArray = new String[]{new String("00001")};
            string = "try blocking his access";
            list = luceneFTSService.getEntryIdsByQuery(schemaid, stringArray, new String[]{string}, ftsOption);
            Assert.assertEquals((Object)1, (Object)list.size());
            luceneFTSService.deleteDocumentsContainingField("00001", "try blocking his access");
            list = luceneFTSService.getEntryIdsByQuery(schemaid, stringArray, new String[]{string}, ftsOption);
            Assert.assertEquals((Object)0, (Object)list.size());
            luceneFTSService.close();
        }
        catch (FTSServiceException fTSServiceException) {
            // empty catch block
        }
    }

    @Test
    public void testDeleteEntryDocument() {
        System.out.println("--Test FTS Service deleteEntryDocument.");
        LuceneFTSService luceneFTSService = LuceneFTSService.getLuceneFTSService();
        try {
            luceneFTSService.init(this.getConfig());
            List<FTSService.EntryData> list = null;
            String string = "";
            String[] stringArray = new String[]{new String("entryid")};
            string = "1";
            list = luceneFTSService.getEntryIdsByQuery(schemaid, stringArray, new String[]{string}, ftsOption);
            Assert.assertEquals((Object)1, (Object)list.size());
            luceneFTSService.deleteEntryDocument(schemaid, "1");
            list = luceneFTSService.getEntryIdsByQuery(schemaid, stringArray, new String[]{string}, ftsOption);
            Assert.assertEquals((Object)0, (Object)list.size());
            luceneFTSService.close();
        }
        catch (FTSServiceException fTSServiceException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveFieldFromDocumentsByQuery() {
        System.out.println("--Test FTS Service removeFieldFromDocumentsByQuery.");
        LuceneFTSService luceneFTSService = LuceneFTSService.getLuceneFTSService();
        try {
            luceneFTSService.init(this.getConfig());
            ftsOption[0].clear();
            ftsOption[0].set(0);
            String[] stringArray = new String[]{new String("schemaid")};
            String[] stringArray2 = new String[]{new String("487")};
            List<FTSService.EntryData> list = null;
            String string = "%";
            list = luceneFTSService.getEntryIdsByQuery(schemaid, new String[]{"00001"}, new String[]{"%"}, ftsOption);
            this.compareResults(list, new String[]{"0", "2", "3", "4", "5", "6", "7", "9", "10", "11", "12", "13", "14", "15"}, string);
            luceneFTSService.removeFieldFromDocumentsByQuery("00001", stringArray, stringArray2);
            list = luceneFTSService.getEntryIdsByQuery(schemaid, new String[]{"00001"}, new String[]{"%"}, ftsOption);
            this.compareResults(list, new String[0], string);
            luceneFTSService.close();
        }
        catch (FTSServiceException fTSServiceException) {
            // empty catch block
        }
    }

    @Test
    public void testDeleteIndexDir() {
        System.out.println("--Test FTS Service deleteIndexDir.");
        LuceneFTSService luceneFTSService = LuceneFTSService.getLuceneFTSService();
        try {
            luceneFTSService.init(this.getConfig());
            luceneFTSService.deleteIndexDir();
            File file = new File("C://Temp//Lucene");
            Assert.assertFalse((boolean)file.exists());
            luceneFTSService.close();
        }
        catch (FTSServiceException fTSServiceException) {
            // empty catch block
        }
    }

    private void compareResults(List<FTSService.EntryData> list, String[] stringArray, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        System.out.println("search for \"" + string + "\"");
        for (FTSService.EntryData entryData : list) {
            System.out.println(entryData.entryId);
            arrayList2.add(entryData.entryId);
        }
        System.out.println();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        Collections.sort(arrayList2);
        Collections.sort(arrayList);
        Assert.assertEquals(arrayList, arrayList2);
    }

    static {
        BasicConfigurator.configure();
        schemaid = "487";
        fieldID = "00001";
        field = new String[]{"00001"};
        values = new String[][]{{"empty string"}, {"firewall blocks access"}, {"firewall will block AcceSS"}, {"firewall blocking my access"}, {"firewall blocked her access"}, {"firewall did not block access"}, {"have the firewall block access"}, {"firewall is not working"}, {"try blocking his access"}, {"super test"}, {"test left"}, {"tested"}, {"tested left"}, {"retest"}, {"user retested"}, {"testcase is"}};
        ftsOption = new BitSet[]{new BitSet(0)};
        literalFtsOption = new BitSet[]{new BitSet(1)};
        config = null;
    }
}

