/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.dao.support;

import com.bmc.thirdparty.org.aopalliance.intercept.MethodInterceptor;
import com.bmc.thirdparty.org.aopalliance.intercept.MethodInvocation;
import com.bmc.thirdparty.org.springframework.beans.factory.InitializingBean;
import com.bmc.thirdparty.org.springframework.dao.support.DataAccessUtils;
import com.bmc.thirdparty.org.springframework.dao.support.PersistenceExceptionTranslator;
import com.bmc.thirdparty.org.springframework.util.Assert;

public class PersistenceExceptionTranslationInterceptor
implements MethodInterceptor,
InitializingBean {
    private PersistenceExceptionTranslator persistenceExceptionTranslator;

    public PersistenceExceptionTranslationInterceptor() {
    }

    public PersistenceExceptionTranslationInterceptor(PersistenceExceptionTranslator persistenceExceptionTranslator) {
        this.setPersistenceExceptionTranslator(persistenceExceptionTranslator);
    }

    public final void setPersistenceExceptionTranslator(PersistenceExceptionTranslator persistenceExceptionTranslator) {
        Assert.notNull(persistenceExceptionTranslator, "PersistenceExceptionTranslator must not be null");
        this.persistenceExceptionTranslator = persistenceExceptionTranslator;
    }

    public void afterPropertiesSet() {
        if (this.persistenceExceptionTranslator == null) {
            throw new IllegalArgumentException("persistenceExceptionTranslator is required");
        }
    }

    public Object invoke(MethodInvocation mi) throws Throwable {
        try {
            return mi.proceed();
        }
        catch (RuntimeException ex) {
            Class<?>[] declaredExceptions = mi.getMethod().getExceptionTypes();
            for (int i2 = 0; i2 < declaredExceptions.length; ++i2) {
                if (!declaredExceptions[i2].isInstance(ex)) continue;
                throw ex;
            }
            throw DataAccessUtils.translateIfNecessary(ex, this.persistenceExceptionTranslator);
        }
    }
}

