/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.apache.commons.collections.functors;

import com.bmc.thirdparty.org.apache.commons.collections.Closure;
import com.bmc.thirdparty.org.apache.commons.collections.Predicate;
import com.bmc.thirdparty.org.apache.commons.collections.Transformer;
import java.util.Collection;
import java.util.Iterator;

class FunctorUtils {
    private FunctorUtils() {
    }

    static Predicate[] copy(Predicate[] predicates) {
        if (predicates == null) {
            return null;
        }
        return (Predicate[])predicates.clone();
    }

    static void validate(Predicate[] predicates) {
        if (predicates == null) {
            throw new IllegalArgumentException("The predicate array must not be null");
        }
        int i2 = 0;
        while (i2 < predicates.length) {
            if (predicates[i2] == null) {
                throw new IllegalArgumentException("The predicate array must not contain a null predicate, index " + i2 + " was null");
            }
            ++i2;
        }
    }

    static Predicate[] validate(Collection predicates) {
        if (predicates == null) {
            throw new IllegalArgumentException("The predicate collection must not be null");
        }
        Predicate[] preds = new Predicate[predicates.size()];
        int i2 = 0;
        Iterator it = predicates.iterator();
        while (it.hasNext()) {
            preds[i2] = (Predicate)it.next();
            if (preds[i2] == null) {
                throw new IllegalArgumentException("The predicate collection must not contain a null predicate, index " + i2 + " was null");
            }
            ++i2;
        }
        return preds;
    }

    static Closure[] copy(Closure[] closures) {
        if (closures == null) {
            return null;
        }
        return (Closure[])closures.clone();
    }

    static void validate(Closure[] closures) {
        if (closures == null) {
            throw new IllegalArgumentException("The closure array must not be null");
        }
        int i2 = 0;
        while (i2 < closures.length) {
            if (closures[i2] == null) {
                throw new IllegalArgumentException("The closure array must not contain a null closure, index " + i2 + " was null");
            }
            ++i2;
        }
    }

    static Transformer[] copy(Transformer[] transformers) {
        if (transformers == null) {
            return null;
        }
        return (Transformer[])transformers.clone();
    }

    static void validate(Transformer[] transformers) {
        if (transformers == null) {
            throw new IllegalArgumentException("The transformer array must not be null");
        }
        int i2 = 0;
        while (i2 < transformers.length) {
            if (transformers[i2] == null) {
                throw new IllegalArgumentException("The transformer array must not contain a null transformer, index " + i2 + " was null");
            }
            ++i2;
        }
    }
}

